package djmetric

import (
	"djconstants"
	"djdb"
	"djextrafunc"
	"djgetad"
	"djlogger"
	"djredis"
	openrtb3 "openrtb/openrtb3"
	"reflect"
	"strconv"
	"strings"
	"time"

	openrtb "openrtb/openrtb2.5"
)

type Ccamp struct {
	View_percent int
	View_time    int
}

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var (
	metricobj   []openrtb3.Metric
	metricobj25 []openrtb.Metric
)

var camp_table = djconstants.TablePrefix + "campaigns"

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "^", "", count), "^")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for coverting string to function arguments
func StringCommandParserUA(cmd string) *Command {
	parts := strings.SplitN(cmd, "(", 2)
	countR := strings.Count(parts[1], ")")
	parts2 := djextrafunc.ReplaceNth(parts[1], ")", "", "", "", countR)
	count := strings.Count(parts2, ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2, ",", "", "^", "", count), "^")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for checking overall Item Metric criteria
func CheckMetricCriteria(metricChannel chan []djgetad.GetAd, metric []openrtb3.Metric, metric25 []openrtb.Metric, ads []djgetad.GetAd, redisClient *djredis.RedisClient) {
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			metricChannel <- filterads
		}
	}()
	if metric != nil {
		metricobj = metric
	} else if metric25 != nil {
		metricobj25 = metric25
	}
	for _, ad := range ads {
		var (
			view_percent, view_time, rowCount int
			placement                         string
		)
		v := &Ccamp{}
		placement = strconv.Itoa(ad.Placement_id)
		err := redisClient.GetKey("djm"+placement, v)
		if err != nil {
			djlogger.Log.Println("Key expired or error in getting redis key: ", err.Error())
		}
		if v != nil && err == nil {
			view_percent = v.View_percent
			view_time = v.View_time
		} else {
			err = djdb.DbQueryRow("SELECT djax_viewpercent,djax_viewtime from "+camp_table+" where campaignid="+placement+" AND status='1' AND budget_status = 0 AND djax_viewpercent > 50").Scan(&view_percent, &view_time)
			errR := redisClient.SetKey("djm"+placement, &Ccamp{View_percent: view_percent, View_time: view_time}, time.Minute*djconstants.RedisExpInMin)
			if errR != nil {
				djlogger.Log.Println("Error in setting redis key: ", errR.Error())
			}
			rowCount, _ = djdb.DbNumRows("SELECT djax_viewpercent,djax_viewtime from " + camp_table + " where campaignid=" + placement + " AND status=1 AND budget_status = 0 AND djax_viewpercent > 50")
		}
		if err != nil || rowCount == 0 {
			djlogger.Log.Println(err)
		} else {
			var ex bool
			var funcarr []string
			if ad.Compiledlimitation != "" {
				s := strings.Split(ad.Compiledlimitation, " and ")
				for _, element := range s {
					if element != "" {
						for _, e := range strings.Split(element, " or ") {
							if e != "" {
								funcarr = append(funcarr, e)
							}
						}
					}
				}
				for _, funcName := range funcarr {
					if funcName != "" {
						command := StringCommandParser(funcName)
						c := &Commander{}
						f := reflect.ValueOf(c).MethodByName(command.Name)
						if f.IsValid() {
							inputs := []reflect.Value{reflect.ValueOf(*command)}
							fu := f.Call(inputs)
							if fu[0].Interface().(bool) == false {
								ex = false
								break
							} else {
								ex = true
							}
						} else {
							ex = true
						}
					}
				}
				if ex != false {
					filterads = append(filterads, ad)
				}
			} else {
				filterads = append(filterads, ad)
			}
		}
	}
	metricChannel <- filterads
}

func (c Commander) MAX_checkClient_Vendor(cmd Command) bool {
	var argVendor []string
	var reqVendor string
	if metricobj != nil {
		for _, v := range metricobj {
			if v.Vendor != "" {
				reqVendor = strings.ToLower(v.Vendor)
			}
		}
	} else if metricobj25 != nil {
		for _, v := range metricobj25 {
			if v.Vendor != "" {
				reqVendor = strings.ToLower(v.Vendor)
			}
		}
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argVendor = append(argVendor, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqVendor != "" {
		if op == "=~" {
			return djextrafunc.In_array(reqVendor, argVendor)
		} else if op == "!~" {
			return !djextrafunc.In_array(reqVendor, argVendor)
		} else {
			return true
		}
	}
	return false
}
