package djdevice_target

import (
	"djconstants"
	"djdb"
	"djextrafunc"
	"djgetad"
	"djlogger"
	"djredis"
	openrtb3 "openrtb/openrtb3"
	"reflect"
	"strconv"
	"strings"
	"time"

	openrtb "openrtb/openrtb2.5"
)

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var (
	devobj   *openrtb3.Device
	devobj25 *openrtb.Device
)

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "^", "", count), "^")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for coverting string to function arguments
func StringCommandParserUA(cmd string) *Command {
	parts := strings.SplitN(cmd, "(", 2)
	countR := strings.Count(parts[1], ")")
	parts2 := djextrafunc.ReplaceNth(parts[1], ")", "", "", "", countR)
	count := strings.Count(parts2, ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2, ",", "", "^", "", count), "^")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for Replacing empty geo values with zeros
func MAX_geoReplaceEmptyWithZero(aRegion []string) []string {
	for i := 0; i < len(aRegion); i++ {
		if aRegion[i] == "" {
			aRegion[i] = "0.0000"
		}
	}
	return aRegion
}

// Function for checking region
func MAX_geoIsPlaceInRegion(lattitude string, longitude string, region []string) bool {
	lattitudeSouth := region[0]
	lattitudeNorth := region[1]
	longitudeWest := region[2]
	longitudeEast := region[3]
	return lattitude >= lattitudeSouth && lattitude <= lattitudeNorth && longitude >= longitudeWest && longitude <= longitudeEast
}

// Function for checking overall device targeting criteria
func CheckDeviceCriteria(devChannel chan []djgetad.GetAd, device *openrtb3.Device, device25 *openrtb.Device, ads []djgetad.GetAd) {
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			devChannel <- filterads
		}
	}()
	if device != nil {
		devobj = device
	} else if device25 != nil {
		devobj25 = device25
	}
	
			validate_campaign := make(map[int]int)


	for _, ad := range ads {
		
		
				if validate_campaign[ad.Placement_id] == 1 {
			
			filterads = append(filterads, ad)
			continue
		}
		
		if validate_campaign[ad.Placement_id] == 2 {
			continue
		} 
		
		validate_campaign[ad.Placement_id] = 2 // by default not match 
		
		
		var ex bool
		var funcarr []string
		var command *Command
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}
			for _, funcName := range funcarr {
				if funcName != "" {
					if strings.Contains(funcName, "MAX_checkClient_Useragent") {
						command = StringCommandParserUA(funcName)
					} else {
						command = StringCommandParser(funcName)
					}
					c := &Commander{}
					f := reflect.ValueOf(c).MethodByName(command.Name)
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {
							ex = true
						}
					} else {
						ex = true
					}
				}
			}
			if ex != false {
				filterads = append(filterads, ad)
								validate_campaign[ad.Placement_id] = 1 // match

			}
		} else {
			filterads = append(filterads, ad)
							validate_campaign[ad.Placement_id] = 1 // match

		}
	}
	devChannel <- filterads
}

/* ------------------------------------------------------------------------------------
			Device Targetting Start(16/12/19 -18/12/19)
---------------------------------------------------------------------------------------*/
// Ip start
func (c Commander) MAX_checkClient_Ip(cmd Command) bool {
	var reqIP string
	if devobj != nil {
		reqIP = devobj.IP
	} else if devobj25 != nil {
		reqIP = devobj25.IP
	}
	argIP := strings.Replace(cmd.Args[0], "'", "", -1)
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqIP != "" {
		if op == "=~" || op == "==" {
			return reqIP == argIP
		} else if op == "!=" || op == "!~" {
			return reqIP != argIP
		} else {
			return false
		}
	}
	return false
}

//Ip end

// Os start
func (c Commander) MAX_checkClient_Os(cmd Command) bool {
	var argOS []string
	var reqOS string
	if devobj != nil {
		reqOS = strings.ToLower(devobj.OS)
	} else if devobj25 != nil {
		reqOS = strings.ToLower(devobj25.OS)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argOS = append(argOS, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqOS != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqOS, argOS)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqOS, argOS)
		} else {
			return false
		}
	}
	return false
}

// Os end

// Display Type start
func (c Commander) MAX_checkClient_DeviceType(cmd Command) bool {
	var argDT []string
	var reqDT string
	if devobj != nil {
		reqDT = strconv.Itoa(devobj.Type)
	} else if devobj25 != nil {
		reqDT = strconv.Itoa(devobj25.DeviceType)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argDT = append(argDT, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqDT != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqDT, argDT)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqDT, argDT)
		} else {
			return false
		}
	}
	return false
}

// Display Type end

// Connection Type start
func (c Commander) MAX_checkClient_Connectiontype(cmd Command) bool {
	var argCT []string
	var reqCT string
	if devobj != nil {
		reqCT = strconv.Itoa(devobj.ConnType)
	} else if devobj25 != nil {
		reqCT = strconv.Itoa(devobj25.ConnType)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argCT = append(argCT, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqCT != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqCT, argCT)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqCT, argCT)
		} else {
			return false
		}
	}
	return false
}

// connection Type end

// mobileCarrierLimitation start
func (c Commander) MAX_checkClient_Network(cmd Command) bool {
	var argCL []string
	var reqCL string
	if devobj != nil {
		reqCL = strings.ToLower(devobj.Carrier)
	} else if devobj25 != nil {
		reqCL = strings.ToLower(devobj25.Carrier)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argCL = append(argCL, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqCL != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqCL, argCL)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqCL, argCL)
		} else {
			return false
		}
	}
	return false
}

// mobileCarrierLimitation end

// Useragent start
func (c Commander) MAX_checkClient_Useragent(cmd Command) bool {
	var reqUA string
	if devobj != nil {
		reqUA = strings.TrimSpace(devobj.UA)
	} else if devobj25 != nil {
		reqUA = strings.TrimSpace(devobj25.UA)
	}
	argUA := strings.TrimSpace(strings.Replace(cmd.Args[0], "'", "", -1))
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqUA != "" {
		if op == "=~" || op == "==" {
			return reqUA == argUA
		} else if op == "!=" || op == "!~" {
			return reqUA != argUA
		} else {
			return false
		}
	}
	return false
}

// Useragent end

// device make start
func (c Commander) MAX_checkClient_Manufacture(cmd Command) bool {
	var argMake []string
	var reqMake string
	if devobj != nil {
		reqMake = strings.ToLower(devobj.Make)
	} else if devobj25 != nil {
		reqMake = strings.ToLower(devobj25.Make)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argMake = append(argMake, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqMake != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqMake, argMake)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqMake, argMake)
		} else {
			return false
		}
	}
	return false
}

// device make end

// device Model start
func (c Commander) MAX_checkClient_Mobilebrandwithmodel(cmd Command) bool {
	var argModel []string
	var reqModel string
	if devobj != nil {
		reqModel = strings.ToLower(devobj.Model)
	} else if devobj25 != nil {
		reqModel = strings.ToLower(devobj25.Model)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	remBrand := strings.Split(cmd.Args[0], "|")
	remBrand[0] = strings.ToLower(strings.Replace(remBrand[0], "'", "", -1))
	for _, val := range strings.Split(remBrand[1], ",") {
		argModel = append(argModel, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqModel != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqModel, argModel)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqModel, argModel)
		} else {
			return false
		}
	}
	return false
}

// device Model end

// language start
func (c Commander) MAX_checkClient_Language(cmd Command) bool {
	var argLang []string
	var reqLang string
	if devobj != nil {
		reqLang = strings.ToLower(devobj.Language)
	} else if devobj25 != nil {
		reqLang = strings.ToLower(devobj25.Language)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argLang = append(argLang, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqLang != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqLang, argLang)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqLang, argLang)
		} else {
			return false
		}
	}
	return false
}

// language end

// PxRatio start
func (c Commander) MAX_checkClient_PxRatio(cmd Command) bool {
	var argPxRatio []string
	var reqPxRatio string
	if devobj != nil {
		reqPxRatio = strconv.FormatFloat(devobj.PxRatio, 'f', -1, 64)
	} else if devobj25 != nil {
		reqPxRatio = strconv.FormatFloat(devobj25.PxRatio, 'f', -1, 64)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argPxRatio = append(argPxRatio, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqPxRatio != "" {
		if op == "=~" || op == "==" {
			return djextrafunc.In_array(reqPxRatio, argPxRatio)
		} else if op == "!~" || op == "!=" {
			return !djextrafunc.In_array(reqPxRatio, argPxRatio)
		} else {
			return false
		}
	}
	return false
}

// PxRatio end

// ifa start
func (c Commander) MAX_checkClient_IFA(cmd Command) bool {
	var argIFA []string
	var reqIFA string
	if devobj != nil {
		reqIFA = strings.ToLower(devobj.IFA)
	} else if devobj25 != nil {
		reqIFA = strings.ToLower(devobj25.IFA)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argIFA = append(argIFA, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqIFA != "" {
		if op == "==" || op == "=~" {
			return djextrafunc.In_array(reqIFA, argIFA)
		} else if op == "!=" || op == "!~" {
			return !djextrafunc.In_array(reqIFA, argIFA)
		} else {
			return false
		}
	}
	return false
}

// ifa end

// ipv6 start
func (c Commander) MAX_checkClient_IPv6(cmd Command) bool {
	var argIPv6 []string
	var reqIPv6 string
	if devobj != nil {
		reqIPv6 = strings.ToLower(devobj.IPv6)
	} else if devobj25 != nil {
		reqIPv6 = strings.ToLower(devobj25.IPv6)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argIPv6 = append(argIPv6, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqIPv6 != "" {
		if op == "==" {
			return djextrafunc.In_array(reqIPv6, argIPv6)
		} else if op == "!=" {
			return !djextrafunc.In_array(reqIPv6, argIPv6)
		} else {
			return false
		}
	}
	return false
}

// ipv6 end

// OSVer start
func (c Commander) MAX_checkClient_OsVersion(cmd Command) bool {
	var argOSVer []string
	var reqOSVer string
	if devobj != nil {
		reqOSVer = strings.ToLower(devobj.OSVer)
	} else if devobj25 != nil {
		reqOSVer = strings.ToLower(devobj25.OSVer)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	remOS := strings.Split(cmd.Args[0], "|")
	remOS[0] = strings.ToLower(strings.Replace(remOS[0], "'", "", -1))
	if op == "nn" {
		if remOS[0] == devobj.OS {
			return true
		}
	} else {
		for _, val := range strings.Split(remOS[1], ",") {
			argOSVer = append(argOSVer, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
		}
		if reqOSVer != "" {
			if op == "==" {
				return reqOSVer == argOSVer[0]
			} else if op == "!=" {
				return reqOSVer != argOSVer[0]
			} else if op == "lt" {
				return djextrafunc.StringToFloat(argOSVer[0], 64) < djextrafunc.StringToFloat(reqOSVer, 64)
			} else if op == "gt" {
				return djextrafunc.StringToFloat(argOSVer[0], 64) > djextrafunc.StringToFloat(reqOSVer, 64)
			} else if op == "le" {
				return djextrafunc.StringToFloat(argOSVer[0], 64) <= djextrafunc.StringToFloat(reqOSVer, 64)
			} else if op == "ge" {
				return djextrafunc.StringToFloat(argOSVer[0], 64) >= djextrafunc.StringToFloat(reqOSVer, 64)
			} else {
				return false
			}
		}
	}
	return false
}

// OSVer end
/* ------------------------------------------------------------------------------------
			Device Targetting End(16/12/19 -18/12/19)
---------------------------------------------------------------------------------------*/

/* ------------------------------------------------------------------------------------
			Geo Targetting Start(16/12/19 -18/12/19)
---------------------------------------------------------------------------------------*/
// Country Start
func (c Commander) MAX_checkGeo_Country(cmd Command) bool {
	type Ccode struct {
		Country_code string
	}
	vC := &Ccode{}
	redisClient := djredis.Initialize()
	var argCountry []string
	var reqCountry string
	if devobj != nil {
		reqCountry = strings.ToLower(devobj.Geo.Country)
	} else if devobj25 != nil {
		reqCountry = strings.ToLower(devobj25.Geo.Country)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		val = strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1))
		if len(val) == 3 {
			err := redisClient.GetKey(val, vC)
			if err != nil {
				djlogger.Log.Println("Key : "+val+" expired or error in getting redis key: ", err.Error())
			}
			if vC != nil && err == nil {
				val = strings.ToLower(vC.Country_code)
			} else {
				djdb.DbQueryRow("SELECT country_code from " + djconstants.TablePrefix + "dj_country where iso_countycode_alpha3='" + val + "'").Scan(&vC.Country_code)
				val = strings.ToLower(vC.Country_code)
				err = redisClient.SetKey(val, &Ccode{Country_code: vC.Country_code}, time.Minute*djconstants.RedisExpInMin)
				if err != nil {
					djlogger.Log.Println("Error in setting redis key: ", err.Error())
				}
			}
		}
		argCountry = append(argCountry, val)
	}
	if len(reqCountry) == 3 {
		err := redisClient.GetKey(reqCountry, vC)
		if err != nil {
			djlogger.Log.Println("Key : "+reqCountry+" expired or error in getting redis key: ", err.Error())
		}
		if vC != nil && err == nil {
			reqCountry = strings.ToLower(vC.Country_code)
		} else {
			djdb.DbQueryRow("SELECT country_code from " + djconstants.TablePrefix + "dj_country where iso_countycode_alpha3='" + reqCountry + "'").Scan(&vC.Country_code)
			err = redisClient.SetKey(reqCountry, &Ccode{Country_code: vC.Country_code}, time.Minute*djconstants.RedisExpInMin)
			if err != nil {
				djlogger.Log.Println("Error in setting redis key: ", reqCountry, err.Error())
			}
		}
	}
	if reqCountry != "" {
		if op == "=~" {
			return djextrafunc.In_array(reqCountry, argCountry)
		} else if op == "!~" {
			return !djextrafunc.In_array(reqCountry, argCountry)
		} else {
			return false
		}
	}
	return false
}

// Country End

// Latlong Start
func (c Commander) MAX_checkGeo_Latlong(cmd Command) bool {
	var reqLat, reqLon string
	if devobj != nil {
		reqLat = djextrafunc.FloatToString(devobj.Geo.Lat)
		reqLon = djextrafunc.FloatToString(devobj.Geo.Lon)
	} else if devobj25 != nil {
		reqLat = djextrafunc.FloatToString(devobj25.Geo.Lat)
		reqLon = djextrafunc.FloatToString(devobj25.Geo.Lon)
	}
	argLatLong := strings.Replace(cmd.Args[0], "'", "", -1)
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqLat != "" && reqLon != "" {
		aRegion := MAX_geoReplaceEmptyWithZero(strings.Split(argLatLong, ","))
		result := MAX_geoIsPlaceInRegion(reqLat, reqLon, aRegion)
		if op == "==" {
			return result
		} else if op == "!=" {
			return !result
		} else {
			return false
		}
	}
	return false
}

// Latlong End

// City Start
func (c Commander) MAX_checkGeo_City(cmd Command) bool {
	var reqcountry, reqcity string
	if devobj != nil {
		reqcountry = strings.ToUpper(devobj.Geo.Country)
		reqcity = strings.ToLower(devobj.Geo.City)
	} else if devobj25 != nil {
		reqcountry = strings.ToUpper(devobj25.Geo.Country)
		reqcity = strings.ToLower(devobj25.Geo.City)
	}
	countryCity := strings.Split(cmd.Args[0], "|")
	argcountry := strings.Replace(strings.ToUpper(countryCity[0]), "'", "", -1)
	argcity := strings.Replace(strings.ToLower(countryCity[1]), "'", "", -1)
	argcities := strings.Split(argcity, ",")
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	if reqcity != "" {
		if reqcountry != argcountry {
			return false
		}
		if op == "==" {
			return djextrafunc.In_array(reqcity, argcities)
		} else if op == "!=" {
			return !djextrafunc.In_array(reqcity, argcities)
		} else if op == "=~" {
			return djextrafunc.In_array(reqcity, argcities)
		} else if op == "!~" {
			return !djextrafunc.In_array(reqcity, argcities)
		} else {
			return false
		}
	}
	return false
}

// City End

// Postalcode Start
func (c Commander) MAX_checkGeo_Postalcode(cmd Command) bool {
	var argZip []string
	var reqZip string
	if devobj != nil {
		reqZip = devobj.Geo.Zip
	} else if devobj25 != nil {
		reqZip = devobj25.Geo.Zip
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argZip = append(argZip, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqZip != "" {
		if op == "==" || op == "=~" {
			return djextrafunc.In_array(reqZip, argZip)
		} else if op == "!=" || op == "!~" {
			return !djextrafunc.In_array(reqZip, argZip)
		} else {
			return false
		}
	}
	return false
}

// Postalcode End

// Region Start
func (c Commander) MAX_checkGeo_Region(cmd Command) bool {
	var argRegions []string
	var reqRegions []string
	var reqRegion string
	if devobj != nil {
		reqRegion = strings.ToLower(devobj.Geo.Region)
	} else if devobj25 != nil {
		reqRegion = strings.ToLower(devobj25.Geo.Region)
	}
	argRegion := strings.Split(cmd.Args[0], "|")
	argcountry := strings.Replace(argRegion[0], "'", "", -1)
	reqdata := strings.Split(reqRegion, "|")
	reqcountry := reqdata[0]
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(reqdata[1], ",") {
		reqRegions = append(reqRegions, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	for _, val := range strings.Split(argRegion[1], ",") {
		argRegions = append(argRegions, strings.TrimSpace(strings.Replace(val, "'", "", -1)))
	}
	if reqRegion != "" {
		if reqcountry != argcountry {
			return false
		}
		if op == "=~" {
			return djextrafunc.In_array(reqRegions, argRegions)
		} else if op == "!~" {
			return !djextrafunc.In_array(reqRegions, argRegions)
		}
	}
	return false
}

// Region End
/* ------------------------------------------------------------------------------------
			Geo Targetting End(16/12/19 -18/12/19)
---------------------------------------------------------------------------------------*/
