package geo

import "strings"
//~ import "fmt"
import "alpha/adDelivery/deliveryLimitation/validation"

func City(limitation string,op string,country_code string,city_name string) bool {
		l := strings.Split(limitation, "|")
		tar_country := l[0]
		tar_city := l[1]
		result := validation.CheckStringMatch(tar_country,country_code)
	
		
		switch op {
    case "==":
        return result && validation.CheckStringMatch(tar_city,city_name)
    case "!=":
        return !(result && validation.CheckStringMatch(tar_city,city_name))
    case "=~":
        return  result && validation.CheckStringContains(city_name , tar_city)
    case "!~":
        return !(result && validation.CheckStringContains(city_name , tar_city))
    case "=x":
        return result && validation.CheckStringRexMatch(city_name , tar_city)
    case "!x":
        return !(result && validation.CheckStringRexMatch(city_name , tar_city) )
  
    }
    
    
    
return false	
}


func Country(limitation string,op string,val string) bool {
	
	result :=  validation.CheckArrayValueMatch(limitation,val)
	
	
	switch op {
    case "=~":
        return result
    case "!~":
        return !result
    }
    
    return false
}

func Continent(limitation string,op string,val string) bool {
	
	result :=  validation.CheckArrayValueMatch(limitation,val)
	
	
	switch op {
    case "=~":
        return result
    case "!~":
        return !result
    }
    
    return false
}


func Latlong(limitation string,op string,lat string,long string) bool {
	
	l := strings.Split(limitation, ",")
	
	switch op {
    case "==":
        return validation.CheckLatLongMatch(l[0],l[1],l[2],l[3],lat,long)
    case "!=":
        return  ! validation.CheckLatLongMatch(l[0],l[1],l[2],l[3],lat,long)
    } 
    
    return false
}


func ConnectionType(limitation string,op string,val string) bool {
	
	result :=  validation.CheckArrayValueMatch(limitation,val)
	
	
	switch op {
    case "=~":
        return result
    case "!~":
        return !result
    }
    
    return false
}





func Organisation(limitation string,op string,organisation string) bool {
	
	result := validation.CheckStringMatch(limitation,organisation)
		
		switch op {
    case "==":
        return result
    case "!=":
        return !result
    case "=~":
        return  validation.CheckStringContains(organisation , limitation)
    case "!~":
        return !validation.CheckStringContains(organisation , limitation)
    case "=x":
        return validation.CheckStringRexMatch(organisation , limitation)
    case "!x":
        return !validation.CheckStringRexMatch(organisation , limitation) 
  
    }
        return false

}


func Postalcode(limitation string,op string,country string ,postalcode string) bool {
	
		
	result_co := validation.CheckStringMatch(country,"US")
	
	if result_co == false { 
		return false
		} 
	
	result := validation.CheckStringMatch(limitation,postalcode)
		
		switch op {
    case "==":
        return result
    case "!=":
        return !result
    case "=~":
        return  validation.CheckStringContains(postalcode , limitation)
    case "!~":
        return !validation.CheckStringContains(postalcode , limitation)
    case "=x":
        return validation.CheckStringRexMatch(postalcode , limitation)
    case "!x":
        return !validation.CheckStringRexMatch(postalcode , limitation) 
  
    }
        return false

}



func Subdivision1(limitation string,op string,val string) bool {
	
	result :=  validation.CheckArrayValueMatch(limitation,val)
	
	
	switch op {
    case "=~":
        return result
    case "!~":
        return !result
    }
    
    return false
}


func Subdivision2(limitation string,op string,val string) bool {
	
	result :=  validation.CheckArrayValueMatch(limitation,val)
	
	
	switch op {
    case "=~":
        return result
    case "!~":
        return !result
    }
    
    return false
}

func UsMetro(limitation string,op string,val string) bool {
	
	result :=  validation.CheckArrayValueMatch(limitation,val)
	
	
	switch op {
    case "=~":
        return result
    case "!~":
        return !result
    }
    
    return false
}
 
