<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';

require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/www/admin/config.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

$title = "Bidding Type Settings";
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);
phpAds_PageHeader("bidding-type-settings", $oHeaderModel);



// Prepare an array for storing error messages
$aErrormessage = array();
$aConf = $GLOBALS['_MAX']['CONF'];
if($_REQUEST['submit']=='submit'){

	$account_id = !empty($_POST['account_id']) ? $_POST['account_id'] : '';

    $default_vendor= !empty($_POST['default_vendor']) ? $_POST['default_vendor'] : '';
	
	//Update Server Setting  Details
	$select=OA_Dal_Delivery_query("SELECT * FROM `{$table_prefix}hb_serverside_settings` ");
	
	if(OA_Dal_Delivery_numRows($select) > 0)
	{
		$res = OA_Dal_Delivery_query("UPDATE `{$table_prefix}hb_serverside_settings` SET `account_id`='".$account_id."',`default_vendor`='".$default_vendor."'");	
	}
	else
	{
		$res = OA_Dal_Delivery_query("INSERT INTO `{$table_prefix}hb_serverside_settings` (account_id,default_vendor) VALUES('".$account_id."','".$default_vendor."')");
	}	
}
$select = OA_Dal_Delivery_query("SELECT * FROM `{$table_prefix}hb_serverside_settings`");

$row = OA_Dal_Delivery_fetchAssoc($select);

$account_id = $row['account_id'];

$default_vendor = $row['default_vendor'];

?>

<html>
	<head>
		<style>
			td{
				font-size:15px;
				padding: 6px;
				}
			.head-bid{
					border: 1px solid #888;
				}
			.control-group{
					margin-top: 20px;
				}
		</style>
	</head>
	<body>
		<div id="dj_header">
		<form  action='' method='post' name='settingsform' id='settingsform1' class='form-inline' enctype='multipart/form-data'>
			<div class="control-group"  id="param-div">
				<h3>Server Side HB Settings</h3>
				<hr/>
				<br/><br/>
				<div>
					<table>
						<tr class="row">
							<td>&nbsp;</td>
							<td class="bid">Account ID:<span style="color:red;"> * </span></td>
							<td>&nbsp;</td>
							<td><input type="text" name="account_id" id="account_id" value="<?=$account_id?>" class="head-bid" placeholder="Enter account ID" required><br></td>
						</tr>
						<tr><br/></tr>
						<tr></tr>
						<tr>
							<td>&nbsp;</td>
							<td class="bid">Default Vendor:<span style="color:red;"> * </span></td>
							<td>&nbsp;</td>
							<td><input type="text" name="default_vendor" id="default_vendor" value="<?=$default_vendor?>" class="head-bid" placeholder="Enter default vendor" required></td>
						</tr>
					</table>
				</div>
				<hr/><br/>
				<div>
					<table>
						<tr>
							<td>&nbsp;</td>
							<td><input type="submit" name='submit' value="submit"></td>
						</tr>
					</table>
				</div>
			</div>
		</form>
		</div>
	</body>
</html>

<?php

// Display the page footer
phpAds_PageFooter();

?>
	

