<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';

require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/www/admin/config.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

if(isset($_POST["function"]) && !empty($_POST["function"]))
	{
		if($_POST["function"] == "checkbidderName")
		{
			$chkusr = OA_Dal_Delivery_query("SELECT * FROM {$table_prefix}djax_hb_bidders_list WHERE hb_bidder_name ='".$_POST["value"]."' AND dj_is_deleted = 0");
			if(OA_Dal_Delivery_numRows($chkusr) > 0 )
			{
				echo json_encode(array("status" => "ok","check"=>true)); exit();
			} else {
				echo json_encode(array("status" => "ok","check"=>false)); exit();
			}
		}
	}

$oOptions = new OA_Admin_Option('settings');

$title="Add new Bidder";
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);
phpAds_PageHeader('bidder-list-index', $oHeaderModel);


// Prepare an array for storing error messages
$aErrormessage = array();
$aConf = $GLOBALS['_MAX']['CONF'];

if($_REQUEST['submit']=='submit'){
	
	//~ echo "<pre>";print_r($_POST);exit;
	$bidder_name = $_POST['bidder_name'];
	$bidder_code = $_POST['bidder_code'];
	$date_created =date('Y-m-d H:i:s');
	$param_name = $_POST['param_name'];
	$param_req = $_POST['param_req'];
	$adapter_name = $_POST['bidder_adapter'];
	$ad_format = serialize($_POST['ad_format']);
	$server_side = $_POST['server_side'];
	
	$banner = 0;
	$video = 0;

	if(in_array(1, $_POST['ad_format']))
	{
		$banner = 1;
	}

	if(in_array(2, $_POST['ad_format']))
	{
		$video = 1;
	}

	//inser bidder table
	$res = OA_Dal_Delivery_query("INSERT into {$table_prefix}djax_hb_bidders_list(hb_bidder_name,hb_bidder_code,server_side,module_name,hb_ad_format,date_created,dj_is_banner,dj_is_video) VALUES('".$bidder_name."','".$bidder_code."','".$server_side."','".$adapter_name."','".$ad_format."','".$date_created."','".$banner."','".$video."')  ");   
	
	$bidder_id=OA_Dal_Delivery_insertId();
	
	//inser param table
	
	foreach($param_name as $key => $value){
		
		$paramreq = (isset($param_req[$key]) && $param_req[$key] == "on") ? 1 : 0; 		
		
		//~ echo "INSERT into {$table_prefix}djax_hb_params(hb_parameter_name,hb_bidder_id,required,date_created) VALUES('".$value."','".$bidder_id."','".$paramreq."','".$date_created."')  ";exit;
		OA_Dal_Delivery_query("INSERT into {$table_prefix}djax_hb_params(hb_parameter_name,hb_bidder_id,required,date_created) VALUES('".$value."','".$bidder_id."','".$paramreq."','".$date_created."')  ")or die("param insert");  
	}
	
	//~ $path = $GLOBALS['_MAX']['HTTP'].$aConf['webpath']['admin'].'/bidder-list-index.php';
	
	$countrow=OA_Dal_Delivery_query("select * from {$table_prefix}djax_hb_bidders_list as bl join {$table_prefix}djax_hb_params as hp on bl.hb_bidder_id=hp.hb_bidder_id where bl.hb_bidder_id
					IN (hp.hb_bidder_id) AND bl.dj_is_deleted=0 group by hp.hb_bidder_id");
	$total_records = OA_Dal_Delivery_numRows($countrow);
	$per_page = 10;
	$total_pages = ceil($total_records / $per_page);
	
	//success msg
	$translation = new OX_Translation();
	$translated_message = $translation->translate ("<b> ".$bidder_name." has been added Successfully.</b>");
	OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
	
	$path = $GLOBALS['_MAX']['HTTP'].$aConf['webpath']['admin'].'/plugins/HbSettings/bidder-list-index.php?page='.$total_pages;
	
	
					echo "<script type='text/javascript'>window.top.location='".$path."';</script>";
	
}

	
?>

<html>
	<head>
		<!--link rel='stylesheet' href='https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css'-->
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.0/jquery.min.js"></script>
		<script type="text/javascript">
			var jq = $.noConflict(true);




			jq(document).ready(function () {
				var count=0;
				var params = jq("#param-div");
				jq("#param-div").on('click', '#plus_param', function () {			
					count++;
					cunt = count - 1;
					jq("#param_name").css('margin-left','10px');
					jq("#param_req").css('margin-left','10px');
					jq("#param_name"+cunt).css('margin-left','17px');
					jq("#param_req"+cunt).css('margin-left','17px');
					
					var fieldWrapper = jq('<div>');
					var paramname = jq('<table><tr class="row"><td class="">&nbsp;&nbsp;&nbsp;parameter name:<span style="color:red;"> * </span></td><td><input type="text" name="param_name['+count+']" id="param_name'+count+'" class="head-bid" placeholder="Enter parameter name" maxlength="50" size="50" style="margin-left: 11px;" required></td><td><img src="assets/images/icon-cross.png" width="16" height="16" align="absmiddle" class="param_delete" name="param_delete"> </td><td><img src="assets/images/plus.png" width="16" height="16" align="absmiddle" id="plus_param" ></td></tr><tr><td class="bid">&nbsp;&nbsp;&nbsp;Is this parameter required<span style="color:red;"> * </span></td><td><input type="checkbox" name="param_req['+count+']" id="param_req'+count+'" class="head-bid" style="margin-left:11px;"></td></tr></table></div>');
						
					fieldWrapper.append(paramname);
					jq(this).remove();
					jq("#param-div").append(fieldWrapper);


				});
				jq(params).on("click",".param_delete", function(e){ //user click on remove field
					
					e.preventDefault(); jq(this).parent().parent().parent().parent().remove();
					var divlen = jq("#param-div > div").children().length;
					if(divlen <= '1'){
						jq("#param_name").css('margin-left','0px');
						jq("#param_req").css('margin-left','0px');
						jq("#param_name").parent().parent().append("<td><img src='assets/images/plus.png' width='16' height='16' align='absmiddle' id='plus_param' ></td>");
					}
					
					
				});
				
				jq('.ad_format').click(function(){
					
					if(jq('#ad_format_banner').is(':checked') || jq('#ad_format_video').is(':checked') || jq('#ad_format_native').is(':checked'))
						jq(".ad_format").attr("required", false);
					else
						jq(".ad_format").attr("required", true);
				
				});

				jq("#bidder_name").on("keyup",function(){
				var get_bidder_name = this.value;
				jq.ajax({
					data : {"function" : "checkbidderName","value" : get_bidder_name },
					type : "POST",
					success : function(res){
						var response = JSON.parse(res);
						if(response.status == "ok")
						{
							if(response.check == true) {
								jq("#bidder_name_error").show();
								jq("#bidder_name").css("border","1px solid red")
								jq("#bidder_submit").attr("disabled",true);
							} else {
								jq("#bidder_name").css("border","1px solid black")
								jq("#bidder_name_error").hide();
								jq("#bidder_submit").attr("disabled",false);

							}
						}
					}
				});
			});
			});			
		</script>
		<style>
			td{
				font-size:15px;
				padding: 6px;
				}
			.head-bid{
					border: 1px solid #888;
				}
			.control-group{
					margin-top: 20px;
				}
			.bid{
					width: 40%;
				}
		</style>
	</head>
	<body>
		<div id="dj_header">
		<form  action='' method='post' name='settingsform' id='settingsform1' class='form-inline' enctype='multipart/form-data'>
			<div class="control-group">
				<h3>Bidder details</h3>
				<hr/>
				<br/><br/>
				<div>
					<table>
						<tr class="row">
							<td>&nbsp;</td>
							<td class="bid">Bidder name:<span style="color:red;"> * </span></td>
							<td>&nbsp;</td>
							<td><input type="text" name="bidder_name" id="bidder_name" class="head-bid" placeholder="Ender bidder name" maxlength="50" size="50" required><br><span style="color: red;font-style: italic;font-size: 14px;display:none;" id="bidder_name_error">Bidder Name already exists</span></td>
						</tr>
						<tr><br/></tr>
						<tr></tr>
						<tr>
							<td>&nbsp;</td>
							<td class="bid">Bidder code:<span style="color:red;"> * </span></td>
							<td>&nbsp;</td>
							<td><input type="text" name="bidder_code" id="bidder_code" class="head-bid" placeholder="Enter bidder code" maxlength="50" size="50" required></td>
						</tr>
						<tr>
							<td>&nbsp;</td>
							<td class="bid">Bidder adapter name:<span style="color:red;"> * </span></td>
							<td>&nbsp;</td>
							<td><input type="text" name="bidder_adapter" id="bidder_adapter" class="head-bid" placeholder="Enter bidder adapter name" maxlength="50" size="50" required>&nbsp;</td>
						</tr>
						<tr>
							<td>&nbsp;</td>
							<td class="bid">Bidding Type</td>
							<td>&nbsp;</td>
							<td >
								<select name="server_side" id="server_side">
									<option value="1" >Client Side</option>
									<option value="2" >Server Side</option>
									<option value="3" >Both</option>
								</select>
							</td>
						</tr>
					</table>
				</div>
					
			</div>
			<div class="control-group">
				<h3>Ad formats</h3>
				<hr/>
				<br/><br/>
				<div>
					<table>
						<tr class="row">
							<td>&nbsp;</td>
							<td class="bid">Supported Ad formats:<span style="color:red;"> * </span></td>
							<td>&nbsp;</td>
							<td style="padding-left: 50px;">
								<input type="checkbox" name="ad_format[]" id="ad_format_banner" class="head-bid ad_format" value='1' <?php echo in_array(1,unserialize($brow['hb_ad_format'])) ? 'checked' : ''; ?> required>Banner
								<input type="checkbox" name="ad_format[]" id="ad_format_video" class="head-bid ad_format" value='2' <?php echo in_array(2,unserialize($brow['hb_ad_format'])) ? 'checked' : ''; ?> required>Video
							</td>
						</tr>
					</table>
				</div>
			</div>
			<div class="control-group" id="param-div">
				<h3>Parameter details</h3>
				<hr/>
				<br/><br/>
				<div>
					<table>
						<tr class="row">
							<td>&nbsp;</td>
							<td class="bid">parameter name:<span style="color:red;"> * </span></td>
							<td><input type="text" name="param_name[0]" id="param_name" class="head-bid" placeholder="Ender parameter name" maxlength="50" size="50" style="margin-left: 5px;" required></td>
							<td><img src='assets/images/plus.png' width='16' height='16' align='absmiddle' id="plus_param" ></td>
						</tr>
						<tr>
							<td>&nbsp;</td>
							<td class="bid">Is this parameter required<span style="color:red;"> * </span></td>
							<td><input type="checkbox" name="param_req[0]" id="param_req" class="head-bid" style="margin-left: 5px;"></td>
							<td>&nbsp;</td>
						</tr>
					</table>
				</div>					
			</div>
			<div>
					<table>
						<tr>
							<td>&nbsp;</td>
							<td><input type="submit" name='submit' value="submit" id="bidder_submit"></td>
						</tr>
					</table>
				</div>
		</form>
	</div>
	</body>
</html>

<?php

// Display the page footer
phpAds_PageFooter();

?>

