<?php

/*
+--------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/RV/Admin/Languages.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/lib/OA/Dll/Publisher.php';
require_once MAX_PATH . '/lib/OA/Session.php';
require_once MAX_PATH . '/lib/OA/Admin/Menu.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/OA/Auth.php';
require_once MAX_PATH . '/lib/OA/Admin/UI/UserAccess.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}elseif ($GLOBALS['_MAX']['CONF']['database']['type'] == 'pgsql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}elseif ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysqli') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER, OA_ACCOUNT_TRAFFICKER);
OA_Permission::enforceAccountPermission(OA_ACCOUNT_TRAFFICKER, OA_PERM_SUPER_ACCOUNT);
OA_Permission::enforceAccessToObject('affiliates', $affiliateid);


/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['affiliateid'] = $affiliateid;
phpAds_SessionDataStore();

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

$oHeaderModel = MAX_displayWebsiteBreadcrumbs($affiliateid);
 phpAds_PageHeader('affiliate-headerbid', $oHeaderModel);
 
if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}elseif ($GLOBALS['_MAX']['CONF']['database']['type'] == 'pgsql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}elseif ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysqli') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
 
	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
	
	
	$getbidder = OA_Dal_Delivery_query("SELECT * FROM ".$table_prefix."djax_hb_bidders_list WHERE dj_is_denied='0' AND dj_is_deleted='0'");
	
	$path = $GLOBALS['_MAX']['SSL_REQUEST'] ? "https://".$GLOBALS['conf']['webpath']['admin']."/" : "http://".$GLOBALS['conf']['webpath']['admin']."/";
	
if(isset($_POST['submit']))
{
	$bidders = $_POST['bidid'];
	
	$impression = $_POST['imp'];
	
	$bidding_type = $_POST['bidding_type'];
	
	$revenue = $_POST['rev'];
	
	$date_created = date('Y-m-d H:i:s');

	//~ INSERT BID PARAM VALUES START

	$bidderid = $_POST['bidid'];
	$param = $_POST['param_name'][$bidderid];
	$parametername = $_POST['parameter_name'];
	$subparam = $_POST['sub_param_name'];
	
	$affiliateid = $_GET['affiliateid'];
	$created_date = date('Y-m-d H:i:s');
	$status = 0;


	if($bidderid)
	{
		foreach($_POST['param_name'][$bidderid] as $id => $pval)
		{
			OA_Dal_Delivery_query("INSERT INTO {$table_prefix}djax_hb_param_value ( account_id, hb_bidder_id, parameter_id, param_value, dj_admin_approve, dj_date_time ) VALUES ( '$affiliateid', '$bidderid', '$id', '".$param[$id]."', '1', '".$created_date."')");
		}
	}

	if(!empty($subparam))
	{			
		foreach($subparam as $spid => $spval)
		{
			foreach($spval as $sbid => $sbval)
			{	
				OA_Dal_Delivery_query("INSERT INTO {$table_prefix}djax_hb_sub_param_value (account_id,hb_bidder_id,parameter_id,sub_para_id,sub_param_value,dj_admin_approve,dj_date_time) VALUES ('$affiliateid','$bidderid','$spid','$sbid','$sbval','1','$created_date')");
			}
		}	
	}
	

	//~STATUS CHANGE
	$no_required = 0;
	$query1 = OA_Dal_Delivery_query("SELECT required, hb_parameter_id FROM {$table_prefix}djax_hb_params WHERE hb_bidder_id = {$bidderid} AND required = 1 ");
	$req_count = OA_Dal_Delivery_numRows($query1);

	if($req_count > 0)
	{
		while($value1 = OA_Dal_Delivery_fetchAssoc($query1))
		{

			if($value1['required'] == 1)
			{
				$no_required = 1;

				if($_POST['param_name'][$bidderid][$value1['hb_parameter_id']] != '')
				{
					$status++;
				}
			}
		}
	}
	//~ NO REQUIRED FIELDS
	if($no_required == 0)
	{
		$status = 1;
	}
	else
	{
		if($req_count == $status)
		{
			$status = 1;
		}
		else
		{
			$status = 2;
		}
	}


	OA_Dal_Delivery_query("INSERT INTO ".$table_prefix."djax_bidder_request (publisher_id,bidder_id,impression,revenue,is_approved,created_date,bidding_type) VALUES ('$affiliateid','$bidderid','$impression','$revenue','".$status."','$date_created','$bidding_type')");
	
	OA_Dal_Delivery_query("UPDATE ".$table_prefix."djax_bidder_request SET impression='$impression', revenue='$revenue' WHERE publisher_id= '$affiliateid'");

	$translation = new OX_Translation();
	$translated_message = $translation->translate ("<b> Request has been send Successfully.</b>");
	
	OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
	
	$filepath = $path."plugins/HbInvocation/affiliate-headerbid.php?affiliateid=$affiliateid";

	echo "<script type='text/javascript'>window.top.location='".$filepath."';</script>";exit();

}	
	
?>
	<html>
		<head>
			<style>
				
				th,td{
					
					padding : 5px;
				}
			
			</style>
		</head>
		<body>
			<div> 
				
				<div> <h3>Add Request </h3> <hr/> <br/> <br/> </div>
				
				<form method="post" name='settingsform'>
				<table>
					<tr>
						<td>
							Choose Bidder <span style='color:red;'>*</span>
						</td>
						
						<td>
							<select id="bidid" name="bidid" required>
		
 <?php

	if(OA_Dal_Delivery_numRows($getbidder))
	{
		$checkbidder = OA_Dal_Delivery_query("SELECT bidder_id FROM `".$table_prefix."djax_bidder_request` where is_deleted='0' and is_admin_deleted = '0' and is_denied='0' and if(is_approved='0', DATE(modified_date) > date_sub(now(), interval 1 month),1) and publisher_id='".$affiliateid."'");
		
		$check_bidder=array();
		while($checkbidders = OA_Dal_Delivery_fetchAssoc($checkbidder)){
			$check_bidder[] = $checkbidders['bidder_id'];
			
		}
		
		while($bidrow = OA_Dal_Delivery_fetchAssoc($getbidder))
		{
			
			if(!in_array($bidrow['hb_bidder_id'],$check_bidder))
			{
		?>
				<option value="<?php echo $bidrow['hb_bidder_id'];?>"><?php echo $bidrow['hb_bidder_name'];?></option>
			
<?php
			}
		}	 
	}
 
 $bidderinfo = OA_Dal_Delivery_query("SELECT impression,revenue FROM ".$table_prefix."djax_bidder_request WHERE publisher_id='".$affiliateid."'");
 $bidderinfo = OA_Dal_Delivery_fetchAssoc($bidderinfo);

?>	
							</select>
						</td>
					</tr>
					
					<tr> <td> <br> </td> </tr>

					<tr>
						<td>Parameters:<span style="color:red;"> * </span></td>
						<td>
					<?php

  						$bidid = $_GET['bidid'];
						$listbidderparam = OA_Dal_Delivery_query("SELECT pv.account_id,hp.hb_bidder_id,hp.hb_parameter_id,hp.hb_parameter_name,pv.param_value,pv.parameter_id,hs.hb_sub_parameter_id,hs.hb_sub_parameter_name,sp.sub_param_value,hp.required as prequired,hs.srequired as srequired FROM {$table_prefix}djax_hb_params as hp
							left join (SELECT * from {$table_prefix}djax_hb_param_value where account_id ='$affiliateid')as pv on pv.parameter_id = hp.hb_parameter_id left join (SELECT GROUP_CONCAT(hb_sub_parameter_id) as hb_sub_parameter_id ,GROUP_CONCAT(hb_sub_parameter_name) as hb_sub_parameter_name,GROUP_CONCAT(required) as srequired,hb_parameter_id from {$table_prefix}djax_hb_sub_param WHERE dj_is_deleted = 0 group by hb_parameter_id ) as hs on hs.hb_parameter_id = hp.hb_parameter_id left join (SELECT sub_para_id,GROUP_CONCAT(sub_param_value) as sub_param_value from  {$table_prefix}djax_hb_sub_param_value group by parameter_id) as sp on sp.sub_para_id = hs.hb_sub_parameter_id");

						$bidder_list = OA_Dal_Delivery_fetchAssoc($listbidder);
		 				
	  				?>

					<table id="param-table">
					<?php 			
						while($row=OA_Dal_Delivery_fetchAssoc($listbidderparam))
						{
							$psreq = ($row['prequired']==1) ? "<span style='color:red;'>*</span>" : ''; ?>

							<tr  class="param_<?=$row['hb_bidder_id']?> all_params" style='display: none;' >
								<td class="param">
									<?php echo $row['hb_parameter_name'];?> <?php echo $psreq;?> &nbsp;
								</td>
							<?php				

								if(!empty($row['hb_sub_parameter_id']))
								{ 
		
									$subparamid = explode(',',$row['hb_sub_parameter_id']);
									$subparamname = explode(',',$row['hb_sub_parameter_name']);
									$subparamvalue = explode(',',$row['sub_param_value']);
									$subparamreq = explode(',',$row['srequired']);
									echo "</tr>";
									
									foreach($subparamid as $sid => $sval)
									{
										$ssreq = ($subparamid[$sid]==1) ? "<span style='color:red;'>*</span>" : '';
		
										?>
										<tr class="all_params subparam_<?=$row['hb_bidder_id']?>">
											<td>
												&nbsp;&nbsp;&nbsp;<?php echo $subparamname[$sid];?><?php echo $ssreq;?>&nbsp;
											</td>
											<td>
												<input type="text" name="sub_param_name[<?php echo $row['hb_parameter_id'];?>][<?php echo $sval;?>]" <?php echo $sreq;?>>
											</td>
										</tr>
													
							<?php	
									}
								}else{ 
							?>
									<td>
										<input type="text" name="param_name[<?php echo $row['hb_bidder_id'];?>][<?php echo $row['hb_parameter_id'];?>]" value='<?php echo $row['param_value'];?>' >
									</td>
								</tr>	
								<?php } ?>
							
						<?php 	} ?>
					</table>
					
					<tr> <td> <br> </td>  </tr>
					
					<tr>
						<td>
							<input type="hidden" name="imp" value="0" required>
							<input type="hidden" name="rev" value="0" required>
							<input type="submit" name="submit" value="Save Changes">
						</td>
					</tr>
				</table>
				</form>
			</div>
		</body>
	</html>
 
 
<script type="text/javascript">
	
	$("#bidid").change(function(){

		var select_bidder = $(this).val();
		change_params(select_bidder);
	});

	var first_bid = $("#bidid").val();
	change_params(first_bid)

	function change_params(bid_id)
	{
		$(".all_params").hide();
		$(".param_"+bid_id).show();
		$(".subparam_"+bid_id).show();
		$(".param_"+bid_id).show();
	}

</script>
