$(function()
{   

    var dates = $("#date_block").html();
    var all_attributes = [];
    var all_metrics = [];
    var limit = "LIMIT 0, 10";

    $(".report_gendration").hide();
    $(".report_params").show();
    $("#loader_div").hide();
    $("#back").hide();

    //* DATE RANGE PICKER START *//

    $('input[name="date_range"]').daterangepicker();
    var start = moment().subtract('days', '7days');
    var end = moment();

    $("#date_range").click(function(event){

        event.preventDefault();
    })

    function cb(start, end) {
        $('#date_block').html(start.format('YYYY MM DD')+' - '+end.format('YYYY MM DD'));
    }

    $('#date_range').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
           'Today': [moment(), moment()],
           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
           'This Month': [moment().startOf('month'), moment().endOf('month')],
           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);

    //* DATE RANGE PICKER END *//


    //* ATTRIBUTE SELECT BOX START *//

    $("#attr_select").click(function(){


        if($("#attr_select").is(":checked") == true){

            $(".attributes").prop("checked", true);

        }else{

            $(".attributes").prop("checked", false);
        }

    })

    //* ATTRIBUTE SELECT BOX END *//


    //* METRICS SELECT BOX START *//

    $("#metric_select").click(function(){

        if($("#metric_select").is(":checked") == true){

            $(".metrics").prop("checked", true);

        }else{

            $(".metrics").prop("checked", false);

        }
    });
    
    //* METRICS SELECT BOX END *//

    //~BACK

    $("#back").click(function(){

        $(".report_params").removeClass('blur');
        $(".report_gendration").addClass('blur');
        $("#loader_div").show();

        setTimeout(function(){

            $(".report_params").show();

            $(".report_gendration").hide();
            $("#loader_div").hide();
            $("#back").hide();
            
        }, 3000);

    });


    // GENERATE REPORT

    $("#generate_button").click(function()
    {
        dates = $("#date_block").html();
        all_attributes = [];
        all_metrics = [];

        $('.attributes:checked').each(function () {
             all_attributes.push($(this).val());
        });

        $('.metrics:checked').each(function () {
             all_metrics.push($(this).val());
        });

        if(all_metrics.length < 1){

            alert('Please select atleast 1 Metrics!');
            return false;
        }

        $(".report_params").addClass('blur');
        $(".report_gendration").removeClass('blur');
        $("#loader_div").show();

        setTimeout(function(){

            $(".report_gendration").show();
            $(".report_params").hide();
            $("#loader_div").hide();
            $("#back").show();
            
        }, 3000);


        generateTable();
    
    });

    var metric_list = [];
    var attr_list = [];

    $(".attributes").click(function(){

        attr_list = [];

        $('.attributes:checked').each(function () {
             attr_list.push($(this).val());
        });

        if(attr_list.length == 8){

            $("#attr_select").prop('checked', true);
        }else{

            if($("#attr_select").is(":checked") == true)
            {
                $("#attr_select").prop('checked', false);
            }
        }
    });

    $(".metrics").click(function(){

        metric_list = [];

        $('.metrics:checked').each(function () {
             metric_list.push($(this).val());
        });

        if(metric_list.length == 10){

            $("#metric_select").prop('checked', true);
        }else{

            if($("#metric_select").is(":checked") == true)
            {
                $("#metric_select").prop('checked', false);
            }
        }
    });


    function generateTable() {

        var empDataTable = $('#report_table').DataTable(
        {
            'scrollY': 300,
            'scrollX': true,
            'scroller': true,
            'fixedHeader': true,
            'processing': true,
            'serverSide': true,
            'serverMethod': 'post',
            'bDestroy': true,
            'bSort' : false,
            'pageLength' : 10,
            'lengthMenu': [[25, 50, 75, 100, -1], [25, 50, 75, 100, "All"]],
            'bFilter' : false,
            'dom': 'l<"toolbar">Bfrtip',
            'responsive': true,
            "pagingType": "full_numbers",
            
            buttons: [
                
                // {
                //     extend: 'colvis',
                // },
                {
                    extend: 'csvHtml5',
                    exportOptions: {
                        columns: [ ':visible' ]
                    }
                },
                // {
                //     extend: 'excelHtml5',
                //     exportOptions: {
                //         columns: [ ':visible' ]
                //     }
                // },
                {
                    extend: 'pdfHtml5',
                    exportOptions: {
                        columns: [ ':visible' ]
                    }
                }
            ],
            lengthMenu: [[10, 25, 50, 75, 100, -1], [10, 25, 50, 75, 100, "All"]],

            ajax: {
                url  : 'report_data.php',
                method: 'POST',
                data : { 'dates' : dates,'attributes' : all_attributes, 'metrics' : all_metrics }
            },
            'drawCallback':function( settings, json){

                var current = empDataTable.page.info();
                limit = " LIMIT " + current['start'] + "," + current['end'];
                generateChartData(limit);
            },
            'columns': [
                { data: 'name' },
                { data: 'country' },
                { data: 'media' },
                { data: 'size' },
                { data: 'source' },
                { data: 'site' },
                { data: 'zone' },
                { data: 'impression' },
                { data: 'wonbid' },
                { data: 'ecpm' }
            ]
        });


        var dt = $('#report_table').DataTable();

        //~ATTRIBUTES VISIBILITY
        
        if(all_attributes.includes('country')){

            dt.column(1).visible(true);

        }else{

            dt.column(1).visible(false);

        } if(all_attributes.includes('hb_media')){

            dt.column(2).visible(true);
        }else{

            dt.column(2).visible(false);

        } if(all_attributes.includes('hb_size')){

            dt.column(3).visible(true);
        }else{

            dt.column(3).visible(false);

        } if(all_attributes.includes('hb_source')){

            dt.column(4).visible(true);
        }else{

            dt.column(4).visible(false);

        } if(all_attributes.includes('affiliateid')){

            dt.column(5).visible(true);
        }else{

            dt.column(5).visible(false);

        } if(all_attributes.includes('zoneid')){

            dt.column(6).visible(true);
        }else{

            dt.column(6).visible(false);
        }

        //~METRICS VISIBILITY

        if(all_metrics.includes('imp')){

            dt.column(7).visible(true);
        }else{

            dt.column(7).visible(false);

        } if(all_metrics.includes('wonbid')){

            dt.column(8).visible(true);
        }else{

            dt.column(8).visible(false);

        } if(all_metrics.includes('ecpm')){

            dt.column(9).visible(true);
        }else{

            dt.column(9).visible(false);
        }
    }

    // CHART DATA

    function generateChartData(limit)
    {
        $.ajax({

            url: 'report_chart.php',
            type: 'post',
            dataType: 'json',
            data : { 'dates' : dates,'attributes' : all_attributes, 'metrics' : all_metrics, 'limit' : limit },
            
            success: function (data) {

                generateChart(data);
            }
        });
    }


    // MENU CLICK

    function generateChart(data)
    {
        var chartBench = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'column'
            },
            title: {
                text: 'HB Reporting'
            },
            subtitle: {
                text: dates
            },
            credits: {
                enabled: false
            },
            legend: {},
            plotOptions: {
                series: {
                    shadow: false,
                    borderWidth: 0
                }
            },
            xAxis: {
                lineColor: '#999',
                lineWidth: 1,
                tickColor: '#666',
                tickLength: 3,
                categories: data['categories'],
                title: {
                    text: ''
                }
            },
            yAxis: {
                lineColor: '#999',
                lineWidth: 1,
                tickColor: '#666',
                tickWidth: 1,
                tickLength: 3,
                gridLineColor: '#ddd',
                labels: {
                    format: '{value}'
                },
                title: {
                    text: ''
                }
            },
            colors: ['#33435C', '#16A085', '#f44336', '#f3c300', '#009688', '#64E572', '#FF9655', '#FFF263', '#6AF9C4'],
            series: data['series']

        });
    }

    var isOpen = 0;
    $(document).on('click','.switchTrigger',function() {
        if (isOpen == 0) {
            $(".accountSwitcher").addClass("expanded");
            $('accountSwitcherOverlay').css({ display: "block" });
            isOpen++;
        } else {
            $(".accountSwitcher").removeClass("expanded");
            $('accountSwitcherOverlay').css({ display: "none" });
            isOpen--;
        }
    });

});
