<?php
    /*
    +---------------------------------------------------------------------------+
    | Revive Adserver                                                           |
    | http://www.revive-adserver.com                                            |
    |                                                                           |
    | Copyright: See the COPYRIGHT.txt file.                                    |
    | License: GPLv2 or later, see the LICENSE.txt file.                        |
    +---------------------------------------------------------------------------+
    */
    
    // Require the initialisation file
    
    require_once '../../../../init.php';
    // Required files
    require_once MAX_PATH . '/www/admin/config.php';
    require_once LIB_PATH . '/Plugin/PluginManager.php';
    require_once LIB_PATH . '/Plugin/ComponentGroupManager.php';
    require_once MAX_PATH . '/lib/pear/Date.php';
    require_once MAX_PATH . '/lib/OA/Dal.php';
     require_once MAX_PATH . '/lib/OA/Admin/Option.php';
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);
    $oPluginManager = new OX_PluginManager();
    $oComponentGroupManager = new OX_Plugin_ComponentGroupManager();
    phpAds_PageHeader('HBReport', $oHeaderModel);
    /* Store preferences */
    $session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid'] = $clientid;
    $session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['campaignid'][$clientid] = $campaignid;
    phpAds_SessionDataStore();

?>
<!DOCTYPE html>
<html>
<head>
    <title>HB Report Generator</title>
</head>

    <!-- DATATABLE EXTENTIONS START -->

<script type="text/javascript" language="javascript" src="https://code.jquery.com/jquery-3.3.1.js"></script>
    <!-- <script type="text/javascript" src="assets/js/jquery-3.5.1.js"></script> -->
    <script type="text/javascript" src="assets/DataTables/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="assets/DataTables/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="assets/DataTables/buttons.flash.min.js"></script>
    <script type="text/javascript" src="assets/DataTables/jszip.min.js"></script>
    <script type="text/javascript" src="assets/DataTables/pdfmake.min.js"></script>
    <script type="text/javascript" src="assets/DataTables/jspdf.min.js"></script>
    <script type="text/javascript" src="assets/DataTables/vfs_fonts.js"></script>
    <script type="text/javascript" src="assets/DataTables/buttons.html5.min.js"></script>
    <script type="text/javascript" src="assets/DataTables/buttons.print.min.js"></script>
    <script type="text/javascript" src="assets/DataTables/buttons.colVis.min.js"></script>

    <link rel="stylesheet" type="text/css" href="assets/DataTables/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="assets/DataTables/buttons.dataTables.min.css">

    <!-- DATATABLE EXTENTIONS END -->

    <!-- CHART EXTENTIONS START -->

    <script src="assets/chart/highcharts.js"></script>
    <script src="assets/chart/data.js"></script>
    <script src="assets/chart/drilldown.js"></script>

    <script src="assets/chart/highcharts-more.js"></script>
    <script src="assets/chart/exporting.js"></script>
    <script type="text/javascript" src="assets/chart/no-data-to-display.js"></script>

    <!-- CHART EXTENTIONS END -->

    <link rel="stylesheet" type="text/css" href="assets/calendar/daterangepicker.css" />
    <script type="text/javascript" src="assets/calendar/moment.min.js"></script>
    <script type="text/javascript" src="assets/calendar/daterangepicker.min.js"></script>
    <script type="text/javascript" src="report_js.js"></script>


    <style type="text/css">

        th, td { 
            white-space: nowrap;
        }

        div.dataTables_wrapper {
            width: 100%;
            margin: 0 auto;
        }

        .dataTable{

            min-width: 1500px;
        }

        #chartdiv {
          width: 100%;
          height: 400px;
        }
        
        div.breadcrumb
        {
          z-index: 0 !important;
        }

        div.dt-buttons {
            float: right;
        }  

        .no_data{
            text-align: center;
            color: red;
        }

        #report_header{

            display: flex;
            width: -webkit-fill;
            padding: 15px 20px;
            box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2);
            margin-bottom: 25px;
        }

        #report_header tbody {

            width: -webkit-fill;
        }

        #export_csv{

            float: right;
            padding: 7px;
            background-color: #3AB86E;
            color: white;
        }

        .dt-button-collection, div.dt-button-collection button.dt-button{

            background: white!important;
            padding: 2px!important;
            border: unset!important;
        }

        .dt-button-collection{
            
            background: #ddd!important;
            padding: 10px!important;
        }

        .current, .dt-button{

            /*background: #0767A8!important;*/
            background: linear-gradient(#0767A8 40%, #000046  128%, #000046  153%)!important;
            border: unset!important;
            color: white!important;
        }

        .buttons-columnVisibility{
            color: black!important;
        }

        .paginate_button:hover{

            background: #8c8c8c;
        }

        .table_header{

            width: auto;
            padding: 8px;
            text-align: center;
            margin: 10px;
            box-shadow: 11px 15px 33px -15px rgba(0, 0, 0, 0.2);
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        #container {
            
            height: 400px;
        }

        .highcharts-figure, .highcharts-data-table table {
            
            min-width: 310px;
            max-width: 800px;
            margin: 1em auto;
        }

        .chart_header{

            /*box-shadow: 11px 15px 33px -15px rgba(0, 0, 0, 0.2);*/
            /*border: 1px solid #ccc;*/
            box-shadow: 0 1px 6px rgba(32,33,36,.28);
            border-radius: 5px;
            width: 1000px; 
            height: auto;
        }
        
        div.breadcrumb
        {
          z-index: 0 !important;
        }

        .outer_wrapper{

            display: flex;
            padding: 30px;
        }

        .blocks{
            display: block;
            padding: 20px;
            margin-right: 20px;
            border: 1px solid grey;
            min-width: 250px;
            /*box-shadow: 9px 24px 33px -9px rgba(0, 0, 0, 0.2);*/
            background: white!important;
        }

        .table_blocks{

            padding: 20px;
            font-size: 13px;
            min-width: 250px;
            vertical-align: top;
        }

        tbody{

            margin-top: 20px;
        }

        h2{
            color: #0767A8;
            padding-bottom: 7px;
        }

        td{

            padding: 5px;
        }

        .header{

            border-bottom: 1px solid #e6e6e6;
            width: 250px;
        }

        .select_deselect{

            float: right;
        }

        .hide{

            display: none;
        }

        #generate_button, #back{

            float: right;
            padding: 10px;
            background-color: #8c8c8c!important;
            color: white;
        }

        #generate_button:hover, #back:hover {

          box-shadow: inset 400px 0 0 0  #283250;
          color: white;
        }

        .button_slide {

          color: #FFF;
          display: inline-block;
          font-size: 14px;
          letter-spacing: 1px;
          cursor: pointer;
          box-shadow: inset 0 0 0 0 #283250;
          -webkit-transition: ease-out 0.4s;
          -moz-transition: ease-out 0.4s;
          transition: ease-out 0.4s;
        }

        .date_container{

            padding: 10px;
            margin-bottom: 20px;
            border-bottom: 1px solid black;
            min-width: 220px;
        }

        #date_block{

            font-weight: 700;
            font-size: 13px;
        }

        #blank_row{

            height: 17px;
        }

        .select_box{

            text-align: right;
            float: right;
            margin-right: 0;
        }

        input[type = "checkbox"]{

            cursor: pointer;
        }

        .report_build{

            /*background: #f7f8f9!important;*/
            padding: 30px;
        }

        h1{

            text-align: center;
        }

        .loader_div{

            z-index: 9990!important;
            background-color: rgba(204, 204, 204, 0.49);
            width: 100%;
            height: 100%;
            top: 0;
            right: 0;
            left: 0;
            position: fixed;
        }

        .loader_img{

            position: absolute;
            margin: auto;
            top: 10%;
            left: 35%;
            z-index: 9999!important;
        }


        .highcharts-figure,
        .highcharts-data-table table {

          min-width: 310px;
          max-width: 800px;
          margin: 1em auto;
        }

        #container {

          height: 400px;
        }

        .highcharts-data-table table {

          font-family: Verdana, sans-serif;
          border-collapse: collapse;
          border: 1px solid #ebebeb;
          margin: 10px auto;
          text-align: center;
          width: 100%;
          max-width: 500px;
        }
        .highcharts-data-table caption {

          padding: 1em 0;
          font-size: 1.2em;
          color: #555;
        }
        .highcharts-data-table th {

          font-weight: 600;
          padding: 0.5em;
        }
        .highcharts-data-table td,
        .highcharts-data-table th,
        .highcharts-data-table caption {

          padding: 0.5em;
        }
        .highcharts-data-table thead tr,
        .highcharts-data-table tr:nth-child(even) {

          background: #f8f8f8;
        }
        .highcharts-data-table tr:hover {

          background: #f1f7ff;
        }

        .blur{

            filter: blur(2px);
            -webkit-filter: blur(2px);
            -moz-filter: blur(2px);
            -o-filter: blur(2px);
            -ms-filter: blur(2px);
        }


    </style>

<body>

<!-- ATTRIBUTES STARTS -->
    <div id="loader_div">

        <div class="loader_div">
        </div>

        <div>
            <img class="loader_img" src="assets/images/loader.gif">
        </div>

    </div>

    <div class="report_params">

        <form name="report_form" id="report_form" >

            <div class="report_build">

                <h1 style="color: #283250;"> Build Header Bidding Report </h1>

                <center>

                    <div class="outer_wrapper">

                        <div class="blocks">

                            <table class="table_blocks">

                                <thead>
                                    <tr class="header">
                                        <th class="name"><h2>Attributes</h2></th>
                                        <th class="select_box"><input type="checkbox" id="attr_select">Select All</th>
                                    </tr>
                                    <tr id="blank_row"></tr>
                                </thead>

                                <tbody>
									<tr>
                                        <td>
                                            <input name="attributes[]" type="checkbox" value="hb_bidder" class="attributes com_check"><label> Bidder </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <input name="attributes[]" type="checkbox" value="country" class="attributes com_check"><label> Country </label>
                                        </td>
                                    </tr>
									<tr>
                                        <td>
                                            <input name="attributes[]" type="checkbox" value="hb_media" class="attributes com_check"><label> Media Type </label>
                                        </td>
                                    </tr>
									<tr>
                                        <td>
                                            <input name="attributes[]" type="checkbox" value="hb_size" class="attributes com_check"><label> Sizes </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <input name="attributes[]" type="checkbox" value="hb_source" class="attributes com_check"><label>Source</label>
                                        </td>
                                    </tr>
									<tr>
                                        <td>
                                            <input name="attributes[]" type="checkbox" value="affiliateid" class="attributes com_check"><label>Sites</label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <input name="attributes[]" type="checkbox" value="zoneid" class="attributes com_check"><label> Zones </label>
                                        </td>
                                    </tr>
                                </tbody>

                            </table>

                        </div>


                        <div class="blocks">

                            <table class="table_blocks">

                                <thead>
                                    <tr class="header">
                                        <th class="name"><h2>Metrics</h2></th>
                                        <th class="select_box"><input type="checkbox" id="metric_select">Select All</th>
                                    </tr>
                                    <tr id="blank_row"></tr>
                                </thead>

                                <tbody>
                        
                                    <tr>
                                        <td>
                                            <input name="metrics[]" type="checkbox" value="imp" class="metrics com_check"> <label> Impressions </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <input name="metrics[]" type="checkbox" value="wonbid" class="metrics com_check"> <label> Won Bid </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label> <input name="metrics[]" type="checkbox" value="ecpm" class="metrics com_check"> <label> eCPM $ </label>
                                        </td>
                                    </tr>
								
                                </tbody>

                            </table>

                        </div>


                        <div class="blocks">

                            <table class="table_blocks">

                                <thead>
                                    <tr class="header">
                                        <th class="name"><h2>Date Period</h2></th>
                                        <th class="hide"><input type="checkbox" class="metric_select">Select All</th>
                                    </tr>
                                    <tr id="blank_row"></tr>
                                </thead>

                                <tbody>

                                    <tr style="vertical-align: top;">
                                        <td>
                                            <div class="date_container">
                                                <span id="date_block"/></span>
                                            </div>
                                        </td>
                                        <td>
                                            <input type='image' name="date_range" src='assets/images/icon-calendar-d.gif' id='date_range'/>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td colspan="2">
                                            <b class="button_slide" id="generate_button">Generate Report</b>
                                        </td>
                                    </tr>

                                </tbody>

                            </table>

                        </div>

                    </div>

                </center>

            </div>
        </form>

    </div>

    <!-- ATTRIBUTES ENDS -->

    <!-- REPORT GENDRATION STARTS -->

    <div class="report_gendration">

        <b class="button_slide" style="float: left;" id="back">Back</b>

        <center>

            <div class="chart_header">

                <center>
                    <figure class="highcharts-figure">
                      <div id="container"></div>
                    </figure>
                </center>

            </div>

        </center>

        <div class="border-key">

            <div class="table_header">
                
                <div>

                    <table id="report_table" class="cell-border display" style="width:100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th class="aleft" style="font-size:13px;">Bidder Name</th>
                                <th class="aleft" style="font-size:13px;">Country</th>
                                <th class="aleft" style="font-size:13px;">Media Type</th>
                                <th class="aleft" style="font-size:13px;">Sizes</th>
								<th class="aleft" style="font-size:13px;">Source</th>
								<th class="aleft" style="font-size:13px;">Sites</th>
                                <th class="aleft" style="font-size:13px;">Zone</th>
                                <th class="aleft" style="font-size:13px;">Impressions</th>
                                <th class="aleft" style="font-size:13px;">Won Bid</th>
                                <th class="aleft" style="font-size:13px;">ECPM $</th>
                            </tr>
                        </thead>
                    </table>

                </div>

            </div>

        </div>

    </div>

<!-- REPORT GENDRATION ENDS -->

</body>
</html>


<?php
    phpAds_PageFooter();   
?>
