<?php


require_once '../../../../init.php';

require_once MAX_PATH . '/www/admin/config.php';
require_once LIB_PATH . '/Plugin/PluginManager.php';
require_once LIB_PATH . '/Plugin/ComponentGroupManager.php';
require_once MAX_PATH . '/lib/pear/Date.php';
require_once MAX_PATH . '/lib/OA/Dal.php';
ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL); 
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

$oDbh = &OA_DB::singleton();

$rsReport = [];
$table_heading = [];

$pPass['period_preset'] = $_GET['period_preset'];
if($pPass['period_preset']!='')
{

  if($pPass['period_preset']=='today')
  {
    $start=date('Y-m-d');
    $end=date('Y-m-d');
  }
  else if($pPass['period_preset']=='yesterday')
  {
    $start=date('Y-m-d', strtotime('Yesterday'));
    $end=date('Y-m-d', strtotime('Yesterday'));

  }
  else if($pPass['period_preset']=='this_week')
  {
    $start=date('Y-m-d', strtotime('this week Monday'));
    $end=date('Y-m-d');
  }
  else if($pPass['period_preset']=='last_week')
  {
    $start=date('Y-m-d', strtotime('previous Monday'));
    $end=date('Y-m-d', strtotime('previous Sunday'));
  }
  else if($pPass['period_preset']=='last_7_days')
  {
    $start=date('Y-m-d', strtotime('Today - 7 Day'));
    $end=date('Y-m-d', strtotime('Today - 1 Day'));
  }
  else if($pPass['period_preset']=='this_month')
  {
    $start=date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
    $end=date('Y-m-d');
  }
  else if($pPass['period_preset']=='last_month')
  {
    $start=date('Y-m-d', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')));
    $end=date('Y-m-d', mktime(0, 0, 0, date('m'), 0, date('Y')));
  }
  else if($pPass['period_preset']=='all_stats')
  {
    $start='0000-00-00';
    $end=date('Y-m-d'); $period_preset='all_stats';
  }
  else if($pPass['period_preset']=='specific')
  {
    $start=$pPass['period_start'];
    $end=$pPass['period_end'];
  }

}
else
{
  $start=date('Y-m-d');
  $end=date('Y-m-d');
}

$start_date=$start;
$end_date=$end;


/*Convert start date and end date into timezone format*/

if($period_preset=='all_stats')
{
  $start_date="0000-00-00 00:00:00";
  $end_day=new Date(date('Y-m-d H:i:00'));
  $end_day->setHour(23);
  $end_day->setMinute(59);
  $end_day->setSecond(59);
  $end_day->toUTC();
  $end_date=$end_day->format('%Y-%m-%d %H:%M:%S');
}
else if($start_date=='' && $end_date=='')
{ 
  $start_day=new Date(date('Y-m-d H:i:00'));
  $start_day->setHour(0);
  $start_day->setMinute(0);
  $start_day->setSecond(0);
  $start_day->toUTC();
  $start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
  $end_day=new Date(date('Y-m-d H:i:00'));
  $end_day->setHour(23);
  $end_day->setMinute(59);
  $end_day->setSecond(59);
  $end_day->toUTC();
  $end_date=$end_day->format('%Y-%m-%d %H:%M:%S'); 
  
}
else
{
  $end_day=new Date($end_date);
  $end_day->setHour(23);
  $end_day->setMinute(59);
  $end_day->setSecond(59);
  $end_day->toUTC();
  $end_date=$end_day->format('%Y-%m-%d %H:%M:%S');
  $start_day=new Date($start_date);
  $start_day->setHour(0);
  $start_day->setMinute(0);
  $start_day->setSecond(0);
  $start_day->toUTC();
  $start_date=$start_day->format('%Y-%m-%d %H:%M:%S');
}



$_bidder = $_GET['bidder'];
$_report = $_GET['report'];


//~REPORT LIST
    
$report_list = array(

                '1' => array('fet' => 'country_name', 'tb'=> 'country' , 'adv'=> 'country_name', 'name' => 'Country', 'value' => 1),

                '2' => array('fet' => 'domain', 'tb'=> 'dj_dsp_adv_report_domain' , 'adv'=> 'domain', 'name' => 'Domain', 'value' => 2),

                '3' => array('fet' => 'os', 'tb'=> 'dj_dsp_adv_report_os' , 'adv'=> 'os', 'name' => 'OS', 'value' => 3),

                '4' => array('fet' => 'ip', 'tb'=> 'dj_dsp_adv_report_ip' , 'adv'=> 'ip', 'name' => 'IP', 'value' => 4),

                '5' => array('fet' => 'language', 'tb'=> 'dj_dsp_adv_report_language' , 'adv'=> 'language', 'name' => 'Language', 'value' => 5),

                '6' => array('fet' => 'user_agent', 'tb'=> 'dj_dsp_adv_report_user_agent' , 'adv'=> 'user_agent', 'name' => 'User-Agent', 'value' => 6),

                '7' => array('fet' => 'age', 'tb'=> 'dj_dsp_adv_report_age' , 'adv'=> 'age', 'name' => 'User Age', 'value' => 7),


                '8' => array('fet' => 'gender', 'tb'=> 'dj_dsp_adv_report_gender' , 'adv'=> 'gender', 'name' => 'User Gender', 'value' => 8),

                '9' => array('fet' => 'device_make', 'tb'=> 'dj_dsp_adv_report_device_make' , 'adv'=> 'device_make', 'name' => 'Device Make', 'value' => 9),

               '10' => array('fet' => 'device_type', 'tb'=> 'dj_dsp_adv_report_device_type' , 'adv'=> 'device_type', 'name' => 'Device Type', 'value' => 10),


               '11' => array('fet' => 'device_model', 'tb'=> 'dj_dsp_adv_report_device_model' , 'adv'=> 'device_model', 'name' => 'Device Model', 'value' => 11),

               '12' => array('fet' => 'page_url', 'tb'=> 'dj_dsp_adv_report_page_url' , 'adv'=> 'page_url', 'name' => 'Site URL', 'value' => 12),

               '13' => array('fet' => 'site_category', 'tb'=> 'dj_dsp_adv_report_site_category' , 'adv'=> 'site_category', 'name' => 'Site Category', 'value' => 13)

              );

/**************************** BIDDERS BASED REPORT STARTS *********************************/

if($_bidder!= 0 && $_report == 0)
{
    $title = $rsReport[0]['dsp_portal_name']."Report";

    $tb_select = "SELECT  d.dsp_portal_name, r.os, sum(r.request_count) as request_count, sum(r.response_count) as response_count, sum(r.win_notice_count) as win_notice_count, sum(r.impression_count) as impression, sum(r.click_count) as click , sum(r.total_amount) as total_amount , sum(r.admin_share) as admin_share , sum(r.test_win_notice_count) as test_win_notice_count from {$table_prefix}dj_dsp_advanced_reports r  inner join {$table_prefix}dj_dsp d on d.id = r.bidderid ";

    $tb_where = " WHERE r.date_created  between '{$start_date}' AND '{$end_date}' AND r.bidderid=".$_bidder;   

    $tb_group = " group by r.bidderid";

    $query = $tb_select.$tb_where.$tb_group;

    //~EXCEL VALUES STARTS

    $rsReport = $oDbh->query($query)->fetchAll();
    $table_heading = array('Bidder Name', 'Request Count','Response Count','Win Notice Count','Impressions', 'Clicks','Amount','Admin Share','Test Win Notice');
}





/**************************** REPORT BASED REPORT STARTS *********************************/

else if($_bidder == 0 && $_report != 0)
{
    $title = $report_list[$_report]['name'];

    $graph_values="";

    $tb_select = "SELECT  d.dsp_portal_name, r.{$report_list[$_report]['fet']}, sum(r.request_count) as request_count, sum(r.response_count) as response_count, sum(r.win_notice_count) as win_notice_count, sum(r.impression_count) as impression, sum(r.click_count) as click ,  sum(r.total_amount) as total_amount , sum(r.admin_share) as admin_share , sum(r.test_win_notice_count) as test_win_notice_count from {$table_prefix}dj_dsp_advanced_reports r  inner join {$table_prefix}dj_dsp d on d.id = r.bidderid ";

    $tb_where = " WHERE r.date_created  between '{$start_date}' AND '{$end_date}' ";   

    $tb_group = " group by r.{$report_list[$_report]['fet']} ";

    $query = $tb_select.$tb_where.$tb_group;

    //~TABLE VALUES STARTS


    $rsReport = $oDbh->query($query)->fetchAll();
    $table_heading = array( 'Bidder Name',strtoupper( $report_list[$_report]['adv'] ), 'Request Count','Response Count','Win Notice Count','Impressions', 'Clicks','Amount','Admin Share','Test Win Notice');
}



/**************************** BIDDERS & REPORT BASED STARTS *********************************/

else if($_bidder != 0 && $_report != 0)
{
    $title =  $rsReport[0]['dsp_portal_name']." - ".$report_list[$_report]['name'];

    $tb_select = "SELECT  d.dsp_portal_name, r.{$report_list[$_report]['fet']}, sum(r.request_count) as request_count, sum(r.response_count) as response_count, sum(r.win_notice_count) as win_notice_count, sum(r.impression_count) as impression, sum(r.click_count) as click , sum(r.total_amount) as total_amount , sum(r.admin_share) as admin_share , sum(r.test_win_notice_count) as test_win_notice_count from {$table_prefix}dj_dsp_advanced_reports r  inner join {$table_prefix}dj_dsp d on d.id = r.bidderid ";

    $tb_where = " WHERE r.date_created between '{$start_date}' AND '{$end_date}' AND r.bidderid=".$_bidder;   

    $tb_group = " group by r.bidderid, r.{$report_list[$_report]['fet']}  order by d.dsp_portal_name ASC";

    $query = $tb_select.$tb_where.$tb_group;

    //~TABLE VALUES STARTS

    $rsReport = $oDbh->query($query)->fetchAll();
    $table_heading = array('Bidder Name', strtoupper($report_list[$_report]['adv']), 'Request Count','Response Count','Win Notice Count','Impressions', 'Clicks','Amount','Admin Share','Test Win Notice');

}



/**************************** ALL BIDDERS REPORT STARTS *********************************/

else if($_report == 0 && $_bidder == 0)
{
   $title = "AllBiddersReport";

   $tb_select = "SELECT d.dsp_portal_name as Bidder_Name, r.country_name as Country_Name, r.os as OS,r.domain as Domain, r.ip as IP, r.user_agent as User_Agent, r.language as Language, r.age as Age, r.gender as Gender, r.device_type as Device_Type, r.device_make as Device_Make, r.device_model as Device_Model, r.page_url as URL, sum(r.request_count) as Request_Count, sum(r.response_count) as Response_Count, sum(r.win_notice_count) as Wing_Notice, sum(r.impression_count) as Impression, sum(r.click_count) as Click ,   sum(r.total_amount) as total_amount , sum(r.admin_share) as admin_share , sum(r.test_win_notice_count) as test_win_notice_count  from {$table_prefix}dj_dsp_advanced_reports r inner join {$table_prefix}dj_dsp d on d.id = r.bidderid";

   $tb_group = "group by r.bidderid, r.country_name, r.os ,r.domain, r.ip, r.user_agent, r.language, r.age, r.gender, r.device_type, r.device_make, r.device_model,r.page_url order by d.dsp_portal_name ASC";

   $tb_where = " WHERE r.date_created  between '{$start_date}' AND '{$end_date}' ";

   $query = $tb_select.$tb_where.$tb_group;

    //~ TABLE VALUES STARTS
	//~ echo $query;
   $rsReport = $oDbh->query($query)->fetchAll();
   $table_heading = array('Bidder Name','Country Name','OS','Domain','IP','User Agent','Language','Age','Gender','Device Type','Device Make','Device Model','Page URL','Request Count','Response Count','Win Notice Count','Impressions', 'Clicks','Amount','Admin Share','Test Win Notice');
}




if($rsReport)    
{   
    // file name for download
    $filename = $title."_".$start_date."_".$end_date.".csv";
    $filename = str_replace(' ', '', $filename);

   
    header("Content-Disposition:attachment;filename=\"$filename\"");
    header('Content-Type: text/csv; charset=utf-8');

    // Generate CSV in Memory
    $file = fopen('php://temp/maxmemory:', 'r+'); // 128mb

    // Write CSV to memory
    // fputcsv($file, array_keys(call_user_func_array('array_merge', strtoupper($rsReport))));
    
    $date = '';

    $date = $start_date." to ".$end_date;
    
    array_unshift($rsReport, array(''));
    array_unshift($rsReport, $table_heading);
    array_unshift($rsReport, array(''));
    array_unshift($rsReport, array("Date:", $date) );
    array_unshift($rsReport, array("Report: ", $title) );
   
   //~ print_r($rsReport);
   //~ die();
    foreach($rsReport as $row)
    {
        fputcsv($file, $row);
    }

    rewind($file);
    $output = stream_get_contents($file);
    fclose($file);

    echo $output;

}


exit;


?>
