<?php
// Require the initialisation file
$path = dirname(__FILE__);
require_once $path . '/../../init.php';
date_default_timezone_set('UTC');
if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

OA_Dal_Delivery_query("INSERT INTO `dj_hb_reports`(`datetime`,`zoneid`, `hb_bidder`, `hb_source`, `hb_media`,
		`hb_size`, `hb_wonbid`, `impression`, `country`)
					SELECT 
					vir.datetime,
					vir.zoneid,
					vir.hb_bidder,
					vir.hb_source,
					vir.hb_media,
					vir.hb_size,
					IFNULL(sum(vir.hb_wonbid), 0) AS hb_wonbid,
					IFNULL(sum(vir.impression), 0) AS impression,
					vir.country
					FROM
					(
					SELECT
							datetime,
							zoneid,
							hb_bidder,
							hb_source,
							hb_media,
							hb_size,
							hb_wonbid,
							impression,
							country
					FROM		
							dj_hb_tracking
							where
							zoneid!=0
							AND 
							hb_bidder!=''
							AND
							datetime<='" . date('Y-m-d H:59:59') . "' GROUP BY datetime,zoneid,hb_bidder,hb_source,hb_media,hb_size,country)
					AS vir GROUP BY datetime,zoneid,hb_bidder,hb_source,hb_media,hb_size,country");
					
					
OA_Dal_Delivery_query("delete from dj_hb_tracking where datetime='" . date('Y-m-d H:59:59') . "'");
?>