<?php

	header("Access-Control-Allow-Origin: *");
	header("Content-Type: application/json; charset=UTF-8");
	header("Access-Control-Allow-Methods: POST");
	header("Access-Control-Max-Age: 3600");
	header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

	require_once '../../init.php';
      
	// Required files
	require_once MAX_PATH . '/lib/OA/Dal.php';      
	require_once MAX_PATH . '/lib/OA/Admin/Option.php';
	require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
	require_once MAX_PATH . '/www/admin/config.php';
	require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
      
	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
	}
	else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
	}
	else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
	}


   	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];	
	$clientid = $_REQUEST['clientid'];
		## Fetch records
		$getDateReportQuery = OA_Dal_Delivery_Query("SELECT h.*,MONTH(h.dep_date) as month  , SUM(h.amt) as amt FROM dj_payment_history as h LEFT JOIN ".$table_prefix."clients as c ON h.client_id=c.clientid WHERE  h.status = 1 and h.client_id={$clientid} GROUP BY MONTH(h.dep_date)");
		
		
		$getCampaingid = OA_Dal_Delivery_Query("SELECT b.bannerid as bid from rv_campaigns as c LEFT JOIN rv_banners AS b ON c.campaignid=b.campaignid WHERE c.clientid={$clientid}");
		$banid=array();
		while ($row1 = OA_Dal_Delivery_fetchAssoc($getCampaingid)) {
			$banid[]=$row1['bid'];
		}
$idban= implode(',',$banid);
$intermediatead = OA_Dal_Delivery_Query("SELECT SUM(total_basket_value) as total,MONTH(date_time) as month  from rv_data_intermediate_ad WHERE ad_id IN({$idban}) GROUP BY MONTH(date_time)");
$arrbal = array();
while($balance = OA_Dal_Delivery_fetchAssoc($intermediatead)){
$arrbal[]=array(
'total'=>$balance['total'],
'month'=>$balance['month']);
}
$data = array();
$i=0;	
	if (isset($getDateReportQuery) && !empty($getDateReportQuery)) {
		while ($row = OA_Dal_Delivery_fetchAssoc($getDateReportQuery)) {
			$type = $row['type']==1?'Wire':'Paypal';
			$timestamp =  date('F, Y',strtotime($row['dep_date']));
			if ($arrbal[$i]['month']==$row['month']) {
				$usedbal = $arrbal[$i]['total'];
			}
			if($usedbal == null )
			{
				$usedbal= 0;
				
			}
			

		   $data[] = array( 
		      "data_type"=>$timestamp,
		      "amount"=>$row['amt'],
		      "spend"=>$usedbal
		   );
		   $i++;
		}
	}

	echo json_encode($data);
	exit();
?>
    
		
