(function($) 
{
    function generateTable() 
    {
      var id = $('#clientid').val();
      var start_date = $("#period_start").val();
      var end = $("#period_end").val();
      var rowperpage = 10;
      var type = 'pre';
      console.log(type);

      $('#table_report').DataTable(
      {
          'processing': true,
          'serverSide': true,
          'serverMethod': 'post',
          'bDestroy': true,
          'pageLength': 10,
          'lengthMenu': [
              [25, 50, 75, 100, -1],
              [25, 50, 75, 100, "All"]
          ],
          'bFilter': false,
          'dom': 'lBfrtip',
          'buttons': ['excel', 'csv', 'pdf'],
          'ajax': 
          {
              'url': 'dj_payment_datatable.php',
              'data':{'clientid':id , 'start_date': start_date, 'end': end, 'adv_type' : type}
          },
          'columns': [
                { data: 'data_type'},
                { data: 'amount'},
                { data: 'status'},
                { data: 'type'}
              ]
      });
  }

generateTable();


// <!--*********************************************** DATE SCRIPT STARTS *************************************-->

var calendar = "assets/images/icon-calendar-d.gif";
Calendar.setup({
    inputField : 'period_start',
    ifFormat   : '%Y-%m-%d',
    button     : 'period_start_button',
    align      : 'Bl',
    weekNumbers: false,
    firstDay   : 1,
    electric   : false
});
Calendar.setup({
    inputField : 'period_end',
    ifFormat   : '%Y-%m-%d',
    button     : 'period_end_button',
    align      : 'Bl',
    weekNumbers: false,
    firstDay   : 1,
    electric   : false
});

$("#period_preset").change(function()
{
  periodFormChange(1);
});

$("#submit_dates").click(function()
{  generateTable();
});
      
function periodFormChange(bAutoSubmit)
{
    var o = document.getElementById('period_preset');
    var periodSelectName = o.options[o.selectedIndex].value;
    var specific = periodSelectName == 'specific';
    var periodTabIndex = 2;

    document.getElementById('period_start').readOnly = !specific;
    document.getElementById('period_start_button').disabled = !specific;
    document.getElementById('period_end').readOnly = !specific;
    document.getElementById('period_end_button').disabled = !specific;
   
  if (!specific) 
  {
    if(bAutoSubmit)
    {
      document.getElementById('period_start').disabled = true;
      document.getElementById('period_end').disabled =  true; 
      generateTable();
    }
    
    document.getElementById('period_start').classList.add("disapp");
    document.getElementById('period_end').classList.add("disapp");
    document.getElementById('period_start').tabIndex = null;
    document.getElementById('period_start_button').tabIndex = null;
    document.getElementById('period_end').tabIndex = null;
    document.getElementById('period_end_button').tabIndex = null;
    document.getElementById('period_start_button').src = calendar;
    document.getElementById('period_end_button').src = calendar ;

  } 
  else 
  {
    document.getElementById('period_start').classList.remove("disapp");
    document.getElementById('period_end').classList.remove("disapp");
    document.getElementById('period_start').tabIndex = periodTabIndex;
    document.getElementById('period_start_button').tabIndex = periodTabIndex + 1;
    document.getElementById('period_end').tabIndex = periodTabIndex + 2;
    document.getElementById('period_end_button').tabIndex = periodTabIndex + 3;
    document.getElementById('period_start_button').src = calendar;
    document.getElementById('period_end_button').src = calendar ;
  }

  document.getElementById('period_start_button').readOnly = !specific;
  document.getElementById('period_end_button').readOnly = !specific;

  document.getElementById('period_start_button').style.cursor = specific ? 'auto' : 'default';
  document.getElementById('period_end_button').style.cursor = specific ? 'auto' : 'default';

  if (!specific && bAutoSubmit) 
  {
      o.form.submit();
  }
}


periodFormChange(0);

function periodFormSubmit() 
{
    var form = document.getElementById('period_form').form;
    if (checkDates(form)) {

      form.submit();
    }
    return false;
}

function checkDates(form)
{
  var startField = form.period_start;
  var endField = form.period_end;

  if (!startField.disabled && startField.value != '') {
    var start_date = Date.parseDate(startField.value, '%Y-%m-%d');
  }
  if (!startField.disabled && endField.value != '') {
    var end = Date.parseDate(endField.value, '%Y-%m-%d');
  }

  if ((start_date != undefined && end != undefined) && (start_date.getTime() > end.getTime())) {
    alert('\'From\' date must be earlier then \'To\' date');
    return false;
  }
  return true;
}

// <!-- **************************************** DATE SCRIPT ENDS ********************************************* -->


})(jQuery);


