<?php
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/
// Require the initialisation file
require_once '../../../../init.php';


require_once MAX_PATH . '/lib/OA/Admin/TemplatePlugin.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';

require_once MAX_PATH .'/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/lib/OX/Plugin/Component.php';
require_once MAX_PATH . '/www/admin/config.php';


// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

// Load translation class
$oTranslation = new OX_Translation();

// Register input variables
phpAds_registerGlobalUnslashed(
     'errormessage'
    ,'dmp_url'
    ,'dmp_seg_user_url'
);



		$doCheck = OA_Dal::factoryDO('dmp_settings');
        $doCheck->whereAdd('name = "dmp_url"');
        $doCheck->limit(1);
        $doCheck->fetch();
        $doCheck->find();
        $doCheck->fetch();
		$data =  $doCheck->toArray();

$aformdata['dmp_url'] = ($data['name']=="dmp_url") ? $data['value'] : '';

		$doCheck = OA_Dal::factoryDO('dmp_settings');
        $doCheck->whereAdd('name = "dmp_seg_user_url"');
        $doCheck->limit(1);
        $doCheck->fetch();
        $doCheck->find();
        $doCheck->fetch();
		$data =  $doCheck->toArray();
		
$aformdata['dmp_seg_user_url'] = ($data['name']=="dmp_seg_user_url") ? $data['value'] : '';

		$doCheck = OA_Dal::factoryDO('dmp_settings');
        $doCheck->whereAdd('name = "dmp_tracking_pixel"');
        $doCheck->limit(1);
        $doCheck->fetch();
        $doCheck->find();
        $doCheck->fetch();
		$data =  $doCheck->toArray();
		
$aformdata['dmp_tracking_pixel'] = ($data['name']== "dmp_tracking_pixel") ? $data['value'] : '';
		
$form = buildForm($aformdata);

if ($form->validate()) {
    //process submitted values
    processForm($aformdata, $form);
}
else { 
	
	//either validation failed or form was not submitted, display the form
    displayPage($aformdata, $form);
}



/*-------------------------------------------------------*/
/* Build form                                            */
/*-------------------------------------------------------*/
function buildForm($aformdata)
{
	
    $form = new OA_Admin_UI_Component_Form("forms", "POST", $_SERVER['SCRIPT_NAME']);
    $form->forceClientValidation(true);
    $form->addElement('header', 'header_basic', 'DMP Informations');
	$nameElem = $form->createElement('text', 'dmp_url', 'DMP Segment URL (with http://)');
    $form->addElement($nameElem);
    $nameElem = $form->createElement('text', 'dmp_seg_user_url', 'DMP Segment User API');
    $form->addElement($nameElem);
    $nameElem = $form->createElement('textarea', 'dmp_tracking_pixel', 'DMP Tracking Pixel');
    $form->addElement($nameElem);
	$form->addRule('dmp_url','Required', 'required');
    $form->addRule('dmp_seg_user_url','Required', 'required');
    $form->addElement('submit', 'submit', 'Save');
	$form->setDefaults($aformdata);
    return $form;
}


/*-------------------------------------------------------*/
/* Process submitted form                                */
/*-------------------------------------------------------*/
function processForm($aformdata, $form)
{
	
	  $aFields = $form->exportValues ();
	  
	if(isset($aFields['dmp_url']))
	{
		$doCheck = OA_Dal::factoryDO('dmp_settings');
        $doCheck->whereAdd('name = "dmp_url"');
        $doCheck->limit(1);
        $doCheck->find();
        $doCheck->fetch();
		$data =  $doCheck->toArray();
		if($data['name'] != 'dmp_url')
		{
			$adata = array();
			$adata['name']  = 'dmp_url';
			$adata['value'] =  $aFields['dmp_url'] ;
			$adata['data_updated'] = date ("Y-m-d H:i:s");
			$doAdd = OA_Dal::factoryDO('dmp_settings');
			$doAdd->setFrom($adata);
			$doAdd->insert();
		}
		else 
		{
			
			$doUpdate = OA_Dal::factoryDO('dmp_settings');
			$doUpdate->get($data['id']);
			$adata = array();
			$adata['id']  = $data['id'];
			$adata['name']  = 'dmp_url';
			$adata['value'] =  $aFields['dmp_url'] ;
			$adata['data_updated'] = date ("Y-m-d H:i:s");
			$doUpdate->setFrom($adata);
			$doUpdate->updated = OA::getNow();
			$doUpdate->update();
			
		}
		
		
		$doCheck = OA_Dal::factoryDO('dmp_settings');
        $doCheck->whereAdd('name = "dmp_seg_user_url"');
        $doCheck->limit(1);
        $doCheck->find();
        $doCheck->fetch();
		$data =  $doCheck->toArray();
		if($data['name'] != 'dmp_seg_user_url')
		{
			$adata = array();
			$adata['name']  = 'dmp_seg_user_url';
			$adata['value'] =  $aFields['dmp_seg_user_url'] ;
			$adata['data_updated'] = date ("Y-m-d H:i:s");
			$doAdd = OA_Dal::factoryDO('dmp_settings');
			$doAdd->setFrom($adata);
			$doAdd->insert();
		}
		else
		{
			
			$doUpdate = OA_Dal::factoryDO('dmp_settings');
			$doUpdate->get($data['id']);
			$adata = array();
			$adata['id']  = $data['id'];
			$adata['name']  = 'dmp_seg_user_url';
			$adata['value'] =  $aFields['dmp_seg_user_url'] ;
			$adata['data_updated'] = date ("Y-m-d H:i:s");
			$doUpdate->setFrom($adata);
			$doUpdate->updated = OA::getNow();
			$doUpdate->update();
			
		}
		
		$doCheck = OA_Dal::factoryDO('dmp_settings');
        $doCheck->whereAdd('name = "dmp_tracking_pixel"');
        $doCheck->limit(1);
        $doCheck->find();
        $doCheck->fetch();
		$data =  $doCheck->toArray();
		if($data['name'] != 'dmp_tracking_pixel')
		{
			$adata = array();
			$adata['name']  = 'dmp_tracking_pixel';
			$adata['value'] =  $aFields['dmp_tracking_pixel'] ;
			$adata['data_updated'] = date ("Y-m-d H:i:s");
			$doAdd = OA_Dal::factoryDO('dmp_settings');
			$doAdd->setFrom($adata);
			$doAdd->insert();
		}
		else
		{
			
			$doUpdate = OA_Dal::factoryDO('dmp_settings');
			$doUpdate->get($data['id']);
			$adata = array();
			$adata['id']  = $data['id'];
			$adata['name']  = 'dmp_tracking_pixel';
			$adata['value'] =  $aFields['dmp_tracking_pixel'] ;
			$adata['data_updated'] = date ("Y-m-d H:i:s");
			$doUpdate->setFrom($adata);
			$doUpdate->updated = OA::getNow();
			$doUpdate->update();
			
		}
		
		// Queue confirmation message
        $translation = new OX_Translation ();
        $translated_message = $translation->translate ('DMP settings updated');
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

        // Go to next page
        OX_Admin_Redirect::redirect("plugins/dmp/dmp-settings.php");
		
		exit;
	}
	
	
  
            
	
}

/*-------------------------------------------------------*/
/* Display page                                          */
/*-------------------------------------------------------*/
function displayPage($aformdata, $form)
{


$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel('DMP Settings');
$oHeaderModel->setIconClass('iconTargetingChannelsLarge');
$oHeaderModel->setpageType('list');
phpAds_PageHeader(null, $oHeaderModel);


    //get template and display form
    $oTpl = new OA_Plugin_Template('dmp-settings.html','dmp');
    
    $oTpl->assign('form', $form->serialize());
    $oTpl->display();
    
    
    
    
       
         
       
    
phpAds_PageFooter();


}
