<?php

// Require the initialisation file
require_once '../../../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/RV/Admin/Languages.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
require_once MAX_PATH . '/lib/OA/Dll/Publisher.php';
require_once MAX_PATH . '/lib/OA/Admin/Menu.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/OA/Admin/Template.php';

require_once MAX_PATH . '/lib/max/other/common.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/OA/Maintenance/Priority.php';
require_once LIB_PATH . '/Plugin/Component.php';
require_once MAX_PATH . '/lib/OA/Admin/Template.php';
require_once MAX_PATH . '/lib/OA/Admin/TemplatePlugin.php';

if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}elseif ($GLOBALS['_MAX']['CONF']['database']['type'] == 'pgsql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}elseif ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysqli') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

// Register input variables
phpAds_registerGlobalUnslashed ('move', 'name', 'dsp_type', 'dealid_token', 'errormessage', 'submit', 'publiczones_old', 'formId');
// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER);
$dealid=$_REQUEST['dealid'];

/*-------------------------------------------------------*/
/* Store preferences                                     */
/*-------------------------------------------------------*/
phpAds_SessionDataStore();
/*-------------------------------------------------------*/
/* Initialise data                                    */
/*-------------------------------------------------------*/
if ($dealid != "") {
    // Do not get this information if the page
    // is the result of an error message
    if (!isset($deal)) 
    {
         $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
         $rows=OA_Dal_Delivery_query("SELECT `dealid`, `agencyid`, `name`, `dsp_type`, `deal_at`, `dealid_token`, `floor_price`, `start`, `end`, `is_pause`, `is_expire`, `is_delete`, `updated`, `websites` as sel_websites, `zones` as sel_zones, `adsize` as sel_adsize, `deal_comments`, `auction_type`, `created`, `compiledlimitation`, `acl_plugins`, `block`, `capping`, `session_capping`, `cus_width`, `cus_height`, `whitelist` FROM {$table_prefix}dealid WHERE
          dealid='$dealid'");
         $deal = OA_Dal_Delivery_fetchAssoc($rows);
        
    }
}

//build form

$DealForm = buildDealForm($deal);

if ($DealForm->validate()) 
{
    //process submitted values
    $oPublisherDll = processForm($dealid, $DealForm, $oComponent);
    if ($oPublisherDll->_errorMessage || $oPublisherDll->_noticeMessage) {
        displayPage($dealid, $DealForm, $oPublisherDll);
    }
}
else 
{ 
    //either validation failed or form was not submitted, display the form
    displayPage($dealid, $DealForm);
}

/*-------------------------------------------------------*/
/* Display page                                          */
/*-------------------------------------------------------*/
function displayPage($dealid, $form, $oPublisherDll = null)
{
    //header and breadcrumbs
    //$oHeaderModel = MAX_displayWebsiteBreadcrumbs($affiliateid);
    if ($dealid != "") {
        OA_Admin_Menu::setPublisherPageContext($dealid, 'dealid-edit.php');
      //  addWebsitePageTools($affiliateid);
        phpAds_PageHeader("Deal-Add", $oHeaderModel);
    }
    else {
        phpAds_PageHeader("Deal-Add", $oHeaderModel);
    }


    $oTpl = new OA_Plugin_Template('dealid-edit.html', 'Rtb');

    $oTpl->assign('dealid', $dealid);
    $oTpl->assign('form', $form->serialize());
    
    if (isset($oPublisherDll)) {
        $oTpl->assign('error',  $oPublisherDll->_errorMessage);
        $oTpl->assign('notice', $oPublisherDll->_noticeMessage);
    }

    $oTpl->assign('showAdDirect', (defined('OA_AD_DIRECT_ENABLED') && OA_AD_DIRECT_ENABLED === true) ? true : false);
    $oTpl->assign('keyAddNew', $keyAddNew);

    $oTpl->display();


// echo "<pre>";print_r($oTpl);exit;
    //footer
    phpAds_PageFooter();
    
    
}

/*-------------------------------------------------------*/
/* Build form                                            */
/*-------------------------------------------------------*/
function buildDealForm($deal)
{

    $form = new OA_Admin_UI_Component_Form("dealidform", "POST", $_SERVER['SCRIPT_NAME']);

    $form->forceClientValidation(true);
    $form->addElement('hidden', 'dealid', $deal['dealid']);

    $form->addElement('header', 'basic_info', $GLOBALS['strBasicInformation']);
    $form->addElement('text', 'name', $GLOBALS['strName']);
    

    ## PREVIOUS ZONES
    $dealid_token ['dealid_token'] = $form->createElement ( 'text', 'dealid_token', null, array ('id' => 'dealid_token', 'class' => 'small' ) );
    $dealid_token ['deal_img'] = $form->createElement ('html', 'copy_button', "&nbsp;<img width='17' title='Click to Copy Token' style='cursor:pointer;' height='20' src='assets/images/icon-copy.png' id='copy' value='Copy' > <h7 style='background:#0767A8; padding: 8px; color:white; width:15px;height:15px;' id='cpy_notification'><b>Token Copied !</b></h7> ");

    $form->addGroup ( $dealid_token, 'dealid_token', 'Deal Token' );

    $newWebsite = empty($deal['dealid']);
    if ($newWebsite) {
        $form->addElement('submit', 'generate_token', 'Generate Deal-Token');            
    }

	/****  DSP Listing - Starts here ****/
	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
    $agencyid = $GLOBALS['agencyid'];
    $sel_dsps = unserialize($deal['dsp_type']);

    $list = OA_Dal_Delivery_query("SELECT id as dsp_id, dsp_portal_name as dsp_name FROM {$table_prefix}dj_dsp order by dsp_name");

    $input_dsplist = '';

    if(OA_Dal_Delivery_numRows($list) > 0)
    {
        $i = 0;
        while ($row = OA_Dal_Delivery_fetchAssoc($list)) 
        {           
            $website_list[$row['dsp_id']] =   $row['dsp_name'];
            $checked = '';

            if(in_array($row['dsp_id'], $sel_dsps)){

                $checked = 'checked';
            }

            $input_dsplist .= '<tr width:250px!important class="deal_dsps">
              <td>
                <label>
                    <input name="dsp_type[]" type="checkbox" value='.$row['dsp_id'].' class="dsps-list" id="dsp_id'.$row['dsp_id'].'" '.$checked.' >'.$row['dsp_name'].'
                </label>
              </td></tr>';

        }
        
    }
	
    $dspgroup['dsp'] = $form->createElement('html', 'dsp', '<span style="display:-webkit-box;">

        <div class="deal-dsps" style="margin-right: 25px; width:272px; height:250px; border: 1px solid grey; overflow: auto;">
          <div id="zones-linked-container">
            <table id="deals-dsp_list" class="deals-dsp_list new-table tableWrapper">

              <thead>
                <tr class="header hide" style="display: table-row;">
                  <th class="name" style="background-color: #0767A8; text-align: center; color: white; font-size:12px;"><label>Select DSP</label></th>
                </tr>
              </thead>
              <tbody>
                <tr class="dsp_lists">
                  <td>
                    <label>
                        '.$input_dsplist.'
                    </label>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
    </div>');

    $form->addGroup($dspgroup, 'dsp_type', 'DSP' );
	/****  DSP Listing - Ends here ****/
	
    /**************************************************** WEBSITE AND ZONE LISTING STARTS **********************************************/

    $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
    $agencyid = $GLOBALS['agencyid'];
    $sel_websites = unserialize($deal['sel_websites']);
    $sel_zones = unserialize($deal['sel_zones']);

    $list = OA_Dal_Delivery_query("SELECT affiliateid, name as web_name FROM {$table_prefix}affiliates WHERE agencyid = '".$agencyid."'  order by web_name");

    $input_list = '';

    if(OA_Dal_Delivery_numRows($list) > 0)
    {
        $i = 0;
        while ($row = OA_Dal_Delivery_fetchAssoc($list)) 
        {           
            $website_list[$row['affiliateid']] =   $row['web_name'];
            $checked = '';

            if(in_array($row['affiliateid'], $sel_websites)){

                $checked = 'checked';
            }

            $input_list .= '<tr width:250px!important class="website">
              <th class="name">
                <label style="white-space: nowrap">
                    <input name="websites[]" type="checkbox" value='.$row['affiliateid'].' class="websites" id="website_id'.$row['affiliateid'].'" '.$checked.' >'.$row['web_name'].'
                </label>
              </th></tr>';
            
            $query2 = OA_Dal_Delivery_query(" SELECT zoneid ,zonename FROM {$table_prefix}zones WHERE affiliateid = '".$row['affiliateid']."' order by zonename ");

            if( OA_Dal_Delivery_numRows($query2) > 0 )
            {
                while ( $row1 = OA_Dal_Delivery_fetchAssoc( $query2 ) ) 
                {    
                    $zone_list[$row1['zoneid']] =   $row1['zonename']; 
                    $checked = '';

                    if(in_array($row1['zoneid'], $sel_zones)){

                        $checked = 'checked';
                    }     

                    $input_list .= '<tr style="margin-left: 100px!important;" class="zone">
                      <td class="name">
                        <label style="margin-left: 25px!important">
                            <input name="zones[]" value='.$row1['zoneid'].' class="zone_list webid_'.$row['affiliateid'].'" id="zone_id'.$row['zoneid'].'" type="checkbox" '.$checked.'>'.$row1['zonename'].'
                        </label>
                      </td></tr>';
                } 
            }$i++;
        }
        
    }

    $group1['websites'] = $form->createElement('html', 'websites', '<span style="display:-webkit-box;">

        <div class="website_zones" style="margin-right: 25px; width:272px; height:250px; border: 1px solid grey; overflow: auto;">
          <div id="zones-linked-container">
            <table id="zones-linked" class="zones new-table tableWrapper">

              <thead>
                <tr class="header hide" style="display: table-row;">
                  <th class="name" style="background:#0767A8; text-align: center; color: white; font-size:12px;"><label>Select Websites & Zones</label></th>
                </tr>
              </thead>


              <tbody id="zones-linked-rows">

                <tr class="website">

                  <td class="name">
                    <label style="white-space: nowrap">
                        '.$input_list.'
                    </label>
                  </td>

                </tr>

              </tbody>

            </table>
          </div>
    </div>', $website_list,array('style' => 'display:flex;' , 'id' => 'websites'));

    $form->addGroup($group1, 'zones', 'Websites & Zones' );

    /**************************************************** WEBSITE AND ZONE LISTING ENDS ************************************************/


    //~AD-SIZE LISTING START
    
    $sel_adsize = unserialize($deal['sel_adsize']);
    
    if(in_array('custom', $sel_adsize)){

        $form->addElement('hidden', 'custom', 'custom');
    }else{

        $form->addElement('hidden', 'custom', 'none');
    }

    $adsize_list = '';

    $ad_size = array('custom'=> 'Custom', 'any' => 'Any Size', '468x60' => '468x60', '120x600' => '120x600', '728x90' => '728x90', '120x90' => '120x90', '120x60' => '120x60', '234x60' => '234x60', '88x31' => '88x31', '125x125' => '125x125', '120x240' => '120x240', '180x150' => '180x150', '300x250' => '300x250', '336x280' => '336x280', '240x400' => '240x400', '250x250' => '250x250', '160x600' => '160x600', '720x300' => '720x300', '300x100' => '300x100');
    $i = 0;

   foreach($ad_size as $key => $value) {

        $check = '';
        if(in_array($key, $sel_adsize)){
            $check = 'checked';
        }

        $adsize_list .= '<tr class="zone">
                          <td class="name">
                            <label>
                                <input name="adsize[]" value='.$key.' class="ad_size" id="adsize" type="checkbox" '.$check.'>'.$value.'
                            </label>
                        </td></tr>'; $i++; 
    }

    $group2['ad_size'] = $form->createElement('html', 'ad_size', '<span style="display:-webkit-box;">

        <div class="ad_size" style="margin-right: 25px; width:272px; height:250px; border: 1px solid grey; overflow: auto;">
          <div id="zones-linked-container">
            <table id="zones-linked" class="new-table tableWrapper" style="background: white;">

              <thead>
                <tr class="header hide" style="display: table-row;">
                  <th class="name" style="background:#0767A8; text-align: center; color: white; font-size:12px;"><label>Select Ad Size</label></th>
                </tr>
              </thead>


              <tbody id="zones-linked-rows">

                <tr class="ad_size">

                  <td class="name">
                    <label style="white-space: nowrap">
                        '.$adsize_list.'
                    </label>
                  </td>

                </tr>

              </tbody>

            </table>
          </div>
    </div>', $website_list,array('style' => 'display:flex;' , 'id' => 'ad_size'));
    
    

    $form->addGroup($group2, 'adsize', 'Ad Size' );

    $custom_dm['width'] = $form->createElement ( 'text', 'cus_width', 'Width: ', array ('id' => 'cus_width', 'class' => 'small' ) );
    $custom_dm['height'] = $form->createElement ( 'text', 'cus_height', 'Height: ', array ('id' => 'cus_height', 'class' => 'small' ) );

    $form->addElement( 'group', 'cus_dm', 'Custom Ad size', $custom_dm, null, false );

    $form->addElement( 'textarea', 'whitelist', 'Whitelist of Buyer Seats (E.g., Advertisers, Agencies)', array( 'style' => 'width:192px; height: 70px' ) );
    
    //~AD-SIZE LISTING END

    $auction_type = array('1' => 'First', '2' => 'Second');
   
    $form->addElement('select', 'auction_type', 'Auction Type', $auction_type);

    $form->addElement('text', 'floor_price', 'Floor price');
      
    $specificStartDateGroup ['date'] = $form->createElement ( 'text', 'start', null, array ('id' => 'start', 'class' => 'small' ) );
    $specificStartDateGroup ['cal_img'] = $form->createElement ('html', 'start_button', "<a href='#' id='start_button'><img style='width: 20px!important;' src='assets/images/calendar.png' align= 'absmiddle' /></a>");
    $specificStartDateGroup ['note'] = $form->createElement ( 'html', 'activation_note', 'Deal will commence at the start of this day ' );
    $actDateGroup ['specificDate'] = $form->createElement ( 'group', 'g_specificStartDate', null, $specificStartDateGroup, null, false );
    $form->addDecorator ( 'g_specificStartDate', 'tag', array ('tag' => 'span', 'attributes' => array ('id' => 'specificStartDateSpan') ) );

    $form->addGroup ( $actDateGroup, 'start_date', $GLOBALS ['strActivationDate'], array ("<br>", '' ) );

    $specificEndDateGroup ['date'] = $form->createElement ( 'text', 'end', null, array ('id' => 'end', 'class' => 'small' ) );
    $specificEndDateGroup ['cal_img'] = $form->createElement ( 'html', 'end_button',    "<a href='#' id='end_button'><img style='width: 20px!important;' src='assets/images/calendar.png' align='absmiddle' /></a>");
    $specificEndDateGroup ['note'] = $form->createElement ( 'html', 'expiration_note', 'Deal will commence at the end of this day ' );
    $expDateGroup ['specificDate'] = $form->createElement ( 'group', 'g_specificEndDate', null, $specificEndDateGroup, null, false );
    $form->addDecorator ( 'g_specificEndDate', 'tag', array ('tag' => 'span', 'attributes' => array ('id' => 'specificEndDateSpan') ) );

    $form->addGroup ( $expDateGroup, 'exp_date', $GLOBALS ['strExpirationDate'], array ("<br>", '', '' ) );
    
    $form->addElement('textarea', 'deal_comments', 'Comments');

    $form->addElement('controls', 'form-controls');
    $form->addElement('submit', 'save', 'Save changes');

    //Form validation rules

    $translation = new OX_Translation();
    $nameRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strName']));
    $form->addRule('name', $nameRequiredMsg, 'required');

    $dealidRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array('Deal token'));
    $form->addRule('dealid_token', $dealidRequiredMsg, 'required');

    $floorPriceRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array('Floor price'));
    $form->addRule('floor_price', $floorPriceRequiredMsg, 'required');

    //$floorPricePositiveRule = $translation->translate("Number Only", array('Floor price'));
    //$form->addRule('floor_price', $floorPricePositiveRule, 'nonzero');

    $form->setDefaults($deal);

// echo "<prE>";print_r($form);exit;

    return $form;
}

/*-------------------------------------------------------*/
/* Process submitted form                                */
/*-------------------------------------------------------*/
 function processForm($affiliateid, $form, $oComponent)
{
    // $_POST = $form->exportValues();
    $newWebsite = empty($_POST['dealid']);
  
    $dealId    =    $_POST['dealid'];
    $dealidName  =  $_POST['name'];
    $dealidToken =   $_POST['dealid_token'];
    $dsp_type       =   serialize($_POST['dsp_type']);
    $floor_price       =   $_POST['floor_price'];
    $auction_type       =   $_POST['auction_type'];

    $websites       =   serialize($_POST['websites']);
    $zones       =   serialize($_POST['zones']);
    $adsize       =   serialize($_POST['adsize']);
    $cus_width       =   $_POST['cus_width'];
    $cus_height       =   $_POST['cus_height'];
    $whitelist       =   $_POST['whitelist'];

    $deal_comments       =   $_POST['deal_comments'];
    $start       =   (!empty($_POST['start']) ? $_POST['start'] : date('Y-m-d'));
    $end       =   (!empty($_POST['end']) ? $_POST['end'] : date('Y-m-d'));
    
    /*Validation with username*/
    $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
    
    $translation = new OX_Translation();
    
    $date = date('Y-m-d H:i:s');

// echo "<pre>";print_r($adsize);exit;

    $agencyId  = OA_Permission::getAgencyId();

    if(!in_array('custom', $_POST['adsize'])){

        $cus_width = 0;
        $cus_height = 0;
    }

    if ($newWebsite) 
    {
        OA_Dal_Delivery_query("INSERT INTO `{$table_prefix}dealid` (`name`, `agencyid`,`dealid_token`,`dsp_type`, `websites`, `zones`, `adsize`, `auction_type`, `floor_price`, `start`, `end`, `deal_comments`, `updated`, `cus_width`, `cus_height`, `whitelist`) VALUES ('$dealidName','$agencyId', '$dealidToken', '$dsp_type', '$websites', '$zones', '$adsize', '$auction_type', '$floor_price', '$start', '$end', '$deal_comments', '$date', '$cus_width', '$cus_height', '$whitelist')");

        $deal_id = OA_Dal_Delivery_insertId();
        
        $translated_message = $translation->translate ('Dealid Has been added', array(
            MAX::constructURL(MAX_URL_ADMIN, 'dealid-edit.php?dealid='.$deal_id)
        ));

        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
        $redirectURL = "/plugins/Rtb/dealid-index.php";
    } 

    else 
    { 

        $is_expire = 0;

        if( $end > date("Y-m-d") ){
            $is_expire = 0;
        }else if( $end < date("Y-m-d") ){
            $is_expire = 1;
        }else{
            $is_expire = 2;
        }

        OA_Dal_Delivery_query("UPDATE `{$table_prefix}dealid` SET `name` = '$dealidName',`agencyid` = '$agencyId', `dealid_token`=  '$dealidToken',`dsp_type` = '$dsp_type', `websites` =  '$websites', `zones` = '$zones', `adsize` = '$adsize', `floor_price` = '$floor_price', `start` = '$start', `end` = '$end', `deal_comments` = '$deal_comments', `updated` = '$date', is_expire = {$is_expire}, `cus_width` = '$cus_width', `cus_height` = '$cus_height', `whitelist` = '$whitelist' where dealid='".$dealId."'");
        
        $translated_message = $translation->translate ('Dealid Has been edited', array(
            MAX::constructURL(MAX_URL_ADMIN, 'dealid-edit.php?dealid=' .$_POST['dealid']),
            htmlspecialchars($publisherName),
        ));
        $redirectURL = "plugins/Rtb/dealid-edit.php?dealid=".$_POST['dealid']."";
    }

    OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
    OX_Admin_Redirect::redirect($redirectURL);

    return $oPublisherDll;
}

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
$countQuery = OA_Dal_Delivery_query("SELECT COUNT(*) AS count FROM {$table_prefix}dealid");
$data = OA_Dal_Delivery_fetchAssoc($countQuery);

$count = $data['count'] + 1;
echo '<script type="text/javascript">var count = "'.$count.'";</script>';
?>

<script type="text/javascript">

    $('#dealid_token').attr('readonly', true);
    var deal_token = "<?=$GLOBALS['_MAX']['CONF']['deal']['deal_token'];?>";

    $("#generate_token").click(function (e) 
    {
        e.preventDefault();
        $('#dealid_token').val(deal_token+'-'+(Math.floor(Math.random() * 90000) + 10000)+'-000'+count);
        
    });

    $(document).ready(function() 
    {

        $(".large").css("width", 270);
        var type = $("input[name=custom]").val();

        if(type == 'custom'){
            show_custom(1);
        }else{
            show_custom(0);
        }

        $("#adsize").change(function(){

            var type = $(this).val();

            if(type == 'custom' && $(this).is(":checked") == true){
                show_custom(1);
            }else{
                show_custom(0);
            }
        });

        function show_custom(type){

            if(type == 1){

                $("#cus_width").parent().parent().show();

            }else{
                $("#cus_width").parent().parent().hide();
            }
        }

        //setup calendars
        Calendar.setup({
            inputField : 'start',
            ifFormat   : '%Y-%m-%d',
            button     : 'start_button',
            align      : 'Bl',
            weekNumbers: false,
            electric   : false,
            onUpdate   : function() {
                $("#start").change();
            }
        });

        Calendar.setup({
           inputField : 'end',
           ifFormat : '%Y-%m-%d',
           button : 'end_button',
           align : 'Bl',
           weekNumbers: false,
           electric : false,
           /*onUpdate : function() {
               $("#end").change();
           }*/
        });
    });

    $("#save").click(function (e) {
        e.preventDefault();
        var start = $('#start').val();
        var end = $('#end').val();
        var startDate = new Date(start);
        var endDate = new Date(end);
        
        var floor_price = $('#floor_price').val();
        if ((floor_price =='') || (floor_price ==0)){
            alert('Please enter only numbers');
            return false;
        }
        

        if (!start) {
            alert('Please select start date');
            return false;
        }

        if (!end) {
            alert('Please select end date');
            return false;
        }

        if (startDate < endDate){
            $('#dealidform').submit();
        } else {
            alert('Start date must be less than end date!');
            return false;
        }

        
    });

    /*var $startDateField = $("#start");
    var $endDateField = $("#end");*/
</script>

<script type="text/javascript">
    
    $(document).ready(function()
    {

        $("#cpy_notification").hide();
        $("#copy").hide();

        //~AUCTION TYPE
        var edit = ("<?=$_GET['dealid']?>") > 0 ? 1 : 0 ;
        if( edit == 1 )
        {
            $("#auction_type").attr("disabled", true);
            $("#copy").show();

            //~ COPY TOKEN

            $("#copy").click(function()
            {
                $("#cpy_notification").show();
                setTimeout(function(){ $("#cpy_notification").hide(); }, 2000);

                var $temp = $("<input>");
                $("body").append($temp);
                $temp.val($("#dealid_token").val()).select();
                document.execCommand("copy");
                $temp.remove();

            });
        }

        //~ON WEBSITE SELECTION

    });

    show_list(0,0);


    $(".websites").click(function(){

        var webid = $(this).val();

        if($(this).is(":checked") == true){

            show_list(webid, 1);

        }else{

            show_list(webid, 0)
        }
    });

    function show_list(type1, type2){

        if(type1 == 0){

            $(".zone_list").parent().parent().hide();

        } else if(type1 > 0 && type2 == 1){

            $(".webid_"+type1).parent().parent().show();

        } else if(type1 > 0 && type2 == 0){

            $(".webid_"+type1).parent().parent().hide();
            $(".webid_"+type1).attr('checked',false);
        }
    }


    $('.websites').each(function() {
        
        if($(this).is(":checked")) {

            $(".webid_"+$(this).val()).parent().parent().show();
        }
    });


</script>
