<?php

  header("Access-Control-Allow-Origin: *");
  header("Content-Type: application/json; charset=UTF-8");
  header("Access-Control-Allow-Methods: POST");
  header("Access-Control-Max-Age: 3600");
  header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

  require_once '../../../../init.php';

  if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
  }else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
  }else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
  }
  
  $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
      
  // Required files
  require_once MAX_PATH . '/lib/OA/Dal.php';      
  require_once MAX_PATH . '/lib/OA/Admin/Option.php';
  require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
  require_once MAX_PATH . '/www/admin/config.php';
  require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

  $data['series'] = array(); 
  $labels = array();
  $requests = array();
  $response = array();
  $impression = array();
  $clicks = array();
  $wins = array();
  
  $conversion = array();
  $total_revenue = array();
  $revenue = array();
  $back_fill = array();
  $win_rate = array();
  $ecpm = array();
  $fill_rate = array();
  $ctr = array();

  $dates = explode(' - ', $_POST['dates']);
  $start_date = str_replace(' ', '-', $dates[0]);
  $end_date = str_replace(' ', '-', $dates[1]);


  $group_by = "Group BY name";
  $metrics = "name";

  for($i=0;$i<sizeof($_POST['attributes']);$i++){

      $group_by .= " , ".$_POST['attributes'][$i];
  }

  $getQuery = "SELECT hb.hb_bidder AS name, SUM(hb.impression) AS impression, sum(hb_wonbid) as revenue,
  hb.datetime AS date_time,hb.country as country,hb.hb_source as source,hb.hb_media as media,hb.hb_size as size,
  af.name as site, z.zonename as zone, af.affiliateid as affiliateid, z.zoneid as zoneid
  FROM dj_hb_reports AS hb
  INNER JOIN {$table_prefix}zones AS z ON z.zoneid = hb.zoneid 
  INNER JOIN {$table_prefix}affiliates AS af ON af.affiliateid = z.affiliateid 
    WHERE DATE(datetime) >='".$start_date."' AND DATE(datetime) <= '".$end_date."' ".$group_by ."  ". $_POST['limit'];

  $getQuery = OA_Dal_Delivery_Query($getQuery);

  while ($aRow = OA_Dal_Delivery_fetchAssoc($getQuery)) 
  {
      $labels[] = (strlen($aRow['name']) > 5 ? substr($aRow['name'],0,10)."..." : $aRow['name']);
      $impression[] = (float)$aRow['impression'];
      $ecpm[] = ($aRow['impression'] > 0) ? round($aRow['revenue'] / $aRow['impression'] * 1000, 2) :  0.00;
      $revenue[] = ($aRow['revenue'] > 0) ? $aRow['revenue'] :  0.00;
  }

  for( $i=0; $i<sizeof($_POST['metrics']); $i++ ){

      if($_POST['metrics'][$i] == 'imp'){

          $impression_series = array(
                              "name" => "impression",
                              "data" => $impression
                          );
          array_push($data['series'], $impression_series);
      }

      if($_POST['metrics'][$i] == 'wonbid'){

          $request_series = array(

                              "name" => "WonBid",
                              "data" => $revenue
                          );
          array_push($data['series'], $request_series);
      }
      if($_POST['metrics'][$i] == 'ecpm'){

          $request_series = array(

                              "name" => "eCPM",
                              "data" => $ecpm
                          );
          array_push($data['series'], $request_series);
      }
  }

  $data['categories'] = $labels;
  
  echo json_encode($data);

  exit();

?>