<?php

// Require the initialisation file

require_once '../../../../init.php';

require_once MAX_PATH . '/www/admin/lib-maintenance-priority.inc.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/lib/OX/Translation.php';
require_once MAX_PATH . '/lib/pear/Date.php';
require_once MAX_PATH . '/www/admin/lib-maintenance-priority.inc.php';
require_once MAX_PATH . '/lib/OA/Dll.php';
require_once MAX_PATH . '/lib/OX/Util/Utils.php';
require_once MAX_PATH . '/lib/OX/Admin/UI/ViewHooks.php';
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';
require_once MAX_PATH . '/lib/OA/Creative/File.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/max/Admin_DA.php';
  
if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

// Create a new option object for displaying the setting's page's HTML form

$oOptions = new OA_Admin_Option('user');



$title='Site Reports';

$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);

phpAds_PageHeader('Site-index', $oHeaderModel);


if($_GET['period_preset']!='')
{
	if($_GET['period_preset']=='today')
	{
		$start=date('Y-m-d 00:00:00');
		$end=date('Y-m-d H:00:00');
		$result=time_zone($start,$end);
			
		$startdate=$result[0];
		$endate=$result[1]; //$start=$result[0]; $end=$endate;
	}
	else if($_GET['period_preset']=='yesterday')
	{
		$start=date('Y-m-d 00:00:00', strtotime('Yesterday'));
		$end=date('Y-m-d 23:59:59', strtotime('Yesterday'));
		$result=time_zone($start,$end);
			
		$startdate=$result[0];
		$endate=$result[1]; //$start=$result[0]; $end=$endate;
	}
	else if($_GET['period_preset']=='last_7_days')
	{
		$start=date('Y-m-d 00:00:00', strtotime('Today - 7 Day'));
		$end=date('Y-m-d 23:59:59', strtotime('Yesterday'));
		$result=time_zone($start,$end);
			
		$startdate=$result[0];
		$endate=$result[1]; //$start=$result[0]; $end=$endate;
	}
	else if($_GET['period_preset']=='this_month')
	{
		$start=date('Y-m-d 00:00:00', mktime(0, 0, 0, date('m'), 1, date('Y')));
		$end=date('Y-m-d 23:59:59');
		$result=time_zone($start,$end);
			
		$startdate=$result[0];
		$endate=$result[1]; //$start=$result[0]; $end=$endate;
	}
	if($_GET['period_preset']=='last_month')
	{
		$start=date('Y-m-d 00:00:00', mktime(0, 0, 0, (date('m') - 1), 1, date('Y')));
		$end=date('Y-m-d', mktime(0, 0, 0, date('m'), 0, date('Y')));
		$result=time_zone($start,$end);
			
		$startdate=$result[0];
		$endate=$result[1]; //$start=$result[0]; $end=$endate;
	}
	else if($_GET['period_preset']=='all_stats')
	{
		$start='';
		$end='';
		//$result=time_zone($start,$end);
		
	}
	else if($_GET['period_preset']=='specific')
	{
		$start=$_GET['period_start'];
		$end=$_GET['period_end'];
		$result=time_zone($start,$end);
			
		$startdate=$result[0];
		$endate=$result[1]; //$start=$result[0]; $end=$endate;
	}
	
	
}
else
{
	$start=date('Y-m-d 00:00:00');
	$end=date('Y-m-d H:00:00');
	$result=time_zone($start,$end);
		
	$startdate=$result[0];
	$endate=$result[1]; //$start=$result[0]; $end=$endate;
}
if($start != '' && $end != '')
{
	$query = OA_Dal_Delivery_query("select exchange_name, domain, category, sum(request) as request, sum(response) as response, sum(won_bid) as won_bid, sum(won_request) as won_request  FROM {$table_prefix}dj_sitereport JOIN {$table_prefix}dj_ad_exchange ON dsp_id = exchange_id AND date BETWEEN '".$startdate."' AND '".$endate."' group by dsp_id,domain,category");
}
else if($start == '' && $end == '')
{
	$query = OA_Dal_Delivery_query("select exchange_name, domain, category, sum(request) as request, sum(response) as response, sum(won_bid) as won_bid, sum(won_request) as won_request FROM {$table_prefix}dj_sitereport JOIN {$table_prefix}dj_ad_exchange ON dsp_id = exchange_id group by dsp_id,domain,category");
}
else if($start != '' && $end == '')
{
	$end = date('Y-m-d');
	$query = OA_Dal_Delivery_query("select exchange_name, domain, category, sum(request) as request, sum(response) as response, sum(won_bid) as won_bid, sum(won_request) as won_request FROM {$table_prefix}dj_sitereport JOIN {$table_prefix}dj_ad_exchange ON dsp_id = exchange_id and date BETWEEN '".$startdate."' AND '".$endate."' group by dsp_id,domain,category");
}
else if($start == '' && $end != '')
{
	$query = OA_Dal_Delivery_query("select exchange_name, domain, category, sum(request) as request, sum(response) as response, sum(won_bid) as won_bid, sum(won_request) as won_request FROM {$table_prefix}dj_sitereport JOIN {$table_prefix}dj_ad_exchange ON dsp_id = exchange_id and date <= '".$endate."'  group by dsp_id,domain,category");
}	

//////////timezone

function time_zone($start,$end)
{
$end_date =  date('Y-m-d',strtotime($end));	
$end_day=new Date($end_date);
$end_day->setHour(23);
$end_day->setMinute(59);
$end_day->setSecond(59);
$end_day->toUTC();
$end_date=$end_day->format('%Y-%m-%d %H:%M:%S');
$start_day=new Date($start);
$start_day->setHour(0);
$start_day->setMinute(0);
$start_day->setSecond(0);
$start_day->toUTC();
$start_date=$start_day->format('%Y-%m-%d %H:%M:%S'); 
$date[]=$start_date;
$date[]=$end_date;
return $date;	
}

///////////timezone


echo "<form method='get' id='myform'>";
echo "<div class='dspstats'>";
echo "<select name='period_preset' id='period_preset' onchange='periodFormChange(1)' tabindex='1'>";
echo  "<option value='today'>Today</option>";
echo  "<option value='yesterday'>Yesterday</option>";
echo  "<option value='last_7_days'>Last 7 days</option>";
echo  "<option value='this_month'>This month</option>";
echo   "<option value='last_month'>Last month</option>";
echo  "<option value='all_stats'>All statistics</option>";
echo   "<option value='specific'>Specific dates</option>";
echo   "</select>";
echo "<label for='period_start' style='margin-left: 2em'><b> From: </b> </label>";

echo "<input  name='period_start' id='period_start' type='text' value='".$start."' tabindex='2'/>";

echo "<input type='image' src='assets/images/icon-calendar-d.gif' id='period_start_button' align='absmiddle' border='0' tabindex='3' />";

echo "<label for='period_end' style='margin-left: 1em'><b>To: </b></label>";

echo "<input  name='period_end' id='period_end' type='text' value='".$end."' tabindex='4' />"; 

echo "<input type='image' src='assets/images/icon-calendar-d.gif' id='period_end_button' align='absmiddle' border='0' tabindex='3' />";



echo "<input type='image' name='sub' class='ig' id='sub_tag' src='assets/images/go_blue.gif' tabindex='6' border='0'>";

echo "</div>";

echo "</form>";
echo "<style>
.ig{

	margin-left: 4px;

	margin-bottom: -2px;

}
</style>";
?>
<style type="text/css">


table.gridtable {
	font-family: verdana,arial,sans-serif;
	font-size:11px;
	color:#333333;
	border-width: 1px;
	width: 100%;
	border-color: #999999;
	border-collapse: collapse;
}
table.gridtable th {
	
	border-width: 1px;
	padding: 8px;
	border-style: solid;
	border-color: #999999;
}
table.gridtable td {
	
	border-width: 1px;
	padding: 8px;
	border-style: solid;
	border-color: #999999;
}
.acenter{
text-align: center;
}

</style>
<?php

if(OA_Dal_Delivery_numRows($query)>0)
{?>
<link rel="stylesheet" type="text/css" href="assets/min.php?g=oxp-css-ltr&v=2.8.10">

	<table width='100%' border='0' cellspacing='0' cellpadding='0'>
		<tr>
		     <td style="padding-bottom:5px; white-space: nowrap;">
					<br />
					<a href="djax_dspsitestats_export.php?start=<?php echo $startdate;?>&end=<?php echo $endate;?>&exstart=<?php echo $ex;?>" accesskey="e">
					<img src="assets/images/excel.gif" border="0" alt="" /> <u>E</u>xport Statistics to Excel</a>
		    </td>
		    
		    <td width="90%">&nbsp;</td>
		 </tr>
	</table>
 
    
        <table width="100%" class="table">
       	<tr>
                <th scope="col" class="acenter" style="color: #0767A8;">Name</th>
                <th scope="col" class="acenter" style="color: #0767A8;">Domain</th>                
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
			    <th scope="col" class="acenter" style="color: #0767A8;">Category</th>
			    <th scope="col" class="acenter" style="color: #0767A8;">Request</th>
			    <th scope="col" class="acenter" style="color: #0767A8;">Response</th>
			   <!-- <th scope="col" class="acenter" style="color: #0767A8;">Won Bid Amount</th>-->
			    <th scope="col" class="acenter" style="color: #0767A8;">Won Request</th>
	</tr> 

<?php
	while($val=OA_Dal_Delivery_fetchAssoc($query))
	{?>
	<tr>
		<td class="acenter dark" ><?php if($val['exchange_name'] != ''){echo $val['exchange_name'];}else{ echo "-";} ?></td>
		<td class="acenter dark" ><?php if($val['domain'] != ''){echo $val['domain'];}else{ echo "-";} ?></td>
		<td class="acenter dark" ><?php if($val['category_name'] != ''){echo $val['category_name'];}else{ echo "-";} ?></td> 
		<td class="acenter dark" ><?php if($val['request'] != ''){echo $val['request'];}else{ echo "-";} ?></td>
		<td class="acenter dark" ><?php if($val['response'] != ''){echo $val['response'];}else{ echo "-";} ?></td>
		<!--<td class="acenter dark" ><?php //if($val['won_bid'] != ''){echo number_format($val['won_bid'],2);}else{ echo "-";} ?></td>-->
		<td class="acenter dark" ><?php if($val['won_request'] != ''){echo $val['won_request'];}else{ echo "-";} ?></td>		
	 </tr>
	<?php
   }
echo '</table>';
}
else{
echo '<div style="margin-top: 2em;" class="errormessage"><img border="0" align="absmiddle" width="16" height="16" src="assets/images/info.gif" class="errormessage">There are currently no statistics available</div>';
}
?>

<script>

    

        <!--

        Calendar.setup({

            inputField : 'period_start',

            ifFormat   : '%Y-%m-%d',

            button     : 'period_start_button',

            align      : 'Bl',

            weekNumbers: false,

            firstDay   : 1,

            electric   : false

        });

        Calendar.setup({

            inputField : 'period_end',

            ifFormat   : '%Y-%m-%d',

            button     : 'period_end_button',

            align      : 'Bl',

            weekNumbers: false,

            firstDay   : 1,

            electric   : false

        });
        
        
        function periodFormChange(bAutoSubmit)

        {

 	   
 	    var o = document.getElementById('period_preset');
            var periodSelectName = o.options[o.selectedIndex].value;
            var specific = periodSelectName == 'specific';
 	    var periodTabIndex = 2;

			document.getElementById('period_start').readOnly = !specific;
            document.getElementById('period_start_button').disabled = !specific;
            document.getElementById('period_end').readOnly = !specific;
            document.getElementById('period_end_button').disabled = !specific;

            if (!specific) {
                document.getElementById('period_start').style.backgroundColor = '#CCCCCC';
                document.getElementById('period_end').style.backgroundColor = '#CCCCCC';
                document.getElementById('period_start').tabIndex = null;
                document.getElementById('period_start_button').tabIndex = null;
                document.getElementById('period_end').tabIndex = null;
                document.getElementById('period_end_button').tabIndex = null;
		document.getElementById('period_start_button').src = 'assets/images/icon-calendar-d.gif';
           	document.getElementById('period_end_button').src = 'assets/images/icon-calendar-d.gif' ;

            } else {
                document.getElementById('period_start').style.backgroundColor = '#FFFFFF';
                document.getElementById('period_end').style.backgroundColor = '#FFFFFF';
                document.getElementById('period_start').tabIndex = periodTabIndex;
                document.getElementById('period_start_button').tabIndex = periodTabIndex + 1;
                document.getElementById('period_end').tabIndex = periodTabIndex + 2;
                document.getElementById('period_end_button').tabIndex = periodTabIndex + 3;
	        document.getElementById('period_start_button').src = 'assets/images/icon-calendar.gif';
           	document.getElementById('period_end_button').src = 'assets/images/icon-calendar.gif' ;
            }

            document.getElementById('period_start_button').readOnly = !specific;
            document.getElementById('period_end_button').readOnly = !specific;
          
            document.getElementById('period_start_button').style.cursor = specific ? 'auto' : 'default';
            document.getElementById('period_end_button').style.cursor = specific ? 'auto' : 'default';

            if (!specific && bAutoSubmit) {
                o.form.submit();
            }
           

}

periodFormChange(0);



    function periodFormSubmit() {

            var form = document.getElementById('period_preset').form;
            // alert(form);
            // $("#period_preset").val("<?php echo $_GET["period_preset"]; ?>");
            if (checkDates(form)) {

              form.submit();

            }

            return false;

        }

    function checkDates(form)

        {

          var startField = form.period_start;

          var endField = form.period_end;



          if (!startField.disabled && startField.value != '') {

            var start = Date.parseDate(startField.value, '%Y-%m-%d');

          }

          if (!startField.disabled && endField.value != '') {

            var end = Date.parseDate(endField.value, '%Y-%m-%d');

          }



          if ((start != undefined && end != undefined) && (start.getTime() > end.getTime())) {

            

            return false;

          }

          return true;

        }

        $(function () {      
            var selectedText = $("#period_preset").find("option:selected").text();
            var selectedValue = $("#period_preset").val();
            var val="<?php echo $_GET["period_preset"]; ?>";
            $("#period_preset").val(val);  
        });
 </script>
