<?php

ini_set("display_errors", "1");
error_reporting(E_ALL);
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';

require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/www/admin/config.php';

if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
} else if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysqli') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
} else if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'pgsql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix']; 


$title="Wirepayment";
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);
phpAds_PageHeader("Wirepayment", $oHeaderModel);
$oOptions = new OA_Admin_Option('user');
$pending = OA_Dal_Delivery_query("SELECT h.*,c.clientname as name FROM dj_payment_history as h LEFT JOIN {$table_prefix}clients as c on h.client_id = c.clientid WHERE h.type = 1  or h.auto_appr = 1 ORDER BY h.dep_date,h.status ASC");

?>

<link rel="stylesheet" type="text/css" href="assets/js/multi/css/custom.css">
<link rel="stylesheet" type="text/css" href="assets/css/jquery_datatable.css">
<link rel="stylesheet" type="text/css" href="assets/js/multi/css/multi-select.css">
<link rel="stylesheet" type="text/css" href="assets/js/multi/css/buttons.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="assets/js/multi/css/bootstrap.min.css">
<script src="assets/js/jquery-3.4.1.min.js"></script>
<script src="assets/js/jquery_datatable.js"></script>
<script type="text/javascript" src="assets/js/multi/js/jquery.multi-select.js"></script>
<script src="assets/js/multi/js/pdfmake.min.js"></script>
<script src="assets/js/multi/js/vfs_fonts.js"></script>
<script src="assets/js/multi/js/jszip.min.js"></script>
<script src="assets/js/multi/js/buttons.flash.min.js"></script>
<script src="assets/js/multi/js/dataTables.buttons.min.js"></script>
<script src="assets/js/multi/js/buttons.print.min.js"></script>
<script src="assets/js/multi/js/buttons.html5.min.js"></script>
<script src="assets/js/popper.min.js"></script>
<script src="assets/js/bootstrap.min.js"></script>

<table id="example" class="table table-bordered table-hover">
<thead>
  <tr>
    <th scope="col">ID</th>
    <th scope="col">Advertiser</th>
    <th scope="col">Amount</th>
    <th scope="col">Date</th>
    <th scope="col">Action</th>
  </tr>
</thead>
<tbody>
<?php
$i=1;
while ($data=OA_Dal_Delivery_fetchAssoc($pending)) {
	
if ($data['status']==1) {
	$class = 'table-success';
} elseif ($data['status']==2) {
	$class='table-danger';
} else{
	$class = 'table-light';
}
?>
   <tr class="<?=$class?> dar<?=$data['id']?>">
      <td><?=$i?></td>
      <td><?=$data['name']?></td>
      <td><?=$data['amt']?></td>
      <td><?=$data['dep_date']?></td>
       <td>
        
         <?php if ($data['status']==3) : ?>
         	<div class="showblock<?=$data['id']?>" data-id="<?=$data['id']?>">
             <a class="blockubc btn btn-outline-primary btn-sm" amt="<?=$data['amt']?>" client-id="<?=$data['client_id']?>" approval="0" data-id="<?=$data['id']?>" href="javascript:void(0)">Approve</a>
              <a class="blockubc btn btn-outline-danger btn-sm" amt="<?=$data['amt']?>" client-id="<?=$data['client_id']?>" approval="1" data-id="<?=$data['id']?>" href="javascript:void(0)">Reject</a>
          </div>
            <button class="btn btn-outline-primary btn-sm showappr<?=$data['id']?>"  disabled="disabled" style="display: none;">Approved</button>
            <button class="btn btn-outline-primary btn-sm showrej<?=$data['id']?>" disabled="disabled" style="display: none;">Rejected</button>

            <?php elseif($data['status']==1)  : ?>
             	<button class="btn btn-outline-primary btn-sm" disabled="disabled">Approved</button>
         	<?php else : ?>
                 <button class="btn btn-outline-primary btn-sm" disabled="disabled">Rejected</button>
        	<?php endif; ?>
        
    </td>
      
    </tr>

<?php
$i++;
}
?>
</tbody>
</table>

<script type="text/javascript">
$(document).ready(function() {
    $('#example').DataTable({
   		'lengthMenu': [[25, 50, 75, 100, -1], [25, 50, 75, 100, "All"]],
   		'dom': 'lBfrtip',
   		'buttons': [
                'excel', 'csv', 'pdf'
           ],
           'bFilter' : false

    });
} );

$(document).on('click', '.blockubc', function() 
{
    var data_id = $(this).attr('data-id');
    var is_block = $(this).attr('approval');
    var client_id = $(this).attr('client-id');
    $(".showblock"+data_id).css("display", "none");

    var amt = $(this).attr('amt');
    var button =$(this);

    if (data_id) 
    {
        $.ajax(
        {
          type: "post",
          url: "dj-wire-approval.php",
          cache: false,               
          data: {'data_id' : data_id,'is_block' :is_block,'client_id':client_id,'amt':amt},
          success: function(json)
          {                        
            if (json['STATUS']=="true") 
            {
                if(json['Approval'] = 'Approved'){
                	$(".showappr"+data_id).css("display", "block");
                	$(".dar"+data_id).removeClass('table-light');
                	$(".dar"+data_id).addClass('table-success');
                }
                else{
          				$(".showappr"+data_id).css("display", "block");
          				$(".dar"+data_id).removeClass('table-light');
          				$(".dar"+data_id).addClass('table-danger');
                }
            }     
          }
        });
    }
});

var isOpen = 0;
$(document).on('click','.switchTrigger',function() 
{
    if (isOpen == 0) 
    {
      $(".accountSwitcher").addClass("expanded");
      $('accountSwitcherOverlay').css({ display: "block" });
      isOpen++;
    } 
    else 
    {
      $(".accountSwitcher").removeClass("expanded");
      $('accountSwitcherOverlay').css({ display: "none" });
      isOpen--;
    }
});

</script>

<?php
phpAds_PageFooter();


?>
