<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-storage.inc.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
include_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/lib/OA/Maintenance/Priority.php';
require_once MAX_PATH . '/lib/max/other/common.php';

// Register input variables
phpAds_registerGlobal ('campaignid', 'clientid', 'newclientid', 'returnurl', 'duplicate');

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER);

if(!empty($duplicate)) {
    OA_Permission::enforceAccessToObject('clients',   $clientid, false, OA_Permission::OPERATION_VIEW);
    OA_Permission::enforceAccessToObject('campaigns', $campaignid, false, OA_Permission::OPERATION_DUPLICATE);
}
else if (!empty($newclientid)) {
    OA_Permission::enforceAccessToObject('clients',   $clientid, false, OA_Permission::OPERATION_VIEW);
    OA_Permission::enforceAccessToObject('campaigns', $campaignid, false, OA_Permission::OPERATION_MOVE);
    OA_Permission::enforceAccessToObject('clients', $newclientid, false, OA_Permission::OPERATION_EDIT);
}

// CVE-2013-5954 - see OA_Permission::checkSessionToken() method for details
OA_Permission::checkSessionToken();

/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


function duplicateVastElements($oDbh,$old_adId,$new_adId) {
			
			$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];			
			 $oRes = $oDbh->query("
            DELETE
            FROM
                djaxbanner_vast_element_seq
            WHERE
                1
			");
			
			$query = "INSERT INTO djaxbanner_vast_element_seq
								(id) 
						VALUES 
								('')";
								
			$banner_vast_element_id = $oDbh->query($query)->db->connection->insert_id;
			
			
			
			
			$oRes = $oDbh->query("
            SELECT
                *
            FROM
                {$table_prefix}djaxbanner_vast_element	
            WHERE
                banner_id = {$old_adId}
				");


				
        $vastBannerDetails =  $oRes->fetchRow();
        
		
        if ($vastBannerDetails['banner_id']) {
			
			$vastBannerDetails['banner_id'] = $new_adId;
			$vastBannerDetails['banner_vast_element_id'] = $banner_vast_element_id;
			
			
			 $query = "INSERT INTO {$table_prefix}djaxbanner_vast_element 
								(".implode("," , array_keys($vastBannerDetails)).") 
						VALUES 
								('".implode("','" , $vastBannerDetails)."')";
								
				$oDbh->query($query);
			
			
			
		}
        
			
        
        
        
}



if (!empty($campaignid)) {
    if (!empty($duplicate)) {
    	//~ // Duplicate the campaign
    	//~ $doCampaigns = OA_Dal::factoryDO('campaigns');
    	//~ $doCampaigns->get($campaignid);
        //~ $oldName = $doCampaigns->campaignname;
    	//~ $newCampaignId = $doCampaigns->duplicate();
    	
    	$doBanners = OA_Dal::factoryDO('banners');  
    	
    	$oDbh   = OA_DB::singleton();
    	 $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
		$newName = "";
         $oldName = "";
         
         
         
         
         $oRes = $oDbh->query("
            SELECT
                *
            FROM
                {$table_prefix}campaigns
            WHERE
                campaignid = {$campaignid}
        ");

        $campaignDetails =  $oRes->fetchRow();
        

	
        if($campaignDetails['campaignid']) {
			
			$oldName = $campaignDetails['campaignname'];
			$campaignDetails['campaignname'] = $newName = $GLOBALS['strCopyOf'] . ' ' . $oldName;
			unset($campaignDetails['campaignid']);


				foreach($campaignDetails as $k=>$b)
				 {
					 $campaignDetails[$k] = str_replace("'","\'",$b);
					 $campaignDetails[$k] = str_replace('"','\"',$campaignDetails[$k]);
				 }
				 
			$query = "INSERT INTO {$table_prefix}campaigns 
							(".implode("," , array_keys($campaignDetails)).") 
					VALUES";
			$query.= '	("'.implode('","' , $campaignDetails).'")';
								
			$newCampaignId = $oDbh->query($query)->db->connection->insert_id;
			
			
	
		
		
		  
			 $oRes = $oDbh->query("
				SELECT
					*
				FROM
					{$table_prefix}banners	
				WHERE
					campaignid = {$campaignid}
			");

			$bd =   $oRes->fetchAll(MDB2_FETCHMODE_ASSOC);
			
      
        foreach($bd as $bannerDetails)
        {
			echo '<br>';
			echo '<br>';
				
				$old_adId = $bannerDetails['bannerid'];
				
					$bannerDetails['description'] = $GLOBALS['strCopyOf'] . ' ' . $bannerDetails['description'];
					unset($bannerDetails['bannerid']);
					$bannerDetails['campaignid'] = $newCampaignId;
				
				$bannerDetails['status'] = 1; 
				
				
				if ($bannerDetails['storagetype'] == 'web' || $bannerDetails['storagetype'] == 'sql') {
				$bannerDetails['filename'] = $doBanners->_imageDuplicate($bannerDetails['storagetype'], $bannerDetails['filename']);
				} elseif ($bannerDetails['type'] == 'web' || $bannerDetails['type'] == 'sql') {
				$bannerDetails['filename'] = $doBanners->_imageDuplicate($$bannerDetails['type'], $bannerDetails['filename']);
				} 
				 
				 
				 foreach($bannerDetails as $k=>$b)
				 {
					 $bannerDetails[$k] = str_replace("'","\'",$b);
					 $bannerDetails[$k] = str_replace('"','\"',$bannerDetails[$k]);
				 }
				 
		 	$query = "INSERT INTO {$table_prefix}banners 
									(".implode("," , array_keys($bannerDetails)).") 
							VALUES
								('".implode("','" , $bannerDetails)."')";
										
			 $new_adId = $new_bannerid = $oDbh->query($query)->db->connection->insert_id;
		
			switch($bannerDetails['ext_bannertype']) {
			
			case "bannerTypeHtml:djaxvastInlineBannerTypeHtml:vastInlineHtml" :
			
					duplicateVastElements($oDbh,$old_adId,$new_adId);
					break;
				}
				
				
				
			 // Copy ACLs and capping
			MAX_AclCopy(basename($_SERVER['SCRIPT_NAME']), $old_adId, $new_adId);

			// Duplicate and ad-zone associations
			MAX_duplicateAdZones($old_adId, $new_adId);



        
        
        
        
       }
    	
	}
    	
    	

        if ($newCampaignId) {
            // Queue confirmation message
            //~ $newName = $doCampaigns->campaignname;
            $translation = new OX_Translation();
            $translated_message = $translation->translate ( $GLOBALS['strCampaignHasBeenDuplicated'],
                array(MAX::constructURL(MAX_URL_ADMIN, "campaign-edit.php?clientid=$clientid&campaignid=$campaignid"),
                    htmlspecialchars($oldName),
                    MAX::constructURL(MAX_URL_ADMIN, "campaign-edit.php?clientid=$clientid&campaignid=$newCampaignId"),
                    htmlspecialchars($newName))
            );
            OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

            Header ("Location: {$returnurl}?clientid={$clientid}&campaignid={$newCampaignId}");
            exit;
        }
        else {
            phpAds_sqlDie();
        }

    }
    else if (!empty($newclientid)) {

        /*-------------------------------------------------------*/
        /* Restore cache of $node_array, if it exists            */
        /*-------------------------------------------------------*/

        if (isset($session['prefs']['advertiser-index.php']['nodes'])) {
            $node_array = $session['prefs']['advertiser-index.php']['nodes'];
        }

        /*-------------------------------------------------------*/

        // Delete any campaign-tracker links
        $doCampaign_trackers = OA_Dal::factoryDO('campaigns_trackers');
        $doCampaign_trackers->campaignid = $campaignid;
        $doCampaign_trackers->delete();

        // Move the campaign
        $doCampaigns = OA_Dal::factoryDO('campaigns');
        $doCampaigns->get($campaignid);
        $doCampaigns->clientid = $newclientid;
        $doCampaigns->update();

        // Find and delete the campains from $node_array, if
        // necessary. (Later, it would be better to have
        // links to this file pass in the clientid as well,
        // to facilitate the process below.
        if (isset($node_array['clients'])) {
            foreach ($node_array['clients'] as $key => $val) {
                if (isset($node_array['clients'][$key]['campaigns'])) {
                    unset($node_array['clients'][$key]['campaigns'][$campaignid]);
                }
            }
        }

        // Rebuild cache
        // require_once MAX_PATH . '/lib/max/deliverycache/cache-'.$conf['delivery']['cache'].'.inc.php';
        // phpAds_cacheDelete();

        /*-------------------------------------------------------*/
        /* Save the $node_array, if necessary                    */
        /*-------------------------------------------------------*/

        if (isset($node_array)) {
            $session['prefs']['advertiser-index.php']['nodes'] = $node_array;
            phpAds_SessionDataStore();
        }

        /*-------------------------------------------------------*/

        // Queue confirmation message
        $campaignName = $doCampaigns->campaignname;
        $doClients = OA_Dal::factoryDO('clients');
        if ($doClients->get($newclientid)) {
            $advertiserName = $doClients->clientname;
        }
        $translation = new OX_Translation();
        $translated_message = $translation->translate ( $GLOBALS['strCampaignHasBeenMoved'],
            array(htmlspecialchars($campaignName), htmlspecialchars($advertiserName))
        );
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);


    }
}

Header ("Location: ".$returnurl."?clientid=".(isset($newclientid) ? $newclientid : $clientid)."&campaignid=".$campaignid);

?>
