<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';


// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-storage.inc.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
require_once MAX_PATH . '/www/admin/lib-banner.inc.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/lib/OA/Maintenance/Priority.php';

// Register input variables

//phpAds_registerGlobal ('returnurl', 'duplicate', 'moveto_x', 'moveto', 'applyto_x', 'applyto');
phpAds_registerGlobal('bannerid', 'campaignid', 'clientid', 'returnurl', 'duplicate', 'moveto', 'moveto_x', 'applyto', 'applyto_x');


// Security check

OA_Permission::enforceAccount ( OA_ACCOUNT_MANAGER, OA_ACCOUNT_ADVERTISER );/*DAC015-DJAX ALPERMISSION MOD*/

// CVE-2013-5954 - see OA_Permission::checkSessionToken() method for details
OA_Permission::checkSessionToken();

/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/







function duplicateVastElements($oDbh,$old_adId,$new_adId) {
			
			$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];			
			 $oRes = $oDbh->query("
            DELETE
            FROM
                djaxbanner_vast_element_seq
            WHERE
                1
			");
			
			$query = "INSERT INTO djaxbanner_vast_element_seq
								(id) 
						VALUES 
								('')";
								
			$banner_vast_element_id = $oDbh->query($query)->db->connection->insert_id;
			
			
			
			
			$oRes = $oDbh->query("
            SELECT
                *
            FROM
                {$table_prefix}djaxbanner_vast_element	
            WHERE
                banner_id = {$old_adId}
				");


				
        $vastBannerDetails =  $oRes->fetchRow();
        
		
        if ($vastBannerDetails['banner_id']) {
			
			$vastBannerDetails['banner_id'] = $new_adId;
			$vastBannerDetails['banner_vast_element_id'] = $banner_vast_element_id;
			
			
			 $query = "INSERT INTO {$table_prefix}djaxbanner_vast_element 
								(".implode("," , array_keys($vastBannerDetails)).") 
						VALUES 
								('".implode("','" , $vastBannerDetails)."')";
								
				$oDbh->query($query);
			
			
			
		}
        
			
        
        
        
}


        
        
        
if (!empty($bannerid)) {
    OA_Permission::enforceAccessToObject('banners', $bannerid);

    if (!empty($moveto) && isset($moveto_x)) {
        if (OA_Permission::isAccount(OA_ACCOUNT_MANAGER)) {
            OA_Permission::enforceAccessToObject('campaigns', $moveto);
        }

        // Move the banner
        $doBanners = OA_Dal::factoryDO('banners');
        $doBanners->get($bannerid);
        $doBanners->campaignid = $moveto;
        $doBanners->update();

        // Increase the memory for running the maintenance
        OX_increaseMemoryLimit(OX_getMinimumRequiredMemory('maintenance'));

        // Run the Maintenance Priority Engine process
        OA_Maintenance_Priority::scheduleRun();

        // Rebuild cache
        // require_once MAX_PATH . '/lib/max/deliverycache/cache-'.$conf['delivery']['cache'].'.inc.php';
        // phpAds_cacheDelete();

        // Get new clientid
        $clientid = phpAds_getCampaignParentClientID($moveto);

        //confirmation message
        $bannerName = $doBanners->description;
        $doCampaigns = OA_Dal::factoryDO('campaigns');
        if ($doCampaigns->get($moveto)) {
           $campaignName = $doCampaigns->campaignname;
        }
        $translation = new OX_Translation();
        $translated_message = $translation->translate ( $GLOBALS['strBannerHasBeenMoved'],
            array(htmlspecialchars($bannerName), htmlspecialchars($campaignName))
        );
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

        Header ("Location: {$returnurl}?clientid={$clientid}&campaignid={$moveto}&bannerid={$bannerid}");

    } elseif (!empty($applyto) && isset($applyto_x)) {
        $doBanners = OA_Dal::factoryDO('banners');
        $doBanners->get($bannerid);
        $bannerName = $doBanners->description;

        if ($applyto == -1) {
            if (OA_Permission::isAccount(OA_ACCOUNT_MANAGER)) {
                OA_Permission::enforceAccessToObject('campaigns', $campaignid);
            }
            $appliedTo = 0;
            $doBanners = OA_Dal::factoryDO('banners');
            $doBanners->campaignid = $campaignid;
            $doBanners->find();
            while ($doBanners->fetch()) {
                if (($doBanners->bannerid != $bannerid) && (MAX_AclCopy(basename($_SERVER['SCRIPT_NAME']), $bannerid, $doBanners->bannerid))) {
                    $appliedTo++;
                }
            }
            $applyto = $bannerid;
        } else {
            if (OA_Permission::isAccount(OA_ACCOUNT_MANAGER)) {
                OA_Permission::enforceAccessToObject('banners', $applyto);
            }
            if (MAX_AclCopy(basename($_SERVER['SCRIPT_NAME']), $bannerid, $applyto)) {
                $appliedTo++;
            }
        }
        $translation = new OX_Translation();
        $translated_message = $translation->translate ( $GLOBALS['strBannerAclHasBeenAppliedTo'],
            array(MAX::constructURL(MAX_URL_ADMIN, "banner-edit.php?clientid=$clientid&campaignid=$campaignid&bannerid=$bannerid"),
                htmlspecialchars($bannerName),
                $appliedTo
            )
        );
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

        Header ("Location: {$returnurl}?clientid={$clientid}&campaignid={$campaignid}&bannerid=".$applyto);
    } elseif (isset($duplicate) && $duplicate == 'true') {
		
		$doBanners = OA_Dal::factoryDO('banners');         
		$oDbh   = OA_DB::singleton();
		$old_adId   = $bannerid;
         $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
         $newName = "";
         $oldName = "";
         $new_zoneid = 0;
        
         $oRes = $oDbh->query("
            SELECT
                *
            FROM
                {$table_prefix}banners	
            WHERE
                bannerid = {$bannerid}
        ");

        $bannerDetails =  $oRes->fetchRow();
        
  
        if($bannerDetails['bannerid']) {
			
			$oldName = $bannerDetails['description'];
			$bannerDetails['description'] = $newName = $GLOBALS['strCopyOf'] . ' ' . $oldName;
			unset($bannerDetails['bannerid']);
			
			$bannerDetails['status'] = 1; 
			$bannerDetails['admin_approve'] = 0; 
			
			
			if ($bannerDetails['storagetype'] == 'web' || $bannerDetails['storagetype'] == 'sql') {
            $bannerDetails['filename'] = $doBanners->_imageDuplicate($bannerDetails['storagetype'], $bannerDetails['filename']);
			} elseif ($bannerDetails['type'] == 'web' || $bannerDetails['type'] == 'sql') {
            $bannerDetails['filename'] = $doBanners->_imageDuplicate($$bannerDetails['type'], $bannerDetails['filename']);
			}
			 
				foreach($bannerDetails as $k=>$b)
				 {
					 $bannerDetails[$k] = str_replace("'","\'",$b);
					 $bannerDetails[$k] = str_replace('"','\"',$bannerDetails[$k]);
				 }
				 
			 
			$query = "INSERT INTO {$table_prefix}banners 
								(".implode("," , array_keys($bannerDetails)).") 
						VALUES 
								('".implode("','" , $bannerDetails)."')";
								
			$new_adId = $new_bannerid = $oDbh->query($query)->db->connection->insert_id;
			
			
			switch($bannerDetails['ext_bannertype']) {
			
			case "bannerTypeHtml:djaxvastInlineBannerTypeHtml:vastInlineHtml" :
			
					duplicateVastElements($oDbh,$old_adId,$new_adId);
					break;
			
			
			
			}

			
			
			 // Copy ACLs and capping
			MAX_AclCopy(basename($_SERVER['SCRIPT_NAME']), $old_adId, $new_adId);

			// Duplicate and ad-zone associations
			MAX_duplicateAdZones($old_adId, $new_adId);

			
		}
		
		
		
        

        // Run the Maintenance Priority Engine process
        OA_Maintenance_Priority::scheduleRun();

        // Rebuild cache
        // require_once MAX_PATH . '/lib/max/deliverycache/cache-'.$conf['delivery']['cache'].'.inc.php';
        // phpAds_cacheDelete();

        //confirmation message
        $translation = new OX_Translation();
        $translated_message = $translation->translate ( $GLOBALS['strBannerHasBeenDuplicated'],
            array(MAX::constructURL(MAX_URL_ADMIN, "banner-edit.php?clientid=$clientid&campaignid=$campaignid&bannerid=$bannerid"),
                htmlspecialchars($oldName),
                MAX::constructURL(MAX_URL_ADMIN, "banner-edit.php?clientid=$clientid&campaignid=$campaignid&bannerid=$new_bannerid"),
                htmlspecialchars($newName))
        );
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

        Header ("Location: {$returnurl}?clientid={$clientid}&campaignid={$campaignid}&bannerid=".$new_bannerid);
    }
    else {
        Header ("Location: {$returnurl}?clientid={$clientid}&campaignid={$campaignid}&bannerid=".$bannerid);
    }
}

?>
