<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-storage.inc.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';

// Register input variables
phpAds_registerGlobal('returnurl');

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER);
OA_Permission::enforceAccessToObject('affiliates', $affiliateid, true);
OA_Permission::checkSessionToken();

/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/

$doAffiliates = OA_Dal::factoryDO('affiliates');
$doAffiliates->get($affiliateid);
$oldName = $doAffiliates->name;
// $new_affiliateId = $doAffiliates->duplicate();
// $newName = $doAffiliates->name;

// Duplicate the WEBSITE

$oDbh   = OA_DB::singleton();
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
$newName = "";
$oldName = "";
$new_affiliateId = 0;

$oRes = $oDbh->query(" SELECT `affiliateid`, `agencyid`, `name`, `mnemonic`, `comments`, `contact`, `email`, `website`, `updated`, `oac_country_code`, `oac_language_id`, `oac_category_id`, `programatic_deal`, `open_market`, `cpm`, `margin`, `is_seller_json`, `is_confidential`, `is_passthrough`, `seller_json_comments` FROM {$table_prefix}affiliates WHERE affiliateid = {$affiliateid} ");

$websiteDetails =  $oRes->fetchRow();

if($websiteDetails['affiliateid']) 
{
	$oldName = $websiteDetails['name'];
	$websiteDetails['name'] = $newName = $GLOBALS['strCopyOf'] . ' ' . $oldName;
	unset($websiteDetails['affiliateid']);
	
 	$query = "INSERT INTO {$table_prefix}affiliates (".implode("," , array_keys($websiteDetails)).") VALUES ('".implode("','" , $websiteDetails)."')";
	$new_affiliateId = $oDbh->query($query)->db->connection->insert_id;

	$zRes = $oDbh->query(" SELECT `zonename`, `description`, `delivery`, `zonetype`, `category`, `width`, `height`, `ad_selection`, `chain`, `prepend`, `append`, `appendtype`, `forceappend`, `inventory_forecast_type`, `comments`, `cost`, `cost_type`, `cost_variable_id`, `technology_cost`, `technology_cost_type`, `updated`, `block`, `capping`, `session_capping`, `what`, `rate`, `pricing`, `oac_category_id`, `ext_adselection`, `show_capped_no_cookie`, `app_select`, `adformat_type`, `inventory_type`, `passbacktag`, `ssp_buyer`, `vidtype`, `reward`, `amount`, `position`, `layout`, `infeedads`, `infeedpos`, `adposition`, `adinterval`, `inv_type`, `floor_price` FROM {$table_prefix}zones WHERE affiliateid = {$affiliateid} ");
	$i = 0;
	$zoneDetails =  $zRes->fetchAll();

	while($i < sizeof($zoneDetails))
	{
		$zoneDetails[$i]['zonename'] = $GLOBALS['strCopyOf'] . ' ' . $zoneDetails[$i]['zonename'];
		$oDbh->query("INSERT INTO {$table_prefix}zones (".implode("," , array_keys($zoneDetails[$i])).", affiliateid) VALUES ('".implode("','" , $zoneDetails[$i])."', $new_affiliateId)");
		$i++;
	}
}

// Queue confirmation message
$translation = new OX_Translation();
$translated_message = $translation->translate ( $GLOBALS['strWebsiteHasBeenDuplicated'],
    array(MAX::constructURL(MAX_URL_ADMIN, "affiliate-edit.php?affiliateid=$affiliateid"),
        htmlspecialchars($oldName),
        MAX::constructURL(MAX_URL_ADMIN, "affiliate-edit.php?affiliateid=$new_affiliateId"),
        htmlspecialchars($newName))
);
OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);

Header("Location: affiliate-edit.php?affiliateid=$new_affiliateId");
exit;

?>