<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

require_once LIB_PATH . '/Extension/deliveryLimitations/DeliveryLimitationsCommaSeparatedData.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';



/**
 * A Client delivery limitation plugin, for filtering delivery of ads on the
 * basis of the viewer's browser.
 *
 * Works with:
 * A comma separated list of valid browser codes. See the phpSniff.class.php
 * file for details of the valid browser codes.
 *
 * Valid comparison operators:
 * =~, !~
 *
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 */
class Plugins_DeliveryLimitations_Client_Exchange extends Plugins_DeliveryLimitations_CommaSeparatedData
{
    protected static $sourceFd = [
        '0' => 'Bidswitch (SSP) Exchange',
        '1' => 'Header Bidding',
    ];

    public function __construct()
    {
        parent::__construct();
        $this->nameEnglish = 'DSP : Client - Source Exchange';

        $aStringOp = MAX_limitationsGetAOperationsForString($this);

        //~ $this->delimiter = '|';
        $this->aOperations = [
            '==' => $aStringOp['=='],
            '!=' => $aStringOp['!='],
        ];
    }

   

    /**
     * Outputs the HTML to display the data for this limitation
     *
     * @return void
     */
    public function displayArrayData()
    {
        $tabindex =& $GLOBALS['tabindex'];
		?>
		<table width="275" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td align="left" width="50"><strong><?php echo "Impression Sale Decision";
				?>:</strong></td>
				<td><select name="acl[<?php echo $this->executionorder;
				?>][data][]" value="<?php echo((!empty($this->data[2])) ? htmlspecialchars($this->data[2]) : '');
				?>" tabindex="<?php echo $tabindex;
				?>"><?php foreach (self::$sourceFd as $key => $value) {
					$value = htmlspecialchars($value, ENT_QUOTES);
					echo "<option value='{$key}'".($key == $this->data[$key] ? ' selected="selected"' : '').">{$value}</option>";
					
				}
				?></select></td>
			</tr>
			
		</table><?php
    }
}
