package router

import (
	"log"

	config "alpha/configuration"
	"alpha/rhandler"
	"crypto/tls"
	"net/http"

	"github.com/gorilla/mux"
)

// SetupHandlers Function for handling routes
func SetupHandlers() {

	go rhandler.ExecuteCronJob()

	log.Println("Server started")
	r := mux.NewRouter()

	r.HandleFunc("/", rhandler.Home).Methods("GET")
	r.HandleFunc("/asyncjs", rhandler.AsyncJs).Methods("GET")
	r.HandleFunc("/async", rhandler.Async).Methods("GET")
	r.HandleFunc("/ajs", rhandler.Ajs).Methods("GET")
	r.HandleFunc("/iframe", rhandler.Iframe).Methods("GET")
	r.HandleFunc("/video", rhandler.Video).Methods("GET")
	r.HandleFunc("/audio", rhandler.Audio).Methods("GET")
	r.HandleFunc("/outstream", rhandler.Outstream).Methods("GET")
	r.HandleFunc("/vastxml", rhandler.Vastxml).Methods("GET")
	r.HandleFunc("/request_sdk", rhandler.Request_sdk).Methods("GET")
	r.HandleFunc("/cookiesync", rhandler.Cookiesync).Methods("GET")
	r.HandleFunc("/testresponse", rhandler.TestResponse).Methods("GET")
	srv := &http.Server{
		Addr:    config.GetConfig("port", "app"),
		Handler: r,
		TLSConfig: &tls.Config{
			MinVersion:               tls.VersionTLS13,
			PreferServerCipherSuites: true,
		},
	}
	if err := srv.ListenAndServeTLS(config.GetConfig("CertFile", "key"), config.GetConfig("KeyFile", "key")); err != nil {
		panic(err)
	}

	// if err := http.ListenAndServe(string(config.GetConfig("portraw", "app")), r); err != nil {
	// 	panic(err)
	// }
}
