package zone

/**
 * Import the Packages
 */
import (
	"alpha/adDelivery/helper"
	"alpha/adDelivery/structure"
	"alpha/redisClient"
	"fmt"

	config "alpha/configuration"
	"alpha/db"
)

var redisClients = redisClient.Initialize()

func Vastxml(keyname string) string {

	var vast string
	redisClients.GetKey(keyname, &vast)

	return vast
}

/**
 * Get The Zone Infomation
 *
 * @param int zone_id
 * @return ZoneDetails Structure
 */

func ZoneModel_ZoneInfo(zone_id int) structure.ZoneDetails {

	var zone_id_str string
	zoneinfo := structure.ZoneDetails{} // initiate the ZoneDetails structure

	zone_id_str = helper.IntToString(zone_id) // Convert Zone id as string value

	redisClients.GetKey("zone_id_"+zone_id_str, &zoneinfo) // Check Zone infomations found in cache

	if zoneinfo.Zoneid != 0 {
		return zoneinfo
	} // if zone information found in redis cache , return the redis cache

	ZoneInfoQuery(zone_id, &zoneinfo) //  Request to get zone details from database

	if zoneinfo.Zoneid != 0 {

		redisClients.SetKey("zone_id_"+zone_id_str, zoneinfo)
		//  Store to redis cache

	}

	return zoneinfo
}

/**
 * Get The Zone Infomation from database
 *
 * @param int zone_id
 * @param ZoneDetails empty strucute
 */

func ZoneInfoQuery(zoneid int, zoneinfo *structure.ZoneDetails) {

	//  Initiate the zone variables
	var zonename string
	var zone_id int
	var affiliateid int
	var delivery string
	var zonetype int
	var width int
	var height int
	var prepend string
	var append string
	var inventory_type int
	var ssp_buyer string
	var block int
	var capping int
	var session_capping int
	var inv_type int
	var passbacktag string
	var comments string
	var vidtype int
	var reward string
	var amount string
	var position string
	var layout string
	var infeedads string
	var infeedpos string
	var adposition string
	var adinterval string
	var affiliate_name string
	var is_seller_json int

	table_prefix := config.GetConfig("prefix", "table") //  Get the table prefix

	DbQuery := "SELECT z.zoneid,z.zonename,z.affiliateid,z.delivery,z.zonetype,z.width,z.height,z.prepend,z.append,z.inventory_type,z.ssp_buyer,z.block,z.capping,z.session_capping,z.inv_type,z.passbacktag ,a.comments ,vidtype,reward,amount	,position,layout,infeedads,infeedpos,adposition,adinterval,a.name as affiliate_name, a.is_seller_json as is_seller_json from " + table_prefix + "zones as z inner join " + table_prefix + "affiliates as a ON a.affiliateid = z.affiliateid where zoneid = %d"

	DbQuery = fmt.Sprintf(DbQuery, zoneid) //  Replace the zone id with '%d'
	zoneDetails := db.DbQueryRow(DbQuery)  //  Execute the query & get the row

	zoneDetails.Scan(&zone_id, &zonename, &affiliateid, &delivery, &zonetype, &width, &height, &prepend, &append, &inventory_type, &ssp_buyer, &block, &capping, &session_capping, &inv_type, &passbacktag, &comments, &vidtype, &reward, &amount, &position, &layout, &infeedads, &infeedpos, &adposition, &adinterval, &affiliate_name, &is_seller_json) // Assign row values into variables

	// Assign zone values to ZoneDetails structure

	zoneinfo.Zoneid = zone_id
	zoneinfo.Zonename = zonename
	zoneinfo.Affiliateid = affiliateid
	zoneinfo.Delivery = delivery
	zoneinfo.Zonetype = zonetype
	zoneinfo.Width = width
	zoneinfo.Height = height
	zoneinfo.Prepend = prepend
	zoneinfo.Append = append
	zoneinfo.Inventory_type = inventory_type
	zoneinfo.Ssp_buyer = ssp_buyer
	zoneinfo.Block = block
	zoneinfo.Capping = capping
	zoneinfo.Session_capping = session_capping
	zoneinfo.Inv_type = inv_type
	zoneinfo.Passbacktag = passbacktag
	zoneinfo.Comments = comments
	zoneinfo.Vidtype = vidtype
	zoneinfo.Reward = reward
	zoneinfo.Amount = amount
	zoneinfo.Position = position
	zoneinfo.Layout = layout
	zoneinfo.Infeedads = infeedads
	zoneinfo.Infeedpos = infeedpos
	zoneinfo.Adposition = adposition
	zoneinfo.Adinterval = adinterval
	zoneinfo.Affiliate_name = affiliate_name
	zoneinfo.Is_seller_json = is_seller_json

	fmt.Println("zoneinfo.Ssp_buyer", zoneinfo.Ssp_buyer)
}
