package cronjobs


import (

	"net/http"

	"fmt"
	"strconv"
	"encoding/csv"
	"encoding/json"
	"os"
	"go/build"
	// "flag"
	"path/filepath"
)



func ProcessDmpSegments(){

	
	var seg_id int
	seg_user_url := getSegmentDataURL()
	

	segment_ids := getSegmentIds()
	

	for segment_ids.Next() {

		
		 segment_ids.Scan(&seg_id)

				
					dmp_fetchfrom := seg_user_url+`?segmentId=`+strconv.Itoa(seg_id)
		
		req, reqerr := http.NewRequest("GET", dmp_fetchfrom, nil)
		if reqerr != nil{
			panic(reqerr)
		}
		req.Header.Add("Content-Type", "application/json")
		client := &http.Client{}
		fetchresp, resperr := client.Do(req)

		if resperr != nil{
			panic(resperr)
		}
		
		var dmpresp DmpSegmentResp
		
		json.NewDecoder(fetchresp.Body).Decode(&dmpresp)
		
						    //~ fmt.Println(dmp_fetchfrom)
						    //~ fmt.Println(dmpresp)

		if dmpresp.Success_code == 1000{
			
			
			
		    createfileon :=  filepath.Join(build.Default.GOPATH , "/ssp-alpha/segments/seg_"+ strconv.Itoa(seg_id)+ ".csv")
		    
		    fmt.Println(build.Default.GOPATH , "/ssp-alpha/segments/seg_"+ strconv.Itoa(seg_id)+ ".csv")
	
			csvdatafile, ferr := os.OpenFile(createfileon, os.O_RDWR|os.O_CREATE|os.O_TRUNC , 0755)
			if ferr != nil{
				panic(ferr)
			}
			
		   	defer csvdatafile.Close()
		   	wr := csv.NewWriter(csvdatafile)
		   	for _, obj := range dmpresp.Data { 
		   		var record []string
		        record = append(record, obj.UniqueId)
		        if werr := wr.Write(record); werr !=  nil{
		        	panic(werr)
		        }
		        record = nil
		    }
		    wr.Flush()	
		}else{
			fmt.Println("%s for Segment id %d\n",dmpresp.Failure_response, seg_id)
		}
		
		
					
				
			}
			
			

	
	
} 




type DmpSegmentResp struct{
	
	Success_code int `json:"successCode"`
	Success_response string `json:"successResponse"`
	Error_code int `json:"errorCode"`
	Failure_response string `json:"failureResponse"`
	Status string `json:"status"`
	Errors string `json:"errors"`
	SegmentData string `json:"segmentData"`
	Data []DmpSegmentResp_Data `json: "data"`
}

type DmpSegmentResp_Data struct{
	UniqueId string `json: "uniqueId"`
}
