package ads_external

import "alpha/adDelivery/structure"
import "alpha/adDelivery/helper"

func GenerateNativeImageObjects(outputData *structure.OutputData, zoneExtra AdExchangeZone, pub_details SiteObjects__pub, matchedDeals []DealsDetails, buyer_details []ExchangeDetails, GrobalVariables structure.GlobalVariables) SspRequestNative {

	zninfo := outputData.Zone_details
	ssp_req := SspRequestNative{}
	ssp_req.Id = GetId()
	ssp_req.Dsp = GetDspObj(outputData, ssp_req.Id, zninfo, zoneExtra, buyer_details, pub_details)
	ssp_req.Imp = GetImpNativeObj(zninfo, zoneExtra, matchedDeals)
	if outputData.Tag_type == "sdk" {
		ssp_req.App = GetAppObj(zninfo, zoneExtra, GrobalVariables)
		ssp_req.App.Pub = pub_details

	} else {
		ssp_req.Site = GetSiteObj(zninfo, zoneExtra, GrobalVariables)
		ssp_req.Site.Pub = pub_details

	}
	ssp_req.Device = GetDeviceObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Device.Geo = GetGeoObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.User = GetUserObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Tmax = zoneExtra.Req_tmax
	ssp_req.Regs = GetRegObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Restri = GetRestriObj(zninfo, zoneExtra, GrobalVariables)

	return ssp_req

}

func GenerateNativeVideoObjects(outputData *structure.OutputData, zoneExtra AdExchangeZone, pub_details SiteObjects__pub, matchedDeals []DealsDetails, buyer_details []ExchangeDetails, GrobalVariables structure.GlobalVariables) SspRequestNative {

	zninfo := outputData.Zone_details

	ssp_req := SspRequestNative{}
	ssp_req.Id = GetId()
	ssp_req.Dsp = GetDspObj(outputData, ssp_req.Id, zninfo, zoneExtra, buyer_details, pub_details)
	ssp_req.Imp = GetVideoNativeObj(zninfo, zoneExtra, matchedDeals)
	if outputData.Tag_type == "sdk" {
		ssp_req.App = GetAppObj(zninfo, zoneExtra, GrobalVariables)
		ssp_req.App.Pub = pub_details

	} else {
		ssp_req.Site = GetSiteObj(zninfo, zoneExtra, GrobalVariables)
		ssp_req.Site.Pub = pub_details

	}
	ssp_req.Device = GetDeviceObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Device.Geo = GetGeoObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.User = GetUserObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Tmax = zoneExtra.Req_tmax
	ssp_req.Regs = GetRegObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Restri = GetRestriObj(zninfo, zoneExtra, GrobalVariables)

	return ssp_req

}

func GenerateImgObjects(outputData *structure.OutputData, zoneExtra AdExchangeZone, pub_details SiteObjects__pub, matchedDeals []DealsDetails, buyer_details []ExchangeDetails, GrobalVariables structure.GlobalVariables) SspRequestImg {

	zninfo := outputData.Zone_details
	ssp_req := SspRequestImg{}
	ssp_req.Id = GetId()
	ssp_req.Dsp = GetDspObj(outputData, ssp_req.Id, zninfo, zoneExtra, buyer_details, pub_details)
	ssp_req.Imp = GetImpImgObj(zninfo, zoneExtra, matchedDeals)
	if outputData.Tag_type == "sdk" {
		ssp_req.App = GetAppObj(zninfo, zoneExtra, GrobalVariables)
		ssp_req.App.Pub = pub_details

	} else {
		ssp_req.Site = GetSiteObj(zninfo, zoneExtra, GrobalVariables)
		ssp_req.Site.Pub = pub_details

	}
	ssp_req.Device = GetDeviceObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Device.Geo = GetGeoObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.User = GetUserObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Tmax = zoneExtra.Req_tmax
	ssp_req.Regs = GetRegObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Restri = GetRestriObj(zninfo, zoneExtra, GrobalVariables)

	return ssp_req

}

func GenerateVideoAudioObjects(outputData *structure.OutputData, zoneExtra AdExchangeZone, pub_details SiteObjects__pub, matchedDeals []DealsDetails, buyer_details []ExchangeDetails, GrobalVariables structure.GlobalVariables) SspRequestVideo {

	zninfo := outputData.Zone_details

	vast := helper.GetUrlParam(outputData.R, "vast")
	protocal := 0

	if outputData.Tag_type == "video" {

		switch vast {
		case "vast1":
			protocal = 1
		case "vast2":
			protocal = 2
		case "vast3":
			protocal = 3
		case "vast1_wrapper":
			protocal = 4
		case "vast2_wrapper":
			protocal = 5
		case "vast3_wrapper":
			protocal = 6
		case "vast4":
			protocal = 7
		case "vast4_wrapper":
			protocal = 8
		case "daast_1":
			protocal = 9
		case "daast_1_wapper":
			protocal = 10
		case "vast4_1":
			protocal = 11
		case "vast4_1_wrapper":
			protocal = 12

		}

	} else if outputData.Tag_type == "audio" {

		protocal = 9
	}

	ssp_req := SspRequestVideo{}
	ssp_req.Id = GetId()
	ssp_req.Dsp = GetDspObj(outputData, ssp_req.Id, zninfo, zoneExtra, buyer_details, pub_details)

	ssp_req.Imp = GetImpVidObj(zninfo, zoneExtra, matchedDeals, protocal)

	if outputData.Tag_type == "sdk" {
		ssp_req.App = GetAppObj(zninfo, zoneExtra, GrobalVariables)
		ssp_req.App.Pub = pub_details

	} else {
		ssp_req.Site = GetSiteObj(zninfo, zoneExtra, GrobalVariables)
		ssp_req.Site.Pub = pub_details

	}

	ssp_req.Device = GetDeviceObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Device.Geo = GetGeoObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.User = GetUserObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Tmax = zoneExtra.Req_tmax
	ssp_req.Regs = GetRegObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Restri = GetRestriObj(zninfo, zoneExtra, GrobalVariables)

	return ssp_req

}

func GenerateAudioObjects(outputData *structure.OutputData, zoneExtra AdExchangeZone, pub_details SiteObjects__pub, matchedDeals []DealsDetails, buyer_details []ExchangeDetails, GrobalVariables structure.GlobalVariables) SspRequestAudio {

	zninfo := outputData.Zone_details

	vast := helper.GetUrlParam(outputData.R, "vast")
	protocal := 0

	switch vast {

		case "daast_1":
			protocal = 9
		case "daast_1_wapper":
			protocal = 10
		case "vast4_1": 
			protocal = 11
		case "vast4_1_wrapper":
			protocal = 12
	} 

	ssp_req := SspRequestAudio{}
	ssp_req.Id  = GetId()
	ssp_req.Dsp = GetDspObj(outputData, ssp_req.Id, zninfo, zoneExtra, buyer_details, pub_details)
	ssp_req.Imp = GetImpAudObj(zninfo, zoneExtra, matchedDeals, protocal)

	if outputData.Tag_type == "sdk" {
		ssp_req.App 	= GetAppObj(zninfo, zoneExtra, GrobalVariables)
		ssp_req.App.Pub = pub_details

	} else {
		ssp_req.Site 	 = GetSiteObj(zninfo, zoneExtra, GrobalVariables)
		ssp_req.Site.Pub = pub_details
	} 

	ssp_req.Device = GetDeviceObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Device.Geo = GetGeoObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.User = GetUserObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Tmax = zoneExtra.Req_tmax
	ssp_req.Regs = GetRegObj(zninfo, zoneExtra, GrobalVariables)
	ssp_req.Restri = GetRestriObj(zninfo, zoneExtra, GrobalVariables)

	return ssp_req
}