package ads_external

type SspRequestImg struct {
	Id   string `json:"id"`
	Tmax int    `json:"tmax"`

	Dsp    []DspObjects    `json:"dsp,omitempty"`
	Imp    []ImpImgObjects `json:"imp,omitempty"`
	Site   SiteObjects     `json:"site,omitempty"`
	App    AppObject       `json:"app,omitempty"`
	Device DeviceObjects   `json:"device,omitempty"`
	User   UserObjects     `json:"user,omitempty"`
	Regs   RegsObjects     `json:"regs,omitempty"`
	Restri Restrictions    `json:"restrictions,omitempty"`
}

type Restrictions struct {
	Test   int      `json:"test"`
	Badv   []string `json:"badv,omitempty"`
	Bapp   []string `json:"bapp,omitempty"`
	Bcat   []string `json:"bcat,omitempty"`
	Secure int      `json:"secure,omitempty"`
	Gdpr   int      `json:"gdpr,omitempty"`
	Ccpa   string   `json:"ccpa,omitempty"`
}

type SspRequestVideo struct {
	Id     string       `json:"id"`
	Tmax   int          `json:"tmax"`
	Restri Restrictions `json:"restrictions,omitempty"`

	Dsp    []DspObjects      `json:"dsp,omitempty"`
	Imp    []ImpVideoObjects `json:"imp,omitempty"`
	Site   SiteObjects       `json:"site,omitempty"`
	App    AppObject         `json:"app,omitempty"`
	Device DeviceObjects     `json:"device,omitempty"`
	User   UserObjects       `json:"user,omitempty"`
	Regs   RegsObjects       `json:"regs,omitempty"`
}

type SspRequestNative struct {
	Id     string       `json:"id"`
	Tmax   int          `json:"tmax"`
	Restri Restrictions `json:"restrictions,omitempty"`

	Dsp  []DspObjects       `json:"dsp,omitempty"`
	Imp  []ImpNativeObjects `json:"imp,omitempty"`
	Site SiteObjects        `json:"site,omitempty"`
	App  AppObject          `json:"app,omitempty"`

	Device DeviceObjects `json:"device,omitempty"`
	User   UserObjects   `json:"user,omitempty"`
	Regs   RegsObjects   `json:"regs,omitempty"`
}

type DspObjects struct {
	Id             int                `json:"id"`
	Ver            string             `json:"ver"`
	Ping_url       string             `json:"ping_url"`
	At             int                `json:"at"`
	Cur            []string           `json:"cur"`
	Ext            DspObjects__ext    `json:"ext,omitempty"`
	Source         DspObjects__source `json:"source"`
	Gzip           int                `json:"gzip"`
	Buyer_id       string             `json:"buyer_id"`
	SeconBidBuffer float64            `json:"seconBidBuffer"`
}

type DspObjects__ext struct {
	Ads_txt DspObjects__ext__ads_txt `json:"ads_txt,omitempty"`
}

type DspObjects__ext__ads_txt struct {
	Status  int    `json:"status,omitempty"`
	Auth_id string `json:"auth_id,omitempty"`
	Pub_id  string `json:"pub_id,omitempty"`
}

type DspObjects__source struct {
	Tid string                 `json:"tid"`
	Ts  int                    `json:"ts"`
	Ds  string                 `json:"ds"`
	Ext DspObjects__source_ext `json:"ext",omitempty`
}

type DspObjects__source_ext struct {
	Schain DspObjects__source_ext_schain `json: "schain",omitempty`
}

type DspObjects__source_ext_schain struct {
	Sccomplete int                                 `json:"complete", omitempty`
	Scnodes    DspObjects__source_ext_schain_nodes `json: "nodes", omitempty`
	Scversion  string                              `json: "ver", omitempty`
}

type DspObjects__source_ext_schain_nodes struct {
	Nodes_asi    string `json: "asi"`
	Nodes_sid    string `json: "sid"`
	Nodes_rid    string `json: "rid", omitempty`
	Nodes_name   string `json: "name", omitempty`
	Nodes_domain string `json: "domain", omitempty`
	Nodes_hp     int    `json: "hp", omitempty`
}

type ImpImgObjects struct {
	Id       string             `json:"id"`
	Bidfloor float64            `json:"bidfloor"`
	Pmp      ImpObjects__pmp    `json:"pmp"`
	Banner   ImpObjects__banner `json:"banner,omitempty"`
}

type ImpVideoObjects struct {
	Id       string            `json:"id"`
	Bidfloor float64           `json:"bidfloor"`
	Pmp      ImpObjects__pmp   `json:"pmp"`
	Video    ImpObjects__video `json:"video,omitempty"`
}

type ImpObjects__pmp struct {
	Private_auction int                      `json:"private_auction"`
	Deals           []ImpObjects__pmp__deals `json:"deals"`
}

type ImpObjects__pmp__deals struct {
	Id       string   `json:"id"`
	At       int      `json:"at"`
	Bidfloor float64  `json:"bidfloor"`
	Wseat    []string `json:"wseat"`
}

type ImpObjects__banner struct {
	H     int      `json:"h"`
	W     int      `json:"w"`
	Pos   int      `json:"pos"`
	Mimes []string `json:"mimes"`
}

type ImpObjects__video struct {
	W              int                              `json:"w,omitempty"`
	H              int                              `json:"h,omitempty"`
	Pos            int                              `json:"pos,omitempty"`
	Startdelay     int                              `json:"startdelay,omitempty"`
	Minduration    int                              `json:"minduration,omitempty"`
	Maxduration    int                              `json:"maxduration,omitempty"`
	Maxextended    int                              `json:"maxextended,omitempty"`
	Minbitrate     int                              `json:"minbitrate,omitempty"`
	Maxbitrate     int                              `json:"maxbitrate"`
	Api            []int                            `json:"api,omitempty,omitempty"`
	Protocols      []int                            `json:"protocols,omitempty"`
	Mimes          []string                         `json:"mimes,omitempty"`
	Linearity      int                              `json:"linearity"`
	Boxingallowed  int                              `json:"boxingallowed"`
	Playbackmethod []int                            `json:"playbackmethod,omitempty"`
	Delivery       []int                            `json:"delivery,omitempty,omitempty"`
	Battr          []int                            `json:"battr,omitempty,omitempty"`
	Companionad    []ImpObjects__video__companionad `json:"companionad,omitempty"`
	Companiontype  []int                            `json:"companiontype,omitempty"`
}

type ImpObjects__video__companionad struct {
	Id     string `json:"id,omitempty"`
	W      int    `json:"w,omitempty"`
	H      int    `json:"h,omitempty"`
	Pos    int    `json:"pos,omitempty"`
	Battr  []int  `json:"battr,omitempty"`
	Expdir []int  `json:"expdir,omitempty"`
}

type SiteObjects struct {
	Id        string                 `json:"id"`
	Name      string                 `json:"name"`
	Domain    string                 `json:"domain"`
	Page      string                 `json:"page"`
	Pagecat   []string               `json:"pagecat"`
	Mobile    int                    `json:"mobile"`
	Amp       int                    `json:"mobile"`
	Pub       SiteObjects__pub       `json:"pub"`
	Inventory SiteObjects__inventory `json:"inventory"`
}

type SiteObjects__pub struct {
	Id     string `json:"id,omitempty"`
	Name   string `json:"name,omitempty"`
	Domain string `json:"domain,omitempty"`
}

type SiteObjects__inventory struct {
	Name          string                     `json:"name,omitempty"`
	Domain        string                     `json:"domain,omitempty"`
	Cat           []string                   `json:"cat,omitempty"`           // Array of IAB content categories
	SectionCat    []string                   `json:"sectioncat,omitempty"`    // Array of IAB content categories for subsection
	PageCat       []string                   `json:"pagecat,omitempty"`       // Array of IAB content categories for page
	PrivacyPolicy int                        `json:"privacypolicy,omitempty"` // Default: 1 ("1": has a privacy policy)
	Keywords      string                     `json:"keywords,omitempty"`      // Comma separated list of keywords about the site.
	Publisher     SiteObjects__inventory_pub `json:"publisher,omitempty"`     // Details about the Publisher
}

type SiteObjects__inventory_pub struct {
	ID     string   `json:"id,omitempty"`
	Name   string   `json:"name,omitempty"`
	Cat    []string `json:"cat,omitempty"`
	Domain string   `json:"domain,omitempty"`
}

type AppObject struct {
	Bundle    string                 `json:"bundle,omitempty"`   // App bundle or package name
	StoreURL  string                 `json:"storeurl,omitempty"` // App store URL for an installed app
	Ver       string                 `json:"ver,omitempty"`      // App version
	Paid      int                    `json:"paid,omitempty"`     // "1": Paid, "2": Free
	Pub       SiteObjects__pub       `json:"pub,omitempty"`
	Inventory SiteObjects__inventory `json:"inventory,omitempty"`
}

type DeviceObjects struct {
	Type       int                `json:"type"`
	Ifa        string             `json:"ifa"`
	Ip         string             `json:"ip"`
	Ua         string             `json:"ua"`
	Make       string             `json:"make"`
	Model      string             `json:"model"`
	Devicetype int                `json:"devicetype"`
	Hwv        string             `json:"hwv"`
	Os         string             `json:"os"`
	Osv        string             `json:"osv"`
	Mccmnc     string             `json:"mccmnc"`
	Geo        DeviceObjects__geo `json:"geo"`
}

type DeviceObjects__geo struct {
	Type      int     `json:"type"`
	Lat       float64 `json:"lat"`
	Lon       float64 `json:"lon"`
	Country   string  `json:"country"`
	Utcoffset int     `json:"utcoffset"`
}

type UserObjects struct {
	Id       string              `json:"id"`
	Consent  string              `json:"consent"`
	Buyeruid string              `json:"buyeruid"`
	Yob      int                 `json:"yob"`
	Gender   string              `json:"gender"`
	Data     []UserObjects__data `json:"data"`
	Ext      UserObjects__ext    `json:"ext"`
}

type UserObjects__data struct {
	Id      string     `json:"id"`
	Name    string     `json:"name"`
	Segment []Segments `json:"segment"`
}

type Segments struct {
	Id    string `json:"id"`
	Name  string `json:"name"`
	Value string `json:"value"`
}

type UserObjects__ext struct {
	Consented_providers_settings []UserObjects__ext_cps `json:"consented_providers_settings"`
}
type UserObjects__ext_cps struct {
	Consented_providers []int `json:"consented_providers"`
}

type RegsObjects struct {
	Coppa int    `json:"coppa"`
	Gdpr  int    `json:"gdpr"`
	Ccpa  string `json:"ccpa"`
}

type Cache_DealsDetails struct {
	In           int
	MatchedDeals []DealsDetails
}

type AdExchangeZone struct {
	Zoneid              int
	Req_test            int
	Req_tmax            int
	Req_wseat           string
	Req_allimps         int
	Req_bcat            string
	Req_badv            string
	Req_bapp            string
	Req_regs            string
	Imp_dm              string
	Imp_dms             string
	Imp_tagid           string
	Imp_bidfloor        float64
	Imp_bidfloorcur     string
	Imp_cb              int
	Imp_secure          int
	Imp_iframe          string
	Imp_exp             int
	Imp_pmp             string
	Ban_btype           string
	Ban_battr           string
	Ban_mimes           string
	Vid_width           int
	Vid_height          int
	Vid_playervideo     string
	Vid_mimes           string
	Vid_min             int
	Vid_max             int
	Vid_protocol        string
	Vid_sd              int
	Vid_roll_sec        int
	Vid_lin             int
	Vid_skip            int
	Vid_skipmin         int
	Vid_skipafter       int
	Vid_seq             int
	Vid_battr           string
	Vid_maxext          int
	Vid_minbit          int
	Vid_maxbit          int
	Vid_box             int
	Vid_play            string
	Vid_del             int
	Vid_pos             int
	Vid_compad          string
	Vid_api             string
	Vid_comptype        string
	Vid_comp_width      int
	Vid_comp_height     int
	Deal_bidfloor       float64
	Deal_bidfloorcur    string
	Deal_wseat          string
	Deal_wadomain       string
	Site_cat            string
	Site_section        string
	Site_page           string
	Site_key            string
	Site_content        string
	Site_privacy        int
	App_id              string
	App_name            string
	App_bundle          string
	App_url             string
	App_cat             string
	App_section         string
	App_page            string
	App_privacy         string
	App_ver             string
	App_paid            int
	App_key             string
	Pub_cat             string
	Pub_domain          string
	Cont_epi            int
	Cont_title          string
	Cont_series         string
	Cont_season         string
	Cont_prod           string
	Cont_cat            string
	Cont_prodq          int
	Cont_vq             int
	Cont_context        int
	Cont_cr             string
	Cont_ur             string
	Cont_mr             int
	Cont_key            string
	Cont_len            int
	Cont_lang           string
	Cont_embed          int
	Cont_data           string
	Prod_name           string
	Prod_cat            string
	Prod_domain         string
	Dev_dnt             int
	Dev_lmt             int
	Geo_accuracy        int
	Geo_lf              int
	User_bid            string
	User_yob            int
	User_gender         string
	User_key            string
	User_cd             string
	User_data           string
	Data_name           string
	Data_seg            string
	Seg_name            string
	Seg_value           string
	Format_w            int
	Format_h            int
	Nat_lay             int
	Nat_adunit          int
	Nat_len             int
	Nat_type            int
	Nat_width           int
	Nat_height          int
	Nat_img_mimes       string
	Nat_vid_width       int
	Nat_vid_height      int
	Nat_vid_playervideo string
	Nat_vid_mimes       string
	Nat_min             int
	Nat_max             int
	Nat_vid_protocol    string
	Nat_datatype        int
	Nat_datalength      int
	Nat_lin             int
	Rtb_id              string
	Nat_id              string
	Nat_widheight       string
	Aud_mimes           string
	Aud_min             int
	Aud_max             int
	Aud_protocol        string
	Aud_battr           string
	Aud_maxext          int
	Aud_minbit          int
	Aud_maxbit          int
	Aud_del             string
	Aud_comptype        string
	Aud_maxseq          int
	Aud_feed            int
	Aud_nvol            int
	Aud_dl              int
	Pmp                 int
	Deal_id             string
	Below_img           string
	Desk_height         string
	Desk_width          string
	Img_height          string
	Img_width           string
	Native_objects      string
	Gdpr                int
	Ccpa                string
}

type ExchangeDetails struct {
	Exchange_id       int
	Exchange_name     string
	Open_rtb_version  string
	Status            int
	Ping_url          string
	Auction_currency  int
	Auction_type      int
	Digital_signature string
	Gzip              int
	SeconBidBuffer    float64
}

type DealsDetails struct {
	Dealid       int
	Dealid_token string
	Auction_type int
	Floor_price  float64
	Zones        string
	Adsize       string
	Whitelist    string
}

type ExternalResponse struct {
	Ads struct {
		Num1 struct {
			ID    string `json:"id"`
			Bidid string `json:"bidid"`
			Cur   string `json:"cur"`
			Seat  string `json:"seat"`
			Imp   string `json:"imp"`
			Adid  string `json:"adid"`
			Cid   string `json:"cid"`
			Adm   string `json:"adm"`
			Price int    `json:"price"`
			Burl  string `json:"burl"`
		} `json:"1"`
	} `json:"ads"`
}

type ImpNativeObjects struct {
	Id       string            `json:"id,omitempty"`
	Bidfloor float64           `json:"bidfloor"`
	Natives  Nativeobj_details `json:"native,omitempty"`
}

type Nativeobj_details struct {
	NativeReq NativeRequests `json:"request"`
}
type NativeRequests struct {
	Assets []interface{} `json:"assets"`
}

//Nativeassets for native
type Nativeobj_assetsTitle struct {
	Id       int                           `json:"id"`
	Required int                           `json:"req"`
	Title    Nativeobj_assetsTitle_details `json:"title"`
}

//Nativeassets for native
type Nativeobj_assetsVideo struct {
	Id    int               `json:"id"`
	Video ImpObjects__video `json:"video"`
}

//Nativetitle for native
type Nativeobj_assetsTitle_details struct {
	Lens int `json:"len"`
}

type Nativeobj_assetsImg struct {
	Id       int                         `json:"id"`
	Required int                         `json:"req,omitempty"`
	Img      Nativeobj_assetsImg_Details `json:"img"`
}

//Nativeimg for native
type Nativeobj_assetsImg_Details struct {
	W    int `json:"w,omitempty"`
	H    int `json:"h,omitempty"`
	Type int `json:"type"`
}

type Nativeobj_assetsData struct {
	Id       int                          `json:"id"`
	Required int                          `json:"req"`
	Data     Nativeobj_assetsData_details `json:"data"`
}

//Nativedata for native
type Nativeobj_assetsData_details struct {
	Type int `json:"type"`
	Len  int `json:"len,omitempty"`
}
type SspRequestAudio struct {
	Id     string       `json:"id"`
	Tmax   int          `json:"tmax"`
	Restri Restrictions `json:"restrictions,omitempty"`

	Dsp    []DspObjects      `json:"dsp,omitempty"`
	Imp    []ImpAudioObjects `json:"imp,omitempty"`
	Site   SiteObjects       `json:"site,omitempty"`
	App    AppObject         `json:"app,omitempty"`
	Device DeviceObjects     `json:"device,omitempty"`
	User   UserObjects       `json:"user,omitempty"`
	Regs   RegsObjects       `json:"regs,omitempty"`
}
type ImpAudioObjects struct {
	Id       string            `json:"id"`
	Bidfloor float64           `json:"bidfloor"`
	Pmp      ImpObjects__pmp   `json:"pmp"`
	Audio    ImpObjects__audio `json:"audio,omitempty"`
}
type ImpObjects__audio struct {
	Sequence      int            	 				`json:"sequence,omitempty"`
	Feed          int             					`json:"feed,omitempty"`  
	Stitched      int             					`json:"stitched,omitempty"`
	NVol          int             					`json:"nvol,omitempty"` 
	MaxSequence   int             					`json:"maxseq,omitempty"`	
	Startdelay     int                              `json:"startdelay,omitempty"`
	Minduration    int                              `json:"minduration,omitempty"`
	Maxduration    int                              `json:"maxduration,omitempty"`
	Maxextended    int                              `json:"maxextended,omitempty"`
	Minbitrate     int                              `json:"minbitrate,omitempty"`
	Maxbitrate     int                              `json:"maxbitrate"`
	Maxsequence     int                              `json:"maxbitrate"`
	Api            []int                            `json:"api,omitempty,omitempty"`
	Protocols      []int                            `json:"protocols,omitempty"`
	Mimes          []string                         `json:"mimes,omitempty"`
	Linearity      int                              `json:"linearity"`
	Delivery       []int                            `json:"delivery,omitempty,omitempty"`
	Battr          []int                            `json:"battr,omitempty,omitempty"`
	Companionad    []ImpObjects__audio__companionad `json:"companionad,omitempty"`
	Companiontype  []int                            `json:"companiontype,omitempty"`
}

type ImpObjects__audio__companionad struct {
	Id     string `json:"id,omitempty"`
	W      int    `json:"w,omitempty"`
	H      int    `json:"h,omitempty"`
	Pos    int    `json:"pos,omitempty"`
	Battr  []int  `json:"battr,omitempty"`
	Expdir []int  `json:"expdir,omitempty"`
}