package adrtb

import (
	"alpha/addelivery/fetching"
	"alpha/addelivery/helper"
	"alpha/addelivery/structure"
	config "alpha/configuration"
	"alpha/logger"
	"bytes"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"strings"
	"sync"
	"time"
)

var Track_Req_Res string = ` pbjs = pbjs || {};  var Request_bids ={}; var Res_status="&res_count=0"; 
var Bidder_Response={}; pbjs.que = pbjs.que || [];
pbjs.onEvent('bidRequested', bidderRequest => {
	console.log("bidderRequest : count :"+count);
	console.log(bidderRequest);
	
	bidderRequest['bids'].forEach(function(v,k){
		if(v!=""){
		Request_bids[bidderRequest['bids'][count]['bidId']]=v;count++;
		if(Priority_level>1){
			var Request_URL=v['Request_URL'];
			xmlHttp.open( "GET", Request_URL, false ); 
			xmlHttp.send();
		}
		}
	});count=0;console.log(Request_bids);
	});
	pbjs.onEvent('bidResponse', bid => { console.log("bidResponse :");
	console.log(bid); 
	Res_status="&res_count=1";
	Bidder_Response=bid;
	var Response_URL=Request_bids[bid['requestId']]['Response_URL'] !="" ? Request_bids[bid['requestId']]['Response_URL']+Res_status :"";
	xmlHttp.open( "GET", Response_URL, false ); 
	xmlHttp.send();
	});
`

var Track_Win_Nobid string = ` 
		if(WonBid!="" && WonBid!=null){ 
		var Adwon_URL=WonBid['Adwon_URL'] !="" ? WonBid['Adwon_URL'] :"";
		var AdImpression_URL=WonBid['AdImpression_URL'] !="" ? WonBid['AdImpression_URL']+'&won_price='+highestCpmBids[0]['cpm'] :"";
		xmlHttp.open("GET", Adwon_URL, false ); 
		xmlHttp.send();
			xmlHttp.open("GET", AdImpression_URL, false ); 
			xmlHttp.send();
			}`

// Nobids['bids'].forEach(function(bids,key){
// Res_status="&res_count=0";
// var Nobid_Response_Url= bids['Response_URL']!="" ? bids['Response_URL']+Res_status : "";
// xmlHttp.open( "GET", Nobid_Response_Url, false );
// xmlHttp.send();
// });

func GetRTBAd(admaruoutput *structure.AdmaruOutput, adsource structure.AdSourceDetails, RTBresar *ProgramaticRes, wg *sync.WaitGroup, mu *sync.Mutex) {
	defer wg.Done()
	demoparam := AdunitExchange{}
	rtbresponce := RTBResponse{}
	var adtype int
	globalvariables := admaruoutput.Globalvariable

	err := json.Unmarshal([]byte(adsource.Src_Obj), &demoparam)
	if err != nil {
		fmt.Println(err)
	}

	publisherDetails := fetching.GetPublisherDetails(adsource)
	publisherDetails.Biding_CUR = "USD"
	site_obj := SiteObj{}
	site_obj.Id = publisherDetails.Publisher_Id
	// site_obj.Name = publisherDetails.Publisher_Name
	// site_obj.Domain = publisherDetails.Website

	var req interface{}
	switch adsource.Adformat {
	case "Banner":
		adtype = 1
		req = GenerateImageObj(admaruoutput, adsource, demoparam, site_obj, globalvariables, publisherDetails)

	case "Video":
		adtype = 2
		req = GenerateVideoObj(admaruoutput, adsource, demoparam, site_obj, globalvariables, publisherDetails)
	}
	req_json, err := json.Marshal(req)
	if err != nil {
		panic(err)
	}
	fmt.Printf("SSP Request :%+s\n", req_json)
	logger.Log.Printf("adunit_id=%+v\n adsource_id=%+v\n RTBrequest=%+s\n", admaruoutput.Adunit_id, adsource.Adsourceid, req_json)
	request, err := http.NewRequest("POST", config.GetConfig("mainpath", "ssp"), bytes.NewBuffer(req_json))
	request.Header.Set("Content-Type", "application/json")
	client := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
	resp, err := client.Do(request)

	if err != nil {
		panic(err)
	}

	defer resp.Body.Close()

	request_id := adsource.Request_id
	publisher_id := admaruoutput.Adunit_details.Publisher
	adunit_id := admaruoutput.Adunit_details.Adunit_id
	tagid := admaruoutput.Tag_Generation.Tag_id
	tagtempid := admaruoutput.Tag_Generation.Template_id
	provider_id := adsource.Provider
	adsource_id := adsource.Adsourceid
	pro_src_id := adsource.Provider_Src_id

	if resp.Status == "200 OK" {
		/**********Ad Response start**********/

		res_count := "1"

		adresponse1, _ := http.NewRequest("GET", config.GetConfig("protocol", "webpath")+config.GetConfig("delivery", "webpath")+"/Ad_Response?req_id="+request_id+"&publisher_id="+publisher_id+"&adunit_id="+adunit_id+"&provider_id="+provider_id+"&adsource_id="+adsource_id+"&tagid="+tagid+"&tagtempid="+tagtempid+"&pro_src_id="+pro_src_id+"&res_count="+res_count+"", nil)
		clientres1 := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
		clientres1.Do(adresponse1)

		/**********Ad Response end**********/
		body, _ := ioutil.ReadAll(resp.Body)

		fmt.Println("SSP Response", string(body))

		err := json.Unmarshal(body, &rtbresponce)
		if err != nil {
			fmt.Println(err)
		}
		logger.Log.Printf("Adunit_id=%+v\n Adsource_id=%+v\n RTBresponse=%+v\n", admaruoutput.Adunit_id, adsource.Adsourceid, rtbresponce.Ads)
		rtbresponce.Ads.Response.Tracking.Adsource_Id = adsource.Adsourceid
		rtbresponce.Ads.Response.Tracking.Request_Id = adsource.Request_id
		rtbresponce.Ads.Response.Tracking.Provider_Id = adsource.Provider
		rtbresponce.Ads.Response.Tracking.ProviderSrc_Id = adsource.Provider_Src_id
		rtbresponce.Ads.Adtype = adtype
		if len(rtbresponce.Ads.Response.Seatbid) != 0 {
			mu.Lock()
			RTBresar.RTBResArray = append(RTBresar.RTBResArray, rtbresponce)
			mu.Unlock()
		} else {
			// res_count := "0"

			// adresponse1, _ := http.NewRequest("GET", config.GetConfig("protocol", "webpath")+config.GetConfig("delivery", "webpath")+"/Ad_Response?req_id="+request_id+"&publisher_id="+publisher_id+"&adunit_id="+adunit_id+"&provider_id="+provider_id+"&adsource_id="+adsource_id+"&tagid="+tagid+"&tagtempid="+tagtempid+"&pro_src_id="+pro_src_id+"&res_count="+res_count+"", nil)
			// clientres1 := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
			// clientres1.Do(adresponse1)
		}
	} else {

		// /**********Ad Response start**********/

		// res_count := "0"

		// adresponse1, _ := http.NewRequest("GET", config.GetConfig("protocol", "webpath")+config.GetConfig("delivery", "webpath")+"/Ad_Response?req_id="+request_id+"&publisher_id="+publisher_id+"&adunit_id="+adunit_id+"&provider_id="+provider_id+"&adsource_id="+adsource_id+"&tagid="+tagid+"&tagtempid="+tagtempid+"&pro_src_id="+pro_src_id+"&res_count="+res_count+"", nil)
		// clientres1 := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
		// clientres1.Do(adresponse1)

		// /**********Ad Response end**********/

	}
	rtbresponce.Ads.Response.Tracking.Adsource_Id = adsource.Adsourceid
	rtbresponce.Ads.Response.Tracking.Request_Id = adsource.Request_id
	rtbresponce.Ads.Response.Tracking.Provider_Id = adsource.Provider
	rtbresponce.Ads.Response.Tracking.ProviderSrc_Id = adsource.Provider_Src_id

	// RTBresar.RTBResArray = append(RTBresar.RTBResArray, rtbresponce)

}

func GetPrebidBannerAd(admaruoutput *structure.AdmaruOutput, adsource []structure.AdSourceDetails) {
	var size []int
	var AutoRefresh string

	/**********Third Party Tracker Start**********/
	var Impressiondiv string

	var impression1 string
	var impression2 string
	var impression3 string

	var viewimpression1 string
	var viewimpression2 string
	var viewimpression3 string

	var clicks1 string
	var clicks2 string
	var clicks3 string

	Adsource_id := admaruoutput.Adsource_details[0].Adsourceid
	adsoure := fetching.FetchAdsourceTracker(Adsource_id)

	if len(adsoure.Data) > 0 {

		for _, v := range adsoure.Data {

			Event := v.Event
			if Event == "1" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					impimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					impimg = strings.Replace(impimg, `\`, ``, -1)

					impression1 += `<img src='` + impimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					impsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					impsrc2 = strings.Replace(impsrc2, `\`, ``, -1)
					impression2 += strings.Replace(impsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					impsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					impsrc3 = strings.Replace(impsrc3, `\`, ``, -1)
					impression3 += strings.Replace(impsrc3, "  ", " ", -1)
				}
			}

			if Event == "2" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					viewimpimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpimg = strings.Replace(viewimpimg, `\`, ``, -1)

					viewimpression1 += `<img src='` + viewimpimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					viewimpsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpsrc2 = strings.Replace(viewimpsrc2, `\`, ``, -1)
					viewimpression2 += strings.Replace(viewimpsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					viewimpsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpsrc3 = strings.Replace(viewimpsrc3, `\`, ``, -1)
					viewimpression3 += strings.Replace(viewimpsrc3, "  ", " ", -1)
				}
			}

			if Event == "3" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					clicksimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					clicksimg = strings.Replace(clicksimg, `\`, ``, -1)

					clicks1 += `<img src='` + clicksimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					clickssrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clickssrc2 = strings.Replace(clickssrc2, `\`, ``, -1)
					clicks2 += strings.Replace(clickssrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					clickssrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clickssrc3 = strings.Replace(clickssrc3, `\`, ``, -1)
					clicks3 += strings.Replace(clickssrc3, "  ", " ", -1)
				}
			}
		}
	}

	adunit := fetching.FetchAdunitTracker(admaruoutput.Adunit_details.Adunit_id)

	if len(adunit.Data) > 0 {

		for _, val := range adunit.Data {

			Event1 := val.Event

			if Event1 == "1" {

				Trackertype := val.Tracker_type

				if Trackertype == "1" {

					impimgu := strings.Replace(val.Tracker_src, "\n", "", -1)
					impimgu = strings.Replace(impimgu, `\`, ``, -1)

					impression1 += `<img src='` + impimgu + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Trackertype == "2" {

					impsrcu := strings.Replace(val.Tracker_src, "\n", "", -1)
					impsrcu = strings.Replace(impsrcu, `\`, ``, -1)
					impression2 += strings.Replace(impsrcu, "  ", " ", -1)

				} else if Trackertype == "3" {

					impsrcf := strings.Replace(val.Tracker_src, "\n", "", -1)
					impsrcf = strings.Replace(impsrcf, `\`, ``, -1)
					impression3 += strings.Replace(impsrcf, "  ", " ", -1)
				}
			}

			if Event1 == "2" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					viewimpimgi := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpimgi = strings.Replace(viewimpimgi, `\`, ``, -1)

					viewimpression1 += `<img src='` + viewimpimgi + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					viewimpsrc2i := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpsrc2i = strings.Replace(viewimpsrc2i, `\`, ``, -1)
					viewimpression2 += strings.Replace(viewimpsrc2i, "  ", " ", -1)

				} else if Tracker_type == "3" {

					viewimpsrc3i := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpsrc3i = strings.Replace(viewimpsrc3i, `\`, ``, -1)
					viewimpression3 += strings.Replace(viewimpsrc3i, "  ", " ", -1)
				}
			}

			if Event1 == "3" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					clicksimg1 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clicksimg1 = strings.Replace(clicksimg1, `\`, ``, -1)

					clicks1 += `<img src='` + clicksimg1 + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					clickssrcu2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clickssrcu2 = strings.Replace(clickssrcu2, `\`, ``, -1)
					clicks2 += strings.Replace(clickssrcu2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					clickssrcu3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clickssrcu3 = strings.Replace(clickssrcu3, `\`, ``, -1)
					clicks3 += strings.Replace(clickssrcu3, "  ", " ", -1)
				}
			}
		}
	}

	if impression2 != "" {
		impression2 = strings.Replace(impression2, "\n", "", -1)
		impression2 = strings.Replace(impression2, `</script>`, `<\/script>`, -1)
	}
	if impression3 != "" {
		impression3 = strings.Replace(impression3, `</script>`, `<\/script>`, -1)
		impression3 = strings.Replace(impression3, "\n", "", -1)
	}
	rand1 := helper.RandToken(5)
	if admaruoutput.Autorefreshrand != "" {
		rand1 = admaruoutput.Autorefreshrand
	}

	finalimpression := impression1 + impression2 + impression3

	if impression1 != "" || impression2 != "" || impression3 != "" {

		Impressiondiv = `<div id='track_` + rand1 + `'>` + finalimpression + `</div>`
	}
	var Clickdiv string
	if clicks1 != "" || clicks2 != "" || clicks3 != "" {

		if clicks2 != "" {
			clicks2 = strings.Replace(clicks2, "\n", "", -1)
			clicks2 = strings.Replace(clicks2, `</script>`, `<\/script>`, -1)
		}
		if clicks3 != "" {
			clicks3 = strings.Replace(clicks3, `</script>`, `<\/script>`, -1)
			clicks3 = strings.Replace(clicks3, "\n", "", -1)
		}

		Clickdiv = `<div id='clk_` + rand1 + `'></div>`
	}

	var viewbleStart string
	var viewbleEnd string
	var viewbleDiv string
	var innerHTML string

	if viewimpression1 != "" || viewimpression2 != "" || viewimpression3 != "" {

		if viewimpression2 != "" {
			viewimpression2 = strings.Replace(viewimpression2, "\n", "", -1)
			viewimpression2 = strings.Replace(viewimpression2, `</script>`, `<\/script>`, -1)
		}
		if viewimpression3 != "" {
			viewimpression3 = strings.Replace(viewimpression3, `</script>`, `<\/script>`, -1)
			viewimpression3 = strings.Replace(viewimpression3, "\n", "", -1)
		}

		viewbleDiv = `<div id='viewble_` + rand1 + `'></div>`

		innerHTML = `document.getElementById("viewble_` + rand1 + `").innerHTML = "` + viewimpression1 + viewimpression2 + viewimpression3 + `";`
	}

	Height := admaruoutput.Banner_Template.Height

	var percent string
	if Height < 1000 {
		percent = "75"
	} else {
		percent = "30"
	}

	viewbleStart = `<div id='test-ad` + rand1 + `'>`
	viewbleEnd = `</div>`

	/**********Third Party Tracker End**********/

	var BidderArray []string
	Biddderjsonmap := make(map[string]interface{})
	// Biddername := make(map[string]string)
	Biddermap := make(map[string]interface{})
	size = append(size, admaruoutput.Adunit_details.Width, admaruoutput.Adunit_details.Height)
	fmt.Println("Prebid Banner Size :", helper.ArrayOfInttoString(size, ","))
	for _, v := range adsource {
		err := json.Unmarshal([]byte(v.Src_Obj), &Biddermap)
		if err != nil {
			fmt.Println(err)
		}

		PrebidTracking(Biddermap, admaruoutput, v)

		Bidderjson, err := json.Marshal(Biddermap)
		if err != nil {
			panic(err)
		}

		// BidderArray = nil
		BidderArray = append(BidderArray, string(Bidderjson))

	}

	BiddermapJson, err := json.Marshal(BidderArray)
	if err != nil {
		panic(err)
	}

	// fmt.Printf("BidderArrayjson NAME :%+v\n", strings.ReplaceAll(string(BidderArrayjson), "\\", ""))

	if admaruoutput.Adunit_type != "PrebidPriority" {
		Biddderjsonmap["Addelivery_Tag"] = "no"
	}
	fmt.Println("admaruoutput.MultiAdFormat :", admaruoutput.MultiAdFormat)
	if admaruoutput.MultiAdFormat == true {
		Biddderjsonmap["MarketPlace"] = "yes"
	} else {
		Biddderjsonmap["MarketPlace"] = "no"
	}
	Biddderjsonmap["Bidder_Details"] = string(BiddermapJson)
	fmt.Printf("Bidderjson :%+v\n", string(BiddermapJson))
	fmt.Println("Biddderjsonmap :", Biddderjsonmap)

	Biddderjsonmapp, err := json.Marshal(Biddderjsonmap)
	if err != nil {
		panic(err)
	}

	// document.write(xmlHttp.responseText);

	tagid := "Prebid_" + fmt.Sprint(helper.RandNumber(5))

	bidderdetails := strings.ReplaceAll(string(BiddermapJson), "\\", "")
	bidderdetailsmk := strings.ReplaceAll(string(bidderdetails), "u0026", "&")
	filtered := strings.ReplaceAll(string(bidderdetailsmk), `"{`, "{")
	filtered1 := strings.ReplaceAll(string(filtered), `}"`, "}")

	fmt.Printf("Biddds :%+v\n", filtered1)

	//varcount := "_" + fmt.Sprint(helper.RandNumber(2))

	/**********Auto Refresh Start**********/

	//Tagsettings1 := structure.Tagsettings{}
	Template_id := admaruoutput.Tag_id
	// TagTemplates := fetching.FetchTagModel(Template_id)
	// Templateid := TagTemplates.Template_id
	Templates := admaruoutput.Temp_Generation
	// admaruoutput.Temp_Generation = Templates
	// admaruoutput.AdDelivery_Type = admaruoutput.Temp_Generation.Template_type
	AutoRefresh = `<script type='text/javascript'>
			var i` + rand1 + ` = 0;
			</script>`

	if Templates.Settings != "" {

		err1 := json.Unmarshal([]byte(Templates.Settings), &admaruoutput.Banner_Template)
		if err1 != nil {
			fmt.Println("end")
		}

		//banner size
		Height, Width := fetching.FetchBannerSize(admaruoutput.Banner_Template.Size)
		admaruoutput.Banner_Template.Height = Height
		admaruoutput.Banner_Template.Width = Width
		fmt.Printf(" Temps.Height : %+v\n", admaruoutput.Banner_Template.Height)
		fmt.Printf(" Temps.Width : %+v\n", admaruoutput.Banner_Template.Width)

		// Enabled := Tagsettings1.Refresh.Enabled
		// MaxImp := Tagsettings1.Refresh.MaxImp
		// Rate := Tagsettings1.Refresh.Rate

		Enabled := admaruoutput.Banner_Template.Refresh.Enabled
		MaxImp := admaruoutput.Banner_Template.Refresh.MaxImp
		Rate := admaruoutput.Banner_Template.Refresh.Rate

		RateVal := helper.StringToInt(Rate)
		checkMax := helper.StringToInt(MaxImp)

		if Enabled == true && RateVal != 0 && checkMax != 0 {

			finalVal := RateVal * 1000
			Refresh_Interval := helper.IntToString(finalVal)

			fmt.Println(Refresh_Interval)

			AutoRefresh = `<script type='text/javascript'>
			var i` + rand1 + ` = 0;
				if(localStorage.getItem('TEMPTAG_` + Template_id + rand1 + `')== null){
					localStorage.setItem('TEMPTAG_` + Template_id + rand1 + `','` + rand1 + "_" + MaxImp + `');
				}
				var Imp_details` + rand1 + `=localStorage.getItem('TEMPTAG_` + Template_id + rand1 + `');
				var Imp_array` + rand1 + `=Imp_details` + rand1 + `.split("_");console.log(Imp_array` + rand1 + `);
				var Remainig_Imp` + rand1 + `=Imp_array` + rand1 + `[1]; 
				var Randnum` + rand1 + `=Imp_array` + rand1 + `[0];
				var Interval` + rand1 + `=setInterval(function() { autoRefresh` + rand1 + `('` + Template_id + `','` + rand1 + `'); },` + Refresh_Interval + `);
				function autoRefresh` + rand1 + `(tag_id,rand) {
					console.log("tag_id : "+tag_id);
					console.log("rand : "+rand);
					console.log("Remainig_Imp : "+Remainig_Imp` + rand1 + `);

					var Ad_Div=document.getElementById('test-ad'+rand);
					var Tracker_Div=document.getElementById('track_'+rand);
					console.log("Ad_Div : "+Ad_Div);
					console.log("Tracker_Div : "+Tracker_Div);
					if(Ad_Div!="" && Ad_Div!=null){
						Ad_Div.outerHTML="";
					}
					if(Tracker_Div!="" && Tracker_Div!=null){
						Tracker_Div.outerHTML="";
					}
					Imp_details` + rand1 + `=localStorage.getItem('TEMPTAG_'+tag_id+rand);
					Imp_array` + rand1 + `=Imp_details` + rand1 + `.split("_");
					Remainig_Imp` + rand1 + `=Imp_array` + rand1 + `[1];  
					Randnum=Imp_array` + rand1 + `[0];
					if (Remainig_Imp` + rand1 + ` !== null){
						if (Remainig_Imp` + rand1 + ` > 1)
						{	
							Remainig_Imp` + rand1 + `--;
							localStorage.setItem('TEMPTAG_'+tag_id+rand,rand+"_"+Remainig_Imp` + rand1 + `);
							Prebid_Initialize(Bidders_Info,Priority_level,tag_id);
							if(Remainig_Imp` + rand1 + `-1==0){
								Remainig_Imp` + rand1 + `--;
								localStorage.removeItem('TEMPTAG_'+tag_id+rand);
								clearInterval(Interval` + rand1 + `);
								setTimeout(Interval` + rand1 + `);
							}
						}else{
							Remainig_Imp` + rand1 + `--;
							localStorage.removeItem('TEMPTAG_'+tag_id+rand);
							clearInterval(Interval` + rand1 + `);
							setTimeout(Interval` + rand1 + `);
						}
					}else{
						Prebid_Initialize(Bidders_Info,Priority_level,tag_id);
						localStorage.setItem('TEMPTAG_'+tag_id+rand,rand+"_"+Remainig_Imp` + rand1 + `);
					}
				}
				</script>`
		}
	}

	/**********Auto Refresh End**********/

	switch {
	case admaruoutput.Adunit_type == "PrebidPriority":
		fmt.Println("hi...................")
		admaruoutput.Html = helper.ConvertStrJsonToRawJson(Biddderjsonmapp)
		admaruoutput.External_ad = true
	case admaruoutput.Adunit_type == "async":
		admaruoutput.External_ad = true

		admaruoutput.Html = `<script type="text/javascript" src="https://app.admaru.com/AdmaruAdDelivery/AdmaruJs/viewability.js"></script>
<script async src="//app.admaru.com/AdmaruAdDelivery/AdmaruJs/Admaru.js"></script>
<script type="text/javascript" >
var Bids=[` + helper.ConvertStrJsonToRawJson(Biddderjsonmapp) + `];console.log("Bids : ");console.log(Bids);
		var Bidders_Info=Bids[0];
		var Priority_level=Bids[0]['Bidder_Details'][0]['priority'];
		var tag_id=Bids[0]['Bidder_Details'][0]['tag_id'];
		console.log("Bidders_Info : ");
		console.log(Bidders_Info["MarketPlace"]);
		var Multi_Ad=Bidders_Info["MarketPlace"];
		var pbjs = pbjs || {};  var Request_bids ={}; var Res_status="&res_count=0"; 
		var Bidder_Response={}; pbjs.que = pbjs.que || []; var count=0; 
			if(Bidders_Info!='' && Bidders_Info['addelivery_tag']=="yes"){ 
			document.write(Bidders_Info['tag']);
		}else{
			Prebid_Initialize(Bidders_Info,Priority_level,tag_id);
		}
	function Prebid_Initialize(Bidders_Info,Priority_level,tag_id){ 
	var sizes =  [[` + helper.ArrayOfInttoString(size, ",") + `]];
var PREBID_TIMEOUT = 8000;

var xmlHttp = new XMLHttpRequest();
pbjs.que.push(function() {
	var adUnits = [{
		code: '` + tagid + `',
		mediaTypes: {
				banner: {
					sizes: sizes
				}
			},
			floors: {
				currency: 'USD',
				skipRate: 5,
				modelVersion: 'Sports Ad Unit Floors',
				schema: {
					fields: [ 'mediaType']
				},
				values: {
					'banner': Bidders_Info['Bidder_Details'][0]['floorprice'] 
				}
			},
			 bids: Bidders_Info['Bidder_Details']
	}];console.log("adUnits : ");
	console.log(adUnits);
	pbjs.removeAdUnit(adUnits);
pbjs.addAdUnits(adUnits);
pbjs.setConfig({ useBidCache: false });
pbjs.requestBids({ 
timeout: PREBID_TIMEOUT,
bidsBackHandler: function(bids) {  console.log("bidsBackHandler"); console.log(bids);

var highestCpmBids = pbjs.getHighestCpmBids('` + tagid + `'); 
console.log("highestCpmBids :");
console.log(highestCpmBids);
if(highestCpmBids=="" && Multi_Ad=="no"){ 
	var m3_u = '` + config.GetConfig("commonpath", "file") + `Prebidwithpriority?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&priority='+Bidders_Info['Bidder_Details'][0]['priority']+'&loc=` + admaruoutput.CORSDomain + `';
	xmlHttp.open( "GET", m3_u, false ); 
xmlHttp.send();
console.log("HTTP Response : ");console.log(xmlHttp.responseText);
var Response=JSON.parse(xmlHttp.responseText);
if(Response['addelivery_tag']=="yes" && Response['tag']!=""){ 
	console.log("Response['tag'] : ");console.log(Response['tag']);
	Response['tag']=atob(Response['tag']);
	document.write(Response['tag']);
}else{ 
	Prebid_Initialize(Response,Response.Bidder_Details.Priority_level,Response.Bidder_Details.tag_id);
}
}else{
	console.log("Request_bids :");
console.log(Request_bids);
	if(Multi_Ad=="yes"){ 
		var highestCPM= highestCpmBids!="" ? highestCpmBids[0]['cpm'] : "";
		var m3_u = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&highestBidCpm='+highestCPM+'&Is_MultiAd='+Multi_Ad+'&loc=` + admaruoutput.CORSDomain + `';
		xmlHttp.open( "GET", m3_u, false ); 
	xmlHttp.send();
	var MultiRes=JSON.parse(xmlHttp.responseText);
	if(MultiRes['multiAd_Tag']=="Yes"){
		MultiRes["tag"]=atob(MultiRes["tag"]);
		document.write(MultiRes["tag"]);
	 }else{  
	let WonBid = Request_bids[highestCpmBids[0]['requestId']] != "" ? Request_bids[highestCpmBids[0]['requestId']] : "";
	console.log("WonBid");
	console.log(WonBid);
	var AdClick_URL=WonBid['AdClick_URL'] !="" ? WonBid['AdClick_URL'] :"";
	var AdViewImpression_URL=WonBid['AdViewImpression_URL'] !="" ? WonBid['AdViewImpression_URL'] :"";
	var Nobids=pbjs.getNoBidsForAdUnitCode('` + tagid + `');
	` + Track_Win_Nobid + `
	document.write("` + viewbleStart + `<div id='` + tagid + `' class='adShow'>"+highestCpmBids[0].ad+"</div>` + Clickdiv + viewbleDiv + viewbleEnd + `");
	var ad_elem` + rand1 + ` = document.getElementById("test-ad` + rand1 + `");
	var ViewableImp = AdViewImpression_URL;	   
	var percent = ` + percent + `;
	oav` + rand1 + ` = new OpenAdViewability();
	oav` + rand1 + `.DEBUG_MODE = true;
	var i` + rand1 + ` = 0;
	oav` + rand1 + `.checkViewability(ad_elem` + rand1 + `, function(check) {
	if(check.percentViewable >=percent){
	if(i` + rand1 + `==0){
	` + innerHTML + `	            	
	var xhttp = new XMLHttpRequest();
	xhttp.open("GET", ViewableImp, true);	            	
	xhttp.send();	            	
	i` + rand1 + `++;		
	}
	}
	});
	document.write("` + Impressiondiv + `");
	document.getElementById('` + tagid + `').onclick = function() { 
	document.getElementById("clk_` + rand1 + `").innerHTML = "` + clicks1 + clicks2 + clicks3 + `"; 
	xmlHttp.open("GET", AdClick_URL, false ); 
	xmlHttp.send();
	}
	}
	}else{
	console.log("new highestCpmBids");
	console.log(highestCpmBids);
let WonBid = Request_bids[highestCpmBids[0]['requestId']] != "" ? Request_bids[highestCpmBids[0]['requestId']] : "";
console.log("WonBid");
console.log(WonBid);
var AdClick_URL=WonBid['AdClick_URL'] !="" ? WonBid['AdClick_URL'] :"";
var AdViewImpression_URL=WonBid['AdViewImpression_URL'] !="" ? WonBid['AdViewImpression_URL'] :"";
var Nobids=pbjs.getNoBidsForAdUnitCode('` + tagid + `');
` + Track_Win_Nobid + `
document.write("` + viewbleStart + `<div id='` + tagid + `' class='adShow'>"+highestCpmBids[0].ad+"</div>` + Clickdiv + viewbleDiv + viewbleEnd + `");
var ad_elem` + rand1 + ` = document.getElementById("test-ad` + rand1 + `");
var ViewableImp = AdViewImpression_URL;	   
var percent = ` + percent + `;
oav` + rand1 + ` = new OpenAdViewability();
oav` + rand1 + `.DEBUG_MODE = true;
var i` + rand1 + ` = 0;
oav` + rand1 + `.checkViewability(ad_elem` + rand1 + `, function(check) {
if(check.percentViewable >=percent){
if(i` + rand1 + `==0){
` + innerHTML + `	            	
var xhttp = new XMLHttpRequest();
xhttp.open("GET", ViewableImp, true);	            	
xhttp.send();	            	
i` + rand1 + `++;		
}
}
});
document.write("` + Impressiondiv + `");
document.getElementById('` + tagid + `').onclick = function() { 
document.getElementById("clk_` + rand1 + `").innerHTML = "` + clicks1 + clicks2 + clicks3 + `"; 
xmlHttp.open("GET", AdClick_URL, false ); 
xmlHttp.send();
}
}
}
}
}); ` + Track_Req_Res + `
});
}
</script>` + AutoRefresh
	}
	fmt.Println(AutoRefresh)
}

func GetPrebidVideoAd(admaruoutput *structure.AdmaruOutput, adsource []structure.AdSourceDetails) {

	/**********Third Party Tracker Start**********/

	rand := helper.RandToken(5)

	var first1 string
	var first2 string
	var first3 string

	var mid1 string
	var mid2 string
	var mid3 string

	var third1 string
	var third2 string
	var third3 string

	var start1 string
	var start2 string
	var start3 string
 
	var mute1 string
	var mute2 string
	var mute3 string

	var unmute1 string
	var unmute2 string
	var unmute3 string

	var pause1 string
	var pause2 string
	var pause3 string

	var resume1 string
	var resume2 string
	var resume3 string

	var complete1 string
	var complete2 string
	var complete3 string

	var close1 string
	var close2 string
	var close3 string

	var impression1 string
	var impression2 string
	var impression3 string

	var viewimpression1 string
	var viewimpression2 string
	var viewimpression3 string

	var clicks1 string
	var clicks2 string
	var clicks3 string

	Adsource_id := admaruoutput.Adsource_details[0].Adsourceid

	adsoure := fetching.FetchAdsourceTracker(Adsource_id)

	if len(adsoure.Data) > 0 {

		for _, v := range adsoure.Data {

			Event := v.Event

			if Event == "1" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					firstimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					firstimg = strings.Replace(firstimg, `\`, ``, -1)

					first1 += `<img src='` + firstimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					firstsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					firstsrc2 = strings.Replace(firstsrc2, `\`, ``, -1)
					first2 += strings.Replace(firstsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					firstsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					firstsrc3 = strings.Replace(firstsrc3, `\`, ``, -1)
					first3 += strings.Replace(firstsrc3, "  ", " ", -1)
				}
			}

			if Event == "2" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					midimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					midimg = strings.Replace(midimg, `\`, ``, -1)

					mid1 += `<img src='` + midimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					midsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					midsrc2 = strings.Replace(midsrc2, `\`, ``, -1)
					mid2 += strings.Replace(midsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					midsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					midsrc3 = strings.Replace(midsrc3, `\`, ``, -1)
					mid3 += strings.Replace(midsrc3, "  ", " ", -1)
				}
			}

			if Event == "3" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					thirdimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					thirdimg = strings.Replace(thirdimg, `\`, ``, -1)

					third1 += `<img src='` + thirdimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					thirdsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					thirdsrc2 = strings.Replace(thirdsrc2, `\`, ``, -1)
					third2 += strings.Replace(thirdsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					thirdsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					thirdsrc3 = strings.Replace(thirdsrc3, `\`, ``, -1)
					third3 += strings.Replace(thirdsrc3, "  ", " ", -1)
				}
			}

			if Event == "5" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					startimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					startimg = strings.Replace(startimg, `\`, ``, -1)

					start1 += `<img src='` + startimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					startsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					startsrc2 = strings.Replace(startsrc2, `\`, ``, -1)
					start2 += strings.Replace(startsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					startsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					startsrc3 = strings.Replace(startsrc3, `\`, ``, -1)
					start3 += strings.Replace(startsrc3, "  ", " ", -1)
				}
			}

			if Event == "6" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					muteimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					muteimg = strings.Replace(muteimg, `\`, ``, -1)

					mute1 += `<img src='` + muteimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					mutesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					mutesrc2 = strings.Replace(mutesrc2, `\`, ``, -1)
					mute2 += strings.Replace(mutesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					mutesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					mutesrc3 = strings.Replace(mutesrc3, `\`, ``, -1)
					mute3 += strings.Replace(mutesrc3, "  ", " ", -1)
				}
			}

			if Event == "7" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					unmuteimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					unmuteimg = strings.Replace(unmuteimg, `\`, ``, -1)

					unmute1 += `<img src='` + unmuteimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					unmutesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					unmutesrc2 = strings.Replace(unmutesrc2, `\`, ``, -1)
					unmute2 += strings.Replace(unmutesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					unmutesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					unmutesrc3 = strings.Replace(unmutesrc3, `\`, ``, -1)
					unmute3 += strings.Replace(unmutesrc3, "  ", " ", -1)
				}
			}

			if Event == "8" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					pauseimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					pauseimg = strings.Replace(pauseimg, `\`, ``, -1)

					pause1 += `<img src='` + pauseimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					pausesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					pausesrc2 = strings.Replace(pausesrc2, `\`, ``, -1)
					pause2 += strings.Replace(pausesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					pausesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					pausesrc3 = strings.Replace(pausesrc3, `\`, ``, -1)
					pause3 += strings.Replace(pausesrc3, "  ", " ", -1)
				}
			}

			if Event == "9" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					resumeimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					resumeimg = strings.Replace(resumeimg, `\`, ``, -1)

					resume1 += `<img src='` + resumeimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					resumesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					resumesrc2 = strings.Replace(resumesrc2, `\`, ``, -1)
					resume2 += strings.Replace(resumesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					resumesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					resumesrc3 = strings.Replace(resumesrc3, `\`, ``, -1)
					resume3 += strings.Replace(resumesrc3, "  ", " ", -1)
				}
			}

			if Event == "13" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					closeimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					closeimg = strings.Replace(closeimg, `\`, ``, -1)

					close1 += `<img src='` + closeimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					closesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					closesrc2 = strings.Replace(closesrc2, `\`, ``, -1)
					close2 += strings.Replace(closesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					closesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					closesrc3 = strings.Replace(closesrc3, `\`, ``, -1)
					close3 += strings.Replace(closesrc3, "  ", " ", -1)
				}
			}

			if Event == "4" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					completeimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					completeimg = strings.Replace(completeimg, `\`, ``, -1)

					complete1 += `<img src='` + completeimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					completesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					completesrc2 = strings.Replace(completesrc2, `\`, ``, -1)
					complete2 += strings.Replace(completesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					completesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					completesrc3 = strings.Replace(completesrc3, `\`, ``, -1)
					complete3 += strings.Replace(completesrc3, "  ", " ", -1)
				}
			}

			if Event == "10" {

				Trackertype := v.Tracker_type

				if Trackertype == "1" {

					impimgu := strings.Replace(v.Tracker_src, "\n", "", -1)
					impimgu = strings.Replace(impimgu, `\`, ``, -1)

					impression1 += `<img src='` + impimgu + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Trackertype == "2" {

					impsrcu := strings.Replace(v.Tracker_src, "\n", "", -1)
					impsrcu = strings.Replace(impsrcu, `\`, ``, -1)
					impression2 += strings.Replace(impsrcu, "  ", " ", -1)

				} else if Trackertype == "3" {

					impsrcf := strings.Replace(v.Tracker_src, "\n", "", -1)
					impsrcf = strings.Replace(impsrcf, `\`, ``, -1)
					impression3 += strings.Replace(impsrcf, "  ", " ", -1)
				}
			}

			if Event == "11" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					viewimpimgi := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpimgi = strings.Replace(viewimpimgi, `\`, ``, -1)

					viewimpression1 += `<img src='` + viewimpimgi + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					viewimpsrc2i := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpsrc2i = strings.Replace(viewimpsrc2i, `\`, ``, -1)
					viewimpression2 += strings.Replace(viewimpsrc2i, "  ", " ", -1)

				} else if Tracker_type == "3" {

					viewimpsrc3i := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpsrc3i = strings.Replace(viewimpsrc3i, `\`, ``, -1)
					viewimpression3 += strings.Replace(viewimpsrc3i, "  ", " ", -1)
				}
			}

			if Event == "12" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					clicksimg1 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clicksimg1 = strings.Replace(clicksimg1, `\`, ``, -1)

					clicks1 += `<img src='` + clicksimg1 + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					clickssrcu2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clickssrcu2 = strings.Replace(clickssrcu2, `\`, ``, -1)
					clicks2 += strings.Replace(clickssrcu2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					clickssrcu3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clickssrcu3 = strings.Replace(clickssrcu3, `\`, ``, -1)
					clicks3 += strings.Replace(clickssrcu3, "  ", " ", -1)
				}
			}
		}
	}

	adunit := fetching.FetchAdunitTracker(admaruoutput.Adunit_details.Adunit_id)

	if len(adunit.Data) > 0 {

		for _, val := range adunit.Data {

			Event1 := val.Event

			if Event1 == "1" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					firstimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					firstimg = strings.Replace(firstimg, `\`, ``, -1)

					first1 += `<img src='` + firstimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					firstsrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					firstsrc2 = strings.Replace(firstsrc2, `\`, ``, -1)
					first2 += strings.Replace(firstsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					firstsrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					firstsrc3 = strings.Replace(firstsrc3, `\`, ``, -1)
					first3 += strings.Replace(firstsrc3, "  ", " ", -1)
				}
			}

			if Event1 == "2" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					midimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					midimg = strings.Replace(midimg, `\`, ``, -1)

					mid1 += `<img src='` + midimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					midsrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					midsrc2 = strings.Replace(midsrc2, `\`, ``, -1)
					mid2 += strings.Replace(midsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					midsrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					midsrc3 = strings.Replace(midsrc3, `\`, ``, -1)
					mid3 += strings.Replace(midsrc3, "  ", " ", -1)
				}
			}

			if Event1 == "3" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					thirdimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					thirdimg = strings.Replace(thirdimg, `\`, ``, -1)

					third1 += `<img src='` + thirdimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					thirdsrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					thirdsrc2 = strings.Replace(thirdsrc2, `\`, ``, -1)
					third2 += strings.Replace(thirdsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					thirdsrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					thirdsrc3 = strings.Replace(thirdsrc3, `\`, ``, -1)
					third3 += strings.Replace(thirdsrc3, "  ", " ", -1)
				}
			}

			if Event1 == "5" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					startimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					startimg = strings.Replace(startimg, `\`, ``, -1)

					start1 += `<img src='` + startimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					startsrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					startsrc2 = strings.Replace(startsrc2, `\`, ``, -1)
					start2 += strings.Replace(startsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					startsrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					startsrc3 = strings.Replace(startsrc3, `\`, ``, -1)
					start3 += strings.Replace(startsrc3, "  ", " ", -1)
				}
			}

			if Event1 == "6" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					muteimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					muteimg = strings.Replace(muteimg, `\`, ``, -1)

					mute1 += `<img src='` + muteimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					mutesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					mutesrc2 = strings.Replace(mutesrc2, `\`, ``, -1)
					mute2 += strings.Replace(mutesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					mutesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					mutesrc3 = strings.Replace(mutesrc3, `\`, ``, -1)
					mute3 += strings.Replace(mutesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "7" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					unmuteimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					unmuteimg = strings.Replace(unmuteimg, `\`, ``, -1)

					unmute1 += `<img src='` + unmuteimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					unmutesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					unmutesrc2 = strings.Replace(unmutesrc2, `\`, ``, -1)
					unmute2 += strings.Replace(unmutesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					unmutesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					unmutesrc3 = strings.Replace(unmutesrc3, `\`, ``, -1)
					unmute3 += strings.Replace(unmutesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "8" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					pauseimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					pauseimg = strings.Replace(pauseimg, `\`, ``, -1)

					pause1 += `<img src='` + pauseimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					pausesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					pausesrc2 = strings.Replace(pausesrc2, `\`, ``, -1)
					pause2 += strings.Replace(pausesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					pausesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					pausesrc3 = strings.Replace(pausesrc3, `\`, ``, -1)
					pause3 += strings.Replace(pausesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "9" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					resumeimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					resumeimg = strings.Replace(resumeimg, `\`, ``, -1)

					resume1 += `<img src='` + resumeimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					resumesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					resumesrc2 = strings.Replace(resumesrc2, `\`, ``, -1)
					resume2 += strings.Replace(resumesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					resumesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					resumesrc3 = strings.Replace(resumesrc3, `\`, ``, -1)
					resume3 += strings.Replace(resumesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "13" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					closeimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					closeimg = strings.Replace(closeimg, `\`, ``, -1)

					close1 += `<img src='` + closeimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					closesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					closesrc2 = strings.Replace(closesrc2, `\`, ``, -1)
					close2 += strings.Replace(closesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					closesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					closesrc3 = strings.Replace(closesrc3, `\`, ``, -1)
					close3 += strings.Replace(closesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "4" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					completeimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					completeimg = strings.Replace(completeimg, `\`, ``, -1)

					complete1 += `<img src='` + completeimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					completesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					completesrc2 = strings.Replace(completesrc2, `\`, ``, -1)
					complete2 += strings.Replace(completesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					completesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					completesrc3 = strings.Replace(completesrc3, `\`, ``, -1)
					complete3 += strings.Replace(completesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "10" {

				Trackertype := val.Tracker_type

				if Trackertype == "1" {

					impimgu := strings.Replace(val.Tracker_src, "\n", "", -1)
					impimgu = strings.Replace(impimgu, `\`, ``, -1)

					impression1 += `<img src='` + impimgu + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Trackertype == "2" {

					impsrcu := strings.Replace(val.Tracker_src, "\n", "", -1)
					impsrcu = strings.Replace(impsrcu, `\`, ``, -1)
					impression2 += strings.Replace(impsrcu, "  ", " ", -1)

				} else if Trackertype == "3" {

					impsrcf := strings.Replace(val.Tracker_src, "\n", "", -1)
					impsrcf = strings.Replace(impsrcf, `\`, ``, -1)
					impression3 += strings.Replace(impsrcf, "  ", " ", -1)
				}
			}

			if Event1 == "11" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					viewimpimgi := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpimgi = strings.Replace(viewimpimgi, `\`, ``, -1)

					viewimpression1 += `<img src='` + viewimpimgi + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					viewimpsrc2i := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpsrc2i = strings.Replace(viewimpsrc2i, `\`, ``, -1)
					viewimpression2 += strings.Replace(viewimpsrc2i, "  ", " ", -1)

				} else if Tracker_type == "3" {

					viewimpsrc3i := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpsrc3i = strings.Replace(viewimpsrc3i, `\`, ``, -1)
					viewimpression3 += strings.Replace(viewimpsrc3i, "  ", " ", -1)
				}
			}

			if Event1 == "12" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					clicksimg1 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clicksimg1 = strings.Replace(clicksimg1, `\`, ``, -1)

					clicks1 += `<img src='` + clicksimg1 + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					clickssrcu2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clickssrcu2 = strings.Replace(clickssrcu2, `\`, ``, -1)
					clicks2 += strings.Replace(clickssrcu2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					clickssrcu3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clickssrcu3 = strings.Replace(clickssrcu3, `\`, ``, -1)
					clicks3 += strings.Replace(clickssrcu3, "  ", " ", -1)
				}
			}
		}
	}

	if impression1 != "" || impression2 != "" || impression3 != "" {

		if impression2 != "" {
			impression2 = strings.Replace(impression2, "\n", "", -1)
			impression2 = strings.Replace(impression2, `</script>`, `<\/script>`, -1)
		}
		if impression3 != "" {
			impression3 = strings.Replace(impression3, `</script>`, `<\/script>`, -1)
			impression3 = strings.Replace(impression3, "\n", "", -1)
		}
	}
	if clicks1 != "" || clicks2 != "" || clicks3 != "" {

		if clicks2 != "" {
			clicks2 = strings.Replace(clicks2, "\n", "", -1)
			clicks2 = strings.Replace(clicks2, `</script>`, `<\/script>`, -1)
		}
		if clicks3 != "" {
			clicks3 = strings.Replace(clicks3, `</script>`, `<\/script>`, -1)
			clicks3 = strings.Replace(clicks3, "\n", "", -1)
		}
	}
	if viewimpression1 != "" || viewimpression2 != "" || viewimpression3 != "" {

		if viewimpression2 != "" {
			viewimpression2 = strings.Replace(viewimpression2, "\n", "", -1)
			viewimpression2 = strings.Replace(viewimpression2, `</script>`, `<\/script>`, -1)
		}
		if viewimpression3 != "" {
			viewimpression3 = strings.Replace(viewimpression3, `</script>`, `<\/script>`, -1)
			viewimpression3 = strings.Replace(viewimpression3, "\n", "", -1)
		}
	}

	if first1 != "" || first2 != "" || first3 != "" {

		if first2 != "" {
			first2 = strings.Replace(first2, "\n", "", -1)
			first2 = strings.Replace(first2, `</script>`, `<\/script>`, -1)
		}
		if first3 != "" {
			first3 = strings.Replace(first3, `</script>`, `<\/script>`, -1)
			first3 = strings.Replace(first3, "\n", "", -1)
		}
	}
	if mid1 != "" || mid2 != "" || mid3 != "" {

		if mid2 != "" {
			mid2 = strings.Replace(mid2, "\n", "", -1)
			mid2 = strings.Replace(mid2, `</script>`, `<\/script>`, -1)
		}
		if mid3 != "" {
			mid3 = strings.Replace(mid3, `</script>`, `<\/script>`, -1)
			mid3 = strings.Replace(mid3, "\n", "", -1)
		}
	}
	if third1 != "" || third2 != "" || third3 != "" {

		if third2 != "" {
			third2 = strings.Replace(third2, "\n", "", -1)
			third2 = strings.Replace(third2, `</script>`, `<\/script>`, -1)
		}
		if third3 != "" {
			third3 = strings.Replace(third3, `</script>`, `<\/script>`, -1)
			third3 = strings.Replace(third3, "\n", "", -1)
		}
	}

	if start1 != "" || start2 != "" || start3 != "" {

		if start2 != "" {
			start2 = strings.Replace(start2, "\n", "", -1)
			start2 = strings.Replace(start2, `</script>`, `<\/script>`, -1)
		}
		if start3 != "" {
			start3 = strings.Replace(start3, `</script>`, `<\/script>`, -1)
			start3 = strings.Replace(start3, "\n", "", -1)
		}
	}
	if mute1 != "" || mute2 != "" || mute3 != "" {

		if mute2 != "" {
			mute2 = strings.Replace(mute2, "\n", "", -1)
			mute2 = strings.Replace(mute2, `</script>`, `<\/script>`, -1)
		}
		if mute3 != "" {
			mute3 = strings.Replace(mute3, `</script>`, `<\/script>`, -1)
			mute3 = strings.Replace(mute3, "\n", "", -1)
		}
	}
	if unmute1 != "" || unmute2 != "" || unmute3 != "" {

		if unmute2 != "" {
			unmute2 = strings.Replace(unmute2, "\n", "", -1)
			unmute2 = strings.Replace(unmute2, `</script>`, `<\/script>`, -1)
		}
		if unmute3 != "" {
			unmute3 = strings.Replace(unmute3, `</script>`, `<\/script>`, -1)
			unmute3 = strings.Replace(unmute3, "\n", "", -1)
		}
	}

	if pause1 != "" || pause2 != "" || pause3 != "" {

		if pause2 != "" {
			pause2 = strings.Replace(pause2, "\n", "", -1)
			pause2 = strings.Replace(pause2, `</script>`, `<\/script>`, -1)
		}
		if pause3 != "" {
			pause3 = strings.Replace(pause3, `</script>`, `<\/script>`, -1)
			pause3 = strings.Replace(pause3, "\n", "", -1)
		}
	}
	if complete1 != "" || complete2 != "" || complete3 != "" {

		if complete2 != "" {
			complete2 = strings.Replace(complete2, "\n", "", -1)
			complete2 = strings.Replace(complete2, `</script>`, `<\/script>`, -1)
		}
		if complete3 != "" {
			complete3 = strings.Replace(complete3, `</script>`, `<\/script>`, -1)
			complete3 = strings.Replace(complete3, "\n", "", -1)
		}
	}

	if resume1 != "" || resume2 != "" || resume3 != "" {

		if resume2 != "" {
			resume2 = strings.Replace(resume2, "\n", "", -1)
			resume2 = strings.Replace(resume2, `</script>`, `<\/script>`, -1)
		}
		if resume3 != "" {
			resume3 = strings.Replace(resume3, `</script>`, `<\/script>`, -1)
			resume3 = strings.Replace(resume3, "\n", "", -1)
		}
	}
	if close1 != "" || close2 != "" || close3 != "" {

		if close2 != "" {
			close2 = strings.Replace(close2, "\n", "", -1)
			close2 = strings.Replace(close2, `</script>`, `<\/script>`, -1)
		}
		if close3 != "" {
			close3 = strings.Replace(close3, `</script>`, `<\/script>`, -1)
			close3 = strings.Replace(close3, "\n", "", -1)
		}
	}

	finalimpression := impression1 + impression2 + impression3
	finalviewimpression := viewimpression1 + viewimpression2 + viewimpression3
	finalclicks := clicks1 + clicks2 + clicks3

	finalfirst := first1 + first2 + first3
	finalmid := mid1 + mid2 + mid3
	finalthird := third1 + third2 + third3

	finalstart := start1 + start2 + start3
	finalmute := mute1 + mute2 + mute3
	finalunmute := unmute1 + unmute2 + unmute1

	finalpause := pause1 + pause2 + pause3
	finalresume := resume1 + resume2 + resume3
	finalcomplete := complete1 + complete2 + complete3
	finalclose := close1 + close2 + close3

	var Impdiv string
	var Viewdiv string
	var Clickdiv string

	var Firstdiv string
	var Middiv string
	var Thirddiv string

	var Startdiv string
	var Mutediv string
	var Unmutediv string

	var Pausediv string
	var Resumediv string
	var Cmpdiv string
	var Closediv string

	var innerHTMLview string
	var innerHTMLclick string

	if finalimpression != "" {

		Impdiv = `<div id='imp_` + rand + `'>`+finalimpression+`</div>`
	}

	if finalviewimpression != "" {

		Viewdiv = `<div id='viewble_` + rand + `'></div>`

		innerHTMLview = `document.getElementById("viewble_` + rand + `").innerHTML = "` + finalviewimpression + `";`
	}

	if finalclicks != "" {

		Clickdiv = `<div id='clk_` + rand + `'></div>`

		innerHTMLclick = `document.getElementById("clk_` + rand + `").innerHTML = "` + finalclicks + `";`
	}

	if finalfirst != "" {

		Firstdiv = `<div id='first_` + rand + `'></div>`
	}

	if finalmid != "" {

		Middiv = `<div id='mid_` + rand + `'></div>`
	}

	if finalthird != "" {

		Thirddiv = `<div id='third_` + rand + `'></div>`
	}

	if finalstart != "" {

		Startdiv = `<div id='start_` + rand + `'></div>`
	}

	if finalmute != "" {

		Mutediv = `<div id='mute_` + rand + `'></div>`
	}

	if finalunmute != "" {

		Unmutediv = `<div id='unmute_` + rand + `'></div>`
	}

	if finalpause != "" {

		Pausediv = `<div id='pause_` + rand + `'></div>`
	}

	if finalresume != "" {

		Resumediv = `<div id='resume_` + rand + `'></div>`
	}

	if finalcomplete != "" {

		Cmpdiv = `<div id='cmp_` + rand + `'></div>`
	}

	if finalclose != "" {

		Closediv = `<div id='close_` + rand + `'></div>`
	}

	finalDiv := Impdiv + Viewdiv + Clickdiv + Startdiv + Firstdiv + Middiv + Thirddiv + Mutediv + Unmutediv + Pausediv + Resumediv + Cmpdiv + Closediv

	fmt.Println(finalDiv)

	/**********Third Party Tracker Start**********/

	var size []int

	var BidderArray []string
	Biddderjsonmap := make(map[string]interface{})
	Biddermap := make(map[string]interface{})
	for _, v := range adsource {
		err := json.Unmarshal([]byte(v.Src_Obj), &Biddermap)
		if err != nil {
			fmt.Println(err)
		}
		PrebidTracking(Biddermap, admaruoutput, v)

		Bidderjson, err := json.Marshal(Biddermap)
		if err != nil {
			panic(err)
		}

		// BidderArray = nil
		BidderArray = append(BidderArray, string(Bidderjson))

	}

	BiddermapJson, err := json.Marshal(BidderArray)
	if err != nil {
		panic(err)
	}

	if admaruoutput.Adunit_type != "PrebidPriority" {
		Biddderjsonmap["Addelivery_Tag"] = "no"
	}
	Biddderjsonmap["Bidder_Details"] = string(BiddermapJson)
	fmt.Printf("Bidderjson :%+v\n", string(BiddermapJson))
	fmt.Println("Biddderjsonmap :", Biddderjsonmap)

	Biddderjsonmapp, err := json.Marshal(Biddderjsonmap)
	if err != nil {
		panic(err)
	}
	// document.write(xmlHttp.responseText);
	template_settings := structure.Outstream_Template{}

	err1 := json.Unmarshal([]byte(admaruoutput.Temp_Generation.Settings), &template_settings)
	if err1 != nil {
		fmt.Println(err)
	}

	fmt.Println("Height :", template_settings)

	if template_settings.MaxWidth == 0 {
		template_settings.MaxWidth = 300
	}
	if template_settings.MinWidth == 0 {
		template_settings.MinWidth = 298
	}

	fmt.Printf(" Temps.Width : %+v\n", template_settings)
	size = append(size, template_settings.MaxWidth, template_settings.MinWidth)

	tagid := "Prebid_" + fmt.Sprint(helper.RandNumber(5))

	bidderdetails := strings.ReplaceAll(string(BiddermapJson), "\\", "")
	bidderdetailsmk := strings.ReplaceAll(string(bidderdetails), "u0026", "&")
	filtered := strings.ReplaceAll(string(bidderdetailsmk), `"{`, "{")
	var filtered1 string = ""
	filtered1 = strings.ReplaceAll(string(filtered), `}"`, "}")

	fmt.Printf("Biddds :%+v\n", filtered1)

	switch {
	case admaruoutput.Adunit_type == "PrebidPriority":
		fmt.Println("hi...................")
		admaruoutput.Html = helper.ConvertStrJsonToRawJson(Biddderjsonmapp)
		admaruoutput.External_ad = true
	case admaruoutput.Adunit_type == "async":
		admaruoutput.External_ad = true
		admaruoutput.Html = `<script type="text/javascript" src="https://app.admaru.com/AdmaruAdDelivery/AdmaruJs/viewability.js"><script async src="https://app.admaru.com/AdmaruAdDelivery/AdmaruJs/admaruPrebid.js"></script>
		<script type="text/javascript" >

		var Bids=[` + helper.ConvertStrJsonToRawJson(Biddderjsonmapp) + `];console.log("Bids : ");console.log(Bids);
		var Bidders_Info=Bids[0];
		var Priority_level=Bids[0]['Bidder_Details'][0]['priority'];
		var tag_id=Bids[0]['Bidder_Details'][0]['tag_id'];
		var pbjs = pbjs || {};  var Request_bids ={}; var Res_status="&res_count=0"; 
		var Bidder_Response={}; pbjs.que = pbjs.que || []; var count=0;  
		var xmlHttp = new XMLHttpRequest();
		if(Bidders_Info!='' && Bidders_Info['addelivery_tag']=="yes"){ 
			document.write(Bidders_Info['tag']);
		}else{
			Prebid_Initialize(Bidders_Info,Priority_level,tag_id);
		}

            function callANRenderer(bid, ad) {
              const adResponse = {
                  ad: {
                      video: {
                          content: ad,
                          player_width: ` + helper.IntToString(template_settings.MaxWidth) + `,
                          player_height: ` + helper.IntToString(template_settings.MinWidth) + `,
                      }
                  }
              };
              bid.renderer.push(() => {
                  window.ANOutstreamVideo.renderAd({
                      targetId: bid.adUnitCode,
                      adResponse,
                  });
              });
            }
           function render(bid) {
                let ad = bid.ad || bid.vastXml;
                if (ad) {
                    callANRenderer(bid, ad);
                } else {
                    if (bid.vastUrl) {
                      (async () => {
                          ad = await fetch(resp).then(resp => resp.text());
                          if (typeof ad === 'string') {
                              callANRenderer(bid, ad);
                          } else {
                              console.log('Invalid VAST');
                          }
                      })();
                    } else {
                        console.log('Invalid ad');
                    }
                }
            }
	function Prebid_Initialize(Bidders_Info,Priority_level,tag_id){ 
            const videoAdUnit = [{
                code: '` + tagid + `',
                mediaTypes: {
                    video: {
                        context: 'outstream',
                       playerSize: [` + helper.ArrayOfInttoString(size, ",") + `],
                        mimes: ['video/mp4'],
                        protocols: [1, 2, 3, 4, 5, 6, 7, 8],
                        playbackmethod: [2],
                        skip: 1,
                        renderer: {
                           url: "//app.admaru.com/AdmaruAdDelivery/AdmaruJs/admaruPlayer.js",
                             options: {
								playVideoVisibleThreshold : (` + helper.IntToString(template_settings.PlayerMode.PlayModeView) + ` !=0)? ` + helper.IntToString(template_settings.PlayerMode.PlayModeView) + `:!0,
                                skippable: {
                                enabled: (` + template_settings.Skip.Skip + ` !=0)? !0:0,
                                allowOverride: !1,
                                videoThreshold: 15,
                                videoOffset: ` + helper.IntToString(template_settings.Skip.SkipTime) + `,
                                skipLocation: "top-left",
                                skipText: "Admaru Ad can  skipped in %%TIME%% seconds",
                                skipButtonText: "` + template_settings.Skip.SkipText + `",
                                    },
								adText: "Ads From Admaru",

                               playerSkin : {
                                 topBarColor : "grey",
                                 topBarTextColor : "yellow",
                                 dividerColor : "lightblue",
                                 dividerHeight : 1,
                                 controlBarColor : "transparent",
                                 bigPlayButtonColor : "white",
                                 controlBarControlsColor : "white",
                                 controlBarDividerColor : "red",
                                 videoBackgroundColor : "",
                                          },
                             
                                learnMore : {
                                       enabled : false,
                                       separator : "-",
                                       text : "Learn More",
                                       clickToPause : true
                                              },        
                                                        
                               showMute: !0,
                               showVolume: !0,
                               showProgressBar: !0,
                               showPlayToggle: !0,
                               showBigPlayButton: !0,
                               allowFullscreen: !0,
                              sideStream : {
                                  enabled : true,
                                  startInSideStream : false,
                                  returnToPage : true,
                                  position : "bottom-right",
                                  xOffset : 0,
                                  yOffset : 0,
                                  maxPageOverlay : 20,
                                 width:` + helper.IntToString(template_settings.MaxWidth) + `,
								height: ` + helper.IntToString(template_settings.MinWidth) + `,
                                   }

                 
                             }
				
                        },
                    },

                },
               bids: Bidders_Info['Bidder_Details']
            }];
            
       pbjs.que.push(function() {
		pbjs.addAdUnits(videoAdUnit);` + Track_Req_Res + ` 
		pbjs.setConfig({
		debug: true, 
		cache: {
		url: 'https://prebid.adnxs.com/pbc/v1/cache',
		} 
		}); 
		pbjs.requestBids({
		
		bidsBackHandler: function(bids) {
			console.log("Test");
			console.log("bidding res");
		var highestCpmBids = pbjs.getHighestCpmBids('` + tagid + `');
		console.log("highestCpmBids :");
		console.log(highestCpmBids);
		if(highestCpmBids==""){ 
			var m3_u = '` + config.GetConfig("commonpath", "file") + `Prebidwithpriority?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&priority='+Bidders_Info['Bidder_Details'][0]['priority']+'&loc=` + admaruoutput.CORSDomain + `';
			xmlHttp.open( "GET", m3_u, false ); 
		xmlHttp.send();
		var Response=JSON.parse(xmlHttp.responseText);
		if(Response!=""){
		if(Response['addelivery_tag']=="yes"){ 
			Response['tag']=atob(Response['tag']);console.log(Response);
			document.write(Response['tag']);
		}else{ 
			Prebid_Initialize(Response,Response.Bidder_Details.Priority_level,Response.Bidder_Details.tag_id);
		}
		}
		}else{
		let WonBid = Request_bids[highestCpmBids[0]['requestId']] != "" ? Request_bids[highestCpmBids[0]['requestId']] : "";
		console.log("WonBid");
		console.log(WonBid);
		var Nobids=pbjs.getNoBidsForAdUnitCode('` + tagid + `');
		` + Track_Win_Nobid + `

		var AdViewImpression_URL=WonBid['AdViewImpression_URL'];
		var ad_elem` + rand + ` = document.getElementById("` + tagid + `");
		var ViewableImp = AdViewImpression_URL;	   
		var percent = 75;
		oav` + rand + ` = new OpenAdViewability();
		oav` + rand + `.DEBUG_MODE = true;
		var i` + rand + ` = 0;
		oav` + rand + `.checkViewability(ad_elem` + rand + `, function(check) {

			if(check.percentViewable >=percent){
				if(i` + rand + `==0){
				   	` + innerHTMLview + `				   	 
					var xhttp = new XMLHttpRequest();
					xhttp.open("GET", ViewableImp, true);	            	
					xhttp.send();	            	
					i` + rand + `++;		
				}
			}
		});

		var AdClick_URL=WonBid['AdClick_URL'];
		
		pbjs.renderAd(document, highestCpmBids[0].adId);
		pbjs.onEvent('bidderDone', bidrender => { 
			console.log("bidrender");
			console.log(bidrender);
			const element2 = document.getElementById('` + tagid + `'); 
					console.log(element2);
			
			setTimeout(
				function() {
					const element = document.getElementById('` + tagid + `').childNodes[0]; 
					var iframe=element.childNodes[0];console.log(iframe.id); 
					var iframeDocument = element.contentDocument || iframe.contentWindow.document;
					var Video = iframeDocument.querySelector("video");
					console.log(Video.id);
					Video.onclick = function() { 
						` + innerHTMLclick + `
						xmlHttp.open("GET", AdClick_URL, false ); 
						xmlHttp.send();
						};
				}, 2000);
			});
		}
		}
		});
		});
	}
		</script>
		<div id='` + tagid + `' class='.rm_videowrapper_` + tagid + `'></div><div id='Prebidtrack_` + rand + `'>`+finalDiv+`</div>`

	}

}

func PrebidTracking(Biddermap map[string]interface{}, admaruoutput *structure.AdmaruOutput, v structure.AdSourceDetails) {
	fmt.Println("Adunit_id", admaruoutput.Adunit_details.Adunit_id)

	Biddermap["Request_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Ad_Request?req_id=" + v.Request_id + "&publisher_id=" + v.Publisher + "&adunit_id=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&adsource_id=" + v.Adsourceid + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&loc=" + admaruoutput.CORSDomain

	Biddermap["Response_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Ad_Response?req_id=" + v.Request_id + "&publisher_id=" + v.Publisher + "&adunit_id=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&adsource_id=" + v.Adsourceid + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&loc=" + admaruoutput.CORSDomain

	Biddermap["Adwon_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Ad_Win?req_id=" + v.Request_id + "&publisher_id=" + v.Publisher + "&adunit_id=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&adsource_id=" + v.Adsourceid + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&won_count=1&loc=" + admaruoutput.CORSDomain

	Biddermap["AdImpression_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Impression?req_id=" + v.Request_id + "&publisher_id=" + v.Publisher + "&adunit_id=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&adsource_id=" + v.Adsourceid + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&loc=" + admaruoutput.CORSDomain

	Biddermap["AdTrack"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Event_Track?req_id=" + v.Request_id + "&adsource_id=" + v.Adsourceid + "&adunitid=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&publisher_id=" + v.Publisher + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id

	Biddermap["AdClick_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Click?requestid=" + v.Request_id + "&adsourceid=" + v.Adsourceid + "&adunitid=" + admaruoutput.Adunit_details.Adunit_id + "&Providerid=" + v.Provider + "&Publisherid=" + v.Publisher + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&loc=" + admaruoutput.CORSDomain

	Biddermap["AdViewImpression_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Viewable_Imp?req_id=" + v.Request_id + "&publisher_id=" + v.Publisher + "&adunit_id=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&adsource_id=" + v.Adsourceid + "&tag_id=" + admaruoutput.Tag_id + "&tagtemp_id=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&loc=" + admaruoutput.CORSDomain

	Biddermap["AdunitId"] = admaruoutput.Adunit_details.Adunit_id

	Biddermap["AdunitName"] = admaruoutput.Adunit_details.Name

	Biddermap["tagid"] = admaruoutput.Tag_id

	Biddermap["priority"] = admaruoutput.Priority_Level

	Biddermap["floorprice"] = v.Bidprice
}
