package djuser_target

import (
	"djextrafunc"
	"djgetad"
	"djlogger"
	openrtb3 "openrtb/openrtb3"
	"reflect"
	"strconv"
	"strings"

	openrtb "openrtb/openrtb2.5"
)

type Command struct {
	Name string
	Args []string
}

type Commander struct{}

var (
	userobj   *openrtb3.User
	userobj25 *openrtb.User
)

// Function for coverting string to function arguments
func StringCommandParser(cmd string) *Command {
	parts := strings.Split(cmd, "(")
	parts2 := strings.Split(parts[1], ")")
	count := strings.Count(parts2[0], ",")
	parts3 := strings.Split(djextrafunc.ReplaceNth(parts2[0], ",", "", "-", "", count), "-")
	return &Command{
		Name: parts[0],
		Args: parts3[0:],
	}
}

// Function for checking overall user targeting criteria
func CheckUserCriteria(userChannel chan []djgetad.GetAd, user *openrtb3.User, user25 *openrtb.User, ads []djgetad.GetAd) {
	var filterads []djgetad.GetAd
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			userChannel <- filterads
		}
	}()
	if user != nil {
		userobj = user
	} else if user25 != nil {
		userobj25 = user25
	}
	
					validate_campaign := make(map[int]int)

	for _, ad := range ads {
		
		
		if validate_campaign[ad.Placement_id] == 1 {
			
			filterads = append(filterads, ad)
			continue
		}
		
		if validate_campaign[ad.Placement_id] == 2 {
			continue
		} 
		
		validate_campaign[ad.Placement_id] = 2 // by default not match 
		
		var ex bool
		var funcarr []string
		if ad.Compiledlimitation != "" && ad.Compiledlimitation != "true" {
			s := strings.Split(ad.Compiledlimitation, " and ")
			for _, element := range s {
				if element != "" {
					for _, e := range strings.Split(element, " or ") {
						if e != "" {
							funcarr = append(funcarr, e)
						}
					}
				}
			}
			for _, funcName := range funcarr {
				if funcName != "" {
					command := StringCommandParser(funcName)
					c := &Commander{}
					f := reflect.ValueOf(c).MethodByName(command.Name)
					if f.IsValid() {
						inputs := []reflect.Value{reflect.ValueOf(*command)}
						fu := f.Call(inputs)
						if fu[0].Interface().(bool) == false {
							ex = false
							break
						} else {
							ex = true
						}
					} else {
						ex = true
					}
				}
			}
			if ex != false {
				filterads = append(filterads, ad)
				validate_campaign[ad.Placement_id] = 1 // match
			}
		} else {
			filterads = append(filterads, ad)
			validate_campaign[ad.Placement_id] = 1 // match
		}
	}
	userChannel <- filterads
}

/* -----------------------------------------------------------------------------------
					User Targetting Start(19-12-19)
--------------------------------------------------------------------------------------*/
// Gender Tagetting start
func (c Commander) MAX_checkClient_Gender(cmd Command) bool {
	var argGen []string
	var reqGen string
	if userobj != nil {
		reqGen = strings.ToLower(userobj.Gender)
	} else if userobj25 != nil {
		reqGen = strings.ToLower(userobj25.Gender)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argGen = append(argGen, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqGen != "" {
		if op == "=~" {
			return djextrafunc.In_array(reqGen, argGen)
		} else if op == "!~" {
			return !djextrafunc.In_array(reqGen, argGen)
		} else {
			return false
		}
	}
	return false
}

// Gender Tagetting  end

// YoB Tagetting start
func (c Commander) MAX_checkClient_useryob(cmd Command) bool {
	var argYOB []string
	var reqYOB string
	if userobj != nil {
		reqYOB = strconv.Itoa(userobj.YOB)
	} else if userobj25 != nil {
		reqYOB = strconv.Itoa(userobj25.YOB)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argYOB = append(argYOB, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqYOB != "" {
		if op == "=~" {
			return djextrafunc.In_array(reqYOB, argYOB)
		} else if op == "!~" {
			return !djextrafunc.In_array(reqYOB, argYOB)
		} else {
			return false
		}
	}
	return false
}

// Yob Tagetting  end

// Consent Tagetting start
func (c Commander) MAX_checkClient_Consent(cmd Command) bool {
	var argcon []string
	var reqcon string
	if userobj != nil {
		reqcon = strings.ToLower(userobj.Consent)
	} else if userobj25 != nil {
		reqcon = strings.ToLower(userobj25.Consent)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		argcon = append(argcon, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if reqcon != "" {
		if op == "=~" {
			return djextrafunc.In_array(reqcon, argcon)
		} else if op == "!~" {
			return !djextrafunc.In_array(reqcon, argcon)
		} else {
			return false
		}
	}
	return false
}

// Consent Tagetting  end

// buyeruid Tagetting start
func (c Commander) MAX_checkClient_Buyeruid(cmd Command) bool {
	var arguid []string
	var requid string
	if userobj != nil {
		requid = strings.ToLower(userobj.BuyerUID)
	} else if userobj25 != nil {
		requid = strings.ToLower(userobj25.BuyerUID)
	}
	op := strings.TrimSpace(strings.Replace(cmd.Args[1], "'", "", -1))
	for _, val := range strings.Split(cmd.Args[0], ",") {
		arguid = append(arguid, strings.TrimSpace(strings.Replace(strings.ToLower(val), "'", "", -1)))
	}
	if requid != "" {
		if op == "==" {
			return djextrafunc.In_array(requid, arguid)
		} else if op == "!=" {
			return !djextrafunc.In_array(requid, arguid)
		} else {
			return false
		}
	}
	return false
}

// buyeruid Tagetting  end
/* -----------------------------------------------------------------------------------
					User Targetting End(19-12-19)
--------------------------------------------------------------------------------------*/
