package djtarget

import (
	"djapp_target"
	"djaudience_target"
	"djdata_target"
	"djdevice_target"
	"djdooh_target"
	"djgetad"
	"djregs_target"
	"djrestrict_target"
	"djsegment_target"
	"djsite_target"
	"djuser_target"
	openrtb3 "openrtb/openrtb3"

	openrtb "openrtb/openrtb2.5"
)

// Function to get banner ad
func Targeting(tarChannel chan []djgetad.GetAd, req *openrtb3.Request, req25 *openrtb.BidRequest, ads []djgetad.GetAd, cookie string) {
	
	
	if cookie != "" {
		audiChannel := make(chan []djgetad.GetAd)
		go djaudience_target.CheckAudienceCriteria(audiChannel, cookie, ads)
		ads = <-audiChannel
	}
	
	
	if req != nil {
		if req.Context.Device != nil {
			devChannel := make(chan []djgetad.GetAd)
			devobj := req.Context.Device
			go djdevice_target.CheckDeviceCriteria(devChannel, devobj, nil, ads)
			ads = <-devChannel
		}
		if req.Context.Site != nil {
			siteChannel := make(chan []djgetad.GetAd)
			siteobj := req.Context.Site
			go djsite_target.CheckSiteCriteria(siteChannel, siteobj, nil, ads)
			ads = <-siteChannel
		}
		if req.Context.App != nil {
			appChannel := make(chan []djgetad.GetAd)
			appobj := req.Context.App
			go djapp_target.CheckAppCriteria(appChannel, appobj, nil, ads)
			ads = <-appChannel
		}
		if req.Context.User != nil {
			userChannel := make(chan []djgetad.GetAd)
			userobj := req.Context.User
			go djuser_target.CheckUserCriteria(userChannel, userobj, nil, ads)
			ads = <-userChannel
			if req.Context.User.Data != nil {
				for _, data := range req.Context.User.Data {
					dataChannel := make(chan []djgetad.GetAd)
					dataobj := data
					go djdata_target.CheckDataCriteria(dataChannel, 1, dataobj, openrtb.Data{}, ads)
					ads = <-dataChannel
					if data.Segment != nil {
						for _, segment := range data.Segment {
							segmentChannel := make(chan []djgetad.GetAd)
							segmentobj := segment
							go djsegment_target.CheckSegmentCriteria(segmentChannel, 1, segmentobj, openrtb.Segment{}, ads)
							ads = <-segmentChannel
						}
					}
				}
			}
		}
		if req.Context.Dooh != nil {
			doohChannel := make(chan []djgetad.GetAd)
			doohobj := req.Context.Dooh
			go djdooh_target.CheckDoohCriteria(doohChannel, doohobj, ads)
			ads = <-doohChannel
		}
		if req.Context.Regs != nil {
			regsChannel := make(chan []djgetad.GetAd)
			regsobj := req.Context.Regs
			go djregs_target.CheckRegsCriteria(regsChannel, regsobj, nil, ads)
			ads = <-regsChannel
		}
		if req.Context.Restrictions != nil {
			restrictChannel := make(chan []djgetad.GetAd)
			restrictobj := req.Context.Restrictions
			go djrestrict_target.CheckRestrictCriteria(restrictChannel, 1, restrictobj, openrtb.Restrictions{}, ads)
			ads = <-restrictChannel
		}
	} else if req25 != nil {
		restrictobj25 := openrtb.Restrictions{Bcat: req25.Bcat, Badv: req25.BAdv, Bapp: req25.BApp}
		if req25.Device != nil {
			devChannel := make(chan []djgetad.GetAd)
			devobj := req25.Device
			go djdevice_target.CheckDeviceCriteria(devChannel, nil, devobj, ads)
			ads = <-devChannel
		}
		if req25.Site != nil {
			siteChannel := make(chan []djgetad.GetAd)
			siteobj := req25.Site
			go djsite_target.CheckSiteCriteria(siteChannel, nil, siteobj, ads)
			ads = <-siteChannel
		}
		if req25.App != nil {
			appChannel := make(chan []djgetad.GetAd)
			appobj := req25.App
			go djapp_target.CheckAppCriteria(appChannel, nil, appobj, ads)
			ads = <-appChannel
		}
		if req25.User != nil {
			userChannel := make(chan []djgetad.GetAd)
			userobj := req25.User
			go djuser_target.CheckUserCriteria(userChannel, nil, userobj, ads)
			ads = <-userChannel
			if req25.User.Data != nil {
				for _, data := range req25.User.Data {
					dataChannel := make(chan []djgetad.GetAd)
					dataobj := data
					go djdata_target.CheckDataCriteria(dataChannel, 2, openrtb3.Data{}, dataobj, ads)
					ads = <-dataChannel
					if data.Segment != nil {
						for _, segment := range data.Segment {
							segmentChannel := make(chan []djgetad.GetAd)
							segmentobj := segment
							go djsegment_target.CheckSegmentCriteria(segmentChannel, 2, openrtb3.Segment{}, segmentobj, ads)
							ads = <-segmentChannel
						}
					}
				}
			}
		}
		if req25.Regs != nil {
			regsChannel := make(chan []djgetad.GetAd)
			regsobj := req25.Regs
			go djregs_target.CheckRegsCriteria(regsChannel, nil, regsobj, ads)
			ads = <-regsChannel
		}
		if len(req25.Bcat) > 0 || len(req25.BAdv) > 0 || len(req25.BApp) > 0 {
			restrictChannel := make(chan []djgetad.GetAd)
			go djrestrict_target.CheckRestrictCriteria(restrictChannel, 2, nil, restrictobj25, ads)
			ads = <-restrictChannel
		}
	}
	tarChannel <- ads
}
