package djad

import (
	"djaudioad"
	"djbannerad"
	"djconstants"
	"djdb"
	"djext"
	"djextrafunc"
	"djgetad"
	"djlogger"
	"djmetric"
	"djmongo"
	"djnativead"
	"djredis"
	"djsource"
	"djtarget"
	"djvideoad"
	"encoding/json"
	openrtb3 "openrtb/openrtb3"
	"strconv"
	"strings"
	"fmt"
	"time"

	openrtb "openrtb/openrtb2.5"
)

type Ccookie struct {
	Adid       int
	Campaignid int
}

var sync_table = djconstants.TablePrefix + "dj_dsp_cookie_sync"
var redisClient = djredis.Initialize()

// Function for returing all requested ads 3.0
func Dsp_adprocessing(channel chan map[string]interface{}, req *openrtb3.Request, req_details map[string]interface{}) {
	var (
		banads, videoads, nativeads, audioads []djgetad.GetAd
		seatbidArr                            []openrtb3.SeatBid
		cookieid                              string
		adomain                               []string
		syncAdid, syncCampaignid, AD_ID       int
	)
	vC := &Ccookie{}
	output := make(map[string]interface{})
	req_details["dsp_id"], req_details["dmp_pixel"], _, req_details["web_response_type"], req_details["video_response_type"], req_details["DS"] = djextrafunc.GetDspId(req_details["dsp_name"].(string), req_details["key"].(string), 0, redisClient)

	if req_details["DS"] != req.Source.DS {

		djlogger.Log.Println("Digital Signature Not Match")
		output["nbr"] = 1
		channel <- output
		return
	}

	resID, objid, reqData, insertRequest := djmongo.MongoSaveRequest(req_details["dsp_id"].(int), req)
	if insertRequest != true {
		djlogger.Log.Println("Request not inserted in Mongodb")
		output["nbr"] = 1
		channel <- output
		return
	}
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			output["id"] = resID
			output["nbr"] = 1
			output["seatbid"] = seatbidArr
			channel <- output
		}
	}()
	if req_details["dsp_id"].(int) != 0 {
		domain := strings.Split(req_details["Host"].(string), ":")
		adomain = []string{domain[0]}
		if req.Context.User.BuyerUID != "" {
			cookieid = req.Context.User.BuyerUID
			err := redisClient.GetKey(cookieid, vC)
			if err != nil {
				djlogger.Log.Println("Key expired or error in getting redis key: ", err.Error())
			}
			if vC != nil && err == nil {
				syncAdid = vC.Adid
				syncCampaignid = vC.Campaignid
			} else {
				djdb.DbQueryRow("SELECT adid,campaignid FROM "+sync_table+" where cookieid= '"+cookieid+"'").Scan(&syncAdid, &syncCampaignid)
				err := redisClient.SetKey(cookieid, &Ccookie{Adid: syncAdid, Campaignid: syncCampaignid}, time.Minute*djconstants.RedisExpInMin)
				if err != nil {
					djlogger.Log.Println("Error in setting redis key: ", err.Error())
				}
			}
		} else {
			cookieid = djextrafunc.RandToken(18)
		}
		for _, item := range req.Item {
			var (
				seatbid                                                                                   openrtb3.SeatBid
				bidArr                                                                                    []*openrtb3.Bid
				revenue_flt                                                                               float64
				dur, width, height                                                                        int
				currentTime                                                                               time.Time
				attr                                                                                      []int
				seat, adm, clickurl, impurl, rubiconDmpurl, cid, ad_id, url, filename, deal_id, titleText string
				dataObject                                                                                map[int]string
			)
			if item.Spec.Placement.Display != nil {
				if item.Spec.Placement.Display.Displayfmt != nil {
					var bid *openrtb3.Bid
					banChannel := make(chan []djgetad.GetAd)
					go djbannerad.GetBannerads(banChannel, item.Spec.Placement.Display.Mimes, item.Spec.Placement.Display.Displayfmt, req_details, item.Private, item.Deal, redisClient)
					banads = <-banChannel
					tarChannel := make(chan []djgetad.GetAd)
					go djtarget.Targeting(tarChannel, req, nil, banads, req_details["cookie"].(string))
					banads = <-tarChannel
					sourceChannel := make(chan []djgetad.GetAd)
					go djsource.GetSourceObj(sourceChannel, req.Source, nil, banads, req_details)
					banads = <-sourceChannel
					if req.Ext != nil {
						extChannel := make(chan []djgetad.GetAd)
						go djext.CheckReqExtCriteria(extChannel, req.Ext, banads)
						banads = <-extChannel
					}
					if len(item.Metric) > 0 {
						metricChannel := make(chan []djgetad.GetAd)
						go djmetric.CheckMetricCriteria(metricChannel, item.Metric, nil, banads, redisClient)
						banads = <-metricChannel
					}
					if len(banads) > 0 {
						var adIndex int
						if syncAdid != 0 && syncCampaignid != 0 {
							for k, v := range banads {
								if v.Ad_id == syncAdid && v.Placement_id == syncCampaignid {
									adIndex = k
								}
							}
						}
						if req.AT == 1 {
							revenue_flt = djextrafunc.StringToFloat(banads[adIndex].Revenue, 64)
						} else {
							if banads[adIndex].SecondRevenue.String != "" {
								revenue_flt = djextrafunc.StringToFloat(banads[adIndex].SecondRevenue.String, 64) + 0.01
							} else {
								revenue_flt = djextrafunc.StringToFloat(banads[adIndex].Revenue, 64)
							}
						}
						cid = strconv.Itoa(banads[adIndex].Placement_id)
						ad_id = strconv.Itoa(banads[adIndex].Ad_id)
						url = banads[adIndex].Url
						filename = banads[adIndex].Filename
						currentTime = time.Now()
						seat = strings.Replace(banads[adIndex].Clientname, " ", "_", -1) + "_" + strconv.Itoa(banads[adIndex].Clientid)
						deal_id = banads[adIndex].Deal_id
						clickurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + ad_id + "&zoneid=0&oadest=" + url + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + cid
						impurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ImpUrlEndPoint + "?bannerid=" + ad_id + "&campaignid=" + cid + "&zoneid=0&bidid=" + resID

						rubiconDmpurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.RubiconDmpPixelEndPoint + "?v={ad_network_id}&cookieid=" + cookieid

						if banads[adIndex].Storagetype == "web" {
							adm = "<?xml version='1.0'?><ad xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'modelVersion='0.9'><imageAd><clickUrl>" + clickurl + "</clickUrl><imgUrl>" + djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + filename + "</imgUrl><width>" + strconv.Itoa(width) + "</width><height>" + strconv.Itoa(height) + "</height><additionalText></additionalText><beacons><beacon>" + impurl + "</beacon><beacon>" + rubiconDmpurl + "</beacon></beacons></imageAd></ad>"
						} else if banads[adIndex].Storagetype == "html" {
							rand := djextrafunc.RandToken(4)
							rand1 := djextrafunc.RandToken(5)
							adm = `var OX_` + rand + ` = '';OX_` + rand + ` += ` + banads[adIndex].Htmltemplate + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>;document.write(OX_` + rand + `);`
						} else if banads[adIndex].Storagetype == "txt" {
							rand := djextrafunc.RandToken(4)
							rand1 := djextrafunc.RandToken(5)
							adm = `var OX_` + rand + ` = '';
								OX_` + rand + ` += <a href='` + clickurl + `' target='_blank'>` + banads[adIndex].Bannertext + `</a><div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><"+"img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>\n";document.write(OX_` + rand + `);`
						}
						bid = &openrtb3.Bid{
							ID:    djextrafunc.RandToken(8),
							Item:  item.ID,
							Deal:  deal_id,
							Price: revenue_flt,
							CID:   cid,
							MID:   ad_id,
							NURL:  djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.WinNoticeEndPoint + "?auctionId=${OPENRTB_ID}&bidid=${OPENRTB_BID_ID}&price=${OPENRTB_PRICE}&impid=${OPENRTB_ITEM_ID}&seatid=${OPENRTB_SEAT_ID}&adid=${OPENRTB_MEDIA_ID}&cur=${OPENRTB_CURRENCY}",
							BURL:  djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${OPENRTB_ID}&bidid=${OPENRTB_BID_ID}&price=${OPENRTB_PRICE}&impid=${OPENRTB_ITEM_ID}&seatid=${OPENRTB_SEAT_ID}&adid=${OPENRTB_MEDIA_ID}&cur=${OPENRTB_CURRENCY}",
							LURL:  djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.LossNoticeEndPoint + "?auctionId=${OPENRTB_ID}&bidid=${OPENRTB_BID_ID}&price=${OPENRTB_PRICE}&impid=${OPENRTB_ITEM_ID}&seatid=${OPENRTB_SEAT_ID}&adid=${OPENRTB_MEDIA_ID}&cur=${OPENRTB_CURRENCY}&lossid=${OPENRTB_LOSS}",
							Macro: []*openrtb3.Macro{
								{
									Key:   "TIMESTAMP",
									Value: strconv.Itoa(int(currentTime.Unix())),
								},
								{
									Key:   "CLICKURL",
									Value: clickurl,
								},
							},
							Media: &openrtb3.Media{
								Ad: &openrtb3.Ad{
									ID:      ad_id,
									Adomain: adomain,
									Lang:    "en",
								},
								Display: &openrtb3.DisplayRes{
									Ctype: item.Spec.Placement.Display.Ctype,
									Adm:   adm,
								},
							},
						}
						bidArr = append(bidArr, bid)
					}
					seatbid.Bid = bidArr
					seatbid.Seat = seat
				}
				if item.Spec.Placement.Display.Nativefmt != nil {
					var (
						//natVideoad *openrtb3.Video
						bid       *openrtb3.Bid
						nassetArr []openrtb3.Assetval
						img       string
					)
					nativeMap := make(map[string]interface{})
					for _, nativefmt := range item.Spec.Placement.Display.Nativefmt.Asset {
						if nativefmt.Title != nil {
							nativeMap["titleLen"] = nativefmt.Title.Len
						}
						if nativefmt.Img != nil {
							nativeMap["imgType"] = nativefmt.Img.Type
							nativeMap["imgW"] = nativefmt.Img.W
							nativeMap["imgH"] = nativefmt.Img.H
							nativeMap["imgWmin"] = nativefmt.Img.Wmin
							nativeMap["imgHmin"] = nativefmt.Img.Hmin
							if nativefmt.Img.Mime != nil {
								nativeMap["imgMime"] = djextrafunc.ImageMimeType(nativefmt.Img.Mime)
							} else {
								nativeMap["imgMime"] = "jpg,gif,jpeg,png"
							}
						}
						if nativefmt.Data != nil {
							nativeMap["dataType"] = nativefmt.Data.Type
							nativeMap["dataLen"] = nativefmt.Data.Len
						}
						/* if nativefmt.Video != nil {
							natVideoad = nativefmt.Video
						} */
					}
					nativeChannel := make(chan []djgetad.GetAd)
					go djnativead.GetNativeads(nativeChannel, nativeMap, req_details, item.Private, item.Deal)
					nativeads = <-nativeChannel
					tarChannel := make(chan []djgetad.GetAd)
					go djtarget.Targeting(tarChannel, req, nil, nativeads, req_details["cookie"].(string))
					nativeads = <-tarChannel
					sourceChannel := make(chan []djgetad.GetAd)
					go djsource.GetSourceObj(sourceChannel, req.Source, nil, nativeads, req_details)
					nativeads = <-sourceChannel
					if req.Ext != nil {
						extChannel := make(chan []djgetad.GetAd)
						go djext.CheckReqExtCriteria(extChannel, req.Ext, nativeads)
						nativeads = <-extChannel
					}
					//~ if len(item.Metric) > 0 {
					//~ metricChannel := make(chan []djgetad.GetAd)
					//~ go djmetric.CheckMetricCriteria(metricChannel, item.Metric, nil, nativeads, redisClient)
					//~ nativeads = <-metricChannel
					//~ }
					if len(nativeads) > 0 {
						var adIndex int
						if syncAdid != 0 && syncCampaignid != 0 {
							for k, v := range nativeads {
								if v.Ad_id == syncAdid && v.Placement_id == syncCampaignid {
									adIndex = k
								}
							}
						}
						if req.AT == 1 {
							revenue_flt = djextrafunc.StringToFloat(nativeads[adIndex].Revenue, 64)
						} else {
							if nativeads[adIndex].SecondRevenue.String != "" {
								revenue_flt = djextrafunc.StringToFloat(nativeads[adIndex].SecondRevenue.String, 64) + 0.01
							} else {
								revenue_flt = djextrafunc.StringToFloat(nativeads[adIndex].Revenue, 64)
							}
						}
						cid = strconv.Itoa(nativeads[adIndex].Placement_id)
						ad_id = strconv.Itoa(nativeads[adIndex].Ad_id)
						filename = nativeads[adIndex].Filename
						width = nativeads[adIndex].Width
						height = nativeads[adIndex].Height
						titleText = nativeads[adIndex].Title
						dataObject = nativeads[adIndex].Data_objects
						url = nativeads[adIndex].Url
						currentTime = time.Now().UTC()
						seat = strings.Replace(nativeads[adIndex].Clientname, " ", "_", -1) + "_" + strconv.Itoa(nativeads[adIndex].Clientid)
						imgLogo := djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + nativeads[adIndex].Icon_image
						img = djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + nativeads[adIndex].Filename

						deal_id = nativeads[adIndex].Deal_id
						/* vidChannel := make(chan []djgetad.GetAd)
						go djvideoad.GetVideoads(vidChannel, natVideoad, req_details, item.Private, item.Deal)
						videoads = <-vidChannel */
						for _, nativefmt := range item.Spec.Placement.Display.Nativefmt.Asset {
							var na openrtb3.Assetval
							if nativefmt.Title != nil {
								na = openrtb3.Assetval{
									Id:       nativefmt.Id,
									Required: nativefmt.Req,
									Title: &openrtb3.TitleRes{
										Text: titleText,
									},
								}
								nassetArr = append(nassetArr, na)
							}
							if nativefmt.Img != nil {
								if nativefmt.Img.Type == 1 {
									na = openrtb3.Assetval{
										Id:       nativefmt.Id,
										Required: nativefmt.Req,
										Img:      imgLogo,
									}
								} else {
									na = openrtb3.Assetval{
										Id:       nativefmt.Id,
										Required: nativefmt.Req,
										Img:      img,
										W:        width,
										H:        height,
									}
								}
								nassetArr = append(nassetArr, na)
							}
							if nativefmt.Data != nil {
								na = openrtb3.Assetval{
									Id:       nativefmt.Id,
									Required: nativefmt.Req,
									Data:     dataObject[nativefmt.Data.Type],
								}
								nassetArr = append(nassetArr, na)
							}
							/* if nativefmt.Video != nil {
								na = openrtb3.Assetval{
									Id:       nativefmt.Id,
									Required: nativefmt.Req,
									Video: &openrtb3.VideoRes{
										Adm: djvideoad.GetVastXML(videoads[0], natVideoad, nil, req_details, "", ""),
									},
								}
								nassetArr = append(nassetArr, na)
							} */
						}
						clickurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + ad_id + "&zoneid=0&oadest=" + url + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + cid
						impurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ImpUrlEndPoint + "?bannerid=" + ad_id + "&campaignid=" + cid + "&zoneid=0&bidid=" + resID
						rubiconDmpurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.RubiconDmpPixelEndPoint + "?v={ad_network_id}&cookieid=" + cookieid
						bid = &openrtb3.Bid{
							ID:    djextrafunc.RandToken(8),
							Item:  item.ID,
							Deal:  deal_id,
							Price: revenue_flt,
							CID:   cid,
							MID:   ad_id,
							NURL:  djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.WinNoticeEndPoint + "?auctionId=${OPENRTB_ID}&bidid=${OPENRTB_BID_ID}&price=${OPENRTB_PRICE}&impid=${OPENRTB_ITEM_ID}&seatid=${OPENRTB_SEAT_ID}&adid=${OPENRTB_MEDIA_ID}&cur=${OPENRTB_CURRENCY}",
							BURL:  djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${OPENRTB_ID}&bidid=${OPENRTB_BID_ID}&price=${OPENRTB_PRICE}&impid=${OPENRTB_ITEM_ID}&seatid=${OPENRTB_SEAT_ID}&adid=${OPENRTB_MEDIA_ID}&cur=${OPENRTB_CURRENCY}",
							LURL:  djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.LossNoticeEndPoint + "?auctionId=${OPENRTB_ID}&bidid=${OPENRTB_BID_ID}&price=${OPENRTB_PRICE}&impid=${OPENRTB_ITEM_ID}&seatid=${OPENRTB_SEAT_ID}&adid=${OPENRTB_MEDIA_ID}&cur=${OPENRTB_CURRENCY}&lossid=${OPENRTB_LOSS}",
							Macro: []*openrtb3.Macro{
								{
									Key:   "TIMESTAMP",
									Value: strconv.Itoa(int(currentTime.Unix())),
								},
								{
									Key:   "CLICKURL",
									Value: clickurl,
								},
							},
							Media: &openrtb3.Media{
								Ad: &openrtb3.Ad{
									ID:      ad_id,
									Adomain: adomain,
									Lang:    "en",
								},
								Display: &openrtb3.DisplayRes{
									Ctype: item.Spec.Placement.Display.Ctype,
									Native: &openrtb3.Nativeres{
										Asset: nassetArr,
										Link: &openrtb3.Link{
											Url:  clickurl,
											Trkr: []string{impurl, rubiconDmpurl},
										},
									},
								},
							},
						}
						bidArr = append(bidArr, bid)
						seatbid.Bid = bidArr
						seatbid.Seat = seat
					}
				}
			}
			if item.Spec.Placement.Video != nil {
				var bid *openrtb3.Bid
				vidChannel := make(chan []djgetad.GetAd)
				go djvideoad.GetVideoads(vidChannel, item.Spec.Placement.Video, req_details, item.Private, item.Deal)
				videoads = <-vidChannel
				tarChannel := make(chan []djgetad.GetAd)
				go djtarget.Targeting(tarChannel, req, nil, videoads, req_details["cookie"].(string))
				videoads = <-tarChannel
				sourceChannel := make(chan []djgetad.GetAd)
				go djsource.GetSourceObj(sourceChannel, req.Source, nil, videoads, req_details)
				videoads = <-sourceChannel
				if req.Ext != nil {
					extChannel := make(chan []djgetad.GetAd)
					go djext.CheckReqExtCriteria(extChannel, req.Ext, videoads)
					videoads = <-extChannel
				}
				if len(item.Metric) > 0 {
					metricChannel := make(chan []djgetad.GetAd)
					go djmetric.CheckMetricCriteria(metricChannel, item.Metric, nil, videoads, redisClient)
					videoads = <-metricChannel
				}
				if len(videoads) > 0 {
					var adIndex int
					if syncAdid != 0 && syncCampaignid != 0 {
						for k, v := range videoads {
							if v.Ad_id == syncAdid && v.Placement_id == syncCampaignid {
								adIndex = k
							}
						}
					}
					if req.AT == 1 {
						revenue_flt = djextrafunc.StringToFloat(videoads[adIndex].Revenue, 64)
					} else {
						if videoads[adIndex].SecondRevenue.String != "" {
							revenue_flt = djextrafunc.StringToFloat(videoads[adIndex].SecondRevenue.String, 64) + 0.01
						} else {
							revenue_flt = djextrafunc.StringToFloat(videoads[adIndex].Revenue, 64)
						}
					}
					cid = strconv.Itoa(videoads[adIndex].Placement_id)
					ad_id = strconv.Itoa(videoads[adIndex].Ad_id)
					url = videoads[adIndex].Url
					filename = videoads[adIndex].Filename
					currentTime = time.Now().UTC()
					dur = int(videoads[adIndex].Vast_video_duration.Int64)
					seat = strings.Replace(videoads[adIndex].Clientname, " ", "_", -1) + "_" + strconv.Itoa(videoads[adIndex].Clientid)
					deal_id = videoads[adIndex].Deal_id
					clickurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + ad_id + "&zoneid=0&oadest=" + url + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + cid
					impurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ImpUrlEndPoint + "?bannerid=" + ad_id + "&campaignid=" + cid + "&zoneid=0&bidid=" + resID
					rubiconDmpurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.RubiconDmpPixelEndPoint + "?v={ad_network_id}&cookieid=" + cookieid
					vAdm, vAttr := djvideoad.GetVastXML(videoads[adIndex], item.Spec.Placement.Video, nil, req_details, resID, cookieid, redisClient)
					if vAttr == 1 {
						attr = []int{16}
					}
					bid = &openrtb3.Bid{
						ID:    djextrafunc.RandToken(8),
						Item:  item.ID,
						Deal:  deal_id,
						Price: revenue_flt,
						CID:   cid,
						MID:   ad_id,
						NURL:  djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.WinNoticeEndPoint + "?auctionId=${OPENRTB_ID}&bidid=${OPENRTB_BID_ID}&price=${OPENRTB_PRICE}&impid=${OPENRTB_ITEM_ID}&seatid=${OPENRTB_SEAT_ID}&adid=${OPENRTB_MEDIA_ID}&cur=${OPENRTB_CURRENCY}",
						BURL:  djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${OPENRTB_ID}&bidid=${OPENRTB_BID_ID}&price=${OPENRTB_PRICE}&impid=${OPENRTB_ITEM_ID}&seatid=${OPENRTB_SEAT_ID}&adid=${OPENRTB_MEDIA_ID}&cur=${OPENRTB_CURRENCY}",
						LURL:  djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.LossNoticeEndPoint + "?auctionId=${OPENRTB_ID}&bidid=${OPENRTB_BID_ID}&price=${OPENRTB_PRICE}&impid=${OPENRTB_ITEM_ID}&seatid=${OPENRTB_SEAT_ID}&adid=${OPENRTB_MEDIA_ID}&cur=${OPENRTB_CURRENCY}&lossid=${OPENRTB_LOSS}",
						Macro: []*openrtb3.Macro{
							{
								Key:   "TIMESTAMP",
								Value: strconv.Itoa(int(currentTime.Unix())),
							},
							{
								Key:   "CLICKURL",
								Value: clickurl,
							},
						},
						Media: &openrtb3.Media{
							Ad: &openrtb3.Ad{
								ID:      ad_id,
								Adomain: adomain,
								Lang:    "en",
								Attr:    attr,
							},
							Video: &openrtb3.VideoRes{
								Dur:   dur,
								Ctype: item.Spec.Placement.Video.Ctype,
								Adm:   vAdm,
							},
						},
					}
					bidArr = append(bidArr, bid)
					seatbid.Bid = bidArr
					seatbid.Seat = seat
				}
			}
			if item.Spec.Placement.Audio != nil {
				var bid *openrtb3.Bid
				audChannel := make(chan []djgetad.GetAd)
				go djaudioad.GetAudioads(audChannel, item.Spec.Placement.Audio, req_details, item.Private, item.Deal)
				audioads = <-audChannel
				tarChannel := make(chan []djgetad.GetAd)
				go djtarget.Targeting(tarChannel, req, nil, audioads, req_details["cookie"].(string))
				audioads = <-tarChannel
				sourceChannel := make(chan []djgetad.GetAd)
				go djsource.GetSourceObj(sourceChannel, req.Source, nil, audioads, req_details)
				audioads = <-sourceChannel
				if req.Ext != nil {
					extChannel := make(chan []djgetad.GetAd)
					go djext.CheckReqExtCriteria(extChannel, req.Ext, audioads)
					audioads = <-extChannel
				}
				if len(item.Metric) > 0 {
					metricChannel := make(chan []djgetad.GetAd)
					go djmetric.CheckMetricCriteria(metricChannel, item.Metric, nil, audioads, redisClient)
					audioads = <-metricChannel
				}
				if len(audioads) > 0 {
					var adIndex int
					if syncAdid != 0 && syncCampaignid != 0 {
						for k, v := range audioads {
							if v.Ad_id == syncAdid && v.Placement_id == syncCampaignid {
								adIndex = k
							}
						}
					}
					if req.AT == 1 {
						revenue_flt = djextrafunc.StringToFloat(audioads[adIndex].Revenue, 64)
					} else {
						if audioads[adIndex].SecondRevenue.String != "" {
							revenue_flt = djextrafunc.StringToFloat(audioads[adIndex].SecondRevenue.String, 64) + 0.01
						} else {
							revenue_flt = djextrafunc.StringToFloat(audioads[adIndex].Revenue, 64)
						}
					}
					cid = strconv.Itoa(audioads[adIndex].Placement_id)
					ad_id = strconv.Itoa(audioads[adIndex].Ad_id)
					url = audioads[adIndex].Url
					filename = audioads[adIndex].Filename
					currentTime = time.Now().UTC()
					dur = int(audioads[adIndex].Vast_video_duration.Int64)
					seat = strings.Replace(audioads[adIndex].Clientname, " ", "_", -1) + "_" + strconv.Itoa(audioads[adIndex].Clientid)
					deal_id = audioads[adIndex].Deal_id
					clickurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + ad_id + "&zoneid=0&oadest=" + url + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + cid
					impurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ImpUrlEndPoint + "?bannerid=" + ad_id + "&campaignid=" + cid + "&zoneid=0&bidid=" + resID
					rubiconDmpurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.RubiconDmpPixelEndPoint + "?v={ad_network_id}&cookieid=" + cookieid
					aAdm, aAttr := djaudioad.GetVastXML(audioads[adIndex], item.Spec.Placement.Audio, nil, req_details, resID, cookieid, redisClient)
					if aAttr == 1 {
						attr = []int{16}
					}
					bid = &openrtb3.Bid{
						ID:    djextrafunc.RandToken(8),
						Item:  item.ID,
						Deal:  deal_id,
						Price: revenue_flt,
						CID:   cid,
						MID:   ad_id,
						NURL:  djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.WinNoticeEndPoint + "?auctionId=${OPENRTB_ID}&bidid=${OPENRTB_BID_ID}&price=${OPENRTB_PRICE}&impid=${OPENRTB_ITEM_ID}&seatid=${OPENRTB_SEAT_ID}&adid=${OPENRTB_MEDIA_ID}&cur=${OPENRTB_CURRENCY}",
						BURL:  djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${OPENRTB_ID}&bidid=${OPENRTB_BID_ID}&price=${OPENRTB_PRICE}&impid=${OPENRTB_ITEM_ID}&seatid=${OPENRTB_SEAT_ID}&adid=${OPENRTB_MEDIA_ID}&cur=${OPENRTB_CURRENCY}",
						LURL:  djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.LossNoticeEndPoint + "?auctionId=${OPENRTB_ID}&bidid=${OPENRTB_BID_ID}&price=${OPENRTB_PRICE}&impid=${OPENRTB_ITEM_ID}&seatid=${OPENRTB_SEAT_ID}&adid=${OPENRTB_MEDIA_ID}&cur=${OPENRTB_CURRENCY}&lossid=${OPENRTB_LOSS}",
						Macro: []*openrtb3.Macro{
							{
								Key:   "TIMESTAMP",
								Value: strconv.Itoa(int(currentTime.Unix())),
							},
							{
								Key:   "CLICKURL",
								Value: clickurl,
							},
						},
						Media: &openrtb3.Media{
							Ad: &openrtb3.Ad{
								ID:      ad_id,
								Adomain: adomain,
								Lang:    "en",
								Attr:    attr,
							},
							Audio: &openrtb3.AudioRes{
								Dur:   dur,
								Ctype: item.Spec.Placement.Audio.Ctype,
								Adm:   aAdm,
							},
						},
					}
					bidArr = append(bidArr, bid)
					seatbid.Bid = bidArr
					seatbid.Seat = seat

				}
			}
			seatbidArr = append(seatbidArr, seatbid)

			ad_idd, _ := strconv.Atoi(ad_id)
			AD_ID = ad_idd
		}
		mainext, err := json.Marshal(openrtb3.MainExt{PixelURL: req_details["dmp_pixel"].(string)})
		if err != nil {
			djlogger.Log.Println("Error ", err.Error())
		}
		output["id"] = resID
		output["bidid"] = resID
		output["cur"] = "USD"
		output["seatbid"] = seatbidArr
		output["ext"] = json.RawMessage(mainext)
	} else {
		output["id"] = resID
		output["nbr"] = 8
		output["seatbid"] = seatbidArr
	}
	channel <- output
	djlogger.Log.Println(output)
	seatBool := false
	for _, v := range seatbidArr {
		if v.Bid != nil {
			seatBool = true
			break
		}
	}
	if seatBool != false {
		insertResponse := djmongo.MongoSaveResponse(resID, objid, req_details["dsp_id"].(int), AD_ID, reqData, output)
		if insertResponse != true {
			djlogger.Log.Println("Response not inserted in Mongodb")
		}
	}
}

// Function for returing all requested ads 2.5
func Dsp_adprocessing25(channel chan map[string]interface{}, req *openrtb.BidRequest, req_details map[string]interface{}) {
	var (
		banads, videoads, audioads, nativeads []djgetad.GetAd
		seatbidArr                            []openrtb.SeatBid
		cookieid                              string
		adomain                               []string
		syncAdid, syncCampaignid, AD_ID       int
	)
	vC := &Ccookie{}
	output := make(map[string]interface{})
	req_details["dsp_id"], req_details["dmp_pixel"], _, req_details["web_response_type"], req_details["video_response_type"], req_details["DS"] = djextrafunc.GetDspId(req_details["dsp_name"].(string), req_details["key"].(string), 0, redisClient)
	resID, objid, reqData, insertRequest := djmongo.MongoSaveRequest25(req_details["dsp_id"].(int), req)
	if insertRequest != true {
		djlogger.Log.Println("Request not inserted in Mongodb")
		output["nbr"] = 1
		channel <- output
		return
	}
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
			output["id"] = resID
			output["nbr"] = 1
			output["seatbid"] = seatbidArr
			channel <- output
		}
	}()
	if req_details["dsp_id"].(int) != 0 {
		domain := strings.Split(req_details["Host"].(string), ":")
		adomain = []string{domain[0]}
		if req.User.BuyerUID != "" {
			cookieid = req.User.BuyerUID


			fmt.Println("cookieid",cookieid)
fmt.Println("vC",vC)

			err := redisClient.GetKey(cookieid, vC)
			if err != nil {
				djlogger.Log.Println("Key expired or error in getting redis key: ", err.Error())
			}
			if vC != nil && err == nil {
				syncAdid = vC.Adid
				syncCampaignid = vC.Campaignid
			} else {
				djdb.DbQueryRow("SELECT adid,campaignid FROM "+sync_table+" where cookieid= '"+cookieid+"'").Scan(&syncAdid, &syncCampaignid)
				err := redisClient.SetKey(cookieid, &Ccookie{Adid: syncAdid, Campaignid: syncCampaignid}, time.Minute*djconstants.RedisExpInMin)
				if err != nil {
					djlogger.Log.Println("Error in setting redis key: ", err.Error())
				}
			}
		} else {
			cookieid = djextrafunc.RandToken(18)
		}
		for _, imp := range req.Imp {
			var (
				seatbid                                                                                   openrtb.SeatBid
				bidArr                                                                                    []*openrtb.Bid
				dls                                                                                       []openrtb.Deal
				revenue_flt                                                                               float64
				pvt                                                                                       int8
				width, height                                                                             int
				attr                                                                                      []int
				seat, adm, clickurl, impurl, rubiconDmpurl, cid, ad_id, url, filename, deal_id, titleText string
				dataObject                                                                                map[int]string
			)
			if imp.Banner != nil {
				var bid *openrtb.Bid
				if imp.Pmp != nil {
					pvt = imp.Pmp.Private
					dls = imp.Pmp.Deals
				}
				banChannel := make(chan []djgetad.GetAd)
				go djbannerad.GetBannerads25(banChannel, imp.Banner, req_details, pvt, dls, redisClient)
				banads = <-banChannel
				tarChannel := make(chan []djgetad.GetAd)
				go djtarget.Targeting(tarChannel, nil, req, banads, req_details["cookie"].(string))
				banads = <-tarChannel
				sourceChannel := make(chan []djgetad.GetAd)
				go djsource.GetSourceObj(sourceChannel, nil, req.Source, banads, req_details)
				banads = <-sourceChannel
				if len(imp.Metric) > 0 {
					metricChannel := make(chan []djgetad.GetAd)
					go djmetric.CheckMetricCriteria(metricChannel, nil, imp.Metric, banads, redisClient)
					banads = <-metricChannel
				}
				if len(banads) > 0 {
					var adIndex int
					if syncAdid != 0 && syncCampaignid != 0 {
						for k, v := range banads {
							if v.Ad_id == syncAdid && v.Placement_id == syncCampaignid {
								adIndex = k
							}
						}
					}
					if req.AuctionType == 1 {
						revenue_flt = djextrafunc.StringToFloat(banads[adIndex].Revenue, 64)
					} else {
						if banads[adIndex].SecondRevenue.String != "" {
							revenue_flt = djextrafunc.StringToFloat(banads[adIndex].SecondRevenue.String, 64) + 0.01
						} else {
							revenue_flt = djextrafunc.StringToFloat(banads[adIndex].Revenue, 64)
						}
					}
					width = banads[adIndex].Width
					height = banads[adIndex].Height
					cid = strconv.Itoa(banads[adIndex].Placement_id)
					ad_id = strconv.Itoa(banads[adIndex].Ad_id)
					url = banads[adIndex].Url
					filename = banads[adIndex].Filename
					seat = strings.Replace(banads[adIndex].Clientname, " ", "_", -1) + "_" + strconv.Itoa(banads[adIndex].Clientid)
					deal_id = banads[adIndex].Deal_id
					bidext, err := json.Marshal(openrtb.BidExt{Btype: banads[adIndex].Revenue_type})
					if err != nil {
						djlogger.Log.Println("Error ", err.Error())
					}
					clickurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + ad_id + "&zoneid=0&oadest=" + url + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + cid
					impurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ImpUrlEndPoint + "?bannerid=" + ad_id + "&campaignid=" + cid + "&zoneid=0&bidid=" + resID
					rubiconDmpurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.RubiconDmpPixelEndPoint + "?v={ad_network_id}&cookieid=" + cookieid
					if banads[adIndex].Storagetype == "web" {
						adm = "<?xml version='1.0'?><ad xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'modelVersion='0.9'><imageAd><clickUrl>" + clickurl + "</clickUrl><imgUrl>" + djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + filename + "</imgUrl><width>" + strconv.Itoa(width) + "</width><height>" + strconv.Itoa(height) + "</height><additionalText></additionalText><beacons><beacon>" + impurl + "</beacon><beacon>" + rubiconDmpurl + "</beacon><beacon>" + req_details["dmp_pixel"].(string) + "</beacon></beacons></imageAd></ad>"
						if req_details["web_response_type"].(string) == "html" {
							rand1 := djextrafunc.RandToken(5)
							adm = `<a href='` + clickurl + `' target='_blank'><img src='` + djconstants.ReviveProtocol + djconstants.ReviveImages + `/` + filename + `' width='` + strconv.Itoa(width) + `' height='` + strconv.Itoa(height) + `' alt='' title='' border='0'></a><div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='` + req_details["dmp_pixel"].(string) + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='` + rubiconDmpurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>`
						}
					} else if banads[adIndex].Storagetype == "html" {
						rand1 := djextrafunc.RandToken(5)
						adm = banads[adIndex].Htmltemplate + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='` + req_details["dmp_pixel"].(string) + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='` + rubiconDmpurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>`
					} else if banads[adIndex].Storagetype == "txt" {
						rand1 := djextrafunc.RandToken(5)
						adm = `<a href='` + clickurl + `' target='_blank'>` + banads[adIndex].Bannertext + `</a><div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><"+"img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='` + req_details["dmp_pixel"].(string) + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='` + rubiconDmpurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>`
					}
					bid = &openrtb.Bid{
						ID:         djextrafunc.RandToken(8),
						ImpID:      imp.ID,
						Price:      revenue_flt,
						AdID:       ad_id,
						NURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.WinNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
						BURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
						LURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.LossNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}&lossid=${AUCTION_LOSS}",
						AdMarkup:   adm,
						CampaignID: cid,
						CreativeID: ad_id,
						AdvDomain:  adomain,
						DealID:     deal_id,
						W:          width,
						H:          height,
						Ext:        json.RawMessage(bidext),
					}
					if req_details["dsp_name"].(string) == djconstants.RubiconSspName {
						bid.NURL = ""
						bid.LURL = ""
						bid.BURL = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=" + resID + "&price=${AUCTION_PRICE}"
						bid.Ext = json.RawMessage("")
					}
					bidArr = append(bidArr, bid)
					seatbid.Bid = bidArr
					seatbid.Seat = seat
				}
			}
			if imp.Video != nil {
				var bid *openrtb.Bid
				if imp.Pmp != nil {
					pvt = imp.Pmp.Private
					dls = imp.Pmp.Deals
				}
				vidChannel := make(chan []djgetad.GetAd)
				go djvideoad.GetVideoads25(vidChannel, imp.Video, req_details, pvt, dls)
				videoads = <-vidChannel
				tarChannel := make(chan []djgetad.GetAd)
				go djtarget.Targeting(tarChannel, nil, req, videoads, req_details["cookie"].(string))
				videoads = <-tarChannel
				sourceChannel := make(chan []djgetad.GetAd)
				go djsource.GetSourceObj(sourceChannel, nil, req.Source, videoads, req_details)
				videoads = <-sourceChannel
				if len(imp.Metric) > 0 {
					metricChannel := make(chan []djgetad.GetAd)
					go djmetric.CheckMetricCriteria(metricChannel, nil, imp.Metric, videoads, redisClient)
					videoads = <-metricChannel
				}

				if len(videoads) > 0 {
					var adIndex int
					if syncAdid != 0 && syncCampaignid != 0 {
						for k, v := range videoads {
							if v.Ad_id == syncAdid && v.Placement_id == syncCampaignid {
								adIndex = k
							}
						}
					}
					if req.AuctionType == 1 {
						revenue_flt = djextrafunc.StringToFloat(videoads[adIndex].Revenue, 64)
					} else {
						if videoads[adIndex].SecondRevenue.String != "" {
							revenue_flt = djextrafunc.StringToFloat(videoads[adIndex].SecondRevenue.String, 64) + 0.01
						} else {
							revenue_flt = djextrafunc.StringToFloat(videoads[adIndex].Revenue, 64)
						}
					}
					cid = strconv.Itoa(videoads[adIndex].Placement_id)
					ad_id = strconv.Itoa(videoads[adIndex].Ad_id)
					url = videoads[adIndex].Url
					filename = videoads[adIndex].Filename
					seat = strings.Replace(videoads[adIndex].Clientname, " ", "_", -1) + "_" + strconv.Itoa(videoads[adIndex].Clientid)
					deal_id = videoads[adIndex].Deal_id
					bidext, err := json.Marshal(openrtb.BidExt{Btype: videoads[adIndex].Revenue_type})
					if err != nil {
						djlogger.Log.Println("Error ", err.Error())
					}

					vAdm, vAttr := djvideoad.GetVastXML(videoads[adIndex], nil, imp.Video, req_details, resID, cookieid, redisClient)

					if vAttr == 1 {
						attr = []int{16}
					}
					bid = &openrtb.Bid{
						ID:         djextrafunc.RandToken(8),
						ImpID:      imp.ID,
						Price:      revenue_flt,
						AdID:       ad_id,
						NURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.WinNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
						BURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
						LURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.LossNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}&lossid=${AUCTION_LOSS}",
						AdMarkup:   vAdm,
						CampaignID: cid,
						CreativeID: ad_id,
						AdvDomain:  adomain,
						Attr:       attr,
						DealID:     deal_id,
						W:          width,
						H:          height,
						Ext:        json.RawMessage(bidext),
					}

					if req_details["dsp_name"].(string) == djconstants.RubiconSspName {
						bid.LURL = ""
						bid.BURL = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=" + resID + "&price=${AUCTION_PRICE}"
						bid.Ext = json.RawMessage("")
					}
					bidArr = append(bidArr, bid)
					seatbid.Bid = bidArr
					seatbid.Seat = seat
				}
			}
			if imp.Audio != nil {
				var bid *openrtb.Bid
				if imp.Pmp != nil {
					pvt = imp.Pmp.Private
					dls = imp.Pmp.Deals
				}
				audChannel := make(chan []djgetad.GetAd)
				go djaudioad.GetAudioads25(audChannel, imp.Audio, req_details, pvt, dls)
				audioads = <-audChannel
				tarChannel := make(chan []djgetad.GetAd)
				go djtarget.Targeting(tarChannel, nil, req, audioads, req_details["cookie"].(string))
				audioads = <-tarChannel
				sourceChannel := make(chan []djgetad.GetAd)
				go djsource.GetSourceObj(sourceChannel, nil, req.Source, audioads, req_details)
				audioads = <-sourceChannel
				if len(imp.Metric) > 0 {
					metricChannel := make(chan []djgetad.GetAd)
					go djmetric.CheckMetricCriteria(metricChannel, nil, imp.Metric, audioads, redisClient)
					audioads = <-metricChannel
				}
				if len(audioads) > 0 {
					var adIndex int
					if syncAdid != 0 && syncCampaignid != 0 {
						for k, v := range audioads {
							if v.Ad_id == syncAdid && v.Placement_id == syncCampaignid {
								adIndex = k
							}
						}
					}
					if req.AuctionType == 1 {
						revenue_flt = djextrafunc.StringToFloat(audioads[adIndex].Revenue, 64)
					} else {
						if audioads[adIndex].SecondRevenue.String != "" {
							revenue_flt = djextrafunc.StringToFloat(audioads[adIndex].SecondRevenue.String, 64) + 0.01
						} else {
							revenue_flt = djextrafunc.StringToFloat(audioads[adIndex].Revenue, 64)
						}
					}
					cid = strconv.Itoa(audioads[adIndex].Placement_id)
					ad_id = strconv.Itoa(audioads[adIndex].Ad_id)
					url = audioads[adIndex].Url
					filename = audioads[adIndex].Filename
					seat = strings.Replace(audioads[adIndex].Clientname, " ", "_", -1) + "_" + strconv.Itoa(audioads[adIndex].Clientid)
					deal_id = audioads[adIndex].Deal_id
					bidext, err := json.Marshal(openrtb.BidExt{Btype: audioads[adIndex].Revenue_type})
					if err != nil {
						djlogger.Log.Println("Error ", err.Error())
					}
					aAdm, aAttr := djaudioad.GetVastXML(audioads[adIndex], nil, imp.Audio, req_details, resID, cookieid, redisClient)
					if aAttr == 1 {
						attr = []int{16}
					}
					bid = &openrtb.Bid{
						ID:         djextrafunc.RandToken(8),
						ImpID:      imp.ID,
						Price:      revenue_flt,
						AdID:       ad_id,
						NURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.WinNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
						BURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
						LURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.LossNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}&lossid=${AUCTION_LOSS}",
						AdMarkup:   aAdm,
						CampaignID: cid,
						CreativeID: ad_id,
						AdvDomain:  adomain,
						Attr:       attr,
						DealID:     deal_id,
						W:          width,
						H:          height,
						Ext:        json.RawMessage(bidext),
					}
					if req_details["dsp_name"].(string) == djconstants.RubiconSspName {
						bid.NURL = ""
						bid.LURL = ""
						bid.BURL = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=" + resID + "&price=${AUCTION_PRICE}"
						bid.Ext = json.RawMessage("")
					}
					bidArr = append(bidArr, bid)
					seatbid.Bid = bidArr
					seatbid.Seat = seat
				}
			}
			if imp.Native != nil {
				if imp.Native.Request != nil || imp.Native.RequestObj != nil {
					var (
						//natVideoad *openrtb.Video
						bid       *openrtb.Bid
						nassetArr []openrtb.Assetval
						img       string
					)
					nativeMap := make(map[string]interface{})
					if imp.Pmp != nil {
						pvt = imp.Pmp.Private
						dls = imp.Pmp.Deals
					}
					for _, nativefmt := range imp.Native.Request.Asset {
						if nativefmt.Title != nil {
							nativeMap["titleLen"] = nativefmt.Title.Len
						}

						if nativefmt.Img != nil {
							nativeMap["imgType"] = nativefmt.Img.Type
							nativeMap["imgW"] = nativefmt.Img.W
							nativeMap["imgH"] = nativefmt.Img.H
							nativeMap["imgWmin"] = nativefmt.Img.Wmin
							nativeMap["imgHmin"] = nativefmt.Img.Hmin
							if nativefmt.Img.Mime != nil {
								nativeMap["imgMime"] = djextrafunc.ImageMimeType(nativefmt.Img.Mime)
							} else {
								nativeMap["imgMime"] = "jpg,gif,jpeg,png"
							}
						}

						//~ if nativefmt.Data != nil {
						//~ nativeMap["dataType"] = nativefmt.Data.Type
						//~ nativeMap["dataLen"] = nativefmt.Data.Len
						//~ }
						/* if nativefmt.Video != nil {
							natVideoad = nativefmt.Video
						} */
					}
					nativeChannel := make(chan []djgetad.GetAd)
					go djnativead.GetNativeads25(nativeChannel, nativeMap, req_details, pvt, dls)
					nativeads = <-nativeChannel
					tarChannel := make(chan []djgetad.GetAd)
					go djtarget.Targeting(tarChannel, nil, req, nativeads, req_details["cookie"].(string))
					nativeads = <-tarChannel
					sourceChannel := make(chan []djgetad.GetAd)
					go djsource.GetSourceObj(sourceChannel, nil, req.Source, nativeads, req_details)
					nativeads = <-sourceChannel
					//~ if len(imp.Metric) > 0 {
					//~ metricChannel := make(chan []djgetad.GetAd)
					//~ go djmetric.CheckMetricCriteria(metricChannel, nil, imp.Metric, nativeads, redisClient)
					//~ nativeads = <-metricChannel
					//~ }
					if len(nativeads) > 0 {
						var adIndex int
						if syncAdid != 0 && syncCampaignid != 0 {
							for k, v := range nativeads {
								if v.Ad_id == syncAdid && v.Placement_id == syncCampaignid {
									adIndex = k
								}
							}
						}
						if req.AuctionType == 1 {
							revenue_flt = djextrafunc.StringToFloat(nativeads[adIndex].Revenue, 64)
						} else {
							if nativeads[adIndex].SecondRevenue.String != "" {
								revenue_flt = djextrafunc.StringToFloat(nativeads[adIndex].SecondRevenue.String, 64) + 0.01
							} else {
								revenue_flt = djextrafunc.StringToFloat(nativeads[adIndex].Revenue, 64)
							}
						}
						cid = strconv.Itoa(nativeads[adIndex].Placement_id)
						ad_id = strconv.Itoa(nativeads[adIndex].Ad_id)
						filename = nativeads[adIndex].Filename
						width = nativeads[adIndex].Width
						height = nativeads[adIndex].Height
						titleText = nativeads[adIndex].Title
						dataObject = nativeads[adIndex].Data_objects
						url = nativeads[adIndex].Url
						seat = strings.Replace(nativeads[adIndex].Clientname, " ", "_", -1) + "_" + strconv.Itoa(nativeads[adIndex].Clientid)

						imgLogo := djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + nativeads[adIndex].Icon_image
						img = djconstants.ReviveProtocol + djconstants.ReviveImages + "/" + nativeads[adIndex].Filename

						deal_id = nativeads[adIndex].Deal_id
						/* vidChannel := make(chan []djgetad.GetAd)
						go djvideoad.GetVideoads25(vidChannel, natVideoad, req_details, pvt, dls)
						videoads = <-vidChannel */
						bidext, err := json.Marshal(openrtb.BidExt{Btype: nativeads[0].Revenue_type})
						if err != nil {
							djlogger.Log.Println("Error ", err.Error())
						}
						clickurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ClickUrlEndPoint + "?bannerid=" + ad_id + "&zoneid=0&oadest=" + url + "&bidid=" + resID + "&cookieid=" + cookieid + "&campaignid=" + cid
						impurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.ImpUrlEndPoint + "?bannerid=" + ad_id + "&campaignid=" + cid + "&zoneid=0&bidid=" + resID
						rubiconDmpurl = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.RubiconDmpPixelEndPoint + "?v={ad_network_id}&cookieid=" + cookieid

						for _, nativefmt := range imp.Native.Request.Asset {
							var na openrtb.Assetval
							if nativefmt.Title != nil {
								na = openrtb.Assetval{
									Id:       nativefmt.Id,
									Required: nativefmt.Req,
									Title: &openrtb.TitleRes{
										Text: titleText,
									},
								}
								nassetArr = append(nassetArr, na)
							}

							if nativefmt.Img != nil {

								if nativefmt.Img.Type == 1 {
									na = openrtb.Assetval{
										Id:       nativefmt.Id,
										Required: nativefmt.Req,
										Img: &openrtb.Imgres{
											Url: imgLogo,
										},
									}
								} else {
									na = openrtb.Assetval{
										Id:       nativefmt.Id,
										Required: nativefmt.Req,
										Img: &openrtb.Imgres{
											Url: img,
											W:   width,
											H:   height,
										},
									}
								}

								nassetArr = append(nassetArr, na)
							}

							if nativefmt.Data != nil {
								na = openrtb.Assetval{
									Id:       nativefmt.Id,
									Required: nativefmt.Req,
									Data: &openrtb.Datares{
										Value: dataObject[nativefmt.Data.Type],
									},
								}
								nassetArr = append(nassetArr, na)
							}
							/* if nativefmt.Video != nil {
								na = openrtb.Assetval{
									Id:       nativefmt.Id,
									Required: nativefmt.Req,
									Video: &openrtb.VideoRes{
										Vasttag: djvideoad.GetVastXML(videoads[0], nil, natVideoad, req_details, "", ""),
									},
								}
								nassetArr = append(nassetArr, na)
							} */
						}
						natres := &openrtb.Admobject{
							&openrtb.Nativeres{
								Asset: nassetArr,
								Link: &openrtb.Link{
									Url: clickurl,
								},
								Imptrackers: []string{impurl, rubiconDmpurl, req_details["dmp_pixel"].(string)},
							},
						}
						nataiveAd, err := json.Marshal(natres)
						if err != nil {
							djlogger.Log.Println("Error ", err.Error())
						}
						bid = &openrtb.Bid{
							ID:         djextrafunc.RandToken(8),
							ImpID:      imp.ID,
							Price:      revenue_flt,
							AdID:       ad_id,
							NURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.WinNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
							BURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}",
							LURL:       djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.LossNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}&lossid=${AUCTION_LOSS}",
							AdMarkup:   string(nataiveAd),
							CampaignID: cid,
							CreativeID: ad_id,
							AdvDomain:  adomain,
							DealID:     deal_id,
							W:          width,
							H:          height,
							Ext:        json.RawMessage(bidext),
						}
						if req_details["dsp_name"].(string) == djconstants.RubiconSspName {
							bid.NURL = ""
							bid.LURL = ""
							bid.BURL = djconstants.AppProtocol + djconstants.AppHost + djconstants.AppPort + djconstants.BillingNoticeEndPoint + "?auctionId=${AUCTION_ID}&bidid=" + resID + "&price=${AUCTION_PRICE}"
							bid.AdMarkup = ""
							bid.Admobject = natres
							bid.Ext = json.RawMessage("")
						}
						bidArr = append(bidArr, bid)
						seatbid.Bid = bidArr
						seatbid.Seat = seat

					}
				}
			}
			seatbidArr = append(seatbidArr, seatbid)

			ad_idd, _ := strconv.Atoi(ad_id)
			AD_ID = ad_idd

		}
		mainext, err := json.Marshal(openrtb.MainExt{PixelURL: req_details["dmp_pixel"].(string)})
		if err != nil {
			djlogger.Log.Println("Error ", err.Error())
		}
		output["id"] = resID
		output["bidid"] = resID
		output["cur"] = "USD"
		output["seatbid"] = seatbidArr
		if req_details["dsp_name"].(string) != djconstants.RubiconSspName {
			output["ext"] = json.RawMessage(mainext)
		}
	} else {
		output["id"] = resID
		output["nbr"] = 8
		output["seatbid"] = seatbidArr
	}
	channel <- output
	djlogger.Log.Println(output)
	seatBool := false
	for _, v := range seatbidArr {
		if v.Bid != nil {
			seatBool = true
			break
		}
	}

	if seatBool != false {
		insertResponse := djmongo.MongoSaveResponse25(resID, objid, req_details["dsp_id"].(int), AD_ID, reqData, output)
		if insertResponse != true {
			djlogger.Log.Println("Response not inserted in Mongodb")
		}
	}
}
