package main

import(
	"fmt"
	"log"
	"net"
	"net/http"
	"strings"
	"github.com/go-user-agent" 
	"github.com/oschwald/maxminddb-golang"
	"path/filepath"
)

type DeviceInfo struct{
	deviceType string
	deviceOs string
	deviceMake string
	deviceModel string
}

/*
const (
	MOBILE DeviceInfoDeviceType = "Mobile"
	TABLET DeviceType = "Tab"
	WEB    DeviceType = "Web"
	TV     DeviceType = "TV"
)*/

func main(){
	// mux := http.NewServeMux()
	http.HandleFunc("/", index)
	
	log.Println("Fetch User Device Details..")
    // mux.HandleFunc("/", index)
    
 
    log.Fatalln(http.ListenAndServe(":3000", nil))
}


func index(w http.ResponseWriter, r *http.Request){
	// deviceType, os := GetType(r)
	deviceType, deviceOs := GetType(r)

	fmt.Println(deviceType)
	fmt.Println(deviceOs)

	fmt.Println(r.UserAgent())
	
	GetGeodetails(r)
	
	html := `<html>
				<title>Golang</title>    
				<body>
					<h1>` + `Welcome` + `</h1>
					
				</body>
			</html>`
	w.Write([]byte(fmt.Sprintf(html)))	
	w.Write([]byte(fmt.Sprintf(deviceType)))	
	w.Write([]byte(fmt.Sprintf(deviceOs)))	
	// w.Write([]byte(fmt.Sprintf(ipaddr)))	
	// w.Write([]byte(fmt.Sprintf(geoInfo)))	
	
}

func GetType(r *http.Request) (string, string) {

	if isUserAgent(r, "Android", "webOS", "iPhone", "BlackBerry", "Windows Phone") {

		return "Mobile", useragent.GetOsName(r.UserAgent())
	}
	if isUserAgent(r, "iPad", "iPod", "tablet", "RX-34", "FOLIO") ||
		(isUserAgent(r, "Kindle", "Mac OS") && isUserAgent(r, "Silk")) ||
		(isUserAgent(r, "AppleWebKit") && isUserAgent(r, "Silk")) {
		return "TABLET", useragent.GetOsName(r.UserAgent())
	}
	if isUserAgent(r, "TV", "NetCast", "boxee", "Kylo", "Roku", "DLNADOC") {
		return "TV", useragent.GetOsName(r.UserAgent())
	}

	return "WEB", useragent.GetOsName(r.UserAgent())
}

func isUserAgent(r *http.Request, userAgents ...string) bool {
	userAgent := r.Header.Get("User-Agent")
	for _, v := range userAgents {
		if strings.Contains(userAgent, v) {
			return true
		}
	}
	return false
}

func GetGeodetails(r *http.Request) {
	ipaddr, _, _ := net.SplitHostPort(r.RemoteAddr)

	cityDb_path, err := filepath.Abs("../src/github.com/oschwald/maxminddb-golang/test-data/test-data/GeoIP2-City.mmdb")
	// connectionDb_path, err := filepath.Abs("../src/github.com/oschwald/maxminddb-golang/test-data/test-data/GeoIP2-Connection-Type-Test.mmdb")

	db, err := maxminddb.Open(cityDb_path)
	// conndb, err := maxminddb.Open(connectionDb_path)
	if err != nil {
		log.Fatal(err)
	}
	defer db.Close()

	ip := net.ParseIP(ipaddr)
	// w.Write([]byte(fmt.Sprintf(ip)))	
	
	record := make(map[string]interface{})
	/*var record struct {
		City struct {
			Names struct{
				Cityname string `maxminddb:"en"`
			}  `maxminddb:"names"`
		} `maxminddb:"city"`

		Country struct {
			ISOCode string `maxminddb:"iso_code"`
		} `maxminddb:"country"`
		
		Location struct{
			latitude float64 `maxminddb:"latitude"`
			longitude float64 `maxminddb:"logitude"`
			// timeZone string `maxminddb:"time_zone"`
		} `maxminddb:"location"`
		Postal struct{
			postal int `maxminddb:"code"`
		}`maxminddb:"postal"`
	}*/

	db_lookupErr := db.Lookup(ip, &record)
	if db_lookupErr != nil {
		log.Panic(db_lookupErr)
	}
	fmt.Println(record)
	// w.Write([]byte(fmt.Sprintf(record)))	
	// return ip, record

}