package rhandler

import (
	"alpha/adDelivery"
	"alpha/adDelivery/cronjobs"
	"alpha/adDelivery/helper"
	"gocron"
	"net/http"
	"net/url"
	"time"
)

// Home function for home handler
func Home(w http.ResponseWriter, r *http.Request) {

	cronjobs.ProcessDmpSegments()

	html := `<html>
		<head>
			<title>Ad Delivery System</title>
		</head>
		<body>
			<h1>Ad Delivery System</h1>
		</body>
	</html>`
	w.Write([]byte(html))
}

func AsyncJs(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.AsyncJs(w, r)

	w.Write([]byte(content))
}

func Video(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.VideoTag(w, r)

	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Content-Type", "application/xml")
	w.Header().Set("Access-Control-Allow-Origin", "*")
	u, _ := url.Parse(r.Header.Get("Referer"))

	w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")


	w.Write([]byte(content))
}

func Audio(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.AudioTag(w, r)

	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Content-Type", "application/xml")
	w.Header().Set("Access-Control-Allow-Origin", "*")
	u, _ := url.Parse(r.Header.Get("Referer"))

	w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")


	w.Write([]byte(content))

}

func Ajs(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.AjsTag(w, r)

	w.Write([]byte(content))

}

func Async(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.AsyncTag(w, r)

	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	u, _ := url.Parse(helper.GetUrlParam(r, "loc"))
	w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)

	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	w.Write([]byte(content))
}

func Iframe(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.IframeTag(w, r)

	w.Write([]byte(content))
}

func Outstream(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.Outstream(w, r)

	w.Write([]byte(content))
}

func Vastxml(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.Vastxml(w, r)

	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Origin", "https://rvphp.djaxbidder.com")
	w.Header().Set("Content-Type", "text/xml;charset=UTF-8")

	w.Write([]byte(content))
}

func Request_sdk(w http.ResponseWriter, r *http.Request) {

	w.Header().Set("Content-Type", "application/json")
	content := adDelivery.Request_sdk(w, r)

	w.Write([]byte(content))
}

func Cookiesync(w http.ResponseWriter, r *http.Request) {

	v := helper.GetUrlParam(r, "v")
	put := helper.GetUrlParam(r, "put")
	expire := helper.GetUrlParam(r, "expire")
	expired := time.Now().AddDate(0, 0, helper.StringToInt(expire))
	c := http.Cookie{
		Name:    "DSP_COOK" + v,
		Value:   put,
		Expires: expired,
	}

	http.SetCookie(w, &c)
}

func ExecuteCronJob() {

	gocron.Every(1).Hour().Do(cronjobs.ProcessDmpSegments)

	<-gocron.Start()
}
