<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once MAX_PATH . '/lib/OA.php';
require_once MAX_PATH . '/lib/max/Plugin/Common.php';
require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
} else if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'pgsql') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
} else if ($GLOBALS['_MAX']['CONF']['database']['type'] == 'mysqli') {
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

class Plugins_BannerTypeHTML_DynamicfloorAds_FloorAds extends Plugins_BannerTypeHTML
{
    /**
     * Return type of plugin
     *
     * @return string A string describing the type of plugin.
     */

    function getStorageType()
    {
        return 'html';
    }

    /**
     * Return the media (content) type
     *
     */
    function getContentType()
    {
        return 'html';
    }

    function getOptionDescription()
    {
        return $this->translate("DynamicFloor Ads");
    }

    function validateForm(&$form)
    {
        return true;
    }

    function processForm($insert, $bannerid, &$aFields, &$aVariables)
    {


        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $table_name = $table_prefix . 'banners';
        $banner = '';
        $location = "../images/";

        //~ if($_POST['bannerid'] != '' && $_POST['bannerid'] != NULL)
        if ($aFields) {
            $set = "";
            $banner = [];
            $field = [];

            $count = ($_POST['banner_count'] != "") ? $_POST['banner_count'] : 2;
            $remove_count = ($_POST['remove_count'] != "") ? $_POST['remove_count'] : 0;

            $imgData = array();
            for ($j = 1; $j <= $count; $j++) {
                $img_data = array();

                if ($_FILES['item' . $j]['name'] != '') {
                    if (isset($_FILES['item' . $j]) || $_POST['replace' . $j] == 't') {
                        //TODO refactor upload to be a valid quickform element
                        $oFile = OA_Creative_File::factoryUploadedFile('item' . $j);
                        checkForErrorFileUploaded($oFile);
                        $oFile->store('web');
                        $aFile = $oFile->getFileDetails();

                        $img_data['image' . $j] = $aFile['filename'];
                        $img_data['image_url' . $j] = $_POST['image_url' . $j];
                    } else if ($_POST['image_url' . $j] && empty($_FILES['item' . $j])) {
                        $set .= 'image_url' . $j . "=" . "'" . $_POST['image_url' . $j] . "'" . ",";
                        $img_data['image_url' . $j] = $_POST['image_url' . $j];
                    } else {
                        //TODO refactor upload to be a valid quickform element
                        $oFile = OA_Creative_File::factoryUploadedFile('item' . $j);
                        checkForErrorFileUploaded($oFile);
                        $oFile->store('web');
                        $aFile = $oFile->getFileDetails();

                        $img_data['image' . $j] = $aFile['filename'];
                        $img_data['image_url' . $j] = $_POST['image_url' . $j];
                    }

                } else {
                    $img_data['image' . $j] = $_POST['eximages' . $j];
                    $img_data['image_url' . $j] = $_POST['image_url' . $j];
                }


                array_push($imgData, $img_data);

            }
            $output = array(
                'banner_count' => $count,
                'banner_info' => $imgData,

            );

            $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
            $oDbh = &OA_DB::singleton();
            $banners = $oDbh->quoteIdentifier($table_prefix . 'banners', true);
            $oDbh->query("UPDATE {$banners} SET parameters = '" . serialize($output) . "', filename = '', height = '-5', width = '-5' WHERE bannerid=" . $bannerid);

        }

        return true;
    }

    function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {
        return true;
    }

    function buildForm(&$form, &$row)
    {



        //~Default Banner Count
        $count = 2;

        $floorads_values = unserialize($row['parameters']);

        $values = array();



        if (isset($floorads_values)) {
            $values['banner_count'] = ($floorads_values['banner_count'] > 0) ? $floorads_values['banner_count'] : 1;
            $bannerInfo = $floorads_values['banner_info'];
            $j = 1;
            foreach ($bannerInfo as $k => $bnrInfo) {

                $values['image' . $j] = isset($bnrInfo['image' . $j]) ? $bnrInfo['image' . $j] : '';
                $values['image_url' . $j] = isset($bnrInfo['image_url' . $j]) ? $bnrInfo['image_url' . $j] : '';
                //~ $values['third_party_tag'.$j] = isset($bnrInfo['third_party_tag'.$j]) ? $bnrInfo['third_party_tag'.$j] : '';
                ++$j;
            }

        } else {
            $values['banner_count'] = 1;
        }
        $default = [];

        for ($i = 1; $i <= $count; $i++) {
            if (isset($values) && $values['banner_count'] > 0) {
                $ac_class = ($i <= $values['banner_count']) ? 'active' : '';
            } else {
                $ac_class = ($i == 1) ? 'active' : '';
            }
            $form->addElement('header', 'as' . $i, '');

            //section decorator to allow hiding of the section
            //~ $form->addDecorator ( 'as'.$i, 'tag', array ('attributes' => array ('id' => 'as'.$i, 'class' =>' banner_row '.$ac_class) ) );
            $bannerType = ($i == 1) ? 'Web ' : 'Mobile ';
            $form->addElement('html', 'select_banner', "<b style='font-size: 14px;    margin-top: 10px;    display: block;    margin-bottom: 5px;'>" . $bannerType . " Banner </b>");

            $type = array();

            $type = 'web';
            $image = _getContentTypeIconImageName($row['contenttype']);
            $size = _getBannerSizeText($type, $row['filename']);


            addUploadGroup(
                $form,
                $row,
                array(
                    'uploadName' => 'item' . $i,
                    'radioName' => 'replace' . $i,
                    'imageName' => $image,
                    'fileName' => $values['image' . $i],
                    'fileSize' => $size,
                    'newLabel' => "Select the <b> Adfloor image" . $i . "</b> you want to use for this banner",
                    'updateLabel' => "Do you wish to keep your existing <b> Image" . $i . "</b>, or do you want to upload another?",
                    'handleSWF' => true
                )
            );


            $form->setDefaults(array('image_url' . $i => $values['image_url' . $i]));
            $form->addElement('textarea', 'Generic' . $i, 'Generic html');
            $form->addElement('text', 'image_url' . $i, 'Destination Url');

            $form->addElement('hidden', 'eximages' . $i, $values['image' . $i]);

        }


        $form->addElement('html', 'jsForDynamicflooradFormat', '
            <style>

                
                .banner_row
                {
                    display:none;
                }
                
                .banner_row.active
                {
                    display:block;
                }

                .remove_button
                {
                    display:none;
                }
                
                .remove_button.active
                {
                    display:block;
                }
            </style>
            <script>
                

                $(document).ready(function()
                 {
                   
                            $("#input1").attr("checked",true);
                            $("#Generic1").parent().parent().hide();
                            $("#Generic2").parent().parent().hide();
                            $("input[name=item1]").parent().parent().show();
                           $("input[name=item2]").parent().parent().show();
                           $("input[name=image_url1]").parent().parent().show();
                           $("input[name=image_url2]").parent().parent().show();

                        
                      

					    var  bannerid = "' . $row['bannerid'] . '";
                        var  banner_count = "' . $values['banner_count'] . '";
                    
                        var i = 1;
                        if(bannerid != "")
                        {

                            //update
                            $("form").submit(function()
                            { 
                                
                                if(type== "html")
                                {
                                    var abc= $("input[name=input_type]:checked").val();
                                    {
                                        if(abc =="image")
                                        {
                                            
                                            $("input[name=item1]").attr("required",true);
                                            $("input[name=item2]").attr("required",true);  
                                                                  
                                        }
                                    }
                                }
                                var abc= $("input[name=input_type]:checked").val();
                                
                                if(abc == "html")
                                {
                                    var text1 =$("textarea#Generic1").val();
                                    var text2 =$("textarea#Generic2").val();
                            
                                    if(text1 !="")
                                    {
                                        $("textarea#Generic2").attr("required",false);
                                    }
                                    else if(text2 !="")
                                    {
                                        $("textarea#Generic1").attr("required",false);
                                    }
                            
                                    if( text1 !="" && text2 !="" )
                                    {
                                        $("textarea#Generic1").attr("required",false);
                                        $("textarea#Generic2").attr("required",false);
                                    }
                                    else if(text1 =="" && text2 =="")
                                    {
                                        alert("Enter Any one html input value ");
                                        return false;
                                    }
                                        
                                }         
                            });
                        
                        }
                        else
                        {   
                       
                        // INSERT
                        $("form").submit(function()
                        {   //validation   
                        
                            $("input[name=item1]").attr("required",true);
                            $("input[name=item2]").attr("required",true);
                                                      
                        
                        });

                       

                       
                        
     
                    }
                    
                    
                });

     
            </script>
            ');
        $form->addElement('header', 'ass', '');
        //~ $form->addElement('html', 'select_banner', "<button  type='button' class='ad_button' > Add</b>");
        //~ $form->addElement('html', 'remove_button', "<button  type='button' class='remove_button' > Remove</b>");
        //~ $form->addElement('header', 'header_b_links', "Banner link");    
        // $targetElem = $form->createElement('text', 'target', $GLOBALS['strTarget']);
        $form->addElement('hidden', 'banner_count', '');
        $form->addElement('hidden', 'remove_count', '');

        $form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());



    }



}