<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    OpenXPlugin
 * @subpackage DeliveryLimitations
 */

require_once MAX_PATH . '/lib/max/Delivery/limitations.delivery.php';

/**
 * Check to see if this impression contains the valid city.
 *
 * @param string $limitation The city (or comma list of cities) limitation
 * @param string $op The operator (either '==' or '!=')
 * @param array $aParams An array of additional parameters to be checked
 * @return boolean Whether this impression's city passes this limitation's test.
 */
function MAX_checkGeo_City($limitation, $op, $aParams = [])
{
    if (empty($aParams)) {
        $aParams = $GLOBALS['_MAX']['CLIENT_GEO'];
    }
   
    $aLimitation = explode('|', $limitation);
    $sCountry = $aLimitation[0];
    $scity = $aLimitation[1];
   // print_r($aParams['city']);die("df");
    if ($aParams && $aParams['city'] && $aParams['country']) {
		
       // print_r( MAX_limitationsMatchArrayValue($aParams['city'], $scity, $op));die("df");
            
            
        return MAX_limitationsMatchStringValue($aParams['country'], $sCountry, $op)
            && MAX_limitationsMatchArrayValue($aParams['city'], $scity, $op);
    } else {
        return false; // If client has no data about city, do not show the ad
    }
}

?>
