jQuery.noConflict();
(function($) {

    function generateChart(start_date, end_date, id, line_dimension, type, limit) {
        
        $.ajax({
            url: 'geo_report.php',
            type: 'post',
            dataType: 'json',
            data: {
                'start_date': start_date,
                'end_date': end_date,
                'line_dimension': line_dimension, 'id' : id
            },
            success: function(data) {
                
                var values = data.maps;
        
                var ctx = document.getElementById('container');

                    Highcharts.mapChart('container', {

                        title: {
                            text: ''
                        },

                        legend: {
                            title: {
                                text: '',
                                style: {
                                    color: (Highcharts.theme && Highcharts.theme.textColor) || 'black'
                                }
                            }
                        },

                        mapNavigation: {
                            enabled: true,
                            buttonOptions: {
                                verticalAlign: 'bottom'
                            }
                        },

                        tooltip: {
                            backgroundColor: 'white',
                            borderWidth: 1,
                            borderColor: 'black',
                            shadow: false,
                            useHTML: true,
                            padding: 4,
                            pointFormat: '<style>.highcharts-label .highcharts-tooltip .highcharts-color-0{ backgroundColor:#ddd!important;}</style><span   style="font-size:16px" class="f32"><table><tbody><tr><td colspan="2"><b>{point.name}</b> <br></td></tr>'+
                            '<tr><td><span style="display: table-cell; font-size:13px"><b> Impressions :</td> <td> {point.impressions}</span></b><br></td></tr>'+                       
                            '<tr><td><span style="display: table-cell; font-size:13px"><b> Clicks      :</td> <td> {point.clicks} </span></b><br></div></td></tr></tbody></table></span>',
                            positioner: function () {
                                return {x: 0, y: 200 };
                            }
                        },
     
                        colorAxis: {
                            min: 1,
                            max: 1000,
                            type: 'logarithmic'
                        },

                        series: [{
                            data: values,
                            mapData: Highcharts.maps['custom/world'],
                            joinBy: ['name', 'name'],
                            name: 'Geo Stats',
                            states: {
                                hover: {
                                    color: '#a4edba'
                                }
                            }
                        }]
                    });
                }
            });


    }

    function toDate(dateStr) {
        var parts = dateStr.split("-");
        return new Date(parts[2], parts[1] - 1, parts[0]);
    }
   $(document).on('change', '.line_dimension', function() {
        var line_dimension = $(this).val();
        var start_date = $('#period_start').val();
        var end_date = $('#period_end').val();
         var val = $('#period_preset').val();
        var id = $('#ids').val();

        if (val == 8) {
            var d = new Date();
            
            var start_date = '2019-08-01';
            var end_date = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate();
        }
                var id = $('#ids').val();

        if (start_date && end_date) {
            
            generateTable();
            dropdownmenu();
        } else {
            alert('Please select start and end date');
        }
    });
    function generateTable() {
        var start_date = $('#period_start').val();
        var end_date = $('#period_end').val();
        var line_dimension = $('.line_dimension').val();
        var val = $('#period_preset').val();

        if (val == 8) {
            var d = new Date();
            
            var start_date = '2019-08-01';
            var end_date = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate();
        }
        
        var id = $('#ids').val();
        // console.log(id);
        var limit = "limit 0,25";
        var first = 0;

        var empDataTable = $('#table_report').DataTable({
            "sScrollX": "100%",
            "sScrollXInner": "200%",
            "scrollY": true,
            "scrollY": "200px",
            'processing': true,
            'serverSide': true,
            'serverMethod': 'post',
            'bDestroy': true,
            'pageLength': 25,
            'lengthMenu': [
                [25, 50, 75, 100, -1],
                [25, 50, 75, 100, "All"]
            ],
            'bFilter': false,
            'dom': 'l<"toolbar">Bfrtip',
            'buttons': [
                {
                    extend: 'excel',
                    text: 'Excel',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: ':visible:not(.notexport)',
                    }
                },
                {
                    extend: 'csv',
                    text: 'CSV',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: ':visible:not(.notexport)',
                    }
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    orientation: 'landscape',
                    pageSize: 'LEGAL',

                    className: 'btn btn-default',
                    exportOptions: {
                        columns: ':visible:not(.notexport)',

                    }
                }
            ],
            'ajax': {
                'url': 'geo_data.php',
                'data': {
                    'start_date': start_date,
                    'end_date': end_date,
                    'period_preset': val,                    
                    'line_dimension': line_dimension, 'id' : id
                }
            },
            'drawCallback':function( settings, json){

                var type = $("#chart_type").val();
                generateChart(start_date, end_date, id, line_dimension, type, limit);
                
            },
            'columns': [
                { data: 'data_type1' },
                { data: 'data_type2' },
                { data: 'data_type3' },
                { data: 'data_type4' },
                { data: 'data_type5' },
                { data: 'data_type6' },
                { data: 'data_type7' },
                { data: 'data_type8' },
                { data: 'data_type9' },
                { data: 'data_type10' },
                { data: 'data_type11' },
                { data: 'data_type12' },
                { data: 'data_type13' },
                { data: 'impressions' },
                { data: 'clicks' },
                { data: 'ctr' },
                ]
        });

        $("div.toolbar").html('<div><div id="list1" class="dropdown-check-list dropdown-menu" tabindex="100"><span id="anchor" class="anchor">Show/Hide</span><ul id="items" class="items"> <li class="hide_clm2"></li><li class="hide_clm3"></li><li class="hide_clm4"></li><li class="hide_clm5"></li><li class="hide_clm6"></li> <li class="hide_clm7"></li><li class="hide_clm8"><li class="hide_clm9"></li><li class="hide_clm10"></li><li class="hide_clm11"></li><li class="hide_clm12"></li> <li><input type="checkbox" name="hide_columns[]" value="12"> Impression </li> <li><input type="checkbox" name="hide_columns[]" value="13"> Clicks </li> <li><input type="checkbox" name="hide_columns[]" value="14"> CTR </li> </ul></div><div>');

      
        if (line_dimension == "") {
            var dt = $('#table_report').DataTable();

            dt.column(1).visible(false);
            dt.column(2).visible(false);
            dt.column(3).visible(false);
            dt.column(4).visible(false);
            dt.column(5).visible(false);
            dt.column(6).visible(false);
            dt.column(7).visible(false);
            dt.column(8).visible(false);
            dt.column(9).visible(false);
            dt.column(10).visible(false);
            dt.column(11).visible(false);
            dt.column(12).visible(false);
        } else {

            var dt = $('#table_report').DataTable();

            if (line_dimension.includes('2')) {
                dt.column(1).visible(true);
                $(".hide_clm2").html('<input type="checkbox" name="hide_columns[]" value="1"> Region');
            }else{
                dt.column(1).visible(false);
            }if (line_dimension.includes('3')) {
                dt.column(2).visible(true);
                $(".hide_clm3").html('<input type="checkbox" name="hide_columns[]" value="2"> City');
            }else{
                dt.column(2).visible(false);
            }if (line_dimension.includes('4')) {
                 dt.column(3).visible(true);
                $(".hide_clm4").html('<li><input type="checkbox" name="hide_columns[]" value="3"> Advertiser ');
            }else{
                dt.column(3).visible(false);
            }if (line_dimension.includes('5')) {
                 dt.column(4).visible(true);
                $(".hide_clm5").html('<li><input type="checkbox" name="hide_columns[]" value="4"> Campaign ');
            }else{
                dt.column(4).visible(false);
            }if (line_dimension.includes('6')) {
                 dt.column(5).visible(true);
                $(".hide_clm6").html('<li><input type="checkbox" name="hide_columns[]" value="5"> Banner ');
            }else{
                dt.column(5).visible(false);
            }if (line_dimension.includes('7')) {
                 dt.column(6).visible(true);
                $(".hide_clm7").html('<li><input type="checkbox" name="hide_columns[]" value="6"> Publisher ');
            }else{
                dt.column(6).visible(false);
            }if (line_dimension.includes('8')) {
                 dt.column(7).visible(true);
                $(".hide_clm8").html('<li><input type="checkbox" name="hide_columns[]" value="7"> Website ');
            }else{
                dt.column(7).visible(false);
            }if (line_dimension.includes('9')) {
                 dt.column(8).visible(true);
                $(".hide_clm9").html('<li><input type="checkbox" name="hide_columns[]" value="8"> Zone ');
            }else{
                dt.column(8).visible(false);
            }if (line_dimension.includes('10')) {
                 dt.column(9).visible(true);
                $(".hide_clm10").html('<li><input type="checkbox" name="hide_columns[]" value="9"> Date ');
            }else{
                dt.column(9).visible(false);
            }if (line_dimension.includes('11')) {
                 dt.column(10).visible(true);
                $(".hide_clm11").html('<li><input type="checkbox" name="hide_columns[]" value="10"> ISP ');
            }else{
                dt.column(10).visible(false);
            }if (line_dimension.includes('12')) {
                 dt.column(11).visible(true);
                $(".hide_clm12").html('<li><input type="checkbox" name="hide_columns[]" value="11"> Domain ');
            }else{
                dt.column(11).visible(false);
            }if (line_dimension.includes('13')) {
                 dt.column(12).visible(true);
                $(".hide_clm13").html('<li><input type="checkbox" name="hide_columns[]" value="12"> App Type ');
            }else{
                dt.column(12).visible(false);
            }
            
        }

        // Hide & show columns
        $('.items').click(function() {
            var checked_arr = [];
            var unchecked_arr = [];
            $.each($('input[type="checkbox"]:checked'), function(key, value) {
                checked_arr.push(this.value);
            });
            // Read all unchecked checkboxes
            $.each($('input[type="checkbox"]:not(:checked)'), function(key, value) {
                unchecked_arr.push(this.value);
            });

            // Hide the checked columns
            empDataTable.columns(checked_arr).visible(false);
            // Show the unchecked columns
            empDataTable.columns(unchecked_arr).visible(true);
        });  
    }


    $(document).ready(function() {
        var d = new Date();
        var strDate = d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + d.getDate();
        $('#period_end').val(strDate);
        $("#period_start").val(strDate);
        $('#period_end').trigger("change");
    });
    $(document).on('change', '#period_preset', function() {
        // console.log('test');
        var val = $(this).val();
        // console.log(val);
        var d = new Date();
        if (val == 1) {
            var strDate = d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + d.getDate();
            $('#period_end').val(strDate);
            $("#period_start").val(strDate);
            $('#period_end').trigger("change");
        } else if (val == 2) {
            var strDate = d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + (d.getDate() - 1);
            $('#period_end').val(strDate);
            $("#period_start").val(strDate);
            $('#period_end').trigger("change");
        } else if (val == 3) {
            var current = new Date(); // get current date    
            var weekstart = current.getDate() - current.getDay() + 1;
            var weekend = weekstart + 6; // end day is the first day + 6 
            var d = new Date(current.setDate(weekstart));
            var strDate = d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + d.getDate();
            var e = new Date();
            var endDate = e.getFullYear() + "-" + (e.getMonth() + 1) + "-" + e.getDate();
            $('#period_start').val(strDate);
            $("#period_end").val(endDate);
            $('#period_end').trigger("change");
        } else if (val == 4) {
            d.setTime(d.getTime() - (d.getDay() ? d.getDay() : 7) * 24 * 60 * 60 * 1000);
            $("#period_end").val(d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + d.getDate());
            d.setTime(d.getTime() - 6 * 24 * 60 * 60 * 1000);
            $("#period_start").val(d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + d.getDate());
            $('#period_end').trigger("change");
        } else if (val == 5) {
            var date = new Date();
            var last = new Date(date.getTime() - (7 * 24 * 60 * 60 * 1000));
            var day =last.getDate();
            var month=last.getMonth()+1;
            var year=last.getFullYear();
            var strDate = year + "-" + month + "-" + day;
            var endDate = d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + (d.getDate());
            $('#period_end').val(endDate);
            $("#period_start").val(strDate);
            $('#period_end').trigger("change");
        } else if (val == 6) {
            var firstDay = new Date(d.getFullYear(), d.getMonth(), 1);
            var lastDay = new Date(d.getFullYear(), d.getMonth() + 1, 0);
            var strDate = firstDay.getFullYear() + "-" + (firstDay.getMonth() + 1) + "-" + (firstDay.getDate());
            var endDate = lastDay.getFullYear() + "-" + (lastDay.getMonth() + 1) + "-" + (lastDay.getDate());
            $('#period_start').val(strDate);
            $("#period_end").val(endDate);
            $('#period_end').trigger("change");
        } else if (val == 7) {
            var prevMonthLastDate = new Date(d.getFullYear(), d.getMonth(), 0);
            var prevMonthFirstDate = new Date(d.getFullYear() - (d.getMonth() > 0 ? 0 : 1), (d.getMonth() - 1 + 12) % 12, 1);
            var strDate = prevMonthFirstDate.getFullYear() + "-" + (prevMonthFirstDate.getMonth() + 1) + "-" + (prevMonthFirstDate.getDate());
            var endDate = prevMonthLastDate.getFullYear() + "-" + (prevMonthLastDate.getMonth() + 1) + "-" + (prevMonthLastDate.getDate());
            $('#period_start').val(strDate);
            $("#period_end").val(endDate);
            $('#period_end').trigger("change");
        } else if (val == 8) {
            var strDate = '1970-01-01';
            var endDate = d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + d.getDate();
            $('#period_start').val('');
            $("#period_end").val('');
            $('#period_end').trigger("change");
        }
    });

    function getChartData(start_date, end_date, line_dimension = '') {
               
        generateTable();
        dropdownmenu();
    }

    $(document).on('change', '#period_end', function() {
        var start_date = $('#period_start').val();
        var end_date = $('#period_end').val();
                 var val = $('#period_preset').val();

        if (val == 8) {
            var d = new Date();
            
            var start_date = '2019-08-01';
            var end_date = d.getFullYear()+"-"+(d.getMonth()+1)+"-"+d.getDate();
        }
        var line_dimension = $('.line_dimension').val();
        var change_start_date = new Date(start_date);
        var change_end_date = new Date(end_date);
        if (change_start_date && end_date) {
            if (change_start_date <= change_end_date) {
                getChartData(start_date, end_date, line_dimension);
            } else {
                $('#period_end').val('');
                $('#period_start').val('');
               alert('Start date must be less than end data');
            }
        }
    });

    function catcalc(cal, type) {
        var date = cal.date;
        var time = date.getTime()
        var field = document.getElementById(type);
        var date2 = new Date(time);
        field.value = date2.print("%Y-%m-%d");
        $('#period_end').trigger("change");
    }
    Calendar.setup({
        inputField: 'period_start',
        ifFormat: '%Y-%m-%d',
        button: 'period_start_button',
        align: 'Bl',
        weekNumbers: false,
        firstDay: 1,
        electric: false,
        onSelect: function(cal) {
            catcalc(cal, 'period_start')
        }
    });
    Calendar.setup({
        inputField: 'period_end',
        ifFormat: '%Y-%m-%d',
        button: 'period_end_button',
        align: 'Bl',
        weekNumbers: false,
        firstDay: 1,
        electric: false,
        onSelect: function(cal) {
            catcalc(cal, 'period_end')
        }
    });

    function dropdownmenu() {
        
        var checkList = document.getElementById('list1');
        var items = document.getElementById('items');
        checkList.getElementsByClassName('anchor')[0].onclick = function(evt) {
            if (items.classList.contains('visible')) {
                items.classList.remove('visible');
                items.style.display = "none";
            } else {
                items.classList.add('visible');
                items.style.display = "block";
            }
        }
        items.onblur = function(evt) {
            items.classList.remove('visible');
        }
        $(document).mouseup(function(e) {
            if ($(e.target).closest(".items").length === 0) {
                items.classList.remove('visible');
                items.style.display = "none";
            }
        });
    }

    $(document).on('change', '#inv_type', function() {
        $('#period_end').trigger("change");
    });

    /*$(document).on('click','.time-data',function(){
        var cur_date = $(this).attr('cur_date');
                var id = $('#ids').val();

        if (cur_date) {
            $('#table_report').DataTable({
                "sScrollX": "100%",
                "sScrollXInner": "200%",
                "scrollY": true,
                "scrollY": "200px",
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                'bDestroy': true,
                'bSort' : false,
                'pageLength' : 25,
                'lengthMenu': [[25], [25]],
                'bFilter' : false,
                'dom': 'l<"toolbar">Bfrtip',
                'buttons': [
                    {
                        extend: 'excel',
                        text: 'Excel',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':visible:not(.notexport)',
                        }
                    },
                    {
                        extend: 'csv',
                        text: 'CSV',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':visible:not(.notexport)',
                        }
                    },
                    {
                        extend: 'pdfHtml5',
                        text: 'PDF',
                        orientation: 'landscape',
                        pageSize: 'LEGAL',

                        className: 'btn btn-default',
                        exportOptions: {
                            columns: ':visible:not(.notexport)',

                        }
                    }
                ],
                'ajax': {
                    'url':'timewise_data_tables.php',
                    'data' : {'cur_date' : cur_date, 'type' : 10, 'id' : id}
                },
                'columns': [
                    { data: 'name' },
                    { data: 'name1' },
                    { data: 'data_type3' },
                    { data: 'data_type4' },
                    { data: 'data_type5' },
                    { data: 'data_type6' },
                    { data: 'data_type7' },
                    { data: 'data_type8' },
                    { data: 'data_type9' },
                    { data: 'data_type10' },
                    { data: 'data_type11' },
                    { data: 'data_type12' },
                    { data: 'data_type13' },
                    { data: 'data_type14' },
                    { data: 'request' },
                    { data: 'impressions' },
                    { data: 'passback' },
                    { data: 'views' },
                    { data: 'clicks' },
                    { data: 'conversions' },
                    { data: 'ctr' },
                    { data: 'vctr' },
                    { data: 'ecpm' },
                    { data: 'vecpm' },
                    { data: 'total_revenue' },
                    { data: 'pub_income' },
                    { data: 'ad_fill' },
                ]
                
            });
        } else {
            console.log('Something went wrong');
        }
    });*/

    var dt = $('#table_report').DataTable();
    dt.column(3).visible(false);
    dt.column(4).visible(false);

     var isOpen = 0;
    $(document).on('click','.switchTrigger',function() {
        if (isOpen == 0) {
            $(".accountSwitcher").addClass("expanded");
            $('accountSwitcherOverlay').css({ display: "block" });
            isOpen++;
        } else {
            $(".accountSwitcher").removeClass("expanded");
            $('accountSwitcherOverlay').css({ display: "none" });
            isOpen--;
        }
    });
})(jQuery);


function formatAMPM() {
    var d = new Date(),
    minutes = d.getMinutes().toString().length == 1 ? '0' + d.getMinutes() : d.getMinutes(),
    hours = d.getHours().toString().length == 1 ? '0' + d.getHours() : d.getHours(),
    ampm = d.getHours() >= 12 ? 'pm' : 'am',
    months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
    days = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
    
    return days[d.getDay()] + ' ' + months[d.getMonth()] + ' ' + d.getDate() + ' ' + d.getFullYear() + ' ' + hours + ':' + minutes + ampm;
}
