<?php

/*
+---------------------------------------------------------------------------+
| OpenX v${RELEASE_MAJOR_MINOR}                                                                |
| =======${RELEASE_MAJOR_MINOR_DOUBLE_UNDERLINE}                                                                |
|                                                                           |
| Copyright (c) 2003-2009 OpenX Limited                                     |
| For contact details, see: http://www.openx.org/                           |
|                                                                           |
| This program is free software; you can redistribute it and/or modify      |
| it under the terms of the GNU General Public License as published by      |
| the Free Software Foundation; either version 2 of the License, or         |
| (at your option) any later version.                                       |
|                                                                           |
| This program is distributed in the hope that it will be useful,           |
| but WITHOUT ANY WARRANTY; without even the implied warranty of            |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
| GNU General Public License for more details.                              |
|                                                                           |
| You should have received a copy of the GNU General Public License         |
| along with this program; if not, write to the Free Software               |
| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA |
+---------------------------------------------------------------------------+
$Id: logImpressionCountry.class.php 32394 2009-02-13 15:30:45Z david.keen $
*/

require_once LIB_PATH . '/Extension/deliveryLog/BucketProcessingStrategyFactory.php';
require_once LIB_PATH . '/Extension/deliveryLog/DeliveryLog.php';

/**
 * @package    Plugin
 * @subpackage openxDeliveryLogCountry
 */
class Plugins_DeliveryLog_OxLogAdvTracking_LogImpressionAdvTracking extends Plugins_DeliveryLog
{

    function getDependencies()
    {
        return array(
            'deliveryLog:oxLogAdvTracking:logImpressionAdvTracking' => array(
                'deliveryDataPrepare:oxDeliveryDataPrepare:dataCommon',
                'deliveryDataPrepare:oxDeliveryAdvTracking:dataAdvTracking'
            )
        );
    }

    /**
     * Returns the bucket table name
     *
     * @return string The bucket table bucket name without prefix.
     */
    function getBucketName()
    {
        return 'data_bkt_advtracking_m';
    }

    /**
     * Returns the columns in the bucket table.
     *
     * @return array Format: array(column name => column type, ...)
     */
    public function getBucketTableColumns()
    {
        $aColumns = array(
           'creative_id'    => self::INTEGER,
            'zone_id'        => self::INTEGER,
            'bundle_id'   => self::CHAR,
            'interval_start' => self::TIMESTAMP_WITHOUT_ZONE,
            'connection_type'   => self::CHAR,
            'brand'   => self::CHAR,
            'os'   => self::CHAR,
            'os_version'   => self::CHAR,
            'screen_height'   => self::CHAR,
            'screen_width'   => self::CHAR,
            'network'   => self::CHAR,
            'timezone'   => self::CHAR,
            'ud_id'   => self::CHAR,
            'user_agent'   => self::CHAR,
            'user_name'   => self::CHAR,
            'user_email'   => self::CHAR,
            'user_phno'   => self::INTEGER,
            'user_language'   => self::CHAR,
            'data_speed'   => self::CHAR,
            'device_type'   => self::CHAR,
            'didsha1'   => self::CHAR,
            'didmd5'   => self::CHAR,
            'count'          => self::INTEGER,
        );
        return $aColumns;
    }

    /**
     * Returns the bucket's destination statistics table name, that is,
     * the table that is defined in the component's plugin to store the
     * aggregate bucket data for the components, but without the table
     * prefix
     *
     * @return string The statistics table name without prefix.
     */
    public function getStatisticsName()
    {
        return 'stats_advtracking';
    }

    /**
     * A method that returns the bucket to statistics column mapping
     * for the component. Where multiple components migrate bucket data
     * into the same statistics table, it is a requirement that the
     * bucket source columns in the different components have identical
     * names.
     *
     * @return array See class Plugins_DeliveryLog::getStatisticsMigration()
     *               for description.
     */
    public function getStatisticsMigration()
    {
        $aMap = array(
            'method'           => 'aggregate',
            'bucketTable'            => $this->getBucketTableName(),
            'dateTimeColumn'   => 'interval_start',
            'groupSource'      => array(
                0 => 'interval_start',
                1 => 'creative_id',
                2 => 'zone_id',
                3 => 'bundle_id',
                4 => 'connection_type',
                5 => 'brand',
                6 => 'os',
                7 => 'os_version',
                8 => 'network',
                9 => 'screen_width',
                10 => 'screen_height',
                11 => 'user_name',
                12 => 'user_phno',
                13=> 'user_email',
                14 => 'user_language',
                15 => 'user_agent',
                16 => 'timezone',
                17 => 'data_speed',
                18 => 'device_type',
                19 => 'didmd5',
                20 => 'didsha1',
                21 => 'ud_id'
            ),
            'groupDestination' => array(
                0 => 'date_time',
                1 => 'creative_id',
                2 => 'zone_id',
                3 => 'bundle_id',
                4 => 'connection_type',
                5 => 'brand',
                6 => 'os',
                7 => 'os_version',
                8 => 'network',
                9 => 'screen_width',
                10 => 'screen_height',
                11 => 'user_name',
                12 => 'user_phno',
                13=> 'user_email',
                14 => 'user_language',
                15 => 'user_agent',
                16 => 'timezone',
                17 => 'data_speed',
                18 => 'device_type',
                19 => 'didmd5',
                20 => 'didsha1',
                21 => 'ud_id'
            ),
            'sumSource'        => array(
                0 => 'count'
            ),
            'sumDestination'   => array(
                0 => 'impressions'
            ),
            'sumDefault'       => array(
                0 => 0
            )
        );
        return $aMap;
    }

}

?>