<?php


require_once LIB_PATH . '/Extension/invocationTags/InvocationTags.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

/**
 *
 * Invocation tag plugin.
 *
 */
class Plugins_InvocationTags_OxInvocationTags_native extends Plugins_InvocationTags
{

    /**
     * Return name of plugin
     *
     * @return string
     */
    function getName()
    {
        return $this->translate("Native Video");
    }

    /**
     * Return the English name of the plugin. Used when
     * generating translation keys based on the plugin
     * name.
     *
     * @return string An English string describing the class.
     */
    function getNameEN()
    {
        return 'Native Video';
    }

    /**
     * Check if plugin is allowed
     *
     * @return boolean  True - allowed, false - not allowed
     */
    function isAllowed($extra)
    {
        $isAllowed = parent::isAllowed($extra);
        return true;
    }

    function getOrder()
    {
        parent::getOrder();
        return 13;
    }

    /**
     * Return list of options
     *
     * @return array    Group of options
     */
    function getOptionsList()
    {
        if (is_array($this->defaultOptions)) {
            if (in_array('cacheBuster', $this->defaultOptions)) {
                unset($this->defaultOptions['cacheBuster']);
            }
        }
        $options = array (
            'width'     => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'height'        => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
        );
        return $options;
    }

    /**
     * Return invocation code for this plugin (codetype)
     *
     * @return string
     */
    function generateInvocationCode()
    {
        $aComments = array(
            'SSL Delivery Comment' => '',
            'Comment'              => $this->translate("
  * This noscript section of this tag only shows image banners. There
  * is no width or height in these banners, so if you want these tags to
  * allocate space for the ad before it shows, you will need to add this
  * information to the <img> tag.
  *
  * If you do not want to deal with the intricities of the noscript
  * section, delete the tag (from <noscript>... to </noscript>). On
  * average, the noscript tag is called from less than 1% of internet
  * users."),
            );
        parent::prepareCommonInvocationData($aComments);

  /*VIDEO JS*/ 

        $conf = $GLOBALS['_MAX']['CONF'];
        $mi = &$this->maxInvocation;
        $zoneid=$mi->zoneid;
        $position=$mi->position;
        $width="300px";
        $height="250px";
        if (isset($_POST['width'])&& $_POST['width'] != 0) {
            $width = $mi->width."px";
        }
        if (isset($_POST['height'])&& $_POST['height'] != 0) {
            $height = $mi->height."px";
        }
    $way=$conf['webpath']['admin'].'/plugins/Outstream/delivery/native.php';
    $buffer  = "<script type='text/javascript'><!--//<![CDATA[
    var adurl = (location.protocol=='https:'?'https://$way':'http://$way');
    document.write (\"<\" + \"script language='JavaScript' \");
    document.write (\"type='text/javascript' src='\"+adurl);
    document.write (\"?zoneid={$zoneid}\");
    document.write (\"&amp;position={$position}";
    $buffer .="\");\n";
    $buffer .= "   document.write (\"&amp;loc=\" + escape(window.location));\n";
    $buffer .= "   if (document.referrer) document.write (\"&amp;referer=\" + escape(document.referrer));\n";
       $buffer .= "   document.write (\"&amp;display_width=\" + window.innerWidth);\n";
       
    $buffer .= "   document.write (\"'><\\/scr\"+\"ipt>\");\n";
    $buffer .= "//]]>--></script>"; 

        return $buffer;
    }

    function setInvocation(&$invocation) {

        $this->maxInvocation = &$invocation;
        $this->maxInvocation->canDetectCharset = true;

    }


}

?>
