<?php

require_once '../../../../init.php';
require_once '../../config.php';
require_once MAX_PATH . '/lib/OA/Admin/TemplatePlugin.php';

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

$inputVariables = array( 
	'entity', 'entityId',
	'startDate', 'endDate', 'dimension',
	'exportCsv', 'showAs', 'expandId');
MAX_commonRegisterGlobalsArray($inputVariables);
PEAR::pushErrorHandling(null);

require_once 'stats-api.php';
require_once 'stats-debug.php';
include_once 'lib/SmartyFunctions/function.url.php';
include_once 'lib/SmartyFunctions/modifier.formatNumber.php';
include_once 'VastAreaGraph.php';
include_once 'VastMultiAreaGraph.php';

// Entity 
$availableEntities = array(
	'advertiser',
	'campaign',
	'banner',
    'website',
    'zone'
);
if(!in_array($entity, $availableEntities))
{
	exit("Invalid input parameters");
}

$entityToRequiredAccess = array(
    'advertiser' => 'clients',
    'campaign' => 'campaigns',
    'banner' => 'banners',
    'website' => 'affiliates',
    'zone' => 'zones',
);
OA_Permission::enforceAccessToObject($entityToRequiredAccess[$entity], $entityId);
$entityId = (int)$entityId;
$startDate = urlencode($startDate);
$endDate = urlencode($endDate);

// "Show as" dropdown
$availableShowAs = array(
	'table' => "Table",
	//'graph-percentage' => "Graph (% of views)",
	//'graph-count' => "Graph (# of views)",
	
);
if(empty($showAs) || !isset($availableShowAs[$showAs])) {
	$showAs = 'table';
}
$showAs = 'table';
$selectedShowAs = $showAs;

// "View by" dimension
$availableDimensions = array();

if(in_array($entity, array('campaign', 'advertiser'))) {
	$availableDimensions['banner'] = "Banner";
	if($entity == 'advertiser') {
		$availableDimensions['campaign'] = "Campaign";
	}
}
if($entity == 'website') {
    $availableDimensions['zone'] = "Zone";
}
$availableDimensions += array(
	"day" => "Day", 
	"week" => "Week", 
	"month" => "Month", 
	"year" => "Year", 
	"hour-of-day" => "Hour of Day"
);
if(empty($dimension)) {
	$dimension = 'day';
}
$selectedDimension = $dimension;

// Period preset in calendar
$today = date('Y-m-d');
$yesterday = date('Y-m-d', strtotime('1 day ago'));
$sevenDaysAgo = date('Y-m-d', strtotime('7 days ago'));
$thirtyDaysAgo = date('Y-m-d', strtotime('30 days ago'));
$availableDateRanges = array(
	'Today' => array($today, $today),
	'Yesterday' => array($yesterday, $yesterday),
	'Last 7 days' => array($sevenDaysAgo, $today),
	'Last 30 days' => array($thirtyDaysAgo, $today),
);
if(empty($startDate) || empty($endDate)) {
	$defaultDateRange = 'Last 7 days';
	$startDate = $availableDateRanges[$defaultDateRange][0];
	$endDate = $availableDateRanges[$defaultDateRange][1];
}
if(($selectedDateRangeName = array_search(array($startDate,$endDate), $availableDateRanges)) === false) {
	$selectedDateRangeName = "$startDate - $endDate";
}

// BUILDING REPORT
$videoReport = new OX_rmVideo_Report();
$dataTable = $videoReport->getVastStatistics(
									$entity, 
									$entityId,
									$dimension,
									$startDate,
									$endDate );								
$columns = $videoReport->getColumnsIdToNameInOrder($availableDimensions[$dimension]);
$summaryRow = $videoReport->getSummaryRowFromDataTable($dataTable);

if(!empty($exportCsv)) {
	require_once "stats-export-csv.php";
    exit;
}

$graphMetricsToPlot = OX_rmVideo_Report::$graphMetricsToPlot; 
$graphEventsIdToName = $graphValues = array();

foreach($graphMetricsToPlot as $eventId) {
    $value = 0;
    if(isset($summaryRow[$eventId])) {
       $value = $summaryRow[$eventId];
    }
	$graphValues[$eventId] = $value;
	$graphEventsIdToName[$eventId] = OX_rmVideo_Report::$vastEventIdToEventName[$eventId];
}
$topGraph = new rmVastAreaGraph($graphValues, $graphEventsIdToName);	
$topGraphJSON = $topGraph->getJSON();
//~ var_dump($topGraphJSON);exit;
if($selectedShowAs != 'table') {
	if($selectedShowAs == 'graph-count') {
		$dataTableXLabelToDataSets = $videoReport->getDataTableForGraphCount($dataTable);
		$isPlottingPercentage = false;
	} elseif ($selectedShowAs == 'graph-percentage') {
		$dataTableXLabelToDataSets = $videoReport->getDataTableForGraphPercentage($dataTable);
		$isPlottingPercentage = true;
	}
	$bottomGraph = new rmVastMultiAreaGraph($dataTableXLabelToDataSets, $graphEventsIdToName, $isPlottingPercentage);
	$bottomGraphJSON = $bottomGraph->getJSON();
}

// Expanded row
if($selectedDimension == 'campaign') {
	// Campaigns expand to Banners
	$selectedDimensionExpanded = 'banner';
} elseif($selectedDimension == 'banner') {
	// Banners do not expand
	$selectedDimensionExpanded = false;
} elseif($selectedDimension == 'zone') {
	// Zones do not expand
	$selectedDimensionExpanded = false;
} else if($entity == 'advertiser') {
	// Date expands to show Sub Campaigns when looking at an advertiser
	$selectedDimensionExpanded = 'campaign';
} else if($entity == 'campaign') {
	// Date expands to show Sub Banners when looking at a campaign
	$selectedDimensionExpanded = 'banner';
} else if($entity == 'website') {
	// Websites expand to Zones
	$selectedDimensionExpanded = 'zone';
} else{
	// Date do not expand when looking at Banners or Zones
	$selectedDimensionExpanded = false;
}

if($selectedDimensionExpanded && !empty($expandId)) {
	$expandedDataTable = $videoReport->getVastStatistics(
									$entity, 
									$entityId,
									$selectedDimensionExpanded,
									$startDate,
									$endDate,
									$dimension,
									$expandId 
									 );
}
;

$isThereAnyData = sizeof($summaryRow[1]);

// $isThereAnyData = @$summaryRow[1] > 0;


/* reviveadservermod.com - Chart Start*/

$clientid    = $_GET['clientid'] ? $_GET['clientid'] : '';
$campaignid  = $_GET['campaignid'] ? $_GET['campaignid'] : '';
$bannerid    = $_GET['bannerid'] ? $_GET['bannerid'] : '';
$affiliateid = $_GET['affiliateid'] ? $_GET['affiliateid'] : '';
$zoneid      = $_GET['zoneid'] ? $_GET['zoneid'] : '';

$start_date  = $startDate ? $startDate.' 00:00:00' : '';
$end_date    = $endDate ? $endDate.' 23:59:59' : '';

$timezone = $GLOBALS['_MAX']['PREF']['timezone'];
date_default_timezone_set($timezone);
$Starts = strtotime($start_date);
$Ends = strtotime($end_date);
date_default_timezone_set("UTC");
$start_date = date("Y-m-d H:i:s", $Starts);
$end_date 	= date("Y-m-d H:i:s", $Ends);

$dateList = array();
$iaChart1 = array();
$iaChart2 = array();
$iaChart3 = array();
$iaChart4 = array();
$iaChart5 = array();

if(!empty($clientid))
{
	$Wher = "AND c.clientid = '{$clientid}'";
	
	if(!empty($clientid) && !empty($campaignid))
	{
		$Wher = "AND c.clientid = '{$clientid}' AND b.campaignid = '{$campaignid}'";
	}	
	else if(!empty($clientid) && !empty($campaignid) && !empty($bannerid))
	{
		$Wher = "AND c.clientid = '{$clientid}' AND b.campaignid = '{$campaignid}' AND s.creative_id = '{$bannerid}'";
	}
	
	if($_GET['dimension'] == 'banner')
	{
		$field = 's.creative_id as dimension_id, b.description as dimension_name';
	}
	else if($_GET['dimension'] == 'campaign')
	{
		$field = ' b.campaignid as dimension_id, c.campaignname as dimension_name';
	}
	else if($_GET['dimension'] == 'week')
	{
		$field = "DATE_FORMAT(interval_start, 'Week %v (%x)') as dimension_id, DATE_FORMAT(interval_start, 'Week %v (%x)') as dimension_name";
	}
	else if($_GET['dimension'] == 'month')
	{
		$field = "DATE_FORMAT(interval_start, '%M %Y') as dimension_id, DATE_FORMAT(interval_start, '%M %Y') as dimension_name";
	}
	else if($_GET['dimension'] == 'year')
	{
		$field = " DATE_FORMAT(interval_start, '%Y') as dimension_id, DATE_FORMAT(interval_start, '%Y') as dimension_name";
	}
	else if($_GET['dimension'] == 'hour-of-day')
	{
		$field = "DATE_FORMAT(interval_start, '%kh') as dimension_id, DATE_FORMAT(interval_start, '%kh') as dimension_name";
	}    
	else
	{
		$field = 'DATE(interval_start) as dimension_id, DATE(interval_start) as dimension_name';
	}
	$AllDate = OA_Dal_Delivery_query("SELECT sum(count) as count, ".$field.", vast_event_id as event_id FROM ".$table_prefix."stats_djaxvast AS s JOIN ".$table_prefix."banners as b ON s.creative_id = b.bannerid JOIN ".$table_prefix."campaigns AS c ON b.campaignid = c.campaignid WHERE interval_start >='".$start_date."' AND interval_start <='".$end_date."' ".$Wher." AND s.count != 0 AND s.vast_event_id IN (1,2,3,4,5) GROUP BY dimension_id") or die("time error");			
	if(OA_Dal_Delivery_numRows($AllDate) > 0 ) 
	{							
		while($rows = OA_Dal_Delivery_fetchAssoc($AllDate))
		{
			$dateList[] = $rows['dimension_name'];
		}
	}

	$StartedEnv = OA_Dal_Delivery_query("SELECT sum(count) as count, ".$field.", vast_event_id as event_id FROM ".$table_prefix."stats_djaxvast AS s JOIN ".$table_prefix."banners as b ON s.creative_id = b.bannerid JOIN ".$table_prefix."campaigns AS c ON b.campaignid = c.campaignid WHERE interval_start >='".$start_date."' AND interval_start <='".$end_date."' ".$Wher." AND s.vast_event_id = 1 AND s.count != 0 GROUP BY dimension_id, vast_event_id ORDER BY interval_start, vast_event_id ASC") or die("time error");
	
	
	if(OA_Dal_Delivery_numRows($StartedEnv) > 0 ) 
	{							
		while($row1 = OA_Dal_Delivery_fetchAssoc($StartedEnv))
		{
			$iaChart1[$row1['dimension_name']] = $row1['count'];
		}
	}

	$Viewed25Env = OA_Dal_Delivery_query("SELECT sum(count) as count, ".$field.", vast_event_id as event_id FROM ".$table_prefix."stats_djaxvast AS s JOIN ".$table_prefix."banners as b ON s.creative_id = b.bannerid JOIN ".$table_prefix."campaigns AS c ON b.campaignid = c.campaignid WHERE interval_start >='".$start_date."' AND interval_start <='".$end_date."' ".$Wher." AND s.vast_event_id = 2 AND s.count != 0 GROUP BY dimension_id, vast_event_id ORDER BY interval_start, vast_event_id ASC") or die("time error");			
	if(OA_Dal_Delivery_numRows($Viewed25Env) > 0 ) 
	{							
		while($row2 = OA_Dal_Delivery_fetchAssoc($Viewed25Env))
		{
			$iaChart2[$row2['dimension_name']] = $row2['count'];
		}
	}

	$Viewed50Env = OA_Dal_Delivery_query("SELECT sum(count) as count, ".$field.", vast_event_id as event_id FROM ".$table_prefix."stats_djaxvast AS s JOIN ".$table_prefix."banners as b ON s.creative_id = b.bannerid JOIN ".$table_prefix."campaigns AS c ON b.campaignid = c.campaignid WHERE interval_start >='".$start_date."' AND interval_start <='".$end_date."' ".$Wher." AND s.vast_event_id = 3 AND s.count != 0 GROUP BY dimension_id, vast_event_id ORDER BY interval_start, vast_event_id ASC") or die("time error");			
	if(OA_Dal_Delivery_numRows($Viewed50Env) > 0 ) 
	{							
		while($row3 = OA_Dal_Delivery_fetchAssoc($Viewed50Env))
		{
			$iaChart3[$row3['dimension_name']] = $row3['count'];
		}
	}

	$Viewed75Env = OA_Dal_Delivery_query("SELECT sum(count) as count, ".$field.", vast_event_id as event_id FROM ".$table_prefix."stats_djaxvast AS s JOIN ".$table_prefix."banners as b ON s.creative_id = b.bannerid JOIN ".$table_prefix."campaigns AS c ON b.campaignid = c.campaignid WHERE interval_start >='".$start_date."' AND interval_start <='".$end_date."' ".$Wher." AND s.vast_event_id = 4 AND s.count != 0 GROUP BY dimension_id, vast_event_id ORDER BY interval_start, vast_event_id ASC") or die("time error");			
	if(OA_Dal_Delivery_numRows($Viewed75Env) > 0 ) 
	{							
		while($row4 = OA_Dal_Delivery_fetchAssoc($Viewed75Env))
		{
			$iaChart4[$row4['dimension_name']] = $row4['count'];
		}
	}

	$CompletedEnv = OA_Dal_Delivery_query("SELECT sum(count) as count, ".$field.", vast_event_id as event_id FROM ".$table_prefix."stats_djaxvast AS s JOIN ".$table_prefix."banners as b ON s.creative_id = b.bannerid JOIN ".$table_prefix."campaigns AS c ON b.campaignid = c.campaignid WHERE interval_start >='".$start_date."' AND interval_start <='".$end_date."' ".$Wher." AND s.vast_event_id = 5 AND s.count != 0 GROUP BY dimension_id, vast_event_id ORDER BY interval_start, vast_event_id ASC") or die("time error");			
	if(OA_Dal_Delivery_numRows($CompletedEnv) > 0 ) 
	{							
		while($row5 = OA_Dal_Delivery_fetchAssoc($CompletedEnv))
		{
			$iaChart5[$row5['dimension_name']] = $row5['count'];
		}
	}
}
else if(!empty($affiliateid))
{	
	$Wher = "a.affiliateid = '{$affiliateid}'";
	
	if(!empty($affiliateid) && !empty($zoneid))
	{
		$Wher = "a.affiliateid = '{$affiliateid}' AND s.zone_id = '{$zoneid}'";
	}
	
	if($_GET['dimension'] == 'zone')
	{
		$field = 'zone_id as dimension_id, z.zonename as dimension_name';
	}
	else if($_GET['dimension'] == 'week')
	{
		$field = "DATE_FORMAT(interval_start, 'Week %v (%x)') as dimension_id, DATE_FORMAT(interval_start, 'Week %v (%x)') as dimension_name";
	}
	else if($_GET['dimension'] == 'month')
	{
		$field = "DATE_FORMAT(interval_start, '%M %Y') as dimension_id, DATE_FORMAT(interval_start, '%M %Y') as dimension_name";
	}
	else if($_GET['dimension'] == 'year')
	{
		$field = " DATE_FORMAT(interval_start, '%Y') as dimension_id, DATE_FORMAT(interval_start, '%Y') as dimension_name";
	}
	else if($_GET['dimension'] == 'hour-of-day')
	{
		$field = "DATE_FORMAT(interval_start, '%kh') as dimension_id, DATE_FORMAT(interval_start, '%kh') as dimension_name";
	}    
	else
	{
		$field = 'DATE(interval_start) as dimension_id, DATE(interval_start) as dimension_name';
	}
	
	$AllDate = OA_Dal_Delivery_query("SELECT sum(count) as count, ".$field.", vast_event_id as event_id FROM ".$table_prefix."stats_djaxvast AS s JOIN ".$table_prefix."zones as z ON s.zone_id = z.zoneid JOIN ".$table_prefix."affiliates as a ON a.affiliateid = z.affiliateid WHERE ".$Wher." AND  interval_start >='".$start_date."' AND interval_start <='".$end_date."' AND s.count != 0 AND s.vast_event_id IN (1,2,3,4,5) GROUP BY dimension_id") or die("time error");				
	
	if(OA_Dal_Delivery_numRows($AllDate) > 0 ) 
	{							
		while($rows = OA_Dal_Delivery_fetchAssoc($AllDate))
		{
			$dateList[] = $rows['dimension_name'];
		}
	}

	$StartedEnv = OA_Dal_Delivery_query("SELECT sum(count) as count, ".$field.", vast_event_id as event_id FROM ".$table_prefix."stats_djaxvast AS s JOIN ".$table_prefix."zones as z ON s.zone_id = z.zoneid JOIN ".$table_prefix."affiliates as a ON a.affiliateid = z.affiliateid WHERE ".$Wher." AND  interval_start >='".$start_date."' AND interval_start <='".$end_date."' AND s.count != 0 AND s.vast_event_id = 1 GROUP BY dimension_id, vast_event_id ORDER BY interval_start, vast_event_id ASC") or die("time error");

	if(OA_Dal_Delivery_numRows($StartedEnv) > 0 ) 
	{							
		while($row1 = OA_Dal_Delivery_fetchAssoc($StartedEnv))
		{
			$iaChart1[$row1['dimension_name']] = $row1['count'];
		}
	}

	$Viewed25Env = OA_Dal_Delivery_query("SELECT sum(count) as count, ".$field.", vast_event_id as event_id FROM ".$table_prefix."stats_djaxvast AS s JOIN ".$table_prefix."zones as z ON s.zone_id = z.zoneid JOIN ".$table_prefix."affiliates as a ON a.affiliateid = z.affiliateid WHERE ".$Wher." AND  interval_start >='".$start_date."' AND interval_start <='".$end_date."' AND s.count != 0 AND s.vast_event_id = 2 GROUP BY dimension_id, vast_event_id ORDER BY interval_start, vast_event_id ASC") or die("time error");			
	if(OA_Dal_Delivery_numRows($Viewed25Env) > 0 ) 
	{							
		while($row2 = OA_Dal_Delivery_fetchAssoc($Viewed25Env))
		{
			$iaChart2[$row2['dimension_name']] = $row2['count'];
		}
	}

	$Viewed50Env = OA_Dal_Delivery_query("SELECT sum(count) as count, ".$field.", vast_event_id as event_id FROM ".$table_prefix."stats_djaxvast AS s JOIN ".$table_prefix."zones as z ON s.zone_id = z.zoneid JOIN ".$table_prefix."affiliates as a ON a.affiliateid = z.affiliateid WHERE ".$Wher." AND  interval_start >='".$start_date."' AND interval_start <='".$end_date."' AND s.count != 0 AND s.vast_event_id = 3 GROUP BY dimension_id, vast_event_id ORDER BY interval_start, vast_event_id ASC") or die("time error");			
	if(OA_Dal_Delivery_numRows($Viewed50Env) > 0 ) 
	{							
		while($row3 = OA_Dal_Delivery_fetchAssoc($Viewed50Env))
		{
			$iaChart3[$row3['dimension_name']] = $row3['count'];
		}
	}

	$Viewed75Env = OA_Dal_Delivery_query("SELECT sum(count) as count, ".$field.", vast_event_id as event_id FROM ".$table_prefix."stats_djaxvast AS s JOIN ".$table_prefix."zones as z ON s.zone_id = z.zoneid JOIN ".$table_prefix."affiliates as a ON a.affiliateid = z.affiliateid WHERE ".$Wher." AND  interval_start >='".$start_date."' AND interval_start <='".$end_date."' AND s.count != 0 AND s.vast_event_id = 4 GROUP BY dimension_id, vast_event_id ORDER BY interval_start, vast_event_id ASC") or die("time error");			
	if(OA_Dal_Delivery_numRows($Viewed75Env) > 0 ) 
	{							
		while($row4 = OA_Dal_Delivery_fetchAssoc($Viewed75Env))
		{
			$iaChart4[$row4['dimension_name']] = $row4['count'];
		}
	}

	$CompletedEnv = OA_Dal_Delivery_query("SELECT sum(count) as count, ".$field.", vast_event_id as event_id FROM ".$table_prefix."stats_djaxvast AS s JOIN ".$table_prefix."zones as z ON s.zone_id = z.zoneid JOIN ".$table_prefix."affiliates as a ON a.affiliateid = z.affiliateid WHERE ".$Wher." AND  interval_start >='".$start_date."' AND interval_start <='".$end_date."' AND s.count != 0 AND s.vast_event_id = 5 GROUP BY dimension_id, vast_event_id ORDER BY interval_start, vast_event_id ASC") or die("time error");			
	if(OA_Dal_Delivery_numRows($CompletedEnv) > 0 ) 
	{							
		while($row5 = OA_Dal_Delivery_fetchAssoc($CompletedEnv))
		{
			$iaChart5[$row5['dimension_name']] = $row5['count'];
		}
	}
}
$ChartImp1 = '';
$ChartImp2 = '';
$ChartImp3 = '';
$ChartImp4 = '';
$ChartImp5 = '';

foreach($dateList as $key => $vals)
{
	$chart1 = $iaChart1[$vals] ? $iaChart1[$vals] : 0;
	$chart2 = $iaChart2[$vals] ? $iaChart2[$vals] : 0;
	$chart3 = $iaChart3[$vals] ? $iaChart3[$vals] : 0;
	$chart4 = $iaChart4[$vals] ? $iaChart4[$vals] : 0;
	$chart5 = $iaChart5[$vals] ? $iaChart5[$vals] : 0;
	
	$ChartImp1 .= ",".$chart1;
	$ChartImp2 .= ",".$chart2;
	$ChartImp3 .= ",".$chart3;
	$ChartImp4 .= ",".$chart4;
	$ChartImp5 .= ",".$chart5;
	
	$iMounth .= ",".$vals;
}

$iaChartDate = '';
$iaChartImp1 = '';
$iaChartImp2 = '';
$iaChartImp3 = '';
$iaChartImp4 = '';
$iaChartImp5 = '';

if(!empty($iMounth)) { $iaChartDate = ltrim($iMounth, ','); }
if(!empty($ChartImp1)) { $iaChartImp1 = ltrim($ChartImp1, ','); }	
if(!empty($ChartImp2)) { $iaChartImp2 = ltrim($ChartImp2, ','); }
if(!empty($ChartImp3)) { $iaChartImp3 = ltrim($ChartImp3, ','); }
if(!empty($ChartImp4)) { $iaChartImp4 = ltrim($ChartImp4, ','); }
if(!empty($ChartImp5)) { $iaChartImp5 = ltrim($ChartImp5, ','); }

/* reviveadservermod.com - Chart End*/

// TEMPLATE
$oTpl = new OA_Plugin_Template('video-report.html', 'VideoAds');
$oTpl->register_function('url', 'smarty_function_url');
$oTpl->register_modifier('formatNumber', 'smarty_modifier_formatNumber');
$oTpl->assign('isThereAnyData', $isThereAnyData );
$oTpl->assign('isThereAtLeastTwoDataPoints', $isThereAtLeastTwoDataPoints );
$oTpl->assign('entityName', ucfirst($entity));
$oTpl->assign('dataForTopGraphInJsonFormat', $topGraphJSON );
$oTpl->assign('dataForBottomGraphInJsonFormat', $bottomGraphJSON );
$oTpl->assign('dataTable', $dataTable);
$oTpl->assign('expandedDataTable', $expandedDataTable);
$oTpl->assign('selectedDimensionExpanded', urlencode($selectedDimensionExpanded));
$oTpl->assign('columns', $columns);
$oTpl->assign('summaryRow', $summaryRow);
$oTpl->assign('availableDateRanges', $availableDateRanges);
$oTpl->assign('thirtyDaysAgo', $thirtyDaysAgo);
$oTpl->assign('expandId', urlencode($expandId));
$oTpl->assign('today', $today);
$oTpl->assign('startDate', $startDate); 
$oTpl->assign('endDate', $endDate);
$oTpl->assign('selectedDateRangeName', $selectedDateRangeName);
$oTpl->assign('availableDimensions', $availableDimensions);
$oTpl->assign('selectedDimension', urlencode($selectedDimension));
$oTpl->assign('availableShowAs', $availableShowAs);
$oTpl->assign('selectedShowAs', urlencode($selectedShowAs));

/* reviveadservermod.com - Chart Start*/

$oTpl->assign('iaChartDate', $iaChartDate);
$oTpl->assign('iaChartImp1', $iaChartImp1);
$oTpl->assign('iaChartImp2', $iaChartImp2);
$oTpl->assign('iaChartImp3', $iaChartImp3);
$oTpl->assign('iaChartImp4', $iaChartImp4);
$oTpl->assign('iaChartImp5', $iaChartImp5);

/* reviveadservermod.com - Chart End*/

// VIEW
phpAds_PageHeader("stats-djaxvast-".$entity,'','../../');

$oTpl->display();

phpAds_PageFooter();
