<?php

	header("Access-Control-Allow-Origin: *");
	header("Content-Type: application/json; charset=UTF-8");
	header("Access-Control-Allow-Methods: POST");
	header("Access-Control-Max-Age: 3600");
	header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

	require_once '../../../../init.php';

	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
	}else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
	}else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
	}

      
	// Required files
	require_once MAX_PATH . '/lib/OA/Dal.php';      
	require_once MAX_PATH . '/lib/OA/Admin/Option.php';
	require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
	require_once MAX_PATH . '/www/admin/config.php';
	require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
     
    OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER, OA_ACCOUNT_TRAFFICKER, OA_ACCOUNT_ADMIN);
	
	## INITIALISATIN
   	$condition = '';
   	$getQuery = '';
   	$limit = "";
   	$id = "";
   	$groupby = "";
   	$data_type = " cl.clientname AS data_type1 ";


   	## REQUIRED POST VALIES
   	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   	$start_date = $_POST['start_date'];
   	$end_date = $_POST['end_date'];
   	$line_dimension = $_POST['line_dimension'];
	$rowperpage = $_POST['length']; // Rows display per page
	$columnIndex = $_POST['order'][0]['column']; // Column index
	$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
	$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
	$searchValue = $_POST['search']['value']; // Search value


   	//~ACCOUNT 
    if(isset($_POST['id']) && !empty($_POST['id'])) {
		
      $id = explode('=', $_POST['id']);
    }

    if(isset($id[0]) && $id[0] == 'clientid'){
      $condition = 'AND cl.clientid='.$id[1];
    }elseif(isset($id[0]) && $id[0] == 'pubid'){
      $condition = 'AND a.affiliateid='.$id[1];
    }elseif(isset($id[0]) && $id[0] == 'manager'){
      $condition = 'AND cl.agencyid='.$id[1];
    }

	
	## LINE DIMENSION
	if(!$line_dimension[0]) {

		$groupby = " GROUP BY cl.clientname ";

	}else{
		
		$groupby = " GROUP BY ";
		$data_type = "";
		$length  = sizeof($line_dimension);
		$i = 0;

		foreach ($line_dimension as $key) {

			if($key == 1){

				$groupby .= "c.campaignid ";
				$data_type .= " c.campaignname AS data_type1";

			}else if($key == 2){

				$groupby .= "b.bannerid ";
				$data_type .= " b.description AS data_type2";

			}else if($key == 3){

				$groupby .= "p.id ";
				$data_type .= " p.name AS data_type3";

			}else if($key == 4){

				$groupby .= "a.affiliateid ";
				$data_type .= " a.name AS data_type4";

			}else if($key == 5){

				$groupby .= "z.zonename ";
				$data_type .= " z.zonename AS data_type5";

			}else if($key == 6){

				$groupby .= "DATE(adh.date_time) ";
				$data_type .= " DATE(adh.date_time) AS data_type6";

			}else if($key == 7){

				$groupby .= "sco.country ";
				$data_type .= " sco.country AS data_type7";

			}$i++;
			if($i < $length){
				$groupby .= ',';
				$data_type .= ',';
			}

		}
	}

	//TOTAL RECORD COUNT
	
	$total_record = OA_Dal_Delivery_Query(" SELECT count(cl.clientname) AS count FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid {$extra_join} LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid WHERE adh.ad_id > 0 AND DATE(adh.date_time) >= '".$start_date."' AND DATE(adh.date_time) <= '". $end_date."' ".$condition." ".$groupby);

	$total_record = OA_Dal_Delivery_numRows($total_record);

	## RECORD COUNT
	if ($rowperpage == -1) {
		$limit = "";	## ALL RECORDS
	}else{
		$limit = "limit ".$_POST['start'].",".$_POST['length'];	## LIMITTED RECORDS
	}

	$getQuery = " SELECT {$data_type}, cl.clientname as name, SUM(adh.requests) as requests, SUM(adh.impressions) AS impressions, SUM(adh.clicks) AS clicks, SUM(adh.conversions) as conversions FROM {$table_prefix}clients cl LEFT JOIN {$table_prefix}campaigns c ON c.clientid = cl.clientid LEFT JOIN {$table_prefix}banners b ON b.campaignid = c.campaignid LEFT JOIN {$table_prefix}data_summary_ad_hourly adh ON adh.ad_id = b.bannerid {$extra_join} LEFT JOIN {$table_prefix}zones z ON z.zoneid = adh.zone_id LEFT JOIN {$table_prefix}affiliates a ON a.affiliateid = z.affiliateid WHERE adh.ad_id > 0 AND DATE(adh.date_time) >= '".$start_date."' AND DATE(adh.date_time) <= '". $end_date."' ".$condition." ".$groupby.$limit;

	
	$data = array();
	$getQuery = OA_Dal_Delivery_Query($getQuery);

	if (isset($getQuery) && !empty($getQuery)) {

		while ($row = OA_Dal_Delivery_fetchAssoc($getQuery)) {

		   	$data[] = array(

		   		"name"=>($row['name']) ? $row['name']: '-',
                "data_type1"=>($row['data_type1'] ? $row['data_type1'] : '-'),
                "data_type2"=>($row['data_type2']) ? $row['data_type2'] : '-',
                "data_type3"=>($row['data_type3']) ? $row['data_type3'] : '-',
                "data_type4"=>($row['data_type4']) ? $row['data_type4'] : '-',
                "data_type5"=>($row['data_type5']) ? $row['data_type5'] : '-',
                "data_type6"=>($row['data_type6']) ? $row['data_type6'] : '-',
                "data_type7"=>($row['data_type7']) ? $row['data_type7'] : '-',

		      	"request"=>$row['requests'],
		      	"impressions"=>$row['impressions'],
		      	"clicks"=>$row['clicks'],
		      	"conversions"=>$row['conversions'],
                "ctr" => ($row['impressions'] > 0)? round($row['clicks']/$row['impressions']*100, 2) : 0.00
		   );
		}
	}
	

	## Response
	$response = array(
	  "draw" => intval($draw),
	  "iTotalRecords" => $total_record,
	  "iTotalDisplayRecords" => $total_record,
	  "aaData" => $data
	);

	echo json_encode($response);
	exit();
?>
    
		
