<?php
require_once '../../../../init.php';
require_once MAX_PATH . '/lib/pear/Date.php';
require_once 'lib/Csv.php';
require_once MAX_PATH . '/www/admin/config.php';

$oDbh = &OA_DB::singleton();

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
$tab_advanced_report = $oDbh->quoteIdentifier($table_prefix . 'dj_dsp_advanced_reports',true);
$tab_advanced = $oDbh->quoteIdentifier($table_prefix . 'dj_dsp_adv_report_device_type',true);

$start_date = $_GET['start_date'];
$end_date = $_GET['end_date'];


$tb_select = "SELECT ".$tab_advanced.".device_type ,
					sum(request_count) as request_count,
					sum(response_count) as response_count,
					sum(wing_notice_count) as wing_count";
					
$tb_from ="FROM ".$tab_advanced_report." INNER JOIN ".$tab_advanced." ON ".$tab_advanced_report.".device_type = ".$tab_advanced.".id ";

$tb_where =  "WHERE datatime BETWEEN '".$start_date."' and '".$end_date."'  AND ".$tab_advanced.".device_type !=''	";
$tb_group ="GROUP BY device_type";

$query = $tb_select." ".$tb_from." ".$tb_where." ".$tb_group;


$rsReport = $oDbh->query($query)->fetchAll();
$columns=array(0=>'Device Type', 1=>'Request', 2=>'Response', 3=>'Wing Notice');

$rows = array();

foreach($rsReport as $r)
{
	$rows[] =  array(0=>$r['device_type'],1=>$r['request_count'],2=>$r['response_count'],3=>$r['wing_count']);
}

if(count($rows)>0)
{
	$toExport = array_merge(array( $columns ),$rows);
}
else{ 
	$rows[]= array(0=>'No stats avilable');
	$toExport = array_merge(array( $columns ),$rows);
}


if($_GET['period_preset']=='all_stats')
{
	$filename = 'Device_Type_all_stats.csv';

}
else if(!empty($start_date) && !empty($end_date))
{

	$filename = 'Device_Type_Stats_'.date('Y-m-d',strtotime($start_date)).'_to_'.date('Y-m-d',strtotime($end_date)).'.csv';
}
else
{

	$filename = 'Device_Type_Stats.csv';
}


header('Content-Disposition:attachment;filename='.$filename);
header('Content-Type:application/vnd.ms-excel');

$csv = '';
foreach($toExport as $row) {
	$csv .= OX_Vast_Common_Csv::formatCsvLine($row);
}
 
echo $csv; 
exit;
