<?php

/*  PHP Paypal IPN Integration Class Demonstration File
 *  4.16.2005 - Micah Carrick, email@micahcarrick.com
 *
 *  This file demonstrates the usage of paypal.class.php, a class designed  
 *  to aid in the interfacing between your website, paypal, and the instant
 *  payment notification (IPN) interface.  This single file serves as 4 
 *  virtual pages depending on the "action" varialble passed in the URL. It's
 *  the processing page which processes form data being submitted to paypal, it
 *  is the page paypal returns a user to upon success, it's the page paypal
 *  returns a user to upon canceling an order, and finally, it's the page that
 *  handles the IPN request from Paypal.
 *
 *  I tried to comment this file, aswell as the acutall class file, as well as
 *  I possibly could.  Please email me with questions, comments, and suggestions.
 *  See the header of paypal.class.php for additional resources and information.
*/
///Set settings

require_once '../../../../init.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];


$getfee= OA_Dal_Delivery_query("SELECT * FROM `adv_set` ") or die("culnot select:".mysql_error());
$getval = OA_Dal_Delivery_fetchAssoc($getfee);



$notify_email = $getval ['notifyid'];
$paypal_email = $getval ['paypalid'];

$amountfor_signup = number_format($getval['advsignupfee'],2);

// Setup class
require_once('OAM_paypal.class.php');  // include the class file
$p = new paypal_class;             // initiate an instance of the class
// $p->paypal_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';   // testing paypal url
$p->paypal_url = 'https://www.paypal.com/cgi-bin/webscr';     // paypal url
            
// setup a variable for this script (ie: 'http://www.micahcarrick.com/paypal.php')
$this_script = 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];


// if there is not action variable, set the default action of 'process'
if (empty($_GET['action'])) $_GET['action'] = 'process';  

switch ($_GET['action']) {
    
   case 'process':      // Process and order...

      // There should be no output at this point.  To process the POST data,
      // the submit_paypal_post() function will output all the HTML tags which
      // contains a FORM which is submited instantaneously using the BODY onload
      // attribute.  In other words, don't echo or printf anything when you're
      // going to be calling the submit_paypal_post() function.
 
      // This is where you would have your form validation  and all that jazz.
      // You would take your POST vars and load them into the class like below,
      // only using the POST values instead of constant string expressions.
 
      // For example, after ensureing all the POST variables from your custom
      // order form are valid, you might have:
      //
      // $p->add_field('first_name', $_POST['first_name']);
      // $p->add_field('last_name', $_POST['last_name']);
      
      $p->add_field('business', $paypal_email);             //Give here your email id
      $p->add_field('return', $this_script.'?action=success&cid='.$_GET['cid']);
      $p->add_field('cancel_return', $this_script.'?action=cancel&cid='.$_GET['cid']);
      $p->add_field('notify_url', $this_script.'?action=ipn&cid='.$_GET['cid']);         
      $p->add_field('item_name', 'Paypal Transaction');
      $p->add_field('amount', $amountfor_signup);                                 //Amount for Signup   

      $p->submit_paypal_post(); // submit the fields to paypal
      //$p->dump_fields();      // for debugging, output a table of all the fields
      break;
      
   case 'success':      // Order was successful...

      // This is where you would probably want to thank the user for their order
      // or what have you.  The order information at this point is in POST 
      // variables.  However, you don't want to "process" the order until you
      // get validation from the IPN.  That's where you would have the code to
      // email an admin, update the database with payment status, activate a
      // membership, etc.  
 
	  OA_Dal_Delivery_query("Update oxm_tempsignup set isapproved=1 Where id=".$_GET['cid']) or die("Something is wrong in cid");	
	  $query=OA_Dal_Delivery_query("SELECT * FROM oxm_tempsignup  Where id=".$_GET['cid']) or die("Something is wrong in cid");
            $result=OA_Dal_Delivery_fetchAssoc($query);
            //~ header("Location: index.php");
      // You could also simply re-direct them to another page, or your own 
      // order status page which presents the user with the status of their
      // order based on a database (which can be modified with the IPN code 
      // below).

					?>
					<div style="margin:50px;line-height:2;width:650px; word-spacing:2px;font-size:15px;color:#14773A; " id="message">  Dear <strong><?php echo $result['username']; ?></strong>, <br/>
					You have successfully registered. Your account  details have been sent to administrator for approval. You will be informed our decision via provided email id. </div>

					<?php 
		
					$url='http://'.$GLOBALS['_MAX']['CONF']['webpath']['admin']; ?>

					<meta http-equiv="refresh" content="2;url=<?php echo $url?>" /> <?php 

					?>

					<div style="margin:50px;line-height:2;width:50px; word-spacing:2px;font-size:15px;color:#14773A; " id="message">Regards,  <b>Administrator</b>.
					</div>
					<?php
					//~ $index_url="http://".$GLOBALS['_MAX']['CONF']['webpath']['admin']."/index.php";
					//~ header("Location: ".$index_url);
	  
      
      break;
      
   case 'cancel':       // Order was canceled...

      // The order was canceled before being completed.
	//DELETE+FROM+%60".$table_prefix."clients%60+WHERE+%60".$table_prefix."clients%60.%60clientid%60+%3D+23
	
	  
 	OA_Dal_Delivery_query("Delete from  oxm_tempsignup  where tempid=".$_GET['cid']) or die("Something is wrong");
 
      header("Location: index.php");
      
      break;
      
   case 'ipn':          // Paypal is calling page for IPN validation...
   
      // It's important to remember that paypal calling this script.  There
      // is no output here.  This is where you validate the IPN data and if it's
      // valid, update your database to signify that the user has payed.  If
      // you try and use an echo or printf function here it's not going to do you
      // a bit of good.  This is on the "backend".  That is why, by default, the
      // class logs all IPN data to a text file.
      //$_GET['test']=1;
      if ($p->validate_ipn() /*|| $test == 1*/ ) {
	
	 
	  
	
         // Payment has been recieved and IPN is verified.  This is where you
         // update your database to activate or process the order, or setup
         // the database with the user's order details, email an administrator,
         // etc.  You can access a slew of information via the ipn_data() array.
  
         // Check the paypal documentation for specifics on what information
         // is available in the IPN POST variables.  Basically, all the POST vars
         // which paypal sends, which we send back for validation, are now stored
         // in the ipn_data() array.
  
         // For this example, we'll just email ourselves ALL the data.
         $subject = 'Instant Payment Notification - Recieved Payment';
         $to = $notify_email;    //  your email
         $body =  "An instant payment notification was successfully recieved\n";
         $body .= "from ".$p->ipn_data['payer_email']." on ".date('m/d/Y');
         $body .= " at ".date('g:i A')."\n\nDetails:\n";
         
         foreach ($p->ipn_data as $key => $value) { $body .= "\n$key: $value"; }
         mail($to, $subject, $body);
		 header("Location: index.php");
      }
      break;
 }     

?>
