<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/lib/RV/Admin/Languages.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/www/admin/lib-zones.inc.php';
require_once MAX_PATH . '/lib/OA/Dll/Publisher.php';
require_once MAX_PATH . '/lib/OA/Admin/Menu.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH .'/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/lib/OA/Admin/Template.php';


if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];


// Register input variables
phpAds_registerGlobalUnslashed ('move', 'name', 'website', 'contact', 'email',
                               'errormessage', 'submit', 'publiczones_old', 'formId');

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_MANAGER);
OA_Permission::enforceAccessToObject('affiliates', $affiliateid, true);


/*-------------------------------------------------------*/
/* Store preferences									 */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['affiliateid'] = $affiliateid;
phpAds_SessionDataStore();

/*-------------------------------------------------------*/
/* Initialise data                                    */
/*-------------------------------------------------------*/
if ($affiliateid != "") {
    // Do not get this information if the page
    // is the result of an error message
    if (!isset($affiliate)) {
        $doAffiliates = OA_Dal::factoryDO('affiliates');
        if ($doAffiliates->get($affiliateid)) {
            $affiliate = $doAffiliates->toArray();
        }
    }
} else {
    //set some default
    $affiliate['website'] = 'http://';
}


/*-------------------------------------------------------*/
/* MAIN REQUEST PROCESSING                               */
/*-------------------------------------------------------*/

//build form
$websiteForm = buildWebsiteForm($affiliate);

if ($websiteForm->validate()) {
    //process submitted values
    $oPublisherDll = processForm($affiliateid, $websiteForm);
    if ($oPublisherDll->_errorMessage || $oPublisherDll->_noticeMessage) {
        displayPage($affiliateid, $websiteForm, $oPublisherDll);
    }
}
else { //either validation failed or form was not submitted, display the form
    displayPage($affiliateid, $websiteForm);
}


/*-------------------------------------------------------*/
/* Build form                                            */
/*-------------------------------------------------------*/
function buildWebsiteForm($affiliate)
{
    $form = new OA_Admin_UI_Component_Form("affiliateform", "POST", $_SERVER['SCRIPT_NAME']);
    $form->forceClientValidation(true);
    $form->addElement('hidden', 'affiliateid', $affiliate['affiliateid']);

    $form->addElement('header', 'basic_info', $GLOBALS['strBasicInformation']);
    $form->addElement('text', 'website', $GLOBALS['strWebsiteURL']);
    $form->addElement('text', 'name', $GLOBALS['strName']);
    $form->addElement('text', 'contact', $GLOBALS['strContact']);
    $form->addElement('text', 'email', $GLOBALS['strEMail']);

    /* reviveadservermod.com - Vast VMAP Start*/

    $azones = getSuitableZonesList($affiliate['affiliateid']);

    if(count($azones) > 0)
    {
        $header = $form->createElement('header', 'header_txt', "Create VMAP Video Settings");
        $form->addElement($header);
        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $tempQuery=OA_Dal_Delivery_query("select * from {$table_prefix}affiliates where affiliateid='".$affiliate['affiliateid']."' AND vmapcount != 0 ");

        if(OA_Dal_Delivery_numRows($tempQuery) > 0 )
        {            
            $row=OA_Dal_Delivery_fetchAssoc($tempQuery);
            $vmapcount1  = $row['vmapcount'];
            $vmap_obj = $row['vmapobjects'];
            $vmapobjects  = json_decode($row['vmapobjects'],true);

            $someObject = json_decode($row['vmapobjects']);
            $temp_vmap=array_values($vmapobjects['vmap']);
            $temp_zone=array_values($vmapobjects['zoneid']);
            $temp_breaktype = array_values($vmapobjects['breaktype']);
            $temp_allowmultipleAds = array_values($vmapobjects['allowmultipleAds']);
            $temp_vmapoffsetadbreak = array_values($vmapobjects['vmap_offset_adbreak']);
            $temp_offsetsetting   = array_values($vmapobjects['offsetsetting']);
            $temp_vmapurl = array_values($vmapobjects['vmapurl']);
            $temp_adbreak   = array_values($vmapobjects['adbreak']);

            $a = array_keys($vmapobjects['vmapurl']);
            $j = 0;              

            if($vmapobjects['offsetsetting'][0] == 'time')
            {
                $selectiontime= 'checked=checked';
                $offsetlable = 'Time';
            }
            else
            {
                $selectiontime= '';
            }   

            $offset[] = $form->createElement('radio', 'offsetsetting[0]','',"Time",'time',array('id' => 'time_0','class'=>'time',$selectiontime,'onClick' => 'vmaptime(this.id)'));

            if($vmapobjects['offsetsetting'][0] == 'percentage')
            {
                $selectionpercentage= 'checked=checked';
                $offsetlable = 'Percentage';
            }
            else
            {
                $selectionpercentage= '';
            }   

            $offset[] = $form->createElement('radio', 'offsetsetting[0]','', "Percentage",'percentage',array('id' => 'percentage_0',$selectionpercentage,'class'=>'percentage','onClick' => 'vmaptime(this.id)'));
            $form->addGroup($offset, 'Offset', 'Offset', "<br/>");

            for($j=0;$j<count($a);$j++)
            {
                $offset = '';
                $breaktype = [];

                // multile ads
                $checkmultiple = $form->createElement('checkbox','allowmultipleAds['.$j.']', 'Allow Mulitple ads');
                $checkmultiple->setAttribute('class','allowmultipleAds'); 
                $checkmultiple-> setAttribute('id','allowmultipleAds_'.$j);

                if(ISSET($vmapobjects['allowmultipleAds'][$a[$j]]) && $vmapobjects['allowmultipleAds'][$a[$j]] == 1)
                {
                    $checkmultiple->setAttribute('checked','checked');
                }
                else
                {
                    $checkmultiple->setAttribute('','');
                }   

                $form->addElement($checkmultiple);

                // ad breaks url options

                if($vmapobjects['vmapurl'][$a[$j]] == 'Internal')
                {
                    $selectioninternal= 'checked=checked';
                }
                else
                {
                    $selectioninternal= '';
                }

                $breaktype['linear1'] = $form->createElement('radio', 'vmapurl['.$j.']', '',"Internal",'Internal', array('id' => 'internal_'.$j,'class'=>'Internal',$selectioninternal,'onClick' => 'vmapinternal(this.id);'));

                if($vmapobjects['vmapurl'][$a[$j]] == 'External')
                {
                    $selectionexternal= 'checked=checked';
                }
                else
                {
                    $selectionexternal= '';
                }   

                $breaktype['nonlinear1'] = $form->createElement('radio', 'vmapurl['.$j.']', '', "External",'External', array('id' => 'non-linear_'.$j,'class'=>'External',$selectionexternal,'onClick' => 'vmapexternal(this.id);'));
                $form->addGroup($breaktype, 'overlaycount', 'Ad tags', "<br/>");

                if($vmapobjects['vmapurl'][$a[$j]] == 'External')
                {
                    $externalurl = $form->createElement('text','adbreak['.$j.']','Ad break',array('value'=>$vmapobjects['adbreak'][$a[$j]]));
                    $externalurl->setAttribute('class','adbreak');
                    $externalurl->setAttribute('id','adbreak_'.$j);
                    $form->addElement($externalurl);
                }

                // vmap zone id 
                if($vmapobjects['vmapurl'][$a[$j]] == 'Internal')
                {
                    $aSettings =$form->createElement('select','zoneid['.$j.']','Zone id', array ('items'   => $azones));
                    $aSettings->setAttribute('class','zoneid');
                    $aSettings->setAttribute('id','zoneid_'.$j);
                    $aSettings->setValue($vmapobjects['zoneid'][$a[$j]]);
                    $form->addElement($aSettings);
                }

                if($vmapobjects['offsetsetting'][$a[$j]] == 'time')
                {
                    $selectiontime= 'checked=checked';
                }
                else
                {
                    $selectiontime= '';
                }   

                $offset =array();
                $offset = $form->createElement('radio', 'offsetsetting['.$j.']','',"Time",'time',array('id' => 'time_'.$j,'class'=>'time',$selectiontime,'onClick' => 'vmaptime(this.id)'));

                if($vmapobjects['offsetsetting'][$a[$j]] == 'percentage')
                {
                    $selectionpercentage= 'checked=checked';
                }
                else
                {
                    $selectionpercentage= '';
                }   

                // offset timimg 
                $offsettime = $form->createElement('text','vmap_offset_adbreak['.$j.']','Offset '.$offsetlable,array('value'=>$vmapobjects['vmap_offset_adbreak'][$a[$j]]));
                $offsettime->setAttribute('class','offset');
                $offsettime->setAttribute('id','offset_'.$j); 
                $offsettime->setAttribute('onchange','validateHhMm(this);');
                $form->addElement($offsettime);

                if($j > 0)
                {
                    $bSettings = $form->createElement('submit', '', 'Remove', array('id' => 'remove_'.$j,'class'=>'remove','onClick' => 'return vmapRemove(this.id)','type'=>'button'));
                    $form->addElement($bSettings);
                    $form->addGroup($overlayvmapFormats, 'overlaycount', '', "<br/>");
                }

            }

            // foreach close

            // vmap count 

            $vmapcount = $form->createElement('hidden','vmapcount','0');
            $vmapcount->setAttribute('class','vmapcount');
            $vmapcount->setAttribute('id','vmapcount');
            $vmapcount->setAttribute('value',$vmapcount1 - 1);
            $form->addElement($vmapcount);

            $overlayvmapFormats[] = $form->createElement('button', '', 'ADD', array('id' => 'vast-overlay-format-vmapcount2','onClick' => 'phpAds_formOverlayIsVmapCount2();','value' => 'ADD','name' => 'find'));
            $form->setDefaults(array('vmap_overlay_count' => $overlayVmapValue));
            $form->addGroup($overlayvmapFormats, 'overlaycount', '', "<br/>");
        }
        else
        {
            $offset[] = $form->createElement('radio', 'offsetsetting[0]','',"Time",'time',array('id' => 'time_0','class'=>'time','onClick' => 'vmaptime(this.id);'));
            $offset[] = $form->createElement('radio', 'offsetsetting[0]','', "Percentage",'percentage',array('id' => 'percentage_0','class'=>'percentage','onClick' => 'vmaptime(this.id);'));
            $form->addGroup($offset, 'Offset', 'Offset', "<br/>");

            // multile ads
            $checked='';
            $checkmultiple = $form->createElement('checkbox','allowmultipleAds[0]', 'Allow Mulitple ads');
            $checkmultiple->setAttribute('class','allowmultipleAds'); 
            $checkmultiple-> setAttribute('id','allowmultipleAds_0');
            $checkmultiple->setAttribute($checked,$checked); 
            $form->addElement($checkmultiple);

            // ad breaks url options
            $vmapurl[] = $form->createElement('radio', 'vmapurl[0]','',"Internal",'Internal',array('id' => 'internal_0','class'=>'internal','onClick' => 'vmapinternal(this.id);'));
            $vmapurl[] = $form->createElement('radio', 'vmapurl[0]','', "External",'External',array('id' => 'external_0','class'=>'external','onClick' => 'vmapexternal(this.id);'));

            $form->addGroup($vmapurl, 'Ad break', 'Ad Tags', "<br/>");

            $offsettime = $form->createElement('text','vmap_offset_adbreak[0]','offset Time',array('value'=>$antifraud_imp['resettime'] ));
            $offsettime->setAttribute('class','offset');
            $offsettime->setAttribute('id','offset_0');
            $offsettime->setAttribute('onchange','validateHhMm(this);');
            $form->addElement($offsettime);

            // vmap count 
            $vmapcount = $form->createElement('hidden','vmapcount','0');
            $vmapcount->setAttribute('class','vmapcount');
            $vmapcount->setAttribute('id','vmapcount');
            $form->addElement($vmapcount);

            $overlayvmapFormats[] = $form->createElement('button', '', 'ADD', array('id' => 'vast-overlay-format-vmapcount2','onClick' => 'phpAds_formOverlayIsVmapCount2();','value' => 'ADD','name' => 'find'));
            $form->setDefaults(array('vmapcount' => $overlayVmapValue));
            $form->addGroup($overlayvmapFormats, 'overlaycount', '', "<br/>");
        }
        $script = getJsScriptList($affiliate,$azones);
        $form->addElement('html','script_1', $script);
    }
    
    /* reviveadservermod.com - Vast VMAP End*/

    $form->addElement('controls', 'form-controls');
    $form->addElement('submit', 'save', 'Save changes');

    //Form validation rules
    $translation = new OX_Translation();
    $urlRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strWebsiteURL']));
    $form->addRule('website', $urlRequiredMsg, 'required');
    $form->addRule('website', $GLOBALS['strInvalidWebsiteURL'], 'regex', '#^http(s?)\://.+$#');
    $contactRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strContact']));
    $form->addRule('contact', $contactRequiredMsg, 'required');
    $nameRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strName']));
    $form->addRule('name', $nameRequiredMsg, 'required');
    $emailRequiredMsg = $translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strEMail']));
    $form->addRule('email', $emailRequiredMsg, 'required');
    $form->addRule('email', $GLOBALS['strEmailField'], 'email'); 

    //set form  values
    $form->setDefaults($affiliate);
    return $form;
}

/* reviveadservermod.com - Vast VMAP Start*/

function getSuitableZonesList($affiliateid)
{
    $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

    $tempQuery1= OA_Dal_Delivery_query("SELECT z.zoneid, z.delivery, af.vmapcount FROM {$table_prefix}agency AS ag, {$table_prefix}affiliates AS af, {$table_prefix}zones AS z, {$table_prefix}ad_zone_assoc AS c WHERE ag.agencyid = af.agencyid AND af.affiliateid = z.affiliateid AND z.zoneid = c.zone_id AND z.delivery IN ( 7, 6 ) AND z.affiliateid = {$affiliateid} GROUP BY z.zoneid");

    $azones = array();

    if(OA_Dal_Delivery_numRows($tempQuery1)>0)
    {
        $azones[0]  =   'Select';
        while($aRow =   OA_Dal_Delivery_fetchAssoc($tempQuery1))
        {
            $azones[$aRow['zoneid']]    =   $aRow['zoneid'];
        }
    }

    return $azones;
}

function getJsScriptList($bannerRow,$zones)
{   
    $bannerid = $bannerRow['affiliateid']; 
    $azoneinline  = json_encode($zones); 
            
    $html_1 = <<<EOD

        <script>
            function VmapRepeatafter(t) {
                if($("#repeatafter_0").is(':checked') == true) {
                    $("#repeataftertime_0").parent().parent().show();
                    $("label[for=repeataftertime_0]").parent().parent().show();
                    $(".offset").parent().parent().hide();
                    $(".time").parent().parent().hide();
                    $("label[for=offset_0]").hide();
                    $("#time0").parent().parent().hide();
                    $(".offsetall").hide();
                    $("#repeataftertime_0").parent().parent().show();
                    var count = $("input[name='vmapcount']").val();
                    $(".time").prop('checked', false);
                    $(".percentage").prop('checked', false);
                    $(".start").prop('checked', false);
                    $(".end").prop('checked', false);
                } else {
                    $("#repeataftertime_0").parent().parent().hide();
                    $("label[for=repeataftertime_0]").parent().parent().hide();
                    $("#offset_0").show();
                    $("label[for=offset_0]").show();
                    $("#time_0").parent().parent().show();
                    $(".offsetall").show();
                    //~ $(".offset").parent().parent().hide();
                    $(".time").parent().parent().show();
                    $("#repeataftertime_0").parent().parent().hide();
                }
            }
            <!-- for vmap time ,percentage,start and end-->
            function vmaptime(idd) {
                var count = idd.split('_');
                var timeid = count[count.length - 1];
                if(idd == 'percentage_0') {
                    $(".offset").parent().prev().children().html("Offset Percentage");
                } else {
                    $(".offset").parent().prev().children().html("Offset Time");
                }
                $(".offset").parent().parent().show();
                //~ $("#offset_"+timeid).parent().parent().show();
                //~ $("#offset_"+timeid).show();
                //~ $("label[for=offset_"+timeid+"]").show();
            }
            <!-- vmap remove-->
            function vmapRemove(iddd) {
                var count = iddd.split('_');
                var removeid = count[count.length - 1];
                //alert(removeid);
                if($("#remove_" + removeid).parent().parent().parent().next().attr('class') == 'spacer') {
                    $("#remove_" + removeid).parent().parent().parent().next().attr('class').remove();
                }
                $("#remove_" + removeid).parent().parent().remove();
                $("#allowmultipleAds_" + removeid).parent().parent().remove();
                $("#adbreak_tag_" + removeid).parent().parent().remove();
                $("#linear_" + removeid).parent().parent().remove();
                $("#time_" + removeid).parent().parent().remove();
                $("#offset_" + removeid).parent().parent().remove();
                $("#zoneid_" + removeid).parent().parent().remove();
                $("#adbreak_" + removeid).parent().parent().remove();
                $("#internal_" + removeid).parent().parent().remove();
                $(".spacer_" + removeid).remove();
                var c = $("#vmapcount").val();
                c = c - 1;
                $("#vmapcount").val(c);
            }

            function vmapexternal(idd) {
                var countexternal = idd.split('_');
                var externalid = countexternal[countexternal.length - 1];
                if(!($("#adbreak_" + externalid).length)) {
                    $("#zoneid_" + externalid).parent().parent().remove();
                    $(".spacer_" + externalid).remove();
                    $(".spacer_" + externalid).remove();
                    $("#internal_" + externalid).parent().parent().after('<tr><td width="30">&nbsp;</td></tr><tr class=" spacer_' + externalid + '"><td style="height:1px;" colspan="3">&nbsp;</td></tr><tr><td width="30">&nbsp;</td><td width="170"><label for="adbreak_' + externalid + '">Ad breaks</label></td><td width="100%"><input value="" name="adbreak[' + externalid + ']" class="adbreak" id="adbreak_' + externalid + '" type="text"></td></tr><tr class="spacer_' + externalid + '"><td style="height:1px;" colspan="3">&nbsp;</td></tr>');
                }
            }

            function vmapinternal(idd) {
                var data = '$azoneinline';
                var zonearr = JSON.parse(data);
                var countinternal = idd.split('_');
                var internalid = countinternal[countinternal.length - 1];
                if(!$("#zoneid_" + internalid).length) {
                    $("#adbreak_" + internalid).parent().parent().remove();
                    $(".spacer_" + internalid).remove();
                    $("#internal_" + internalid).parent().parent().after('<tr class="spacer_' + internalid + '"><td style="height:1px;" colspan="3">&nbsp;</td></tr><tr class="spacer_' + internalid + '"><td style="height:1px;" colspan="3">&nbsp;</td></tr><tr><td width="30">&nbsp;</td><td width="170">Zone id </td><td width="100%"><select id="zoneid_' + internalid + '" name="zoneid[' + internalid + ']" class="subCategory' + internalid + '"></select> </td></tr><tr class="spacer_' + internalid + '"><td style="height:1px;" colspan="3">&nbsp;</td></tr>');
                }
                $.each(zonearr, function(key, value) {
                    $('.subCategory' + internalid).append($('<option/>').val(key).text(value));
                });
            }

            function validaterepeatafter(repeatField) {
                if($('#repeatafter_0').is(':checked') == true) {
                    var fieldid1 = repeatField.id;
                    var isValid = /^([0-1]?[0-9]|2[0-4]):([0-5][0-9])(:[0-5][0-9])?$/.test(repeatField.value);
                    if(isValid) {
                        repeatField.style.backgroundColor = '#bfa';
                        $('#time').remove();
                    } else {
                        var fieldid1 = repeatField.id;
                        repeatField.style.backgroundColor = '#fba';
                        $('#' + fieldid1).after('<span style="color:red;" id="time">The Repeat after time format should be (HH:mm:ss)</span>');
                    }
                    return isValid;
                }
            }

            function validateHhMm(inputField) {
                if($('#time_0').is(':checked') == true) {
                    var fieldid = inputField.id;
                    var isValid = /^([0-1]?[0-9]|2[0-4]):([0-5][0-9])(:[0-5][0-9])?$/.test(inputField.value);
                    if(isValid) {
                        inputField.style.backgroundColor = '#bfa';
                        $('#time').remove();
                    } else {
                        var fieldid = inputField.id;
                        inputField.style.backgroundColor = '#fba';
                        $('#' + fieldid).after('<span style="color:red;" id="time">The time format should be (HH:mm:ss)</span>');
                    }
                    return isValid;
                }
                if($('#percentage_0').is(':checked') == true) {
                    var fieldid1 = inputField.id;
                    //~ $('#'+fieldid1).numeric();
                    var pervalue = inputField.value;
                    var regexPattern = /(^100(\.0{1,2})?$)|(^([1-9]([0-9])?|0)(\.[0-9]{1,2})?$)/.test(inputField.value);
                    if(regexPattern) {
                        inputField.style.backgroundColor = '#bfa';
                        $('#percentage').remove();
                    } else {
                        var fieldid = inputField.id;
                        inputField.style.backgroundColor = '#fba';
                        $('#' + fieldid1).after('<span style="color:red;" id="percentage">The Percentage should be Numberic</span>');
                    }
                    return regexPattern;
                }
            }

            function phpAds_formOverlayIsVmapCount2() {
                var count = 0;
                var count = $("input[name='vmapcount']").val();
                if(count) {
                    count++;
                    $("input[name=vmapcount]").val(count);
                } else {
                    count = 1;
                }
                $("#vast-overlay-format-vmapcount2").parent().parent().before('<tr><td width="30">&nbsp;</td><td width="170">Allow Mulitple ads </td><td width="100%"><input name="allowmultipleAds[' + count + ']" id="allowmultipleAds_' + count + '" class="allowmultipleAds" type="checkbox" value="1"></td></tr><tr class="spacer spacer_' + count + '"><td style="height:1px;" colspan="3">&nbsp;</td></tr><tr><td width="30">&nbsp;</td><td style="padding-top: 5px" width="170" valign="top">Ad Tags</td><td width="100%"><input id="internal_' + count + '" class="internal" name="vmapurl[' + count + ']" value="Internal" type="radio" onclick="vmapinternal(this.id);"><label for="internal_' + count + '">Internal</label><br/><input id="external_' + count + '" class="external" name="vmapurl[' + count + ']" value="External" type="radio" onclick="vmapexternal(this.id);"><label for="external_' + count + '">External</label><br/></td></tr><tr class="spacer spacer_' + count + '"><td style="height:1px;" colspan="3">&nbsp;</td></tr><tr><td width="30">&nbsp;</td><td width="170"><label for="offset_' + count + '">offset Time </label></td><td width="100%"><input value="" name="vmap_offset_adbreak[' + count + ']" class="offset" id="offset_' + count + '" type="text" onchange="validateHhMm(this);" ></td></tr><tr class="spacer spacer_' + count + '"><td style="height:1px;" colspan="3">&nbsp;</td></tr><tr><td width="30">&nbsp;</td><td width="170"><input type="button" id="remove_' + count + '" value="Remove" onClick="return vmapRemove(this.id);"></td></tr><tr class="spacer"><td style="height:1px;" colspan="3"> &nbsp;</td></tr><tr><td width="30"></td><td colspan="2"></td></tr>');
                if($("#repeatafter_0").is(':checked') == true) {
                    $("#repeataftertime_0").parent().parent().show();
                    $(".offset").parent().parent().hide();
                    $(".time").parent().parent().hide();
                } else {
                    $("#repeataftertime_0").parent().parent().hide();
                    //~ $(".offset").parent().parent().show();
                    $(".time").parent().parent().show();
                }
                if(($("#time_0").is(':checked') == true) || ($("#percentage_0").is(':checked') == true)) {
                    $(".offset").parent().parent().show();
                } else {
                    $(".offset").parent().parent().hide();
                    //~ $("label[for=offset_"+count+"]").hide();
                }
                if($("#time_0").is(':checked') == true) {
                    $(".offset").parent().prev().children().html("Offset Time");
                } else {
                    $(".offset").parent().prev().children().html("Offset Percentage");
                }
            }
            if($("#repeatafter_0").is(':checked') == true) {
                $("#repeataftertime_0").parent().parent().show();
                $(".offset").parent().parent().hide();
                $(".time").parent().parent().hide();
            } else {
                $("#repeataftertime_0").parent().parent().hide();
                //~ $(".offset").parent().parent().show();
                $(".time").parent().parent().show();
            }
        </script>
        <style>
            #thirdLevelContent {
                min-height: auto !important;
            }
        </style>
EOD;

    if(!$bannerid)
    {   
        $html_1.= <<<EOD
            <script>
            
             $("#repeataftertime_0").parent().parent().hide();
             $("#adbreak_0").parent().parent().hide();
             $("#zoneid_0").parent().parent().hide(); 
             $("#offset_0").parent().parent().hide(); 
            </script>
EOD;
 
    }

    return $html_1;
}

/* reviveadservermod.com - Vast VMAP End*/


/*-------------------------------------------------------*/
/* Process submitted form                                */
/*-------------------------------------------------------*/
function processForm($affiliateid, $form)
{
    $aFields = $form->exportValues();
    $newWebsite = empty($aFields['affiliateid']);

    // Setup a new publisher object and set the fields passed in from the form:
    $oPublisher = new OA_Dll_PublisherInfo();
    $oPublisher->agencyId       = $aFields['agencyid'];
    $oPublisher->contactName    = $aFields['contact'];
    $oPublisher->emailAddress   = $aFields['email'];
    $oPublisher->publisherId    = $aFields['affiliateid'];
    $oPublisher->publisherName  = $aFields['name'];
    $oPublisher->website        = $aFields['website'];

    /* reviveadservermod.com - Vast VMAP */

    $vmap_details = '';

    if(!empty($_POST['offsetsetting']))
    {
        $vmap_details = array(
            'offsetsetting' => $_POST['offsetsetting'],
            'vmapurl' => $_POST['vmapurl'],
            'zoneid' => $_POST['zoneid'],
            'allowmultipleAds' => $_POST['allowmultipleAds'],
            'vmap_offset_adbreak' => $_POST['vmap_offset_adbreak']
        );
    }

    /* reviveadservermod.com - Vast VMAP */

    $oPublisherDll = new OA_Dll_Publisher();
    if ($oPublisherDll->modify($oPublisher) && !$oPublisherDll->_noticeMessage) {

        // Queue confirmation message
        $translation = new OX_Translation ();
        if ($newWebsite) {


            /* reviveadservermod.com - Vast VMAP */

            if(!empty($_POST['offsetsetting']))
            {
                $vmapcount   = $_POST['vmapcount'] ? $_POST['vmapcount'] + 1 : 1 ;
                $vmapobjects = json_encode($vmap_details);
                $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
                OA_Dal_Delivery_query("UPDATE {$table_prefix}affiliates SET vmapobjects = '{$vmapobjects}', vmapcount = '{$vmapcount}' WHERE affiliateid = {$oPublisher->publisherId} ");
            }

            /* reviveadservermod.com - Vast VMAP */


            $translated_message = $translation->translate ( $GLOBALS['strWebsiteHasBeenAdded'], array(
                MAX::constructURL(MAX_URL_ADMIN, 'affiliate-edit.php?affiliateid=' .  $oPublisher->publisherId),
                htmlspecialchars($oPublisher->publisherName),
                MAX::constructURL(MAX_URL_ADMIN, 'zone-edit.php?affiliateid=' .  $oPublisher->publisherId),
            ));
            OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
            $redirectURL = "website-index.php";
        }
        else {

            /* reviveadservermod.com - Vast VMAP */

            if(!empty($_POST['offsetsetting']))
            {
                $vmapcount   = $_POST['vmapcount'] ? $_POST['vmapcount'] + 1 : 1 ;
                $vmapobjects = json_encode($vmap_details);
                $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
                OA_Dal_Delivery_query("UPDATE {$table_prefix}affiliates SET vmapobjects = '{$vmapobjects}', vmapcount = '{$vmapcount}' WHERE affiliateid = {$oPublisher->publisherId} ");
            }

            /* reviveadservermod.com - Vast VMAP */


            $translated_message = $translation->translate ( $GLOBALS['strWebsiteHasBeenUpdated'], array(
                MAX::constructURL(MAX_URL_ADMIN, 'affiliate-edit.php?affiliateid=' .  $oPublisher->publisherId),
                htmlspecialchars($oPublisher->publisherName),
            ));
            $redirectURL = "affiliate-edit.php?affiliateid={$oPublisher->publisherId}";
        }
        OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
        OX_Admin_Redirect::redirect($redirectURL);

    }
    return $oPublisherDll;
}

/*-------------------------------------------------------*/
/* Display page                                          */
/*-------------------------------------------------------*/
function displayPage($affiliateid, $form, $oPublisherDll = null)
{
    //header and breadcrumbs
    $oHeaderModel = MAX_displayWebsiteBreadcrumbs($affiliateid);
    if ($affiliateid != "") {
        OA_Admin_Menu::setPublisherPageContext($affiliateid, 'affiliate-edit.php');
        addWebsitePageTools($affiliateid);
        phpAds_PageHeader(null, $oHeaderModel);
    }
    else {
        phpAds_PageHeader("affiliate-edit_new", $oHeaderModel);
    }

    //get template and display form
    $oTpl = new OA_Admin_Template('affiliate-edit.html');
    $oTpl->assign('affiliateid', $affiliateid);
    $oTpl->assign('form', $form->serialize());

    if (isset($oPublisherDll)) {
        $oTpl->assign('error',  $oPublisherDll->_errorMessage);
        $oTpl->assign('notice', $oPublisherDll->_noticeMessage);
    }

    $oTpl->assign('showAdDirect', (defined('OA_AD_DIRECT_ENABLED') && OA_AD_DIRECT_ENABLED === true) ? true : false);
    $oTpl->assign('keyAddNew', $keyAddNew);

    $oTpl->display();

    //footer
    phpAds_PageFooter();
}
?>
