var NODE_TYPE_ELEMENT = 1;

function extend(obj) {
  var arg, i, k;
  for (i = 1; i < arguments.length; i++) {
    arg = arguments[i];
    for (k in arg) {
      if (arg.hasOwnProperty(k)) {
        if (isObject(obj[k]) && !isNull(obj[k]) && isObject(arg[k])) {
          obj[k] = extend({}, obj[k], arg[k]);
        } else {
          obj[k] = arg[k];
        }
      }
    }
  }
  return obj;
}

function isString(str) {
  return typeof str === 'string';
}

function isNotEmptyString(str) {
  return isString(str) && str.length !== 0;
}

function isNull(o) {
  return o === null;
}

function isObject(obj) {
  return typeof obj === 'object';
}

function isFunction(str){
  return typeof str === 'function';
}

function forEach(obj, iterator, context) {
  var key, length;
  if (obj) {
    if (isFunction(obj)) {
      for (key in obj) {
        // Need to check if hasOwnProperty exists,
        // as on IE8 the result of querySelectorAll is an object without a hasOwnProperty function
        if (key !== 'prototype' && key !== 'length' && key !== 'name' && (!obj.hasOwnProperty || obj.hasOwnProperty(key))) {
          iterator.call(context, obj[key], key, obj);
        }
      }
    } else if (isArray(obj)) {
      var isPrimitive = typeof obj !== 'object';
      for (key = 0, length = obj.length; key < length; key++) {
        if (isPrimitive || key in obj) {
          iterator.call(context, obj[key], key, obj);
        }
      }
    } else if (obj.forEach && obj.forEach !== forEach) {
      obj.forEach(iterator, context, obj);
    } else {
      for (key in obj) {
        if (obj.hasOwnProperty(key)) {
          iterator.call(context, obj[key], key, obj);
        }
      }
    }
  }
  return obj;
}

function isArray(array){
  return Object.prototype.toString.call( array ) === '[object Array]';
}

function isWindow(obj) {
  return isObject(obj) && obj.window === obj;
}

function isUndefined(o){
  return o === undefined;
}

function isArrayLike(obj) {
  if (obj === null || isWindow(obj) || isFunction(obj) || isUndefined(obj)) {
    return false;
  }

  var length = obj.length;

  if (obj.nodeType === NODE_TYPE_ELEMENT && length) {
    return true;
  }

  return isString(obj) || isArray(obj) || length === 0 ||
    typeof length === 'number' && length > 0 && (length - 1) in obj;
}

function arrayLikeObjToArray(args) {
  return Array.prototype.slice.call(args);
}

module.exports = {
  extend: extend,
  isString: isString,
  isFunction: isFunction,
  isArray: isArray,
  isArrayLike: isArrayLike,
  arrayLikeObjToArray: arrayLikeObjToArray,
  forEach: forEach,
  isNotEmptyString: isNotEmptyString,
  isNull: isNull,
  isObject: isObject
};