<?php

	header("Access-Control-Allow-Origin: *");
	header("Content-Type: application/json; charset=UTF-8");
	header("Access-Control-Allow-Methods: POST");
	header("Access-Control-Max-Age: 3600");
	header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

	require_once '../../init.php';
      
	// Required files
	require_once MAX_PATH . '/lib/OA/Dal.php';      
	require_once MAX_PATH . '/lib/OA/Admin/Option.php';
	require_once MAX_PATH . '/lib/OA/Admin/Settings.php';      
	require_once MAX_PATH . '/www/admin/config.php';
	require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
      
	if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
	}
	else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
	}
	else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
	{
		require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
	}

   	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
   	$totalRecords = 0;
   	$totalRecordwithFilter = 0;

   	## Read value
	$draw = $_POST['draw'];
	$row = $_POST['start'];
	$rowperpage = (isset($_POST['table_report_length']))?$_POST['table_report_length']: 25; // Rows display per page
	$columnIndex = $_POST['order'][0]['column']; // Column index
	$columnName = $_POST['columns'][$columnIndex]['data']; // Column name
	$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
	$searchValue = $_POST['search']['value']; // Search value
	
	$clientid = $_POST['clientid'];
	$start_date = $_POST['start_date'];
	$end = $_POST['end'];

	$adv_type = $_POST['adv_type'];

	$data = array();
	$i=0;
	$timestamp = '';

	if($adv_type == "pre")
	{
		## Fetch records
		$getDateReportQuery = OA_Dal_Delivery_Query("SELECT h.*,MONTH(h.dep_date) as month FROM dj_payment_history as h LEFT JOIN {$table_prefix}clients as c ON h.client_id = c.clientid WHERE h.client_id = {$clientid} and DATE(dep_date) >= '".$start_date."' and DATE(dep_date) <= '".$end."'");

		$getCampaingid = OA_Dal_Delivery_Query("SELECT b.bannerid as bid from {$table_prefix}campaigns as c LEFT JOIN {$table_prefix}banners AS b ON c.campaignid=b.campaignid WHERE c.clientid = {$clientid} and b.bannerid > 0");

		$banid = array();
		while ($row1 = OA_Dal_Delivery_fetchAssoc($getCampaingid)) 
		{
			$banid[] = $row1['bid'];
		}

		$idban = implode(',',$banid);
		$intermediatead = OA_Dal_Delivery_Query("SELECT SUM(total_basket_value) as total, MONTH(date_time) as month  from {$table_prefix}data_intermediate_ad WHERE ad_id IN({$idban}) GROUP BY MONTH(date_time)");

		$arrbal = array();
		while($balance = OA_Dal_Delivery_fetchAssoc($intermediatead))
		{
			$arrbal[] = array(
						'total' => $balance['total'],
						'month' => $balance['month']
						);
		}

		$data = array();
		$i=0;

		if (isset($getDateReportQuery) && !empty($getDateReportQuery)) 
		{
			while ($row = OA_Dal_Delivery_fetchAssoc($getDateReportQuery)) 
			{
				// $usedbal = 0;
				$type = $row['type']==1?'Wire':'Paypal';
				
				if($row['status'] == 1)
				{
					$status="Success";
				}
				elseif (($row['status'] == 2) ) 
				{
					$status="Failed";
				}
				else 
				{
					$status="Pending";
				}

				$timestamp =  date("d-m-Y H:00:00",strtotime($row['dep_date']));
				if ($arrbal[$i]['month']==$row['month']) 
				{
					$usedbal = $arrbal[$i]['total'];
				}

			   	$data[] = array( 
			      "data_type"=>$timestamp,
			      "amount"=>$row['amt'],
			      "status"=>$status,
			      "type"=>$type			   );
			   $i++;
			}
		}

		// echo json_encode($banid);exit;
	}

	else
	{
		## Fetch records
		$query = OA_Dal_Delivery_Query("SELECT * FROM dj_postpaid_details as h WHERE h.clientid = {$clientid} and h.paid_date >= '".$start_date."' and h.paid_date <= '".$end."'");


		if (isset($query) && !empty($query)) 
		{
			while ($row = OA_Dal_Delivery_fetchAssoc($query)) 
			{

				$type = $row['type']==1?'Wire':'Paypal';
				
				if($row['is_paid'] == 1)
				{
					$status="Success";
				}
				elseif (($row['is_paid'] == 2) ) 
				{
					$status="Failed";
				}
				else if(($row['is_paid'] == 3) ) 
				{
					$status="Pending";
				}
				else if(($row['is_paid'] == 4) ) 
				{
					$status="Rejected";
				}

				$timestamp =  date("d-m-Y H:00:00",strtotime($row['paid_date']));

				if ($arrbal[$i]['month']==$row['month']) 
				{
					$usedbal = $arrbal[$i]['total'];
				}
			    $i++;

			   	$data[] = array( 
			      "data_type"=>$timestamp,
			      "amount"=>$row['bill_amt'],
			      "status"=>$status,
			      "type"=>$type
			   );
			}

		}
	}
	
	# Response
	$response = array(
	  "draw" => intval($draw),
	  "iTotalRecords" => sizeof($data),
	  "iTotalDisplayRecords" => sizeof($data),
	  "aaData" => $data
	);

	echo json_encode($response);
	exit();
?>
    
		
