<?php
/*  PHP Paypal IPN Integration Class Demonstration File
 *  4.16.2005 - Micah Carrick, email@micahcarrick.com
 *
 *  This file demonstrates the usage of paypal.class.php, a class designed  
 *  to aid in the interfacing between your website, paypal, and the instant
 *  payment notification (IPN) interface.  This single file serves as 4 
 *  virtual pages depending on the "action" varialble passed in the URL. It's
 *  the processing page which processes form data being submitted to paypal, it
 *  is the page paypal returns a user to upon success, it's the page paypal
 *  returns a user to upon canceling an order, and finally, it's the page that
 *  handles the IPN request from Paypal.
 *
 *  I tried to comment this file, aswell as the acutall class file, as well as
 *  I possibly could.  Please email me with questions, comments, and suggestions.
 *  See the header of paypal.class.php for additional resources and information.
*/
// Setup class

require_once '../../init.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql'){
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql'){
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
} else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli'){
    require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

ini_set("display_errors", "1");
error_reporting(E_ALL);
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

require_once('paypal.class.php');  // include the class file

$p = new paypal_class;             // initiate an instance of the class
$id = $_GET['client_id'];
$amt = $_GET['amount'];
$method = $_GET['method'];
$bill = $_GET['billperiod'];

$apptype = OA_Dal_Delivery_query("SELECT * FROM dj_admin_settings");
$admin = OA_Dal_Delivery_fetchAssoc($apptype);

if($admin['pay_method'] == 2)
{
  $p->paypal_url = 'https://www.paypal.com/cgi-bin/webscr'; 
}
else
{
  $p->paypal_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr'; 
}

if ($GLOBALS['_MAX']['SSL_REQUEST']) {
  $djprotocol = 'https://';
} else {
  $djprotocol = 'http://';
}
$this_script = $djprotocol.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
$paypal_email = $admin['paypalid'];

switch($_GET['action'])
{
    case 'process':
                 
            $p->add_field('business', $paypal_email);
            $p->add_field('return', $this_script.'?action=success&client_id='.$id.'&amount='.$amt.'&method='.$method.'&bill='.$bill.'');
            //Zone Bidding
            $p->add_field('cancel_return', $this_script.'?action=cancel&client_id='.$id.'&amount='.$amt.'');
            $p->add_field('item_name', 'Advertiser Amount');
            $p->add_field('amount', $amt);
            $p->submit_paypal_post(); 

      break;

    case 'success':

          if($method == 1)
          { 
              $slectrow = OA_Dal_Delivery_query("SELECT * FROM dj_payment_details WHERE client_id='".$id."'");

              $query2 = OA_Dal_Delivery_query("SELECT * FROM {$table_prefix}clients WHERE clientid = ".$id);
              $adv = OA_Dal_Delivery_fetchAssoc($query2);
              
              $campquery2 = OA_Dal_Delivery_query("UPDATE {$table_prefix}campaigns set status=0 WHERE clientid = ".$id);
                
              if ($admin['payment_approval'] == 1) 
              {
                  if(OA_Dal_Delivery_numRows($slectrow)>0)
                  {
            
                    $fetch=OA_Dal_Delivery_fetchAssoc($slectrow);
                    $amount_old=$fetch['deposit_amount'];
                    $amounts_zone=$amount_old+$_GET['amount']; 
                    $amounts_zone1=$_GET['amount'];
                    
                    $res = OA_Dal_Delivery_query("UPDATE dj_payment_details set deposit_amount ='".$amounts_zone."' where client_id ='".$id."' ");
                    OA_Dal_Delivery_query("INSERT INTO dj_payment_history(client_id,amt,status,type,dep_date) VALUES('".$id."','".$amounts_zone1."',1,2,'".date('Y-m-d H:i:s')."') ");       
                  }
                  else
                  {
                    $amounts_zone1=$_GET['amount'];
                    $res = OA_Dal_Delivery_query("INSERT INTO dj_payment_details(client_id,deposit_amount) VALUES('".$id."','".$amounts_zone1."') ");
                    OA_Dal_Delivery_query("INSERT INTO dj_payment_history(client_id,amt,status,type,dep_date) VALUES('".$id."','".$amounts_zone1."',1,2,'".date('Y-m-d H:i:s')."') ");   
                  }
                  
              	 OA_Dal_Delivery_query("UPDATE {$table_prefix}campaigns SET status = 0 where  status = 1 AND clientid=".$id."");	   
 
                  //~MAIL TO ADVERTISER

                  $to = $adv['email']; 
                  $subject = 'Payment Approved';
                    
                  $headers .= "MIME-Version: 1.0\r\n";
                  $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
                  $headers .='From: '.$admin['emailid']. "\r\n";
                  $message = '<html><style type="text/css">strong {background: #eee;}</style><body>';

                  $message .= '<table width="70%" style="border-color: rgb(102, 102, 102); background: none repeat scroll 0% 0% rgb(226, 226, 226);"  cellspacing="10" cellpadding="10" >';

                  $message .= "<tr><td>Dear ".$adv['clientname']." ,</td></tr>";
                  $message .= "<tr><td>Your Payment of Rs. ".$amt." has been approved on ".date("Y-m-d")." </td></tr>";
                            
                  $message .='<tr><td style="margin:50px;line-height:1;width:650px; word-spacing:2px;font-size:15px;color:#14773A; ">Regards,  <br/><b>Administrator</b></td></tr>';  
                  $message .= "</body></html>"; 
                  $message .= "</table>";
                  mail($to,$subject,$message,$headers); 
              }
              else
              {
                OA_Dal_Delivery_query("INSERT INTO dj_payment_history(client_id,amt,status,type,auto_appr,dep_date) VALUES('".$id."','".$amt."',3,2,1,'".date('Y-m-d H:i:s')."') ");
              } 


            $path = $djprotocol.$GLOBALS['_MAX']['CONF']['webpath']['admin'].'/dj-deposite-index.php?clientid='.$id;

            echo "<script type='text/javascript'> 

              window.location.href = '".$path."';

            </script>";
            exit();
          }
          else
          {
           
              $billperiod = $_GET['bill'];
              $now = date('Y-m-d H:i:s');
              $bill = $fetch['bill_period'];

              if ($admin['payment_approval'] == 1) 
              {
                $res = OA_Dal_Delivery_query("UPDATE dj_postpaid_details set is_paid=1,paid_date='".$now."',ptype=2 where clientid ='".$id."' AND bill_period ='".$billperiod."'");
              }
              else
              {
                OA_Dal_Delivery_query("UPDATE dj_postpaid_details set is_paid=3,paid_date='".$now."',ptype=3 ,papr=1 where clientid ='".$id."' AND bill_period ='".$billperiod."'");
              }
             
              //~MAIL TO ADMIN
              $query = OA_Dal_Delivery_query("SELECT * FROM dj_admin_settings");
              $values = OA_Dal_Delivery_fetchAssoc($query);

              $query2 = OA_Dal_Delivery_query("SELECT * FROM {$table_prefix}clients where clientid=".$id);
              $values2 = OA_Dal_Delivery_fetchAssoc($query2);

              $to = $values2['email']; 

              $subject = 'Payment: '.$values2['clientname'];
              
              $headers .= "MIME-Version: 1.0\r\n";
              $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
              $headers .='From: '.$values['emailid']. "\r\n";
              $message = '<html><style type="text/css">strong {background: #eee;}</style><body>';

              $message .= '<table width="70%" style="border-color: rgb(102, 102, 102); background: none repeat scroll 0% 0% rgb(226, 226, 226);"  cellspacing="10" cellpadding="10" >';

              $message .= "<tr><td>Dear Admin,</td></tr>";
              $message .= "<tr><td>Advertiser ".$values2['clientname']." Paid Rs.".$amt." on ".date("Y-m-d")." </td></tr>";
                      
              $message .='<tr><td style="margin:50px;line-height:1;width:650px; word-spacing:2px;font-size:15px;color:#14773A; ">Regards,  <br/><b>'.$values2['clientname'].'</b></td></tr>';  
              $message .= "</body></html>"; 
              $message .= "</table>";
              mail($to,$subject,$message,$headers);   
         

            $path = $djprotocol.$GLOBALS['_MAX']['CONF']['webpath']['admin'].'/dj_postpaid_index.php?clientid='.$id;

            echo "<script type='text/javascript'> 

              window.location.href = '".$path."';

            </script>";
            exit();
            // header("Location:dj_postpaid_index.php?clientid=".$id);
            // exit();
           
          }

    break;

    case 'cancel':

            OA_Dal_Delivery_query("INSERT INTO dj_payment_history(client_id,amt,status,type) VALUES('".$id."','".$amounts_zone1."','2',2) ");
            echo "<script type='text/javascript'>  window.location='dj-deposite-index.php?clientid=".$id."&action=cancel'; </script>";
          
    break;
}
?>
