<?php

$path = dirname(__FILE__);
require_once $path . '/../../init.php';

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
	require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

if (!function_exists('OX_Delivery_logMessage()')) 
{
    function OX_Delivery_logMessage()
    {
        return true;
    }
}

$djprotocol = $GLOBALS['_MAX']['SSL_REQUEST'] ? 'https://' :'http://';
$path = $djprotocol . $GLOBALS['_MAX']['CONF']['webpath']['admin'];
?>

<html>
   <head>
      <title>Highcharts Tutorial</title>
      <script src = "https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js">
      </script>
      <script src = "https://code.highcharts.com/highcharts.js"></script> 
   </head>
   
   <body>
      <div id = "container" style = "width: 550px; height: 400px; margin: 0 auto"></div>
      <script language = "JavaScript">
         $(document).ready(function() {
            var title = {
               text: 'Average Temperatures of Cities'   
            };
            var subtitle = {
               text: 'Source: worldClimate.com'
            };
            var xAxis = {
               categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                  'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
            };
            var yAxis = {
               title: {
                  text: 'Temperature (\xB0C)'
               },
               plotLines: [{
                  value: 0,
                  width: 1,
                  color: '#808080'
               }]
            };   
            var tooltip = {
               valueSuffix: '\xB0C'
            }
            var legend = {
               layout: 'vertical',
               align: 'right',
               verticalAlign: 'middle',
               borderWidth: 0
            };
            var series =  [{
                  name: 'Tokyo',
                  data: [7.0, 6.9, 9.5, 14.5, 18.2, 21.5, 25.2,
                     26.5, 23.3, 18.3, 13.9, 9.6]
               }, 
               {
                  name: 'New York',
                  data: [-0.2, 0.8, 5.7, 11.3, 17.0, 22.0, 24.8,
                     24.1, 20.1, 14.1, 8.6, 2.5]
               },
               {
                   name: 'Argentina',
                   data:[-2, 0.8, 7, 13.3, 10.0, 29.0, 22.8,
                     23.1, 15.1, 12, 18, 2.5]
               },
               {
                   name: 'India', 
                   data:[1, 22, 17, 23.3, 13.0, 19.0, 12.8,
                     12, 13, 11, 25, 12.5]
               },
               {
                  name: 'pakistan',
                  data: [17.0, 26.9, 19.5, 14.5, 28.2, 11.5, 15.2,
                     6.5, 13.3, 12.3, 23.9, 19.6]
               },
               {
                  name: 'uruguay',
                  data:[-12, 20.8, 17, 23.3, 15.0, 9.0, 27.8,
                     13.1, 5.1, 22, 28, 12.5]
               }              
            ];

            var json = {};
            json.title = title;
            json.subtitle = subtitle;
            json.xAxis = xAxis;
            json.yAxis = yAxis;
            json.tooltip = tooltip;
            json.legend = legend;
            json.series = series;
            
            $('#container').highcharts(json);
         });
      </script>
   </body>
   
</html>



