<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
// require_once '../../../../init.php';

// Require the initialisation file
require_once '../../init.php';
require_once LIB_PATH . '/Extension/deliveryLimitations/DeliveryLimitationsCommaSeparatedData.php';
require_once MAX_PATH . '/lib/max/Delivery/limitations.delivery.php';

// ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL); 
// Required files
require_once MAX_PATH . '/lib/OA/Admin/UI/component/Form.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/lib/pear/Date.php';
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/RV/Admin/Languages.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/lib/OX/Admin/Timezones.php';
require_once MAX_PATH . '/lib/OA/Admin/Template.php';
require_once MAX_PATH . '/lib/OA/Admin/Option.php';

require_once MAX_PATH . '/plugins/deliveryLimitations/Geo/Country.class.php';
require_once MAX_PATH . '/plugins/deliveryLimitations/Geo/Country.res.inc.php';


require_once MAX_PATH . '/plugins/deliveryLimitations/Geo/Subdivision1.class.php';

// require_once MAX_PATH . '/lib/max/Delivery/cache.php';

//
if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
$timezone = OX_Admin_Timezones::getTimezone();
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
// Register input variables

// Security check
OA_Permission::enforceAccount ( OA_ACCOUNT_MANAGER );
OA_Permission::enforceAccessToObject('clients', $clientid, false, OA_Permission::OPERATION_EDIT);
OA_Permission::enforceAccessToObject('campaigns', $campaignid, true, OA_Permission::OPERATION_EDIT);


/*-------------------------------------------------------*/
/* Store preferences                                     */
/*-------------------------------------------------------*/
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['clientid'] = $clientid;
$session['prefs']['inventory_entities'][OA_Permission::getEntityId()]['campaignid'][$clientid] = $campaignid;
phpAds_SessionDataStore();

$campaign['clientid'] = $clientid;
$campaign['campaignid'] = $campaignid;

$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
$conf = $GLOBALS['_MAX']['CONF'];


/*-------------------------------------------------------*/
/* Main                                                  */
/*-------------------------------------------------------*/
 $q =  OA_Dal_Delivery_query("select * from {$table_prefix}djaxcampaign_daytimeparting where campaignid=".$campaignid);
 if(OA_Dal_Delivery_numRows($q) > 0){
    $res = OA_Dal_Delivery_fetchAssoc($q);
 }

$ID = $res['campaginid'];
$ClientID = $res['clientid'];
$daytimePartForm = '';


//~FOR UPDATE DAYPATING
 
if ($campaign['campaignid'] == $res['campaignid'] &&  $campaign['clientid'] == $res['clientid']) {
    $campaign['up_timezone'] = $res['timezone'];
    $campaign['day_time'] = $res['daytime_part'];

    $daytimePartForm = builddaytimePartForm( $campaign, $oComponent );    
}

//~FOR ADD DAYPATING

else
{
   $daytimePartForm = builddaytimePartForm( $campaign, $oComponent ); 
}



if ($daytimePartForm->isSubmitted () && $daytimePartForm->validate ()) {
    //process submitted values
    $errors = processdaytimePartForm($daytimePartForm, $oComponent );
    if (! empty ( $errors )) { //need to redisplay page with general errors
        displayPage ( $campaign, $daytimePartForm, $statusForm, $errors );
    }
}
else { 
    
    displayPage( $campaign, $daytimePartForm, $statusForm );
}


/*-------------------------------------------------------*/
/* Build form                                            */
/*-------------------------------------------------------*/
function builddaytimePartForm($campaign, &$oComponent = null)
{
    global $pref;

    $form = new OA_Admin_UI_Component_Form ( "daypartform", "POST", $_SERVER ['SCRIPT_NAME'] );
    $form->forceClientValidation ( true );
    $form->addElement ( 'hidden', 'campaignid', $campaign['campaignid'] );
    $form->addElement ( 'hidden', 'clientid', $campaign['clientid'] );
    
    buildDayPartingFormSection($form, $campaign);

    //form controls
    $form->addElement ( 'controls', 'form-controls' );
    $form->addElement ( 'submit', 'submit', $GLOBALS ['strSaveChanges'] );

    //validation rules
    $translation = new OX_Translation();
    $form->addRule('select_timezone', "Select Time Zone", 'required' );

    // echo "<pre>";print_r($form);
    return $form;
}


function buildDayPartingFormSection(&$form, $campaign)
{
   
    $form->addElement ( 'header', 'h_day_parting', "Day Parting" );
    // Get timezone dropdown information
    $aTimezones = OX_Admin_Timezones::availableTimezones(true);
    
    foreach ($aTimezones as $key => $value) 
    {
       $val[$value] = $value;
    } 

    $timezone = array (  'Select TIME ZONE' => $val);
    $campaign['select_timezone'] = $campaign['up_timezone'];

    $form->setDefaults($campaign);
   
    $days_of_week = array(1 => "Mon", 2 => "Tue", 3=> "Wed", 4=>"Thu", 5=> "Fri", 6 => "Sat", 7=> "Sun");

    $form->addElement ( 'select', 'select_timezone', "Time Zone", $timezone, array('id' => 'select_timezone', 'selected' => "selected"));

    $form->addElement ('checkbox','check_all', "", '<b style=color:#1b00ff;>Select / Unselect All</b>', array('id' => 'check_all'));

    $form->addElement ( 'header');
    $hour_day = array();
    $var1 = array();



    for ($i =1; $i < 25; $i++) 
    {
        $daypart_html = "";

        if($i == 1)
        {
            $daypart_html .= '<span class="day"></span>';
        }

        $daypart_html .= '<span class="hour_check"><b>'.$i.'</b></span>';
        $var1[$i] = $form->createElement('html', "hour",$daypart_html, array('id' => 'hour'));
    }

    //~FETCH AND DECODE JSON
    $form->addGroup($var1, 'hours_in_day'); 
    $dt_part = explode("@", $campaign['day_time']);
    $decode_hours = json_decode($dt_part[0],true);
    $j=0;

    foreach ($days_of_week as $key => $value) 
    {

        $weekdays_link = '<a class="day" style="cursor:pointer;" onclick="dayClick('.$key.');">'.$value.'</a> ';
        $hour_day[$days] = $form->createElement('html', 'days_of_week', $weekdays_link,"&nbsp;");
         
        for ($k =1; $k <25; $k++) 
        {
            $check_hours = '<span class="hour_check">
                            <input type="checkbox" name="hours['.$key.']['.$k.']" id="hours['.$key.']['.$k.']"  '.((isset($decode_hours[$key][$k])) ? "checked" : "").' 
                            class=" hours_perday day'.$key.'" value="1"></span>';

            $hour_day[$k] =  $form->createElement('html', 'hours_perday' ,$check_hours);
            (isset($decode_hours[$key][$k]))? $j++: '';
        }

        $form->addGroup($hour_day);
    }

    $form->addElement('html','script1',"
        <style>
        .day{
            min-width: 30px;
            display: inline-block;

        }
        .hour_check {
            display: inline-block;
            min-width: 35px;   
            text-align: center;
        }
        </style>
        <script>

            $(document).ready(function()
            {
                if(".$j." == 168)
                {
                    $('#check_all').attr('checked',true);
                }

                $('#check_all').click(function()
                {
                    if($(this).is(':checked')== true)
                    {
                        $('.hours_perday').attr('checked',true);
                    }
                    else
                    {
                        $('.hours_perday').attr('checked',false);
                    }
                });
            });

            //~SELECT DAYWISE
            var click = [];

            function dayClick(value = 0)
            {
                if(click[value] == null || click[value] == 1)
                {
                    $('.day'+value).attr('checked',true);
                    click[value] = 0;
                }
                else
                {
                    $('.day'+value).attr('checked',false);
                    click[value] = 1;
                }
            }

        </script>
    ");

}



/*-------------------------------------------------------*/
/* Process submitted form                                */
/*-------------------------------------------------------*/
/**
 * Processes submit values of campaign form
 *
 * @param OA_Admin_UI_Component_Form $form form to process
 * @return An array of Pear::Error objects if any
 */
function processdaytimePartForm($form, &$oComponent = null)
{   
    $aFields = $form->_submitValues;
    $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
         
    if (empty($errors)) 
    {
        //check booked limits values

        $qry =  OA_Dal_Delivery_query("select * from {$table_prefix}djaxcampaign_daytimeparting where campaignid = {$aFields['campaignid']}");
         
         if(OA_Dal_Delivery_numRows($qry) > 0)
         {
            $res = OA_Dal_Delivery_fetchAssoc($qry);
         }
       
        $time_zone_selected = $aFields['select_timezone'];
          
         $arr1 = array(json_encode($aFields['hours']),$time_zone_selected);
         $dt_parting = implode("@", $arr1);
        
        if ($aFields['campaignid'] != $res['campaignid'] && !empty($aFields['select_timezone'])) 
        {
           
            OA_Dal_Delivery_query("insert into {$table_prefix}djaxcampaign_daytimeparting (campaignid,clientid,timezone,daytime_part) values (".$aFields['campaignid'].", ".$aFields['clientid'].",'".$aFields['select_timezone']."','".$dt_parting."')");
        }
        else if($aFields['campaignid'] == $res['campaignid'])
        {
            OA_Dal_Delivery_query("update {$table_prefix}djaxcampaign_daytimeparting set timezone = '".$aFields['select_timezone']."',daytime_part = '".$dt_parting."' where campaignid = ".$aFields['campaignid']." and clientid = ".$aFields['clientid']."");            
        }

         // Delete channel forecasting cache
        include_once 'Cache/Lite.php';
        $options = array ('cacheDir' => MAX_CACHE );
        $cache = new Cache_Lite ( $options );
        $group = 'campaign_' . $aFields['campaignid'];
      

        $translation = new OX_Translation();
        $translated_message = $translation->translate ("Campaign Day-time Parting has been updated", array (
                MAX::constructURL(MAX_URL_ADMIN, 'campaign-dayparting.php?clientid=' . $aFields['clientid'] . '&campaignid=' . $aFields['campaignid'] ),
                htmlspecialchars ( $aFields['campaignid'] )
                ));
            OA_Admin_UI::queueMessage($translated_message, 'local', 'confirm', 0);
            OX_Admin_Redirect::redirect("campaign-dayparting.php?clientid=" . $aFields['clientid'] . "&campaignid=" . $aFields['campaignid'] );
       
    }

    if ($oComponent) {
        $oComponent->processdaytimePartForm($aFields);
    }

    return $errors;
}

/*-------------------------------------------------------*/
/* Display page                                          */
/*-------------------------------------------------------*/
function displayPage($campaign, $daytimePartForm, $statusForm, $campaignErrors = null )
{


   
    global $res;
    global $$executionorder;
    global $data;
    global $countryData;
    global $countryDataName;

    
    $nameEnglish = 'Geo - Country';


    $tabindex = 1;
    $agencyId = OA_Permission::getAgencyId ();
    $aEntities = array ('clientid' => $campaign['clientid'], 'campaignid' => $campaign['campaignid'] );

    // Display navigation
    $aOtherAdvertisers = Admin_DA::getAdvertisers ( array ('agency_id' => $agencyId ) );
    $aOtherCampaigns = Admin_DA::getPlacements ( array ('advertiser_id' => $campaign['clientid'] ) );
    MAX_displayNavigationCampaign ( $campaign['campaignid'], $aOtherAdvertisers, $aOtherCampaigns, $aEntities );
   
    //get template and display form
        
    $oTpl = new OA_Admin_Template('campaign_dayparting.html');


    $oTpl->assign('clientid', $campaign['clientid'] );
    $oTpl->assign('campaignid', $campaign['campaignid'] );
    $oTpl->assign('select_timezone', isset ( $campaign['select_timezone'] ) ? $campaign['select_timezone'] : 0 );
    $oTpl->assign('language', $GLOBALS ['_MAX'] ['PREF'] ['language'] );
       
    $oTpl->assign('daytimePartFormId', $daytimePartForm->getId () );
    $oTpl->assign('daytimePartForm', $daytimePartForm->serialize () );
  
    if (!empty ( $campaign['campaignid'] ) && defined ( 'OA_AD_DIRECT_ENABLED' ) && OA_AD_DIRECT_ENABLED === true)
    {

    }

    $oTpl->display();

    $responsea = json_decode($res);
    
    //$bRow = OA_Dal_Delivery_fetchAssoc($select_region);

    
    // while ($aRow = OA_Dal_Delivery_fetchAssoc($select_logo_f)) 
    // {
    //     echo "<div style='font-weight: bold'>".$aRow[name]."</div>";
    //     $select_region = OA_Dal_Delivery_query("SELECT * FROM {$table_prefix}rv_djax_region Where country_code = '".$aRow[country_code]."'");

    //     while ($bRow = OA_Dal_Delivery_fetchAssoc($select_region)) {
                
    //         echo "<div>".$bRow[region_name]."</div><br/>";

    //     }
        
        
    // }

    //print_r($fetch_support);

    $geo_assets=$_SERVER['REQUEST_SCHEME']."://".$GLOBALS['_MAX']['CONF']['webpath']['admin']."/assets/geo_multiselect/";
    
    
    
    $htmlPrint = '
        <link href="'.$geo_assets.'css/jqueryscripttop.css" rel="stylesheet" type="text/css">
        <link rel="stylesheet" href="'.$geo_assets.'css/bootstrap.min.css">
        <link rel="stylesheet" href="'.$geo_assets.'css/style.css">
        <link rel="stylesheet" href="'.$geo_assets.'css/virtual_select/css/styles.css">
        <link rel="stylesheet" href="'.$geo_assets.'css/virtual_select/css/virtual-select.min.css">



        <style>
       
            label{
                display:block;
                font-size: 18px;
                font-weight: 700;
                margin-bottom: 5px;
            }
            .vscomp-toggle-button{
                padding: 10px 30px 10px 10px;
                border-radius: 5px;
            }
            .column {
                float: left;
                width: 33.33%;
              }
              
              /* Clear floats after the columns */
              .row:after {
                content: "";
                display: table;
                clear: both;
              }
        </style>

        <div class="row">
            <div class="column">
                <span>Select Countries:</span>
                <div id="countryInputBox"></div>
            </div>
            <div class="column">
                <span>Select Regions:</span>
                <div id="regionInputBox"></div>
            </div>
            <div class="column">
                <span>Select Cities:</span>
                <div id="cityInputBox"></div>
            </div>
        </div>


        <script src="'.$geo_assets.'js/jquery-3.4.1.min.js"></script>
        <script src="'.$geo_assets.'js/comboTreePlugin.js"  type="text/javascript"></script>
        <script type="text/javascript" src="'.$geo_assets.'js/virtual_select/js/virtual-select.min.js"></script>

        
        <script type="text/javascript">

        var countryData = [
    ';

    echo  $htmlPrint;

    $countryDataName =  '';


    $select_country = OA_Dal_Delivery_query("SELECT * FROM {$table_prefix}countries");

    while ($aRow = OA_Dal_Delivery_fetchAssoc($select_country)) {

        echo '
        {
            value: "'.$aRow[id].'" ,
            label: "'. $aRow[name].'"          
        },';

    }


     echo '
        ];
        var countryValue;
        var regionValue;
        var comboTree1, comboTree2,  comboTree3;
       
        jQuery(document).ready(function($) {

            VirtualSelect.init({ 
                ele: "#countryInputBox",
                options: countryData,
                multiple: true,
                hasOptionDescription: true,
                search: true,
                searchGroup: true,
                disableOptionGroupCheckbox:false,
                useGroupValue: true,
                noSearchResultsTex: "No results found",
                updatePositionThrottle: 100,
                allowNewOption: true,
                keepAlwaysOpen:true
        
            });
            $("#countryInputBox").change(function() {
                countryValue = this.value;
                regionUpdate(countryValue);
            });


        });';

    

               echo' 
               
      
        function regionUpdate(countryValue) {


            let arr = countryValue.filter(function(entry) { return entry.trim() != ""; });

            let text = arr.toString();

            let textValue = ""; 
            console.log("this value "+text.length);
            if(text.length === 0){
                textValue = "null"
            }else{
                textValue = text
            }

            console.log("textValue: "+ textValue);



            var userdata = {"myCheckbox":textValue};
                $.ajax({
                        type: "POST",
                        url: "region_json.php",
                        async:false,
                        data:userdata, 
                        success: function(data){

                                let obj = "";
                                obj = JSON.parse(data);
                                console.log(obj.length);

                                if(obj.length === 0){
                                    document.querySelector("#regionInputBox").setOptions(obj);
                                    document.querySelector("#cityInputBox").setOptions(obj);
                                   
                                }else{


                                    VirtualSelect.init({ 
                                                ele: "#regionInputBox",
                                                options: obj,
                                                multiple: true,
                                                hasOptionDescription: true,
                                                search: true,
                                                searchGroup: true,
                                                disableOptionGroupCheckbox:false,
                                                useGroupValue: true,
                                                noSearchResultsTex: "No results found",
                                                updatePositionThrottle: 1000,
                                                keepAlwaysOpen:true,
                                                dropboxBreakpoint: "3000px"
                                        
                                            });
                                            
                                    var i;
                                    for (i = 0; i < obj.length; i++) { 

                                        document.querySelector("#regionInputBox").setOptions(obj);

                                    }


                                }

                               
                           
                           

                           

                        }
                });

                $("#regionInputBox").change(function() {
                    regionValue = this.value;
                    citiesUpdate(regionValue);

                });






        }   

       

        function citiesUpdate(regionValue) {

            let arr = regionValue.filter(function(entry) { return entry.trim() != ""; });

            let text = arr.toString();

            console.log(text);


            var userdata = {"myCheckbox":text};
                $.ajax({
                        type: "POST",
                        url: "cities_json.php",
                        async:false,
                        data:userdata, 
                        success: function(data){

                                const obj = JSON.parse(data);
                                if(obj.length === 0){
                                    document.querySelector("#cityInputBox").setOptions(obj);
                                   
                                }else{



                                        VirtualSelect.init({ 
                                            ele: "#cityInputBox",
                                            options: obj,
                                            multiple: true,
                                            hasOptionDescription: true,
                                            search: true,
                                            searchGroup: true,
                                            disableOptionGroupCheckbox:false,
                                            useGroupValue: true,
                                            noSearchResultsTex: "No results found",
                                            updatePositionThrottle: 100,
                                            allowNewOption: true,
                                            keepAlwaysOpen:true,
                                            dropboxBreakpoint: "3000px"
                                    
                                        });
                                        
                                    var i;
                                    for (i = 0; i < obj.length; i++) { 

                                        document.querySelector("#cityInputBox").setOptions(obj);

                                    }
                                }


                               
                           
                           

                           

                        }
                });


        }

      
                    </script>
           
           ';
           

           

    
    // $rema = new  Plugins_DeliveryLimitations_Geo_Country();





    //footer
    phpAds_PageFooter();
}




?>

