<?php

/*
 * 
 * File Created by DAC141
 * 
 */

/*---------------- Start of Agency Statistics -------------*/

$app->get('/get_agency_advertiser_statistics/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');              
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
    $input = $request->getParsedBody();
    $table_prefix= $this->get('settings')['path']['table_prefix'];
    $datetime=date('Y-m-d H:i:s');
	$startdate=$args['start_date'];
	$enddate=$args['end_date'];  
	$agencyid = $args['agency_id'];
	
	$stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
	$std = $this->db->prepare($stc);
	$std->bindParam("agency_id",$args['agency_id']);
	$std->execute();
	$agency = $std->fetchAll();

	if($agency)
	{
		$sql="select 
		
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
		cl.clientname as clientname,
		b.campaignid as campaignid,
		cl.clientid as clientid,
		cl.agencyid as agencyid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	 
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."agency as g
		where
		h.ad_id = b.bannerid
		AND b.campaignid = c.campaignid
		AND g.agencyid = :agencyid
		AND cl.agencyid = g.agencyid
		AND cl.clientid = c.clientid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by clientid";

    $sth = $this->db->prepare($sql);
    $sth->bindParam(":agencyid",$agencyid);

    $sth->execute();
    
    $todos = $sth->fetchAll();
    if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
  //  return $this->response->withJson($todos);
		
	}
	else{
		
		$response = array('response'=>'error','ok'=>'Please enter valid Agency Id');
		return $this->response->withJson($response);

	}
	
		
  
}
    
})->add($container->get('datevalidation'));




$app->get('/get_agency_campaign_statistics/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
    $input = $request->getParsedBody();
    $table_prefix= $this->get('settings')['path']['table_prefix'];
    $datetime=date('Y-m-d H:i:s');
	$startdate=$args['start_date'];	
	$enddate=$args['end_date']; 
	$agencyid = $args['agency_id']; 
	
	$stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
	$std = $this->db->prepare($stc);
	$std->bindParam("agency_id",$args['agency_id']);
	$std->execute();
	$agency = $std->fetchAll();

	if($agency)
	{
		$sql="select 
		g.agencyid as agencyid,
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.campaignid as campaignid,
		c.campaignname as campaignname,
		cl.clientid as clientid,
		cl.agencyid as agencyid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."agency as g
		where
		h.ad_id = b.bannerid
		AND b.campaignid = c.campaignid
		AND g.agencyid = :agencyid
		AND cl.agencyid = g.agencyid
		AND c.clientid = cl.clientid 
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by campaignid";

    $sth = $this->db->prepare($sql);
    $sth->bindParam(":agencyid",$agencyid);

    $sth->execute();
    
    $todos = $sth->fetchAll();
    
    if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
	}
	else{
		
		$response = array('response'=>'error','ok'=>'Please enter valid Agency Id');
		return $this->response->withJson($response);

	}
  
}
    
})->add($container->get('datevalidation'));



$app->get('/get_agency_banner_statistics/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
    $input = $request->getParsedBody();
    $table_prefix= $this->get('settings')['path']['table_prefix'];
    $datetime=date('Y-m-d H:i:s');
	$startdate=$args['start_date'];
	$enddate=$args['end_date']; 
	$agencyid = $args['agency_id']; 
		
	$stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
	$std = $this->db->prepare($stc);
	$std->bindParam("agency_id",$args['agency_id']);
	$std->execute();
	$agency = $std->fetchAll();

	if($agency)
	{
	$sql="select 
			g.agencyid as agencyid,
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.description as bannername,
			b.campaignid as campaignid,
			c.campaignid as camp,
			c.clientid as client,
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."agency as g
			where
			h.ad_id = b.bannerid
			AND g.agencyid = :agencyid
			AND cl.agencyid = g.agencyid
			AND b.campaignid = c.campaignid   
			AND c.clientid = cl.clientid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by ad_id"; 

	$sth = $this->db->prepare($sql);
	$sth->bindParam(":agencyid",$agencyid);
	$sth->execute();    
	$todos = $sth->fetchAll();    
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
	}
	else{
		
		$response = array('response'=>'error','ok'=>'Please enter valid Agency Id');
		return $this->response->withJson($response);

	}
  
}
    
})->add($container->get('datevalidation'));




$app->get('/get_agency_publisher_statistics/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$agency_id = $args['agency_id']; 
		
		$stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id",$args['agency_id']);
		$std->execute();
		$agency = $std->fetchAll();

		if($agency)
		{
		$sql="select 
			g.agencyid as agencyid,
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			a.name as affiliatename, 
			z.affiliateid as affiliateid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."affiliates as a,
			".$table_prefix."zones as z,
			".$table_prefix."agency as g
			where
			h.zone_id = z.zoneid
			AND g.agencyid = :agencyid
			AND a.agencyid = g.agencyid
			AND a.affiliateid = z.affiliateid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by  affiliateid";

    $sth = $this->db->prepare($sql);
    $sth->bindParam(":agencyid",$agency_id);

    $sth->execute();
    
    $todos = $sth->fetchAll();
    
   if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
    }
	else{
		
		$response = array('response'=>'error','ok'=>'Please enter valid Agency Id');
		return $this->response->withJson($response);

	}
  
}
    
})->add($container->get('datevalidation'));



$app->get('/get_agency_zone_statistics/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$agencyid = $args['agency_id']; 
		
		$stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id",$args['agency_id']);
		$std->execute();
		$agency = $std->fetchAll();

		if($agency)
		{
		$sql="select 
		g.agencyid as agencyid,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		z.zoneid as zoneid,
		z.zonename as zonename,
		z.affiliateid as affiliateid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."affiliates as a,
		".$table_prefix."zones as z,
		".$table_prefix."agency as g
		where
		z.zoneid = h.zone_id
		AND g.agencyid = :agencyid
		AND a.agencyid = g.agencyid
		AND a.affiliateid = z.affiliateid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by zoneid";

    $sth = $this->db->prepare($sql);
    $sth->bindParam(":agencyid",$agencyid);

    $sth->execute();
    
    $todos = $sth->fetchAll();
    
   if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
	}
	else{
		
		$response = array('response'=>'error','ok'=>'Please enter valid Agency Id');
		return $this->response->withJson($response);

	}
}
    
})->add($container->get('datevalidation'));


$app->get('/get_agency_daily_statistics/[{start_date},{end_date},{agency_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$agency_id = $args['agency_id']; 
	
		$stc = "select * from ".$table_prefix."agency where agencyid=:agency_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("agency_id",$args['agency_id']);
		$std->execute();
		$agency = $std->fetchAll();

		if($agency)
		{
			$sql="select 
			g.agencyid as agencyid,
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			cl.clientname as clientname,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."agency as g
			where
			h.ad_id = b.bannerid
			AND b.campaignid = c.campaignid
			AND c.clientid = cl.clientid
			AND g.agencyid = :agencyid		
			AND cl.agencyid = g.agencyid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by DATE(date_time)";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":agencyid",$agency_id);

			$sth->execute();

			$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
			
		}
		else{
			
			$response = array('response'=>'error','ok'=>'Please enter valid Agency Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));


/*---------------- End of Agency Statistics -------------*/


/*--------------- Start of Advertiser Statistics ------------*/

$app->get('/get_advertiser_daily_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:advertiser_id";
		$std = $this->db->prepare($stc);
		$std->bindParam(":advertiser_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			$sql="select 
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			c.clientid as client,
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl
			where
			h.ad_id = b.bannerid
			AND b.campaignid = c.campaignid
			AND c.clientid = cl.clientid
			AND cl.clientid = :advertiser
			AND DATE(h.date_time) between '".$startdate."' and 
			'".$enddate."' group by DATE(date_time)";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":advertiser",$advertiser_id);
			$sth->execute();
			$todos = $sth->fetchAll();
			if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
			
		}
		else{
			
			$response = array('response'=>'error','ok'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
		
  
}
 
})->add($container->get('datevalidation'));


$app->get('/get_advertiser_campaign_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
	
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
			
		$sql="select 
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
		b.campaignid as campaignid,
		cl.clientid as clientid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl 
		where
		h.ad_id = b.bannerid
		AND c.campaignid = b.campaignid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();

		$todos = $sth->fetchAll();

		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','ok'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));


$app->get('/get_advertiser_banner_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
		$sql="select 
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
		b.campaignid as campaignid,
		b.description as bannername,
		cl.clientid as clientid,		
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl
		where
		h.ad_id = b.bannerid
		AND c.clientid = :advertiserid
		AND cl.clientid = c.clientid
		AND b.campaignid = c.campaignid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' GROUP BY ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			
			$response = array('response'=>'error','ok'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
  
}
 
})->add($container->get('datevalidation'));


$app->get('/get_advertiser_publisher_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
		$sql="select 
		h.ad_id as ad_id,
		h.zone_id as zoneid,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
        b.campaignid as campaignid,
		p.name as affiliatename,
		cl.clientid as clientid,	
		p.affiliateid as affiliateid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."affiliates as p,
		".$table_prefix."zones as z
		where
		h.ad_id = b.bannerid
		AND c.clientid = :advertiserid
		AND cl.clientid = c.clientid
		AND z.affiliateid =  p.affiliateid
		AND z.zoneid = h.zone_id
		AND b.campaignid = c.campaignid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by affiliateid";
		}
		else{
			
			$response = array('response'=>'error','ok'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);

		}
	$sth = $this->db->prepare($sql);
	$sth->bindParam(":advertiserid",$advertiser_id);

	$sth->execute();
	$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
  
}
 
})->add($container->get('datevalidation'));


$app->get('/get_advertiser_zone_statistics/[{start_date},{end_date},{advertiser_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$advertiser_id = $args['advertiser_id']; 
		
		$stc = "select * from ".$table_prefix."clients where clientid=:client_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("client_id",$advertiser_id);
		$std->execute();
		$client = $std->fetchAll();

		if($client)
		{
		$sql="select 
		h.ad_id as ad_id,
		h.zone_id as zoneid,
		DATE(h.date_time) as date_time,
		h.impressions as impressions,
		h.clicks as clicks,
		h.conversions as conversions,
		h.total_revenue as revenue,
		b.bannerid as bannerid,
        b.campaignid as campaignid,
		cl.clientid as clientid,
		z.affiliateid as affiliateid,
		z.zonename as zonename,
		p.agencyid as agencyid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm 
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."affiliates as p,
		".$table_prefix."zones as z
		where
		h.ad_id = b.bannerid
		AND c.clientid = cl.clientid
		AND cl.clientid = :advertiserid
		AND p.affiliateid = z.affiliateid
		AND h.zone_id = z.zoneid
		AND b.campaignid = c.campaignid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by zoneid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":advertiserid",$advertiser_id);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
	}
	else{
			$response = array('response'=>'error','ok'=>'Please enter valid Advertiser Id');
			return $this->response->withJson($response);
	}
}
 
})->add($container->get('datevalidation'));

/*--------------- End of Advertiser Statistics ------------*/

/*--------------- Start of Campaign Statistics ------------*/

$app->get('/get_campaign_daily_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaignid = $args['campaign_id']; 
		
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaign_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaign_id",$campaignid);
		$std->execute();
		$campaign = $std->fetchAll();

		if($campaign)
		{
		$sql="select 
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
		b.campaignid as campaignid,
		c.clientid as clientid,
		c.campaignname as campaignname,
		cl.agencyid as agencyid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."agency as a
		where
		h.ad_id = b.bannerid
		AND b.campaignid = c.campaignid
		AND c.campaignid = :campaignid
		AND a.agencyid=cl.agencyid
		AND cl.clientid=c.clientid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by DATE(date_time)";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":campaignid",$campaignid);

		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Campaign Id');
			return $this->response->withJson($response);
		}
  
}
 
})->add($container->get('datevalidation'));

$app->get('/get_campaign_banner_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaignid = $args['campaign_id']; 
		
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaign_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaign_id",$campaignid);
		$std->execute();
		$campaign = $std->fetchAll();

		if($campaign)
		{
		$sql="select 
		h.ad_id as ad_id,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
		b.description as bannername,
		b.campaignid as campaignid,
		c.clientid as clientid,
		c.campaignname as campaignname,
		cl.agencyid as agencyid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm 
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."clients as cl,
		".$table_prefix."agency as a
		where
		h.ad_id = b.bannerid
		AND b.campaignid = c.campaignid
		AND c.campaignid = :campaign_id
		AND a.agencyid=cl.agencyid
		AND cl.clientid=c.clientid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by ad_id";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":campaign_id",$campaignid);
		$sth->execute();
		$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Campaign Id');
			return $this->response->withJson($response);
		}
  
}
 
})->add($container->get('datevalidation'));

$app->get('/get_campaign_publisher_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
     
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$campaignid = $args['campaign_id']; 
		
		$stc = "select * from ".$table_prefix."campaigns where campaignid=:campaign_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaign_id",$campaignid);
		$std->execute();
		$campaign = $std->fetchAll();

		if($campaign)
		{
		$sql="select 
		p.agencyid as agencyid,
		h.ad_id as ad_id,
		h.zone_id as zoneid,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
        b.description as bannername,
		b.campaignid as campaignid,
		p.affiliateid as affiliateid,		
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."affiliates as p,
		".$table_prefix."zones as z
		where
		h.ad_id = b.bannerid
		AND z.zoneid = h.zone_id
		AND b.campaignid =:campaignid
		AND c.campaignid =b.campaignid
		AND z.affiliateid = p.affiliateid
		AND DATE(h.date_time) between '".$startdate."'
		and '".$enddate."' group by affiliateid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":campaignid",$campaignid);
		$sth->execute();
		$todos = $sth->fetchAll();
			if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Campaign Id');
			return $this->response->withJson($response);
		}
}
 
})->add($container->get('datevalidation'));

$app->get('/get_campaign_zone_statistics/[{start_date},{end_date},{campaign_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    $table_prefix= $this->get('settings')['path']['table_prefix'];
    $input = $request->getParsedBody();		
	$datetime=date('Y-m-d H:i:s');
	$startdate=$args['start_date'];
	$enddate=$args['end_date']; 
	$campaignid = $args['campaign_id']; 
    $stc = "select * from ".$table_prefix."campaigns where campaignid=:campaign_id";
	$std = $this->db->prepare($stc);
	$std->bindParam("campaign_id",$campaignid);
	$std->execute();
	$campaign = $std->fetchAll();	
	if($campaign)
	{
		
		$sql="select 
		h.ad_id as ad_id,
		h.zone_id as zoneid,
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
		b.campaignid as campaignid,
		p.affiliateid as affiliateid,
		z.zonename as zonename,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm	
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."campaigns as c,
		".$table_prefix."affiliates as p,
		".$table_prefix."zones as z
		where
		h.ad_id = b.bannerid
		AND h.zone_id = z.zoneid
		AND b.campaignid = :campaignid
		AND c.campaignid = b.campaignid
		AND p.affiliateid = z.affiliateid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by zoneid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":campaignid",$campaignid);
		$sth->execute();
		$todos = $sth->fetchAll();
			if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
	}
	else{
			$response = array('response'=>'error','ok'=>'Please enter valid Campaign Id');
			return $this->response->withJson($response);
	}

}
 
})->add($container->get('datevalidation')); 

/*--------------- End of Campaign Statistics ------------*/

/*--------------- Start of Banner Statistics ------------*/

$app->get('/get_banner_daily_statistics/[{start_date},{end_date},{banner_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
		
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['banner_id']; 
		
		$stc = "select * from ".$table_prefix."banners where bannerid=:banner_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("banner_id",$bannerid);
		$std->execute();
		$banners = $std->fetchAll();
		if($banners)
		{		
			$sql="select 	 	
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,					
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b
			where
			h.ad_id = :bannerid
			AND b.bannerid = :bannerid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by DATE(date_time)";

			$sth = $this->db->prepare($sql);
			$sth->bindParam(":bannerid",$bannerid);
			$sth->execute();
			$todos = $sth->fetchAll();
			if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Banner Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 



$app->get('/get_banner_publisher_statistics/[{start_date},{end_date},{banner_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['banner_id']; 
		
		$stc = "select * from ".$table_prefix."banners where bannerid=:banner_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("banner_id",$bannerid);
		$std->execute();
		$banners = $std->fetchAll();
		if($banners)
		{
			
		$sql="select 		
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,		
		b.bannerid as bannerid,
		p.name as affiliatename,
		p.affiliateid as affiliateid
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."affiliates as p,	
		".$table_prefix."zones as z
		where
		h.ad_id = :bannerid
		AND b.bannerid = h.ad_id
		AND p.affiliateid = z.affiliateid
		AND z.zoneid = h.zone_id 
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."'  group by affiliateid"; 


		$sth = $this->db->prepare($sql);
		$sth->bindParam(":bannerid",$bannerid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Banner Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 



$app->get('/get_banner_zone_statistics/[{start_date},{end_date},{banner_id}]', function($request, $response, $args)
{ 
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$bannerid = $args['banner_id']; 
		
		$stc = "select * from ".$table_prefix."banners where bannerid=:banner_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("banner_id",$bannerid);
		$std->execute();
		$banners = $std->fetchAll();
		
		if($banners)
		{
		$sql="select 
		h.zone_id as zoneid,		
		DATE(h.date_time) as date_time,
		sum(h.impressions) as impressions,
		sum(h.clicks) as clicks,
		sum(h.conversions) as conversions,
		sum(h.total_revenue) as revenue,
		b.bannerid as bannerid,
		p.affiliateid as affiliateid,
		(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
		(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
		z.zonename as zonename
		from
		".$table_prefix."data_summary_ad_hourly as h,
		".$table_prefix."banners as b,
		".$table_prefix."affiliates as p,	
		".$table_prefix."zones as z
		where
		h.ad_id = :bannerid
		AND b.bannerid = h.ad_id
		AND p.affiliateid = z.affiliateid 
		AND h.zone_id = z.zoneid
		AND DATE(h.date_time) between '".$startdate."'
		AND '".$enddate."' group by zoneid"; 

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":bannerid",$bannerid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Banner Id');
			return $this->response->withJson($response);
		}
}
 
})->add($container->get('datevalidation')); 

/*--------------- End of Banner Statistics ------------*/


/*--------------- Start of Publisher Statistics ------------*/


$app->get('/get_publisher_daily_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			
		    h.ad_id as ad_id,
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
            b.campaignid as campaignid,
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			p.name as name
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by DATE(date_time)";
		
		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}
}
 
})->add($container->get('datevalidation')); 

$app->get('/get_publisher_zone_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
		    h.ad_id as ad_id,
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
            b.campaignid as campaignid,
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			z.zonename as zonename
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by zoneid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

$app->get('/get_publisher_advertiser_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			h.ad_id as ad_id,
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			cl.clientname as clientname
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by clientid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
	if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

$app->get('/get_publisher_campaign_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
		    h.ad_id as ad_id,
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm,
			p.affiliateid as affiliateid,
			p.name as name,
			c.campaignname as campaignname
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 

$app->get('/get_publisher_banner_statistics/[{start_date},{end_date},{publisher_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$publisherid = $args['publisher_id']; 
		
		$stc = "select * from ".$table_prefix."affiliates where affiliateid=:affiliateid";
		$std = $this->db->prepare($stc);
		$std->bindParam("affiliateid",$publisherid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			h.ad_id as ad_id,
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(Sum(h.total_revenue)/sum(h.impressions))*1000 as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND p.affiliateid = :publisherid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":publisherid",$publisherid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
		{
		return $this->response->withJson($todos);
	}else{
		$response = array('response'=>'error','ok'=>'No Stats Available');
			return $this->response->withJson($response);
	}
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Publisher Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 



/*--------------- End of Publisher Statistics ------------*/

/*--------------- Start of zone Statistics ------------*/


$app->get('/get_zone_daily_statistics/[{start_date},{end_date},{zone_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$zoneid = $args['zone_id']; 
		
		$stc = "select * from ".$table_prefix."zones where zoneid=:zone_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("zone_id",$zoneid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
            b.campaignid as campaignid,
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as name,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND z.zoneid = :zoneid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by DATE(date_time)";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":zoneid",$zoneid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
        {
        return $this->response->withJson($todos);
    }else{
        $response = array('response'=>'error','ok'=>'No Stats Available');
            return $this->response->withJson($response);
    }
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Zone Id');
			return $this->response->withJson($response);
		}
}
 
})->add($container->get('datevalidation')); 


$app->get('/get_zone_advertiser_statistics/[{start_date},{end_date},{zone_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$zoneid = $args['zone_id']; 
		
		$stc = "select * from ".$table_prefix."zones where zoneid=:zone_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("zone_id",$zoneid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
			$sql="select 
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			cl.clientname as clientname,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND z.zoneid = :zoneid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by clientid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":zoneid",$zoneid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
        {
        return $this->response->withJson($todos);
    }else{
        $response = array('response'=>'error','ok'=>'No Stats Available');
            return $this->response->withJson($response);
    }
		
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Zone Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 


$app->get('/get_zone_campaign_statistics/[{start_date},{end_date},{zone_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$zoneid = $args['zone_id']; 
		
		$stc = "select * from ".$table_prefix."zones where zoneid=:zone_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("zone_id",$zoneid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			h.zone_id as zoneid,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			c.campaignname as campaignname,
			cl.clientname as clientname,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND z.zoneid = :zoneid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND '".$enddate."' group by campaignid";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":zoneid",$zoneid);
		$sth->execute();
		$todos = $sth->fetchAll();
	if($todos)
        {
        return $this->response->withJson($todos);
    }else{
        $response = array('response'=>'error','ok'=>'No Stats Available');
            return $this->response->withJson($response);
    }
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Zone Id');
			return $this->response->withJson($response);
		}

} 
 
})->add($container->get('datevalidation')); 


$app->get('/get_zone_banner_statistics/[{start_date},{end_date},{zone_id}]', function($request, $response, $args)
{
	
	if ($request->getAttribute('has_errors')) {
        //There are errors, read them
        $errors = $request->getAttribute('errors');      
        return $this->response->withJson($errors);
        
        return $response;
    } else {
    
		$input = $request->getParsedBody();
		$table_prefix= $this->get('settings')['path']['table_prefix'];
		$datetime=date('Y-m-d H:i:s');
		$startdate=$args['start_date'];
		$enddate=$args['end_date']; 
		$zoneid = $args['zone_id']; 
		
		$stc = "select * from ".$table_prefix."zones where zoneid=:zone_id";
		$std = $this->db->prepare($stc);
		$std->bindParam("zone_id",$zoneid);
		$std->execute();
		$publishers = $std->fetchAll();
		
		if($publishers)
		{
		$sql="select 
			h.zone_id as zoneid,
			h.ad_id as ad_id,
			DATE(h.date_time) as date_time,
			sum(h.impressions) as impressions,
			sum(h.clicks) as clicks,
			sum(h.conversions) as conversions,
			sum(h.total_revenue) as revenue,
			b.bannerid as bannerid,
			b.campaignid as campaignid,
			cl.clientid as clientid,
			p.affiliateid as affiliateid,
			p.name as affiliatename,
			c.campaignname as campaignname,
			cl.clientname as clientname,
			(sum(h.clicks)/sum(h.impressions)) * 100 as ctr,
			(sum(h.total_revenue)/sum(h.impressions)) * 1000 as ecpm,
			b.description as bannername
			from
			".$table_prefix."data_summary_ad_hourly as h,
			".$table_prefix."banners as b,
			".$table_prefix."campaigns as c,
			".$table_prefix."clients as cl,
			".$table_prefix."affiliates as p,
			".$table_prefix."zones as z
			where
			h.ad_id = b.bannerid
			AND cl.clientid = c.clientid
			AND z.zoneid = :zoneid
			and p.affiliateid=z.affiliateid
			AND z.zoneid = h.zone_id
			AND b.campaignid = c.campaignid
			AND DATE(h.date_time) between '".$startdate."'
			AND  '".$enddate."' group by ad_id";

		$sth = $this->db->prepare($sql);
		$sth->bindParam(":zoneid",$zoneid);
		$sth->execute();
		$todos = $sth->fetchAll();
		if($todos)
        {
        return $this->response->withJson($todos);
    }else{
        $response = array('response'=>'error','ok'=>'No Stats Available');
            return $this->response->withJson($response);
    }
		}
		else{
			$response = array('response'=>'error','ok'=>'Please enter valid Zone Id');
			return $this->response->withJson($response);
		}

}
 
})->add($container->get('datevalidation')); 



/*--------------- End of zone Statistics ------------*/

//Worked by DAC141//
