<?php

require_once MAX_PATH . '/lib/OA.php';
require_once MAX_PATH . '/lib/max/Plugin/Common.php';
require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

class Plugins_BannerTypeHTML_Outstream_Outstream extends Plugins_BannerTypeHTML
{
    /**
     * Return type of plugin
     *
     * @return string A string describing the type of plugin.
     */
     
    function getStorageType()
    {
        return 'html';
    }

    /**
     * Return the media (content) type
     *
     */
    function getContentType()
    {
        return 'html';
    }
     
    function getOptionDescription()
    {
        return $this->translate("Native video");
    }

    function validateForm(&$form)
    {
        return true;
    }

    function processForm($insert, $bannerid, $aFields)
    {

        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $video_url = $_POST['video_url'];

        $inlinefields = array(

                        'vid_type'          => $_POST['vid_type'],
                        'video_url'         => $video_url,
                        'destination_url'   => $_POST['destination_url'],
                        'description'       => $_POST['description'],
                        'extension_type'    => $_POST['extension_type'],
                        'skip'              => $_POST['skip'],
                        'cta_text'          => $_POST['cta_text'],
                        'title'             => $_POST['title'],
                        'text_description'  => $_POST['text_description'],
                        'icon_url'          => $_POST['icon_url'],
                        'sponser_text'      => $_POST['sponser_text'],
                    );


        OA_Dal_Delivery_query("UPDATE {$table_prefix}banners SET parameters = '".serialize($inlinefields)."', url='".$_POST['destination_url']."', width='-8', height='-8' WHERE bannerid = ".$bannerid);
       
        return true;
    }
     
    function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {
        return true;
    }
     
    function buildForm(&$form, &$row)
    { 
        //FETCH VALUE 
        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $array = OA_Dal_Delivery_query("select parameters from {$table_prefix}banners where bannerid ='".$row['bannerid']."' ");
        $values1 = OA_Dal_Delivery_fetchAssoc($array);

        $values = unserialize($values1['parameters']);
        
        $form->addElement('text', 'video_url', 'Video URL');
        $extension_type = array("MP4" => "MP4","WEBM" => "WEBM","MP3" => "MP3");

        $form->addElement('select', 'extension_type','Extension Type',$extension_type); 
        $form->addElement('text', 'skip', 'Skip (In Secs.)', array("placeholder"=> "00:00:00"));

        $form->addElement('text', 'title', 'Title');
        $form->addElement('text', 'text_description', 'Description');
        $form->addElement('text', 'cta_text', 'CTA Text');

        $form->addElement('text', 'sponser_text', 'Sponser Text');
        $form->addElement('text', 'icon_url', 'Icon URL ');

        $form->addElement('text', 'destination_url',"Destination URL");

        $front_image = _getContentTypeIconImageName($row['contenttype']);
        $front_size = _getBannerSizeText($type, $row['filename']);   
        
        $form->addElement('header', 'header_b_links', "Banner link");
        $form->addElement('text', 'tp_tag', 'Third Party Tags (optional)',$tp_tag);
        
        
        //echo "<pre></pre>";print_r($values);exit;

        //~DEFAULT VALUES
        
        $form->setDefaults(array(vidplay_type => $values['vid_type']));
        $form->setDefaults(array(adplay_type => $values['ad_type']));
        $form->setDefaults(array(adupload_type => $values['vid_upload_type']));
        $form->setDefaults(array(video_url => $values['video_url'])); 
        $form->setDefaults(array(sponser_text => $values['sponser_text'])); 
        $form->setDefaults(array(title => $values['title'])); 
        $form->setDefaults(array(text_description => $values['text_description'])); 
        $form->setDefaults(array(cta_text => $values['cta_text'])); 
        $form->setDefaults(array(destination_url => $values['destination_url'])); 
        $form->setDefaults(array(external_wrapper => $values['external_wrapper'])); 

        $form->setDefaults(array(tp_tag => $values['tp_tag'])); 
        $form->setDefaults(array(extension_type => $values['extension_type'])); 
        $form->setDefaults(array(icon_url => $values['icon_url'])); 
        $form->setDefaults(array(skip => $values['skip'])); 
        $form->setDefaults(array(bg_image => $values['bg_image']));
        $form->setDefaults(array(pre_vid => $values['rm_video']));
        
        //~UNIQUE BANNER FOR BANNER LINK
        $form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());

        $form->addElement('hidden', 'width', -10 );
        $form->addElement('hidden', 'height', -10 );
        
    }


    
}
