<?php

require_once MAX_PATH . '/lib/OA.php';
require_once MAX_PATH . '/lib/max/Plugin/Common.php';
require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
 if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

class Plugins_BannerTypeHTML_InfeedAds_InfeedAds extends Plugins_BannerTypeHTML
{
    /**
     * Return type of plugin
     *
     * @return string A string describing the type of plugin.
     */
     
    function getStorageType()
    {
        return 'html';
    }

    /**
     * Return the media (content) type
     *
     */
    function getContentType()
    {
        return 'html';
    }
     
    function getOptionDescription()
    {
        return $this->translate("Infeed Ads");
    }

    function validateForm(&$form)
    {
        return true;
    }

    function processForm($insert, $bannerid, $aFields)
    {

        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $table_name = $table_prefix.'banners';
        $banner = '';
        $sponsored_icon = '';
        $width = '';
        $height = '';
        $output = array();
        $location = "../images/";
        

        //~UPDATE
        if($aFields)
        {            
            if ($_FILES['upload']['name'] != '' || $_POST['replaceimage'] == 't')
            { 
                //TODO refactor upload to be a valid quickform element
                $oFile = OA_Creative_File::factoryUploadedFile('upload');
                checkForErrorFileUploaded($oFile);
                $oFile->store('web');
                $aFile = $oFile->getFileDetails();
                $banner =  $aFile['filename'];
                $width = $aFile['width'];
                $height = $aFile['height'];
            }

            if ( $aFields['is_sponsored_icon'] == 1 && ($_FILES['sponsored_icon']['name'] != '' || $_POST['re_sponsored_icon'] == 't'))
            { 
                //TODO refactor upload to be a valid quickform element
                $oFile = OA_Creative_File::factoryUploadedFile('sponsored_icon');
                checkForErrorFileUploaded($oFile);
                $oFile->store('web');
                $aFile = $oFile->getFileDetails();
                $sponsored_icon =  $aFile['filename'];
            }

            if($_POST['replaceimage'] == 'f'){
                $banner = $_POST['banner'];
                $width = $_POST['cus_width'];
                $height = $_POST['cus_height'];
            }

            if($_POST['re_sponsored_icon'] == 'f'){
                $sponsored_icon = $_POST['pre_sponsored_icon'];
            }

            $output = array(

                        'recommend_type' => $aFields['recommend_type'],
                        'upload' => $banner,                        
                        'title' => $aFields['title'],
                        'dj_data_sponsored' => $aFields['dj_data_sponsored'],
                        'is_sponsored_icon' => $aFields['is_sponsored_icon'],
                        'sponsored_icon' => $sponsored_icon,
                        'dj_data_descdata' => $aFields['dj_data_descdata'],
                        'destination_url' => $aFields['url'],
                        'width' => $width,
                        'height' => $height,

                    );


        	$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        	$oDbh = &OA_DB::singleton();
        	$banners = $oDbh->quoteIdentifier($table_prefix . 'banners',true);
        	$oDbh->query("UPDATE {$banners} SET parameters = '".serialize($output)."', filename = '".$banner."' WHERE bannerid=".$bannerid);	
	
        }
   
        return true;
    }
     
    function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {
        
        return true;
            
    }
    
    function buildForm(&$form, &$row)
    {
		
        $values = unserialize($row['parameters']);

        //~PREVIOUS FILES
        $recommend_type = 0;

        if($values['recommend_type'] == 'recommend_text'){
            $recommend_type = 1;
        }

        // echo $recommend_type;exit;

        $type = 'web';
        $front_image = _getContentTypeIconImageName($row['contenttype']);
        $front_size = _getBannerSizeText($type, $row['filename']);


        //////////////////  BANNER DETAIS START ////////////////////////

        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

        $header = $form->createElement('header', 'header_txt','Banner Details');
        $form->addElement($header);
        
        $imageName1 = _getContentTypeIconImageName($aBanner['contenttype']);
        $size1 = _getBannerSizeText($type, $aBanner['filename']);

            addUploadGroup($form, $aBanner,
                array(
                    'uploadName' => 'upload',
                    'radioName' => 'replaceimage',
                    'imageName'  => $imageName1,
                    'fileName'  => $values['upload'],
                    'fileSize'  => $size1,
                    'newLabel'  => $GLOBALS['strNewBannerFile'],
                    'updateLabel'  => $GLOBALS['strUploadOrKeep'],
                    'handleSWF' => true
                  )
            );

        $form->addElement('text', 'dj_data_sponsored', "Brand Name (Sponsored)");
        $form->addElement('hidden', 'sponsored_enabled', $values['is_sponsored_icon']);
        $form->addElement('checkbox', 'is_sponsored_icon', "Brand Icon (Sponsored)", '',array("id" => "is_sponsored_icon") );

        $imageName2 = _getContentTypeIconImageName($aBanner['contenttype']);
        $size2 = _getBannerSizeText($type, $aBanner['filename']);

            addUploadGroup($form, $aBanner,
                array(
                    'uploadName' => 'sponsored_icon',
                    'radioName' => 're_sponsored_icon',
                    'imageName'  => $imageName2,
                    'fileName'  => $values['sponsored_icon'],
                    'fileSize'  => $size2,
                    'newLabel'  => 'Select Sponsored Icon (50 X 50)',
                    'updateLabel'  => 'Change Sponsored Icon (50 X 50)',
                    'handleSWF' => true
                  )
            );

        $form->addElement('text', 'title', "Title");

        $form->addElement('hidden', 'banner', $values['uploads']);
        $form->addElement('hidden', 'banner', $values['upload']);
        $form->addElement('hidden', 'pre_sponsored_icon', $values['sponsored_icon']);
        $form->addElement('hidden', 'width', $values['width']);
        $form->addElement('hidden', 'height', $values['height']);

        $textarea0 =& $form->addElement('textarea','dj_data_descdata', "Descriptive text");
        $textarea0->setValue($sponsordata['dj_data_desc']);
            
        $url0 =& $form->addElement('text', 'url', "Destination url<span class='type-name'> (incl. http://)</span>");
        $url0->setValue($sponsordata['url']);
        
        
             
            $custom_dm['width'] = $form->createElement ( 'text', 'width', 'Width: ', array ('id' => 'cus_width', 'class' => 'small' ) );
            $custom_dm['height'] = $form->createElement ( 'text', 'height', 'Height: ', array ('id' => 'cus_height', 'class' => 'small' ) );

            $form->addElement( 'group', 'cus_dm', 'Image Size', $custom_dm, null, false );
      
      
      
      

        //////////////////  BANNER DETAIS END ////////////////////////
      

        $form->addElement('html', 'jsForExpandedFloor', '
            
            <script>

                var recommend_type = '.$recommend_type.';
                show_hide(recommend_type);

                $("input[name=recommend_type]").click(function(){
                    
                    if($(this).val() == "recommend_text"){
                        
                        show_hide(1);

                    } else{
                        
                        show_hide(0);
                    }
                });

                function show_hide(type){

                    if(type == 1){

                        $("input[name=upload]").parent().parent().hide();
                        $("input[name=replaceimage]").attr("disabled", true);
                        $("input[name=upload]").attr("disabled", true);
                    }else{

                        $("input[name=upload]").parent().parent().show();
                        $("input[name=replaceimage]").attr("disabled", false);
                        $("input[name=upload]").attr("disabled", false);
                    }
                }

                var sponsored = $("input[name=sponsored_enabled]").val();
                (sponsored == 1)? $("#is_sponsored_icon").attr("checked", true) : "" ;
                show_icon(sponsored);

                $("#is_sponsored_icon").click(function(){
                    
                    if($(this).is(":checked") == true)
                    {
                        show_icon(1);
                    }
                    else
                    {
                        show_icon(0);
                    }
                })

                function show_icon(type)
                {
                    if(type == 1)
                    {
                        $("input[name=sponsored_icon]").parent().parent().show();
                        $("input[name=sponsored_icon]").attr("disabled", false);
                    }
                    else{
                        $("input[name=sponsored_icon]").parent().parent().hide();
                        $("input[name=sponsored_icon]").attr("disabled", true);
                    }
                }
                
            </script>' );

        $form->setDefaults(array(recommend_type => $values['recommend_type']));
        $form->setDefaults(array(sponsor => $values['sponsor']));
        $form->setDefaults(array(uploads => $values['uploads']));
        $form->setDefaults(array(url => $values['url']));
        $form->setDefaults(array(upload => $values['upload']));
        $form->setDefaults(array(dj_data_sponsored => $values['dj_data_sponsored']));
        $form->setDefaults(array(title => $values['title']));
        $form->setDefaults(array(dj_data_descdata => $values['dj_data_descdata']));
        $form->setDefaults(array(destination_url => $values['destination_url']));

        $form->setDefaults(array(banner => $values['upload']));
      

        $form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());
    }


    
}
